/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandRepeat: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) argc;
	(void) args;
	
	return NULL;
}

const gchar *getName ()
{
	return "repeat";
}	

gchar *getHint ()
{
	return _("Repeat");
}

void checkArgc (guint n)
{
	if (n != 0) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean matchNextCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_RepeatButWhereIsUntil);
	
	if (g_ascii_strcasecmp (cmd->getName(), "until"))
		throw new LWMessage (LW_ERROR_RepeatButWhereIsUntil);
	
	match();
	
	return TRUE;
}

};

LWSymbol *new_LWCommandRepeat()
{
	return new LWCommandRepeat();
}
