/***********************************************************************************

	Copyright (C) 2007-2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "widget_entrylist.hpp"
#include "view_entry.hpp"


using namespace LIFEO;


WidgetEntryList::WidgetEntryList( BaseObjectType* cobject,
								  const Glib::RefPtr<Gtk::Builder>& )
	:	Gtk::TreeView( cobject )
{
// CELL RENDERERS
	Gtk::CellRendererPixbuf *cellrendererPixbuf = Gtk::manage(
			new Gtk::CellRendererPixbuf );
	Gtk::CellRendererText *cellrendererDate = Gtk::manage(
			new Gtk::CellRendererText );
	Gtk::CellRendererText *cellrendererTitle = Gtk::manage(
			new Gtk::CellRendererText );
	Gtk::TreeViewColumn *columnDate = Gtk::manage(
			new Gtk::TreeViewColumn( _( "Date" ) ) );
	Gtk::TreeViewColumn *columnTitle = Gtk::manage(
			new Gtk::TreeViewColumn( _( "Title" ) ) );

	columnDate->pack_start( *cellrendererPixbuf );
	columnDate->pack_start( *cellrendererDate );
	columnDate->add_attribute( cellrendererDate->property_markup(),
								ListData::colrec->id );
	columnDate->add_attribute( cellrendererPixbuf->property_pixbuf(),
								ListData::colrec->icon );

	cellrendererTitle->property_ellipsize() = Pango::ELLIPSIZE_END;
	cellrendererTitle->property_scale() = .90;
	cellrendererTitle->set_fixed_height_from_font( 1 );
	columnTitle->pack_start( *cellrendererTitle );
	columnTitle->add_attribute( cellrendererTitle->property_text(),
								ListData::colrec->info );

	m_treestore_entries = Gtk::TreeStore::create( *ListData::colrec );
	m_treemodelsort_entries = Gtk::TreeModelSort::create( m_treestore_entries );
	m_treemodelsort_entries->set_sort_column(
			Gtk::TreeSortable::DEFAULT_SORT_COLUMN_ID, Gtk::SORT_ASCENDING );

	set_model( m_treemodelsort_entries );
	append_column( *columnDate );
	append_column( *columnTitle );

	get_selection()->signal_changed().connect(
			sigc::mem_fun( *this, &WidgetEntryList::on_selection_changed ) );
}

WidgetEntryList::~WidgetEntryList( void )
{
}

void
WidgetEntryList::present_row( const Gtk::TreePath &path )
{
	Lifeobase::m_internaloperation++;

	Gtk::TreePath path2 = m_treemodelsort_entries->convert_child_path_to_path( path );
	expand_to_path( path2 );
	get_selection()->select( path2 );
	scroll_to_row( path2 );

	Lifeobase::m_internaloperation--;
}

void
WidgetEntryList::expand_element( const DiaryElement *element )
{
	Gtk::TreePath path2 = m_treemodelsort_entries->convert_child_path_to_path(
			element->m_list_data->treepath );
	expand_to_path( path2 );
}

void
WidgetEntryList::handle_sorting_criteria_changed( SortingCriteria sc )
{
	if( sc == Diary::d->get_sorting_criteria() )
		return;

	Diary::d->set_sorting_criteria( sc );

	switch( sc )
	{
		//case ST_NOT_SET:
		case SC_DATE:
			m_treemodelsort_entries->set_default_sort_func(
					sigc::mem_fun( *this, &WidgetEntryList::sort_by_date ) );
			break;
		case SC_SIZE:
			m_treemodelsort_entries->set_default_sort_func(
					sigc::mem_fun( *this, &WidgetEntryList::sort_by_size ) );
			break;
	}

	Lifeobase::base->update_entry_list();
}

void
WidgetEntryList::set_sorting_criteria( void )
{
	switch( Diary::d->get_sorting_criteria() )
	{
		//case ST_NOT_SET:
		case SC_DATE:
			m_treemodelsort_entries->set_default_sort_func(
					sigc::mem_fun( *this, &WidgetEntryList::sort_by_date ) );
			break;
		case SC_SIZE:
			m_treemodelsort_entries->set_default_sort_func(
					sigc::mem_fun( *this, &WidgetEntryList::sort_by_size ) );
			break;
	}
}

void
WidgetEntryList::on_selection_changed( void )
{
	if( Lifeobase::m_internaloperation ) return;

	Glib::RefPtr< Gtk::TreeSelection > selection = get_selection();
	if( selection->count_selected_rows() > 0 )
	{
		Gtk::TreeRow row = ( *selection->get_selected() );

		DiaryElement *listitem = row[ ListData::colrec->ptr ];
		listitem->show();
	}
	else
		Diary::d->show();	// if nothing is selected show the diary view
}

bool
WidgetEntryList::on_button_press_event( GdkEventButton *event )
{
/*	if( event->button != 3 )
		return Gtk::TreeView::on_button_press_event( event );

	Glib::RefPtr< Gtk::TreeSelection > selection = get_selection();

	if( selection->count_selected_rows() <= 0 )
		return Gtk::TreeView::on_button_press_event( event );

	// treeview issues selection changed signal after button press signal.
	// this causes context menus to be linked to the previously selected item
	// when a row is selected with right click.
	// to get around this we use a somewhat dirty hack and select the row
	// from within the button press event handler
	// p.s.: i dunno but there might be a simpler way of doing this
	Gtk::TreeModel::Path path;
	Gtk::TreeViewColumn  *column;
	int i, j;
	if( ! get_path_at_pos( (int) event->x, (int) event->y, path, column, i, j ) )
		return Gtk::TreeView::on_button_press_event( event );

	set_cursor( path );
	// end of dirty hack

	Gtk::TreeRow row = *( selection->get_selected() );
	DiaryElement *item = row[ ListData::colrec->ptr ];

	if( ! (	item->get_type() == DiaryElement::IT_ENTRY ||
			item->get_type() == DiaryElement::IT_TAG ) )
		return Gtk::TreeView::on_button_press_event( event );

	if( m_menu )
	{
		delete m_menu;
		m_menu = NULL;
	}

	m_menu = new Gtk::Menu;
	Gtk::Image *imageDismiss = Gtk::manage(
			new Gtk::Image( Gtk::Stock::DELETE, Gtk::ICON_SIZE_MENU ) );

	if( item->get_type() == DiaryElement::IT_ENTRY )
	{
		Entry *entry = dynamic_cast< Entry* >( item );


		m_menu->items().push_back(
			Gtk::Menu_Helpers::ImageMenuElem(
				entry->is_favored() ?
						_( "Remove from _Favorites" ) : _( "Add to _Favorites" ),
				*image_favored,
				sigc::mem_fun( *entry, &Entry::toggle_favoredness ) ) );
	}
	m_menu->accelerate( *this );
	m_menu->popup( event->button, event->time );
*/
	return Gtk::TreeView::on_button_press_event( event );
}

int
WidgetEntryList::sort_by_date( const Gtk::TreeModel::iterator &itr1,
							   const Gtk::TreeModel::iterator &itr2 )
{
	// SORT BY DATE (ONLY DESCENDINGLY FOR NOW)
	DiaryElement *item1 = ( *itr1 )[ ListData::colrec->ptr ];
	DiaryElement *item2 = ( *itr2 )[ ListData::colrec->ptr ];
	if( !( item1 && item2 ) )
		return 0;
	else
	if( item1->get_type() == DiaryElement::IT_DIARY )
	return -1;
	else
	if( item1->get_date() > item2->get_date() )
		return -1;
	else
	if( item1->get_date() < item2->get_date() )
		return 1;
	else
		return 0;
}

int
WidgetEntryList::sort_by_size( const Gtk::TreeModel::iterator &itr1,
							   const Gtk::TreeModel::iterator &itr2 )
{
	DiaryElement *item1 = ( *itr1 )[ ListData::colrec->ptr ];
	DiaryElement *item2 = ( *itr2 )[ ListData::colrec->ptr ];
	if( !( item1 && item2 ) )
		return 0;

	if( item1->get_size() > item2->get_size() )
		return -1;
	else
	if( item1->get_size() < item2->get_size() )
		return 1;
	else
		return 0;
}
