/***********************************************************************************

	Copyright (C) 2007-2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_LISTITEMDIARY_HEADER
#define LIFEOGRAPH_LISTITEMDIARY_HEADER


#include "helpers.hpp"	// i18n headers
#include "entry.hpp"
#include "diary.hpp"
#include "views.hpp"
#include "widget_textview.hpp"


namespace LIFEO
{

class EntryView : public Entry::Shower
{
								EntryView( void );

		void					sync( void );

		void					focus_tag( void );
		//bool					handle_hboxtagtools_enternotify( GdkEventCrossing * );

		void					show( Entry& );
		void					prepare_for_hiding( Entry& );
		void					toggle_details( void );

	protected:
		enum TagOperation { TO_NONE, TO_ADD, TO_REMOVE, TO_CREATE_AND_ADD };

		void					populate_tags( void );
		void					remove_selected_tags( void );
		void					dismiss_entry( void );
		void					toggle_favoredness( void );
		void					reset_theme( void );
		void					handle_textview_changed( void );
		void					handle_entry_tag_changed( void );
		void					handle_button_tag_clicked( void );
		void					handle_treeviewtags_buttonpress( GdkEventButton* );
		void					handle_drag_data_received(
										const Glib::RefPtr< Gdk::DragContext >&,
										int, int,
										const Gtk::SelectionData&,
										uint,
										guint );

		void					handle_iconview_tags_key_release( GdkEventKey* );
		void					handle_iconview_tags_button_press( GdkEventButton* );

		// WIDGETS
		Gtk::VBox				*m_vbox_entry;
		Gtk::ToggleButton		*m_button_toggle_details;
		Gtk::ToggleButton		*m_button_toggle_favorite;
		Gtk::Button				*m_button_dismiss;
		Gtk::Button				*m_button_reset_theme;

		Gtk::Button				*m_button_add_bullet;
		Gtk::Button				*m_button_add_checkbox;

		TextviewDiary			*m_textviewdiary;
		EntryIdletext			*m_entry_tag;
		Gtk::Button				*m_button_tag_operation;
		Gtk::Menu				*m_menu_tag;
		Gtk::IconView			*m_iconview_tags;
		Gtk::Alignment			*m_alignment_toolbar;
		Gtk::HBox				*m_hbox_editing_toolbar;
		TagOperation			m_tag_operation_cur;

		Glib::RefPtr< Gtk::ListStore >
								m_liststore_tags;

		Entry					*m_ptr2entry;

		bool					m_flag_entrychanged;

	friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
