/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"


u_long id = 1328382269;

u_long options = BE_GFX;
u_long mode = OVERLAY;

char dname[] = "GLCube";
char desc[] = "OpenGL cube";

/* many things shamefully backported from the EC_cube project */
#define ZERO 0.0
#define ONE  1.0

static float CUBE[8][3] =
  {{ ONE,  ONE, -ONE},   // 1
   { ONE, -ONE, -ONE},   // 2
   {-ONE, -ONE, -ONE},
   {-ONE,  ONE, -ONE},   // 4
   {-ONE,  ONE,  ONE},
   { ONE,  ONE,  ONE},   // 6
   { ONE, -ONE,  ONE},
   {-ONE, -ONE,  ONE}};

#define CE(x) glVertex3fv(CUBE[x-1])

#define coucou face


void
create(__attribute__ ((unused)) Context_t *ctx)
{
}


void
destroy(__attribute__ ((unused)) Context_t *ctx)
{
}


static void
cube()
{
  glDisable(GL_TEXTURE_2D);
  glColor3f(1, 1, 1);
  glLineWidth(2);
  glBegin(GL_LINES);
  CE(1); CE(2); CE(2); CE(3); CE(3); CE(4);
  CE(4); CE(5); CE(5); CE(8); CE(8); CE(3);
  CE(1); CE(6); CE(6); CE(7); CE(7); CE(2);
  CE(6); CE(5); CE(5); CE(8); CE(8); CE(7);
  CE(6); CE(1); CE(1); CE(4); CE(4); CE(5);
  CE(7); CE(2); CE(3); CE(8);
  glEnd();
}


static inline void t1() {
  glTexCoord2f(ZERO, ZERO);
}
static inline void t2() {
  glTexCoord2f(ZERO, ONE);
}
static inline void t3() {
  glTexCoord2f(ONE, ONE);
}
static inline void t4() {
  glTexCoord2f(ONE, ZERO);
}


static void
face(const char f)
{
  glBegin(GL_QUADS);
  switch (f) {
  case 0: // front face
    t1(); CE(8);
    t2(); CE(5);
    t3(); CE(6);
    t4(); CE(7);
    break;

  case 1: // back face
    t1(); CE(2);
    t2(); CE(1);
    t3(); CE(4);
    t4(); CE(3);
    break;

  case 2: // left face
    t1(); CE(3);
    t2(); CE(4);
    t3(); CE(5);
    t4(); CE(8);
    break;

  case 3: // right face
    t1(); CE(7);
    t2(); CE(6);
    t3(); CE(1);
    t4(); CE(2);
    break;

  case 4: // up face
    t1(); CE(5);
    t2(); CE(4);
    t3(); CE(1);
    t4(); CE(6);
    break;

  case 5: // bottom face
    t1(); CE(3);
    t2(); CE(8);
    t3(); CE(7);
    t4(); CE(2);
    break;
  }
  glEnd();
}


void
//textures( __attribute__ ((unused)) Context_t *ctx)
textures(/* __attribute__ ((unused)) */Context_t *ctx)
{
  char ibou; /* :) */

  Context_make_GL_texture(ctx, ACTIVE_BUFFER);
  //  printf("texid: %d\n", ctx->textures[ACTIVE_BUFFER]);
  for (ibou = 0; ibou < 6; ibou++)
    coucou(ibou); /* :) again */

  //  glDeleteTextures(1, &ctx->textures[ACTIVE_BUFFER]);
}


void
run(Context_t *ctx)
{
  textures(ctx);
  cube();
  ctx->gl_done = 1;
}
