/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"


u_long id = 1325105220;
u_long options = BE_GFX|BEQ_PICTURE|BEQ_BYPASS;
char desc[] = "1dTV plugin from the EffecTV project";
u_long mode = OVERLAY;

static int line = 0;
static int prevline = 0;
static Pixel_t *linebuf = NULL;


void
create(__attribute__ ((unused)) Context_t *ctx)
{
  if (!ctx->has_cam)
    options |= BEQ_DISABLED;
  else {
    line = MAXY;
    linebuf = xmalloc(WIDTH*sizeof(Pixel_t));
  }
}


void
delete(__attribute__ ((unused)) Context_t *ctx)
{
  xfree(linebuf);
}


static void
blitline_buf(Pixel_t *src, Pixel_t *dest)
{
  memcpy(dest + WIDTH * prevline, linebuf, WIDTH * sizeof(Pixel_t));

  src += WIDTH * line;
  dest += WIDTH * line;
  memcpy(dest, src, WIDTH * sizeof(Pixel_t));
  memcpy(linebuf, src, WIDTH * sizeof(Pixel_t));

  prevline = line;
}


void
run(Context_t *ctx)
{
  int i;
  Pixel_t *src = NULL;
  Pixel_t *dst = passive_buffer(ctx)->buffer;

  if (!ctx->has_cam)
    return;

  pthread_mutex_lock(&ctx->cam_mtx);
  src = ctx->buffers[CAM_IN_BUFFER]->buffer;
  blitline_buf(src, dst);
  pthread_mutex_unlock(&ctx->cam_mtx);

  if (line)
    line--;
  else
    line = MAXY;

  dst += WIDTH * line;
  for (i = 0; i < WIDTH; i++)
    dst[i] = 127;
}
