/***************************************************************************
 *
 *  $Id: kzensearchline.h,v 1.6 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENSEARCHLINE_H
#define KZENSEARCHLINE_H

#include <qhbox.h>

class KComboBox;
class QHBox;
class KLineEdit;
class QCheckBox;
class KIntNumInput;
class KZenRatingWidget;

class KZenSearchCondition;

class KZenTextSearch;
class KZenCategorySearch;
class KZenNumberSearch;
class KZenRatingSearch;

class KZenSearchLine : public QHBox
{
  Q_OBJECT

 public:

  KZenSearchLine(QWidget *parent, const char *name = 0);
  virtual ~KZenSearchLine();
  
  void                        setCondition(KZenSearchCondition * con);
  
 protected slots:

  void                        slotFieldChanged(int);

 protected:

  KComboBox                  *fFieldBox;

  KZenTextSearch             *fTextSearch;
  KZenCategorySearch         *fCategorySearch;
  KZenNumberSearch           *fNumberSearch;
  KZenRatingSearch           *fRatingSearch;

  KZenSearchCondition        *fCondition;

  bool                        fBusy;
  int                         fLastField;
};

class KZenTextSearch : public QHBox
{
  Q_OBJECT

 public:

  KZenTextSearch(QWidget *parent, const char *name = 0);
  virtual ~KZenTextSearch();
  
  void                        setCondition(KZenSearchCondition * con);
  void                        clear();
  void                        setItems(const QStringList &);
  void                        addItem(const QString &);

 protected slots:

  void                        slotOperationChanged(int);
  void                        slotTextChanged(const QString &);
  void                        slotCSChanged();

 protected:

  KComboBox                  *fOperationBox;
  KComboBox                  *fTextEdit;
  QCheckBox                  *fCaseSensitiveCheck;

  KZenSearchCondition        *fCondition;
};

class KZenCategorySearch : public QHBox
{
  Q_OBJECT

 public:

  KZenCategorySearch(QWidget *parent, const char *name = 0);
  virtual ~KZenCategorySearch();
  
  void                        setCondition(KZenSearchCondition * con);
  void                        clear();
  void                        setItems(const QStringList &);
  void                        addItem(const QString &);

 protected slots:

  void                        slotOperationChanged(int);
  void                        slotItemChanged(int);

 protected:

  KComboBox                  *fOperationBox;
  KComboBox                  *fTextEdit;

  KZenSearchCondition        *fCondition;
};

class KZenNumberSearch : public QHBox
{
  Q_OBJECT

 public:

  KZenNumberSearch(QWidget *parent, const char *name = 0);
  virtual ~KZenNumberSearch();

  void                        setCondition(KZenSearchCondition * con);

 protected slots:

  void                        slotOperationChanged(int);
  void                        slotNumberChanged(int);

 protected:
  
  KComboBox                  *fOperationBox;
  KIntNumInput               *fNumEdit;

  KZenSearchCondition        *fCondition;
};

class KZenRatingSearch : public QHBox
{
  Q_OBJECT

 public:

  KZenRatingSearch(QWidget *parent, const char *name = 0);
  virtual ~KZenRatingSearch();

  void                        setCondition(KZenSearchCondition * con);

 protected slots:

  void                        slotOperationChanged(int);
  void                        slotRatingChanged(int);

 protected:
  
  KComboBox                  *fOperationBox;
  KZenRatingWidget           *fRatingEdit;

  KZenSearchCondition        *fCondition;
};

#endif
