/***************************************************************************
 *
 *  $Id: kzenratingwidget.h,v 1.3 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENRATINGWIDGET_H
#define KZENRATINGWIDGET_H

#include <qwidget.h>

/**
@author Andreas Mussgiller
*/

class KZenRatingWidget : public QWidget
{
  Q_OBJECT

 public:
 
  KZenRatingWidget(QWidget *parent = 0, const char *name = 0);
  virtual ~KZenRatingWidget();

  QSize                       sizeHint() const;
  QSize                       minimumSizeHint() const;

  int                         value() const;

 public slots:

  void                        setValue(int value);

 signals:

  void                        valueChanged(int);

 protected:
  
  int                         valueFromPoint(const QPoint &);

  void                        resizeEvent(QResizeEvent *);
  void                        paintEvent(QPaintEvent *);
  void                        keyPressEvent(QKeyEvent *);
  void                        mousePressEvent(QMouseEvent *);
  void                        mouseReleaseEvent(QMouseEvent *);
  void                        mouseMoveEvent(QMouseEvent *);
#ifndef QT_NO_WHEELEVENT
  void                        wheelEvent(QWheelEvent *);
#endif
  void                        focusInEvent(QFocusEvent *);
  void                        focusOutEvent(QFocusEvent *);
  
  virtual void                repaintScreen(const QRect *cr = 0);
  
  int                         fValue;
};

#endif
