/***************************************************************************
 *
 *  $Id: kzenglobal.cpp,v 1.12 2005/06/15 11:13:18 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <kdeversion.h>

#include "kzenitem.h"
#include "kzenartist.h"

#include "kzenglobal.h"

struct ColumnDescription {
  const char * title;
  int width;
  KZen::TagField tagfield;
  KZen::TagFieldType tagfieldtype;
  Qt::AlignmentFlags alignment;
  QListView::WidthMode widthmode;
  bool resizeable;
  bool renameable;
};

static const struct ColumnDescription sColumnDescription[] = {
  {"Title",    10, KZen::FieldTitle,    KZen::FieldTypeText,    Qt::AlignLeft,    QListView::Maximum, true,  true},
  {"Artist",   10, KZen::FieldArtist,   KZen::FieldTypeText,    Qt::AlignLeft,    QListView::Maximum, true,  true},
  {"Album",    10, KZen::FieldAlbum,    KZen::FieldTypeText,    Qt::AlignLeft,    QListView::Maximum, true,  true},
  {"Track",    10, KZen::FieldTrack,    KZen::FieldTypeInt,     Qt::AlignHCenter, QListView::Maximum, true,  true},
  {"Rating",   90, KZen::FieldRating,   KZen::FieldTypeRating,  Qt::AlignHCenter, QListView::Manual,  false, true},
  {"Category",  0, KZen::FieldCategory, KZen::FieldTypeText,    Qt::AlignLeft,    QListView::Maximum, true,  true},
  {"Year",     10, KZen::FieldYear,     KZen::FieldTypeInt,     Qt::AlignHCenter, QListView::Maximum, true,  true},
  {"Length",   10, KZen::FieldLength,   KZen::FieldTypeTime,    Qt::AlignRight,   QListView::Maximum, true,  false},
  {"Genre",    10, KZen::FieldGenre,    KZen::FieldTypeText,    Qt::AlignHCenter, QListView::Maximum, true,  true},
  {"Codec",    10, KZen::FieldCodec,    KZen::FieldTypeText,    Qt::AlignHCenter, QListView::Maximum, true,  false},
  {0,           0, KZen::FieldUnknown,  KZen::FieldTypeUnknown, Qt::AlignHCenter, QListView::Maximum, false, false}
};

static int sColumnIndex[KZen::FieldUnknown] = { -1, -1, -1, -1 };

int KZen::getColumn(TagField field)
{
  if (sColumnIndex[0]==-1) {
    int count = 0;
    while (getTitle(count)) {
      sColumnIndex[getTagField(count)] = count;
      count++;
    }
  }

  return sColumnIndex[field];
}

const char * KZen::getTitle(int c)
{
  return sColumnDescription[c].title;
}

const int KZen::getWidth(int c)
{
  return sColumnDescription[c].width;
}

KZen::TagField KZen::getTagField(int c)
{
  return sColumnDescription[c].tagfield;
}

KZen::TagFieldType KZen::getTagFieldType(int c)
{
  return sColumnDescription[c].tagfieldtype;
}
  
Qt::AlignmentFlags KZen::getAlignment(int c)
{
  return sColumnDescription[c].alignment;
}

QListView::WidthMode KZen::getWidthMode(int c)
{
  return sColumnDescription[c].widthmode;
}

bool KZen::getResizable(int c)
{
  return sColumnDescription[c].resizeable;
}

bool KZen::getRenameable(int c)
{
  return sColumnDescription[c].renameable;
}

QString KZen::formatTime(uint length)
{
  QString t;

  int hours,minutes,seconds;
  seconds = length%60;
  length -= seconds;
  length /= 60;
  minutes = length%60;
  length -= minutes;
  hours = length/60;

  if (hours>0) {
    t.sprintf("%02d:%02d:%02d",hours,minutes,seconds);
  } else {
    t.sprintf("%02d:%02d",minutes,seconds);
  }

  return t;
}
 
KZenArtistItem * KZen::artistItem(QListViewItem * i)
{
  KZenItem * item = (KZenItem*) i;
  if (item->getItemType()==KZenItem::ItemTypeArtist) {
    return (KZenArtistItem*) item;
  }
  return 0;
}

const QColor KZen::backgroundColor(KListViewItem* item, int column)
{
#if KDE_VERSION < KDE_MAKE_VERSION(3,4,0)
  return item->backgroundColor();
#else
  return item->backgroundColor(column);
#endif
}
