/***************************************************************************
 *
 *  $Id: kzenconfigdialog.h,v 1.10 2005/07/01 23:25:17 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENCONFIGDIALOG_H
#define KZENCONFIGDIALOG_H

#include <kdialogbase.h>

class QVBox;
class KZenExplorer;
class KLineEdit;
class KListBox;
class KPushButton;
class KDateTimeWidget;
class QTimer;
class QCheckBox;
class DirSelector;

class KZenConfigDialog : public KDialogBase
{
  Q_OBJECT
    
 public:
 
  KZenConfigDialog(QWidget* parent = 0, const char* name = 0);
  virtual ~KZenConfigDialog();
  
  bool                        modified() { return (fOwnerStringModified|fClockModified); }
  bool                        ownerStringModified() { return fOwnerStringModified; }
  bool                        clockModified() { return fClockModified; }
  void                        setModified(bool v) { fOwnerStringModified = fClockModified = v; }

  void                        setup();
  void                        acceptData();

  const QString &             getOwnerString() { return fOwnerString; }
  void                        setOwnerString(const QString & owner);

  void                        setClock(const QDateTime & datetime);
  const QDateTime &           getClock();

  QStringList &               excludeFromSync();

 protected:

  KZenExplorer               *fExplorer;

  bool                        fBusy;
  
  QVBox                      *fJukeboxPage;
  bool                        fOwnerStringModified;
  QString                     fOwnerString;
  KLineEdit                  *fOwnerEdit;
  bool                        fClockModified;
  QDateTime                   fClock;
  KDateTimeWidget            *fClockWidget;
  KPushButton                *fAdjustClock;
  QTimer                     *fTimer;
  QCheckBox                  *fSmartImport;

  QHBox                      *fCategoryPage;
  KLineEdit                  *fCategoryEdit;
  KListBox                   *fCategoryListBox;
  KPushButton                *fAddCategory;
  KPushButton                *fModifyCategory;
  KPushButton                *fRemoveCategory;

  QVBox                      *fLibraryPage;
  KLineEdit                  *fLocalLibraryEdit;
  KPushButton                *fSelectLocalLibrary;
  KLineEdit                  *fSavePathEdit;
  KLineEdit                  *fSaveNameEdit;

  QVBox                      *fSyncPage;
  QCheckBox                  *fSyncLibrary;
  DirSelector                *fExcludeFromSync;
  QCheckBox                  *fSyncPlayLists;
  QCheckBox                  *fPlayListOverride;
  QCheckBox                  *fCaseSensitiveSearch;
  QCheckBox                  *fExactSearch;

 protected slots:
  
  void                        languageChange();

  void                        ownerChanged(const QString &);
  void                        clockChanged(const QDateTime &);
  void                        clockAdjust();
  void                        timeout();

  void                        categorySelected(int idx);
  void                        addCategory();
  void                        modifyCategory();
  void                        removeCategory();

  void                        syncLibraryChanged();
  void                        syncPlayListsChanged();

  void                        selectLocalLibrary();

  void                        aboutToShow(QWidget *);
};

#endif
