/***************************************************************************
 *   Copyright (C) 2005 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KTRANSLATOR_OCR_H
#define KTRANSLATOR_OCR_H

#include <ui/uiplugin.h>

#include <qpixmap.h>

class KToggleAction;
class OcrWatchdog;
class KlackPluginInterface;
class QOCRProgress;
class QString;

class OCR :public KTranslator::UIPlugin
{
Q_OBJECT
public:
    OCR(QObject *parent, const char* name, const QStringList& );
public slots:
    void toggleOCR();
    void loadModifierKey();
protected slots: // Protected slots
  //void slotShiftAndRightClick(int x,int y);
  /** No descriptions */
  void receivePixmap(QPixmap pixmap,int xOfPoint,int yOfPoint);
  /** Emits a query when OCR finished. */
  void slotEmitSearch( QString );
private:
    void setEnabled( bool enable );
    bool enabled;
    KToggleAction *actionOCR;
    OcrWatchdog *watchdog;
    QOCRProgress *ocr;
    bool m_running;
};


#endif /* KTRANSLATOR_OCR_H */

