/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cronReader.h"

#include <klocale.h>
#include <kmessagebox.h>

CronReader::CronReader(QObject *parent, const char *name) : 
	DefaultReader(parent, name)
	{
	
}


CronReader::~CronReader() {

}


void CronReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Host Name"), true, true));
	columns->append(new LogViewColumn(i18n("Process"), true, true));
	columns->append(new LogViewColumn(i18n("User"), true, true));
	columns->append(new LogViewColumn(i18n("Message"), true, false));
}


/**
 * TODO Improve speed of this method
 */
LogLine* CronReader::parseMessage(QString& line, LogFile* logFile) {
	
	//Use the default parsing
	LogLine* logLine=DefaultReader::parseMessage(line, logFile);
	
	
	QStringList& list=logLine->getItemList();
	
	//Gets the message column (last item) and deletes it
	QString message=list.back();
	list.pop_back();
	
	int leftBracket=message.find('(');
	int rightBracket=message.find(')');
	
	QString user=message.mid(leftBracket+1, rightBracket-leftBracket-1);
	
	list.push_back(user);
	
	message=message.right(message.length() - rightBracket-2);
	
	list.push_back(message);
	
	//This log line comes from Cron Reader
	logLine->setType(Globals::cronMode->id);
	
	return(logLine);
}

#include "cronReader.moc"


