/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCALER_H
#define SCALER_H

#include <qpoint.h>
#include <qimage.h>
#include <qfont.h>

class Scaler
{
  private:
    QSize mBaseResolution;  
    QSize mTargetResolution;

  public:
    Scaler(QSize baseResolution, QSize targetResolution);

    const QSize& baseResolution() { return mBaseResolution; };
    const QSize& targetResolution() { return mTargetResolution; };

    void autoCoords(QPoint* pt, const QFont& f, const QString& s);
    void autoCoords(QPoint* pt, const QSize s);
    void scaleCoords(QPoint* pt);
    bool scaleSize(QImage* i);
    bool scaleSize(QFont* f);

    bool resolutionDiff();
  
    int center(int width, int size, int offset = 0);
    int intIt(const float v);
};

#endif
