/*
	mstatstab.h - A statistics dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSTATSTAB_H__
#define __MSTATSTAB_H__

#include <kdialogbase.h>

class QCheckBox;
class QProcess;
class QTextEdit;

class KPushButton;

/** @short A statistics dialog (output from the `w' command). */
class MStatsTab: public KDialogBase
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 */
	MStatsTab();

	/**
	 * Destructor.
	 */
	virtual ~MStatsTab();

	inline static MStatsTab *getInstance() {
		if (!_instance)
			_instance = new MStatsTab();

		_instance->slotRefresh();
		_instance->show();
		_instance->raise();

		return _instance;
	}
protected:
	void keyPressEvent(QKeyEvent *e);
private:
	KPushButton *b_refresh;
	static MStatsTab *_instance;
	QCheckBox
		*c_longFormat,
		*c_toggleFromField;
	QProcess *_process;
	QString _buf;
	QTextEdit *te_output;
	void killProcess() const;
private slots:
	void slotProcessExit();
	void slotReadStdout();
	void slotRefresh();
};

#endif // __MSTATSTAB_H__
