/***************************************************************************
                          kpskmeter.cpp  -  description
                             -------------------
    begin                : Tue Sep 24 2002
    copyright            : (C) 2002 by David Kjellquist
    email                : kpsk-develop@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*   This class provides an S-Meter (signal strength indicator for the     *
 *   statusbar. Left clicking on this widget brings up a slider to adjust  *
 *   DCD (squelch) level. A vertical redline on the S-Meter display shows  *
 *   the current DCD value.                                                */


#include "kpskmeter.h"
#include "globals.h"

kpskmeter::kpskmeter(QWidget* parent) : QWidget(parent)

{

  setMinimumWidth(60);

  // basic display timer for waterfall
	timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotDrawMeter()));

	/* update signal strength every second,
     faster and display appears to bounce around*/
  timer->start(150, false);

  dcdDialog = NULL;

}


kpskmeter::~kpskmeter()
{
 delete dcdDialog;
}

void kpskmeter::paintEvent(QPaintEvent*)
{

   bitBlt (this, 0,0, &buffer);

   buffer.fill (Qt::black);
}

void kpskmeter::resizeEvent (QResizeEvent* )
{

  buffer.resize(width(), height());
}

void kpskmeter::slotDrawMeter()
{
  QPainter painter;

// get signal strength and dcd level data
  commGetInfo(meterchannel, &meterinfo, sizeof (meterinfo));

  painter.begin (&buffer);

// draw rectangle for strength bar
  painter.setBrush(Qt::yellow);
// 60 - minimum width, 40 - max signal strength, +2 - min width line
  painter.fillRect(0,0,((meterinfo.quality+2)*60)/100, height(), Qt::yellow);

// draw line for dcdlevel
  painter.setPen(Qt::red);
/* +1 ensures in range even if disabled, dcdlevel=-1
   *3 scales max value 20 to width = 60 */
   int x = ((meterinfo.dcdlevel+1)*60)/100;
  painter.drawLine(x,0,x,height());
  painter.setPen(Qt::green);
  painter.drawLine(x/2, 0, x/2, height());
  painter.end();

// paint new meter
  repaint();
}

// press left mouse button for dcd level slider adjust
void kpskmeter::mousePressEvent (QMouseEvent* event)
{
   if (event->button() == LeftButton && event->state() == 0) {

      if (dcdDialog == NULL)
      dcdDialog = new dcdDlg (this, meterchannel, meterinfo.dcdlevel);
      dcdDialog->show();
   }
}

// set the correct rx channel
void kpskmeter::setChannel(int ch)
{
  meterchannel = ch;
}
