/***************************************************************************
                          kpregitem.cpp  -  description
                             -------------------
    begin                : Sun Aug 26 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpregitem.h"

KpregItem::KpregItem(QString _title, QString _content, QString _type, QListBox *_qlb, KPopupMenu *_subMenu, QPixmap *_blue_type, QPixmap *_yellow_type, QPixmap *_red_type){
	title = _title;
	content = _content;
	qlb = _qlb;
	subMenu = _subMenu;
	blue_pm = _blue_type;
	yellow_pm = _yellow_type;
	red_pm = _red_type;
	if ( _type == "blue" ) {
		type = blue_type;
	}
	if ( _type == "red" ) {
		type = red_type;
	}
	if ( _type == "yellow" ) {
		type = yellow_type;
	}
}

void KpregItem::atualizeViewItem (){         
	qlb->changeItem  ( *getIcon(), getViewItem(), qlb->currentItem () );
	subMenu->changeItem  ( subMenu->idAt(menuId), *getIcon(), getViewItem() );
}

void KpregItem::setMenuId (int a) {
 	menuId = a;
}

QPixmap* KpregItem::getIcon () {
	if (type == yellow_type)
		return yellow_pm;
	if (type == blue_type)
		return blue_pm;
	if (type == red_type)
		return red_pm;

	return yellow_pm;
}

QString KpregItem::getContent(){
	return content;
}

QString KpregItem::getTitle(){
	return title;
}

Type KpregItem::getType(){
	return type;
}

void KpregItem::setTitle (QString a){
	title = a;
}

void KpregItem::setContent (QString a){
	content = a;
}

void KpregItem::setType (Type t){
	type = t;
}

QDomDocumentFragment KpregItem::save(QDomDocument qdd){
	itemXMLfactory ixf ( title, content, type );
	return  ixf . getFragment(qdd);
}

QString KpregItem::getViewItem(){
	if ( type == blue_type )
		return content;
	if ( type == red_type )
		return title;
	if ( type == yellow_type ) {
		QString str (title);
		str . append ( " - ");
		str . append (content);
		return str;
	}
	return content;
}




