//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgconnectioninthread.h"

// include files for Qt
#include <qdatetime.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>

#include "DbObjects/kpgtreeitem.h"


KPGConnectionInThread::KPGConnectionInThread() : QThread()
{
    m_pConnection = 0;
	m_iCustomEventType = 0;
    m_OperationType = eRunSql; // default
	// setTerminationEnabled(true); TODO Qt 4.x
}

KPGConnectionInThread::~KPGConnectionInThread()
{
    if(m_pConnection)
    {
        if(m_pConnection->is_open() == true)
		{
			m_pConnection->disconnect();
		}
        delete m_pConnection;
  	}
}

// Try connect to PostgreSQL server by given connection strong. Throw exception, if fails
void KPGConnectionInThread::connectToServer(const QString &strConnectString)
{
    m_pConnection = new KPGConnection(strConnectString);
    
        
    if(m_pConnection->is_open() == false)
    {
        kdError() << "Failed to open connection" << endl;
        throw PGSTD::runtime_error(i18n("Failed to open connection"));
    }
}

// Close connection
void KPGConnectionInThread::disconnectFromServer()
{
    if(m_pConnection)
    {
        if(m_pConnection->is_open() == true)
        m_pConnection->disconnect();
    
        delete m_pConnection;
        m_pConnection = 0;
    }
}

// Call it when connection thread is terminated
void KPGConnectionInThread::leaveConnection()
{
    if(m_pConnection)
    {
        m_pConnection = 0;
    }
}

// Unprepare prepared statement
void KPGConnectionInThread::unprepareStatement()
{
    if((m_pConnection) && (m_OperationType == eRunPreparedStatement))
    {
        try
        {
            m_pConnection->unprepare(m_stdstrPrepStmtName);
        }
        catch (const std::exception &e)
        {   
            kdError() << k_funcinfo "Exception: " <<  e.what() << endl;
            kdError() << k_funcinfo "Cann't unprepare statement: " <<  m_stdstrPrepStmtName << endl;
        }
    }
}

// Unprepare prepared statement
void KPGConnectionInThread::unprepareStatement(const std::string &stdstrPrepStmtName)
{
    if((m_pConnection) && (m_OperationType == eRunPreparedStatement))
    {
        try
        {
            m_pConnection->unprepare(stdstrPrepStmtName);
        }
        catch (const std::exception &e)
        {   
            kdError() << k_funcinfo "Exception: " <<  e.what() << endl;
            kdError() << k_funcinfo "Cann't unprepare statement: " <<  stdstrPrepStmtName << endl;
        }
    }
}

void KPGConnectionInThread::run()
{
	KPGQueryResultEvent *pQueryResultEvent = new KPGQueryResultEvent(m_pConnection, m_iCustomEventType);
	// run query on selected database
	try
	{
		QTime t;
		t.start();
		
		if(m_OperationType == eRunSql)
		{
			*m_pPqxxResult = m_pConnection->runQuery(m_strSQL, m_eTransType);
		}
		else if(m_OperationType == eRunPreparedStatement)
		{
			*m_pPqxxResult = m_pConnection->runPreparedStatement(m_stdstrPrepStmtName, m_listArgumentsWithValues, m_eTransType);
		}
		else
		{
			kdError() << k_funcinfo <<  "Unknown operation !" << endl;
		}
		
		pQueryResultEvent->setExecutionMiliseconds(t.elapsed());
	}
	catch(const std::exception &e)
	{
		pQueryResultEvent->setError(m_pConnection->toUnicode(e.what()));
	} 
	
	QApplication::postEvent(m_pEventReceiver, pQueryResultEvent);
}
