//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgaclitem.h"

// include files for KDE
#include <kdebug.h>


KPGAclItem::KPGAclItem(const QString &strACL)
{
  m_bSELECT = false;
  m_bUPDATE = false;
  m_bINSERT = false;
  m_bDELETE = false; 
  m_bRULE = false;
  m_bREFERENCES = false;
  m_bTRIGGER = false;
  m_bEXECUTE = false;
  m_bUSAGE = false;
  m_bCREATE = false;
  m_bTEMPORARY = false;
    
  m_bGrantSELECT = false;
  m_bGrantUPDATE = false;
  m_bGrantINSERT = false;
  m_bGrantDELETE = false;
  m_bGrantRULE = false;
  m_bGrantREFERENCES = false; 
  m_bGrantTRIGGER = false;
  m_bGrantEXECUTE = false;
  m_bGrantUSAGE = false;
  m_bGrantCREATE = false;
  m_bGrantTEMPORARY = false;
  
  m_bIsGroup = false;
  m_pListViewItem = 0;
  
  unsigned int i = 0;
  
  // Get grantee
  for(; i < strACL.length(); i++)
  {
    if(strACL[i] == '"')
      continue;
      
    if(strACL[i] == '=')
    {  
      if(m_strGrantee.isEmpty())
      {
        m_strGrantee = "PUBLIC";
      }
      i++;
      break;
    }
      
    m_strGrantee.append(strACL[i]);
  }
  
  // Get ACL string
  QString strPrivileges;     // ACL - privilege, such as "arwdRxt" for table
  for(; i < strACL.length(); i++)
  {
    if(strACL[i] == '/')
      break;
      
    strPrivileges.append(strACL[i]);
  }
  
  parsePrivileges(strPrivileges);
  
  // Get grantor
  for(; i < strACL.length(); i++)
  {
    if((strACL[i] == '"') || (strACL[i] == '}') || (strACL[i] == '/'))
      continue;
      
    m_strGrantor.append(strACL[i]);
  }
}


KPGAclItem::~KPGAclItem()
{
}

void KPGAclItem::parsePrivileges(const QString &strPrivileges)
{
  for(unsigned int i = 0; i < strPrivileges.length(); i++)
  {
    
    switch(strPrivileges[i])
    {
      case 'r':
          m_bSELECT = true;
          break;
          
      case 'w':
          m_bUPDATE = true;
          break;
          
      case 'a':
          m_bINSERT = true;
          break;
          
      case 'd':
          m_bDELETE = true;
          break;
          
      case 'R':
          m_bRULE = true;
          break;
          
      case 'x':
          m_bREFERENCES = true;
          break;
          
      case 't':
          m_bTRIGGER = true;
          break;    
            
      case 'X':
          m_bEXECUTE = true;
          break;  
          
      case 'U':
          m_bUSAGE = true;
          break;
          
      case 'C':
          m_bCREATE = true;
          break;  
        
      case 'T':
          m_bTEMPORARY = true;
          break;
          
      case '*': // * -- grant option for preceding privilege
          {
            switch(strPrivileges[i - 1])
            {
              case 'r':
                  m_bGrantSELECT = true;
                  break;
                  
              case 'w':
                  m_bGrantUPDATE = true;
                  break;
                  
              case 'a':
                  m_bGrantINSERT = true;
                  break;
                  
              case 'd':
                  m_bGrantDELETE = true;
                  break;
                  
              case 'R':
                  m_bGrantRULE = true;
                  break;
                  
              case 'x':
                  m_bGrantREFERENCES = true;
                  break;
                  
              case 't':
                  m_bGrantTRIGGER = true;
                  break;    
                    
              case 'X':
                  m_bGrantEXECUTE = true;
                  break;  
                  
              case 'U':
                  m_bGrantUSAGE = true;
                  break;
                  
              case 'C':
                  m_bGrantCREATE = true;
                  break;  
                
              case 'T':
                  m_bGrantTEMPORARY = true;
                  break;
            
              default:
                kdError() << "KPGAclItem::parsePrivileges - unexpected character: " << QString(strPrivileges[i - 1]) << endl;
                kdError() << strPrivileges << endl;
                break;     
            }
          }
          break;
          
      default:
          kdError() << "KPGAclItem::parsePrivileges - unexpected character: " << QString(strPrivileges[i]) <<  endl;
          kdError() << strPrivileges << endl;
          break;      
          
    }
  }
    
  // Initialize variables for user editing to state loaded from DB server
  m_bSELECT_New = m_bSELECT;
  m_bUPDATE_New = m_bUPDATE;
  m_bINSERT_New = m_bINSERT;
  m_bDELETE_New = m_bDELETE; 
  m_bRULE_New = m_bRULE;
  m_bREFERENCES_New = m_bREFERENCES;
  m_bTRIGGER_New = m_bTRIGGER;
  m_bEXECUTE_New = m_bEXECUTE;
  m_bUSAGE_New = m_bUSAGE;
  m_bCREATE_New = m_bCREATE;
  m_bTEMPORARY_New = m_bTEMPORARY;
    
  m_bGrantSELECT_New = m_bGrantSELECT;
  m_bGrantUPDATE_New = m_bGrantUPDATE;
  m_bGrantINSERT_New = m_bGrantINSERT;
  m_bGrantDELETE_New = m_bGrantDELETE;
  m_bGrantRULE_New = m_bGrantRULE;
  m_bGrantREFERENCES_New = m_bGrantREFERENCES; 
  m_bGrantTRIGGER_New = m_bGrantTRIGGER;
  m_bGrantEXECUTE_New = m_bGrantEXECUTE;
  m_bGrantUSAGE_New = m_bGrantUSAGE;
  m_bGrantCREATE_New = m_bGrantCREATE;
  m_bGrantTEMPORARY_New = m_bGrantTEMPORARY;    
}

const QString KPGAclItem::getSQL(const QString &strObjectTypeName) const
{
  QString strSQL;
  
  if(m_bSELECT != m_bSELECT_New)
  {
    if(m_bSELECT_New)
      strSQL.append("GRANT SELECT ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE SELECT ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bUPDATE != m_bUPDATE_New)
  {
    if(m_bUPDATE_New)
      strSQL.append("GRANT UPDATE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE UPDATE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bINSERT != m_bINSERT_New)
  {
    if(m_bINSERT_New)
      strSQL.append("GRANT INSERT ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE INSERT ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bDELETE != m_bDELETE_New)
  {
    if(m_bDELETE_New)
      strSQL.append("GRANT DELETE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE DELETE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }

  if(m_bRULE != m_bRULE_New)
  {
    if(m_bRULE_New)
      strSQL.append("GRANT RULE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE RULE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bREFERENCES != m_bREFERENCES_New)
  {
    if(m_bREFERENCES_New)
      strSQL.append("GRANT REFERENCES ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE REFERENCES ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bTRIGGER != m_bTRIGGER_New)
  {
    if(m_bTRIGGER_New)
      strSQL.append("GRANT TRIGGER ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE TRIGGER ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bEXECUTE != m_bEXECUTE_New)
  {
    if(m_bEXECUTE_New)
      strSQL.append("GRANT EXECUTE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE EXECUTE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bUSAGE != m_bUSAGE_New)
  {
    if(m_bUSAGE_New)
      strSQL.append("GRANT USAGE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE USAGE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bCREATE != m_bCREATE_New)
  {
    if(m_bCREATE_New)
      strSQL.append("GRANT CREATE ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE CREATE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bTEMPORARY != m_bTEMPORARY_New)
  {
    if(m_bTEMPORARY_New)
      strSQL.append("GRANT TEMPORARY ON " + strObjectTypeName + " TO " + m_strGrantee + ";\n");
    else
      strSQL.append("REVOKE TEMPORARY ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  //------------------------------------------------------------------------------------------
  // WITH GRANT OPTIONs
  //------------------------------------------------------------------------------------------
  if(m_bGrantSELECT != m_bGrantSELECT_New)
  {
    if(m_bGrantSELECT_New)
      strSQL.append("GRANT SELECT ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR SELECT ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
    if(m_bGrantUPDATE != m_bGrantUPDATE_New)
  {
    if(m_bGrantUPDATE_New)
      strSQL.append("GRANT UPDATE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR UPDATE ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantINSERT != m_bGrantINSERT_New)
  {
    if(m_bGrantINSERT_New)
      strSQL.append("GRANT INSERT ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR INSERT ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantDELETE != m_bGrantDELETE_New)
  {
    if(m_bGrantDELETE_New)
      strSQL.append("GRANT DELETE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR DELETE ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }

  if(m_bGrantRULE != m_bGrantRULE_New)
  {
    if(m_bGrantRULE_New)
      strSQL.append("GRANT RULE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR RULE ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantREFERENCES != m_bGrantREFERENCES_New)
  {
    if(m_bGrantREFERENCES_New)
      strSQL.append("GRANT REFERENCES ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR REFERENCES ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantTRIGGER != m_bGrantTRIGGER_New)
  {
    if(m_bGrantTRIGGER_New)
      strSQL.append("GRANT TRIGGER ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR TRIGGER ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantEXECUTE != m_bGrantEXECUTE_New)
  {
    if(m_bGrantEXECUTE_New)
      strSQL.append("GRANT EXECUTE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR EXECUTE ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  if(m_bGrantUSAGE != m_bGrantUSAGE_New)
  {
    if(m_bGrantUSAGE_New)
      strSQL.append("GRANT USAGE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR USAGE ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantCREATE != m_bGrantCREATE_New)
  {
    if(m_bGrantCREATE_New)
      strSQL.append("GRANT CREATE ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR CREATE ON " + strObjectTypeName + " FROM " + m_strGrantee + " ;\n");
  }
  
  if(m_bGrantTEMPORARY != m_bGrantTEMPORARY_New)
  {
    if(m_bGrantTEMPORARY_New)
      strSQL.append("GRANT TEMPORARY ON " + strObjectTypeName + " TO " + m_strGrantee + " WITH GRANT OPTION;\n");
    else
      strSQL.append("REVOKE GRANT OPTION FOR TEMPORARY ON " + strObjectTypeName + " FROM " + m_strGrantee + ";\n");
  }
  
  return strSQL;
}

bool KPGAclItem::canPassGrantToOther() const
{
  // Grant options can only be granted to individual users, not to groups or PUBLIC
  if(m_strGrantee == "PUBLIC")
    return false;
    
  if(m_strGrantee.left(6) == "group ")
    return false;
    
  return true;  
}
