//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdumpdatabasewizard.h"

#include <qframe.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klocale.h>
#include <kdebug.h>

#include <dcopclient.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qtextedit.h>

#include "konsoleviewwidget.h"


KPGDumpDatabaseWizard::KPGDumpDatabaseWizard(QWidget *parent, const char *name, DCOPClient *pDcopClient, const QString &strDatabase, const QString &strHostname, const QString &strPort, const QString &strUsername)
 : KPGDumpDatabaseWizardBase(parent, name)
{
    m_pDcopClient = pDcopClient;
    m_strDatabase = strDatabase;
    m_strHostname = strHostname;
    m_strPort = strPort;
    m_strUsername = strUsername;
    
    m_pPartManager = new KParts::PartManager(this);
    
    QVBoxLayout *pLayout = new QVBoxLayout(m_pFrameConsole);
    
    m_pConsoleWidget = new KonsoleViewWidget(m_pPartManager, m_pFrameConsole);
    connect(m_pPartManager, SIGNAL(activePartChanged(KParts::Part*)), m_pConsoleWidget, SLOT(activePartChanged(KParts::Part*)));
    
    connect(m_pConsoleWidget, SIGNAL(sigProcessExited()), this, SLOT(slotProcessExited()));
    
    pLayout->addWidget(m_pConsoleWidget);
    
    m_pConsoleWidget->setIcon( SmallIcon("konsole") );
    m_pConsoleWidget->setCaption(i18n("Konsole"));
    
    setNextEnabled(WizardPage1, false);
}


KPGDumpDatabaseWizard::~KPGDumpDatabaseWizard()
{
    delete m_pConsoleWidget;
    delete m_pPartManager;
}

// When this function called, initialize appropriate Wizard page
void KPGDumpDatabaseWizard::showPage(QWidget *pPage)
{
    // call parent
    KPGDumpDatabaseWizardBase::showPage(pPage);
    
    if(pPage == WizardPage2) 
    {
        QStrList listArguments = getDumpArguments();
        QString strArguments("");  
        for(QStrListIterator it(listArguments); it.current(); ++it) 
        {    
            strArguments.append(*it);
            strArguments.append("\n");
        }
        
     m_pTextEditCommand->setText(strArguments);
    }
    
    if(pPage == WizardPage3) 
    {
        /**
        * @deprecated Remove later
        
        m_dcopTalkThread.setDcopClient(m_pDcopClient);
        m_dcopTalkThread.setCommand(m_pTextEditCommand->text());
        m_dcopTalkThread.start(); // send command to m_pConsoleWidget via DCOP
        m_dcopTalkThread.wait();*/
        
        cancelButton()->setEnabled(false);
        setBackEnabled(WizardPage3, false);
        setFinishEnabled(WizardPage3, false);
        
        m_pConsoleWidget->startProgram("pg_dump", getDumpArguments());
    }
}

void KPGDumpDatabaseWizard::slotOutputFileChanged(const QString &strOutputFile)
{
    setNextEnabled(WizardPage1, !strOutputFile.isEmpty());
}

void KPGDumpDatabaseWizard::slotFormatChanged(int iFormat)
{
    m_pCheckBoxOnlyData->setEnabled(iFormat == 0); // This option is only meaningful for the plain-text format. 
    m_pCheckBoxCreate->setEnabled(iFormat == 0); // This option is only meaningful for the plain-text format. 
    m_pIntNumInputCompressionLevel->setEnabled(iFormat == 2); // Currently only the custom archive format supports compression.
    m_pCheckBoxIncludeBlobs->setEnabled(iFormat != 0); // plain-text format not support large objects
}

void KPGDumpDatabaseWizard::slotOnlyDataToggled(bool bToggled)
{
    m_pCheckBoxOnlySchema->setEnabled(!bToggled);
    m_pCheckBoxDisableTriggers->setEnabled(bToggled);
}

void KPGDumpDatabaseWizard::slotOnlySchemaToggled(bool bToggled)
{
    m_pCheckBoxOnlyData->setEnabled(!bToggled);
}

void KPGDumpDatabaseWizard::slotProcessExited()
{
    cancelButton()->setEnabled(true);
    setBackEnabled(WizardPage3, true);
    setFinishEnabled(WizardPage3, true);
}

QStrList KPGDumpDatabaseWizard::getDumpArguments() const
{
    QStrList listArguments;
    listArguments.append("pg_dump");     
    listArguments.append("--host=" + m_strHostname); 
    listArguments.append("--port=" + m_strPort);
    listArguments.append("--username=" + m_strUsername);
    listArguments.append("--file=" + m_pURLRequesterOutputFile->url());
    
    if(m_pComboBoxFormat->currentItem() == 0)
        listArguments.append("--format=p");
    else if(m_pComboBoxFormat->currentItem() == 1)
        listArguments.append("--format=t");
    else if(m_pComboBoxFormat->currentItem() == 2)
    {
        listArguments.append("--format=c");
        listArguments.append("--compress=" + QString("%1").arg(m_pIntNumInputCompressionLevel->value()));
    }
    
    if(m_pCheckBoxOnlyData->isChecked() && (m_pComboBoxFormat->currentItem() == 0))
        listArguments.append("--data-only");  
        
    if(m_pCheckBoxOnlySchema->isChecked())
        listArguments.append("--schema-only");   
        
    if(m_pCheckBoxIncludeBlobs->isChecked() && (m_pComboBoxFormat->currentItem() != 0))
        listArguments.append("--blobs");
        
    if(m_pCheckBoxClean->isChecked())
        listArguments.append("--clean");
        
    if(m_pCheckBoxCreate->isChecked())
        listArguments.append("--create");
        
    if(m_pCheckBoxInserts->isChecked())
        listArguments.append("--inserts");
        
    if(m_pCheckBoxColumnInserts->isChecked())
        listArguments.append("--column-inserts");
        
    if(m_pCheckBoxIgnoreVersion->isChecked())
        listArguments.append("--ignore-version");
            
    if(m_pCheckBoxOIDs->isChecked())
        listArguments.append("--oids");
        
    if(m_pCheckBoxNoOwner->isChecked())
        listArguments.append("--no-owner");
        
    if(m_pCheckBoxVerbose->isChecked())
        listArguments.append("--verbose");
    
    if(m_pCheckBoxNoPrivileges->isChecked())
        listArguments.append("--no-acl");
    
    if(m_pCheckBoxDisDollarQuoting->isChecked())
        listArguments.append("--disable-dollar-quoting");  
        
    if(m_pCheckBoxOnlyData->isChecked() && m_pCheckBoxDisableTriggers->isChecked())
        listArguments.append("--disable-triggers");  
        
    if(m_pCeckBoxSetSessionAuth->isChecked())
        listArguments.append("--use-set-session-authorization");      
        
    listArguments.append(m_strDatabase);
    
    return listArguments;
}

/*

const QString PGDumpDatabaseWizard::getDumpArguments() const
{
    QString strCommand(m_strDatabase + " --file=");
    
    strCommand.append(m_pURLRequesterOutputFile->url());
    
    strCommand.append(" --host=" + m_strHostname); 
    strCommand.append(" --port=" + m_strPort);
    strCommand.append(" -U " + m_strUsername);
    
    if(m_pComboBoxFormat->currentItem() == 0)
        strCommand.append(" --format=p");
    else if(m_pComboBoxFormat->currentItem() == 1)
        strCommand.append(" --format=t");
    else if(m_pComboBoxFormat->currentItem() == 2)
{
        strCommand.append(" --format=c");
        strCommand.append(" --compress=" + QString("%1").arg(m_pIntNumInputCompressionLevel->value()));
}
    
    if(m_pCheckBoxOnlyData->isChecked() && (m_pComboBoxFormat->currentItem() == 0))
        strCommand.append(" --data-only");  
        
    if(m_pCheckBoxOnlySchema->isChecked())
        strCommand.append(" --schema-only");   
        
    if(m_pCheckBoxIncludeBlobs->isChecked() && (m_pComboBoxFormat->currentItem() != 0))
        strCommand.append(" --blobs");
        
    if(m_pCheckBoxClean->isChecked())
        strCommand.append(" --clean");
        
    if(m_pCheckBoxCreate->isChecked())
        strCommand.append(" --create");
        
    if(m_pCheckBoxInserts->isChecked())
        strCommand.append(" --inserts");
        
    if(m_pCheckBoxColumnInserts->isChecked())
        strCommand.append(" --column-inserts");
        
    if(m_pCheckBoxIgnoreVersion->isChecked())
        strCommand.append(" --ignore-version");
            
    if(m_pCheckBoxOIDs->isChecked())
        strCommand.append(" --oids");
        
    if(m_pCheckBoxNoOwner->isChecked())
        strCommand.append(" --no-owner");
        
    if(m_pCheckBoxVerbose->isChecked())
        strCommand.append(" --verbose");
    
    if(m_pCheckBoxNoPrivileges->isChecked())
        strCommand.append(" --no-acl");
    
    if(m_pCheckBoxDisDollarQuoting->isChecked())
        strCommand.append(" --disable-dollar-quoting");  
        
    if(m_pCheckBoxOnlyData->isChecked() && m_pCheckBoxDisableTriggers->isChecked())
        strCommand.append(" --disable-triggers");  
        
    if(m_pCeckBoxSetSessionAuth->isChecked())
        strCommand.append(" --use-set-session-authorization");      
        
    return strCommand;
}

*/

#include "kpgdumpdatabasewizard.moc"
