//
// C++ Interface: kpgtablespaceproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLESPACEPROPPAGE_H
#define KPGTABLESPACEPROPPAGE_H

#include "kpgtablespaceproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

class KPGTablespace;

/**
  * Tablespace property page
  *
  * @author Lumir Vanek
  */
class KPGTablespacePropPage : public KPGTablespacePropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGTablespacePropPage(QWidget *parent, KPGTablespace *);
    ~KPGTablespacePropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
    void setACL(const QString &);
    
protected:
    KPGTablespace * m_pTablespace;
    KPGAclItemList m_listOfAclItems;
    
signals:
	void sigSearchObject(pqxx::oid);
    void sigRunWizard(const QString &);	
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
	
protected slots:
  
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
                
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
};

#endif
