/***************************************************************************
                          kpgserverproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgserverproppage.h"

// include files for Qt
#include <qtextcodec.h>
#include <qstring.h>
#include <qtable.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qclipboard.h>

#include <ktabwidget.h>

// include files for KDE
#include <kiconloader.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>

#include "../kpgutil.h"
#include "../kpglinklabel.h"
#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgserver.h"
#include "../kpgsqldialog.h"

KPGServerPropPage::KPGServerPropPage(QWidget *parent, KPGServer *pServer)
 : KPGServerPropPageBase(parent, "KPGServerPropPage")
{
	m_pServer = pServer;
  	m_pTableDatabases->verticalHeader()->setResizeEnabled( false );
  
  	m_pTabWidget->setTabIconSet(tabActivity, QIconSet(QPixmap(SmallIcon("ksysguard.png")))); 
  
  	m_pButtonRefresh->setIconSet(QIconSet(QPixmap(BarIcon("reload.png")))); 
  	m_pButtonCopySql->setIconSet(QIconSet(QPixmap(BarIcon("editcopy.png")))); 
  	m_pButtonCancelQuery->setIconSet(QIconSet(QPixmap(BarIcon("stop.png")))); 
  	
  	displayProperties();
}


KPGServerPropPage::~KPGServerPropPage()
{
}

void KPGServerPropPage::displayProperties()
{
	bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	int iColumns = 9;
	
	// Is it 8.0 or newer ?
	if(m_pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
    }     
	    
    // Is it 8.1 or newer ?
	if(((m_pServer->versionMajor() == 8) && (m_pServer->versionMiddle() >= 1)) || ((m_pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
		iColumns += 1;
	}
	
	// Display server properties
	setVersionInfo(m_pServer->versionInfo());
	
    try
    {
        m_ptextLabelConnectionEncoding->setText(m_pServer->connection()->clientEncoding());
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        KMessageBox::sorry(this, m_pServer->connection()->toUnicode(e.what()));
        return;
    }
    
	//----------------------------------------------------------------------------
	int nTableCols = KPGUtil::fillPropertiesTable(m_pServer->resultDatabases(), m_pTableDatabases, m_pServer->connection()->textCodec(), true, iColumns);
	
	// field names
	QHeader* pHeader = m_pTableDatabases->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Owner"));
	
	if(m_pServer->versionMajor() <= 7)
		pHeader->setLabel(nCol++, i18n("Path"));
	else
		pHeader->setLabel(nCol++, i18n("Tablespace"));
		
	pHeader->setLabel(nCol++, i18n("Encoding"));
	
	if(bVersion81_OrNewer) 
  	{
  		pHeader->setLabel(nCol++, i18n("Size"));
  	}
	
	pHeader->setLabel(nCol++, i18n("Can create"));
	pHeader->setLabel(nCol++, i18n("Default variables"));
	pHeader->setLabel(nCol++, i18n("Allow connection"));
	pHeader->setLabel(nCol++, i18n("Is template"));
	pHeader->setLabel(nCol++, i18n("ACL"));
		
		
	for(int nCol = 0; nCol < nTableCols; nCol++)
	{
		m_pTableDatabases->adjustColumn(nCol);
	}
	
	displayActivity();
}

void KPGServerPropPage::displayActivity()
{
	try
	{
		pqxx::result pqxxResultActivity = m_pServer->queryActivity();
		
		// fill properties table with result data
		int nTableCols = KPGUtil::fillPropertiesTable(pqxxResultActivity, m_pTableActivity, m_pServer->connection()->textCodec());
		
		// field names
		QHeader* pHeader = m_pTableActivity->horizontalHeader();
	
		int nCol = 0;
		pHeader->setLabel(nCol++, i18n("Database"));
		pHeader->setLabel(nCol++, i18n("Process ID"));
		pHeader->setLabel(nCol++, i18n("User"));
		pHeader->setLabel(nCol++, i18n("Current query"));
		pHeader->setLabel(nCol++, i18n("Query start"));
		
		for(int nCol = 0; nCol < nTableCols; nCol++)
		{
		    m_pTableActivity->adjustColumn(nCol);
		}
	
	}
	catch (const KPGSqlException &e)
	{
        KPGSqlDialog dlg(this, e.sql(), e.message());
	    dlg.exec();
	}
}

void KPGServerPropPage::setVersionInfo(const QString & strVersionInfo)
{
	m_pLineEditVersion->setText(strVersionInfo);
}

void KPGServerPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableDatabases->cellWidget(iRow, iCol);
    if(w == 0)
      return;
          
    KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
    pqxx::oid _oid = pLabel->oid();
      
    if(_oid != 0)
      emit sigSearchObject(_oid);
}

void KPGServerPropPage::slotRefreshActivity()
{
	displayActivity();
}

void KPGServerPropPage::slotCopySql()
{
	int currentRow = m_pTableActivity->currentRow();
	if(currentRow < 0) return;
	
	QString sqlQuery = m_pTableActivity->text(currentRow, 3);
	
	QApplication::clipboard()->setText(sqlQuery);
}

void KPGServerPropPage::slotCancelQuery()
{
	int currentRow = m_pTableActivity->currentRow();
	if(currentRow < 0) return;
	
	QString strPID = m_pTableActivity->text(currentRow, 1);
	bool bOk;
	int iPID = strPID.toInt(&bOk);
	
	if (KMessageBox::questionYesNo(this, i18n("Cancel a backend's current query for PID %1 ?").arg(iPID)) != KMessageBox::Yes) return;
	
	try
	{
		bool bResult = m_pServer->cancelBackend(iPID);
		if(bResult)
			slotRefreshActivity();
	}
	catch (const std::exception &e)
    {
        QTextCodec *pTextCodec = QTextCodec::codecForLocale(); 
		KMessageBox::sorry(this, pTextCodec->toUnicode(e.what()));
    }
}

// Consumes request for context menu for property table
void KPGServerPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgserverproppage.moc"
