//
// C++ Interface: kpgtrigger
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTRIGGER_H
#define KPGTRIGGER_H

#include "kpgobject.h"

class KPGTriggersFolder;

/**
  * Table trigger
  * 
  * @author Lumir Vanek
  */
class KPGTrigger : public KPGObject
{
public:
    KPGTrigger(KPGTriggersFolder *, const QString, pqxx::oid);
	KPGTrigger(KPGTriggersFolder *, KPGTrigger *, const QString, pqxx::oid);
    ~KPGTrigger();

	virtual eNodeType type() const { return nodeTrigger; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "TRIGGER"; }
	
	void setProperties(const pqxx::result::tuple &, const KPGConnection *pConnection);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	/*
	 * Functions for accessing properties
	 */
	const QString & enabled() const { return m_strIsEnabled; }
	bool isDeferrable() const { return m_bDeferrable; }
	bool isInitiallyDeferred() const { return m_bInitDeferred; }
	const QString & nameSpace() const { return m_strNameSpace;	}
	int numArguments() const { return m_iNArgs; }
	const QString & arguments() const { return m_strArgs; }
	pqxx::oid oidProcedure() const { return m_oidProcedure; }
	const QString & procName() const { return m_strProcName; }
		
protected:
	
	/*
	 * Properties
	 */
	QString m_strIsEnabled;
	bool m_bDeferrable;
	bool m_bInitDeferred;
	int m_iNArgs;
	QString m_strNameSpace;
	QString m_strArgs;
	pqxx::oid m_oidProcedure;
	QString m_strProcName;
};

#endif
