//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrestoredatabasewizard.h"

#include <qframe.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klocale.h>
#include <kdebug.h>

#include <dcopclient.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qtextedit.h>

#include "konsoleviewwidget.h"


KPGRestoreDatabaseWizard::KPGRestoreDatabaseWizard(QWidget *parent, const char *name, DCOPClient *pDcopClient, const QString &strDatabase, const QString &strHostname, const QString &strPort, const QString &strUsername)
 : KPGRestoreDatabaseWizardBase(parent, name)
{
  m_pDcopClient = pDcopClient;
  m_strDatabase = strDatabase;
  m_strHostname = strHostname;
  m_strPort = strPort;
  m_strUsername = strUsername;
  
  m_pPartManager = new KParts::PartManager(this);
  
  QVBoxLayout *pLayout = new QVBoxLayout(m_pFrameConsole);
  
  m_pConsoleWidget = new KonsoleViewWidget(m_pPartManager, m_pFrameConsole);
  connect(m_pPartManager, SIGNAL(activePartChanged(KParts::Part*)), m_pConsoleWidget, SLOT(activePartChanged(KParts::Part*)));

  pLayout->addWidget(m_pConsoleWidget);
  
  m_pConsoleWidget->setIcon( SmallIcon("konsole") );
  m_pConsoleWidget->setCaption(i18n("Konsole"));
  
  setNextEnabled(WizardPage1, false);
}


KPGRestoreDatabaseWizard::~KPGRestoreDatabaseWizard()
{
  delete m_pConsoleWidget;
  delete m_pPartManager;
}

// When this function called, initialize appropriate Wizard page
void KPGRestoreDatabaseWizard::showPage(QWidget *pPage)
{
  // call parent
  KPGRestoreDatabaseWizardBase::showPage(pPage);
  
  if(pPage == WizardPage2) 
  {
    m_pTextEditCommand->setText(getCommand());
  }
  
  if(pPage == WizardPage3) 
  {
    m_dcopTalkThread.setDcopClient(m_pDcopClient);
    m_dcopTalkThread.setCommand(m_pTextEditCommand->text());
    m_dcopTalkThread.start(); // send command to m_pConsoleWidget via DCOP
    
    setFinishEnabled(WizardPage3, true);
  }
}

void KPGRestoreDatabaseWizard::slotInputFileChanged(const QString &strInputFile)
{
  setNextEnabled(WizardPage1, !strInputFile.isEmpty());
}

void KPGRestoreDatabaseWizard::slotOnlyDataToggled(bool bToggled)
{
  m_pCheckBoxOnlySchema->setEnabled(!bToggled);
  m_pCheckBoxDisableTriggers->setEnabled(bToggled);
}

void KPGRestoreDatabaseWizard::slotOnlySchemaToggled(bool bToggled)
{
  m_pCheckBoxOnlyData->setEnabled(!bToggled);
} 

const QString KPGRestoreDatabaseWizard::getCommand() const
{
  QString strCommand("pg_restore ");
    
  strCommand.append(" --dbname=" + m_strDatabase);
  
  strCommand.append(" --host=" + m_strHostname);  
  strCommand.append(" --port=" + m_strPort);  
  strCommand.append(" -U " + m_strUsername);  
  
  if(m_pCheckBoxOnlyData->isChecked())
    strCommand.append(" --data-only");  

  if(m_pCheckBoxOnlySchema->isChecked())
    strCommand.append(" --schema-only");   
       
  if(m_pCheckBoxClean->isChecked())
    strCommand.append(" --clean");
    
  if(m_pCheckBoxExitOnError->isChecked())
    strCommand.append(" --exit-on-error");  
    
  /*
   TODO: use when called from server as : Create from DUMP 
   if(m_pCheckBoxCreate->isChecked())
    strCommand.append(" --create");
  */
      
  if(m_pCheckBoxIgnoreVersion->isChecked())
    strCommand.append(" --ignore-version");
    
 if(m_pCheckBoxNoOwner->isChecked())
    strCommand.append(" --no-owner");
    
  if(m_pCheckBoxVerbose->isChecked())
    strCommand.append(" --verbose");
  
  if(m_pCheckBoxNoPrivileges->isChecked())
    strCommand.append(" --no-acl");
  
  if(m_pCheckBoxDisableTriggers->isChecked())
    strCommand.append(" --disable-triggers");  
    
  if(m_pCeckBoxSetSessionAuth->isChecked())
    strCommand.append(" --use-set-session-authorization");   
 
  strCommand.append(" " + m_pURLRequesterInputFile->url());
        
  return strCommand;
}

#include "kpgrestoredatabasewizard.moc"
