//
// C++ Interface: kpgcreateviewwidget4
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATEVIEWWIDGET4_H
#define KPGCREATEVIEWWIDGET4_H

#include "kpgcreateviewwidget4base.h"

#include "kpgtablecolumnwizinfo.h"

#include "kpgcreateviewwizard.h"

class KPGDatabase;

/**
Widget for create view Wizard

@author Lumir Vanek
*/

class KPGCreateViewWidget4 : public KPGCreateViewWidget4Base
{
	Q_OBJECT
public:
    KPGCreateViewWidget4(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGCreateViewWidget4();

    void setNamespace(const QString &strNamespace) { m_strNamespace = strNamespace; }
    
    void setMapTableNameAlias(const MapTableNameAlias &mapTableNameAlias)
	{
		m_MapTableNameAlias = mapTableNameAlias;
	}
    
    const QString getSQL() const;
	void refreshAvailColumnsList(const QString &);

protected:
	void enableAddConditionButton(QListBoxItem*, int, const QString &);

protected:
	KPGDatabase *m_pDatabase;
    QString m_strNamespace; // name of the namespace
    
    // Map of pair of <QString strTableName, QString strAlias> 	
    MapTableNameAlias m_MapTableNameAlias;
    
	bool m_bCheckBoxShowSysColumns;
	KPGListTableColumnWizInfo m_listOfAvailableColumns;
		
protected slots:

	virtual void slotCheckBoxShowSysColumnsToggled(bool);
	virtual void slotComboBoxTableActivated(const QString &);
	virtual void slotColumnsSelectChanged(QListBoxItem*);
	virtual void slotComboBoxConditionActivated(int);
	virtual void slotLineEditValueTextChanged(const QString &);
    virtual void slotConditionsSelectionChanged(QListViewItem *);
    virtual void slotConditionsCurrentChanged(QListViewItem *);
		
	virtual void slotConditionAdd();
    virtual void slotConditionDelete();
		
signals:
	void sigEnableNextButton(bool);		
};

#endif
