//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablespacewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "kpgcreatetablespacewidget1.h"
#include "kpgcreatetablespacewidget2.h"

KPGCreateTablespaceWizard::KPGCreateTablespaceWizard(QWidget *parent, const char *name, KPGServer *pServer)
 : KPG4StepsWizard(parent, name)
{
  KPGCreateTablespaceWidget1 *pCreateTablespaceWidget1 = new KPGCreateTablespaceWidget1(WizardPage1, "KPGCreateTablespaceWidget1");
  m_pPageWidget1 = pCreateTablespaceWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTablespaceWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  KPGCreateTablespaceWidget2 *pCreateTablespaceWidget2 = new KPGCreateTablespaceWidget2(WizardPage2, "KPGCreateTablespaceWidget2");
  m_pPageWidget2 = pCreateTablespaceWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  //connect(pCreateTablespaceWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  pServer->getUsersFolder()->fillComboBoxWithChildItems(pCreateTablespaceWidget1->m_pComboBoxOwner);
  
  pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateTablespaceWidget2->m_pListBoxUsersGroups);
  pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateTablespaceWidget2->m_pListBoxUsersGroups);
  
  languageChange();
  
  setNextEnabled(WizardPage2, true);
}


KPGCreateTablespaceWizard::~KPGCreateTablespaceWizard()
{
}

void KPGCreateTablespaceWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
    
    setCaption( i18n( "Create new tablespace" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Tablespace name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Grant create privileges" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTablespaceWizard::showPage(QWidget *pPage)
{ 
  if(pPage == WizardPage2) // Step 2 - Define user rights
  {
    KPGCreateTablespaceWidget1 *pCreateTablespaceWidget1 = static_cast <KPGCreateTablespaceWidget1 *> (m_pPageWidget1);
    KPGCreateTablespaceWidget2 *pCreateTablespaceWidget2 = static_cast <KPGCreateTablespaceWidget2 *> (m_pPageWidget2);
        
    // Set tablespace name
    pCreateTablespaceWidget2->setTablespaceName(pCreateTablespaceWidget1->m_pLineEditTablespaceName->text());
  }
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    
    strSQL.append((static_cast <KPGCreateTablespaceWidget1 *> (m_pPageWidget1))->getSQL());
    strSQL.append(";\n\n");
    strSQL.append((static_cast <KPGCreateTablespaceWidget2 *> (m_pPageWidget2))->getSQL());
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage4) // Step 4 - Check operation result
  {
    runQuery(false);
  }
  
  // call parent
  KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreatetablespacewizard.moc"
