//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatelanguagewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "kpgcreatelanguagewidget1.h"
#include "kpgcreatelanguagewidget2.h"


KPGCreateLanguageWizard::KPGCreateLanguageWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPG4StepsWizard(parent, name)
{
  KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
  
  KPGCreateLanguageWidget1 *pCreateLanguageWidget1 = new KPGCreateLanguageWidget1(WizardPage1, "KPGCreateLanguageWidget1", pDatabase);
  m_pPageWidget1 = pCreateLanguageWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateLanguageWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  KPGCreateLanguageWidget2 *pCreateLanguageWidget2 = new KPGCreateLanguageWidget2(WizardPage2, "KPGCreateLanguageWidget2");
  m_pPageWidget2 = pCreateLanguageWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  //connect(pCreateLanguageWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateLanguageWidget2->m_pListBoxUsersGroups);
  pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateLanguageWidget2->m_pListBoxUsersGroups);
    
  languageChange();
  
  setNextEnabled(WizardPage2, true);
}


KPGCreateLanguageWizard::~KPGCreateLanguageWizard()
{
}

void KPGCreateLanguageWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
    
    setCaption( i18n( "Create new language" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Language name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Grant usage privileges" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateLanguageWizard::showPage(QWidget *pPage)
{ 
  if(pPage == WizardPage2) // Step 2 - Define user rights
  {
    KPGCreateLanguageWidget1 *pCreateLanguageWidget1 = static_cast <KPGCreateLanguageWidget1 *> (m_pPageWidget1);
    KPGCreateLanguageWidget2 *pCreateLanguageWidget2 = static_cast <KPGCreateLanguageWidget2 *> (m_pPageWidget2);
        
    // Set language name
    pCreateLanguageWidget2->setLanguageName(pCreateLanguageWidget1->m_pLineEditLanguageName->text());
  }
  
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateLanguageWidget1 *> (m_pPageWidget1))->getSQL());
    strSQL.append(";\n");
    strSQL.append((static_cast <KPGCreateLanguageWidget2 *> (m_pPageWidget2))->getSQL());
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage4) // Step 4 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreatelanguagewizard.moc"
