//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedomainconstraintwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreatedomainwidget3.h"
#include "../kpgutil.h"

KPGCreateDomainConstraintWizard::KPGCreateDomainConstraintWizard(QWidget *parent, const char *name, const QString& strNamespace, const QString& strDomain)
 : KPG3StepsWizard(parent, name)
{
  m_strNamespace = strNamespace; 
  m_strDomain = strDomain;
  
  KPGCreateDomainWidget3 *pCreateDomainWidget3 = new KPGCreateDomainWidget3(WizardPage1, "KPGCreateDomainWidget3"); m_pPageWidget1 = pCreateDomainWidget3;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateDomainWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
       
  languageChange();
}

KPGCreateDomainConstraintWizard::~KPGCreateDomainConstraintWizard()
{
}

void KPGCreateDomainConstraintWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Create new domain constraint(s)" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Domain constraints" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateDomainConstraintWizard::showPage(QWidget *pPage)
{   
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    KPGCreateDomainWidget3 *pCreateDomainWidget3 = (static_cast <KPGCreateDomainWidget3 *> (m_pPageWidget1));
    
    // prepare SQL statement
    QString strSQL;
    
    QListViewItem * pItem = pCreateDomainWidget3->m_pListViewConstraints->firstChild();
    while(pItem)
    {
      strSQL.append("ALTER DOMAIN ");
      strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strDomain));
      strSQL.append(" ADD ");
      
      strSQL.append(pItem->text(0));
      strSQL.append(";\n");
              
      pItem = pItem->nextSibling();
    }
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpgcreatedomainconstraintwizard.moc"
