//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcopyfromtablewidget1.h"

// include files for Qt
#include <qcheckbox.h>

// include files for KDE
#include <kactionselector.h> 
#include <kurlrequester.h>

// application specific includes
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCopyFromTableWidget1::KPGCopyFromTableWidget1(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPGCopyFromTableWidget1Base(parent, name)
{
  pTable->getTableColumnsFolder()->fillListBoxWithChildItems(m_pColumnsSelector->availableListBox(), false);
  
  m_strTableName = pTable->text(0);
  m_strNamespace = strNamespace;
  
  m_pURLRequesterFile->setURL(m_strTableName + ".txt");
    
  // This is here, instead of making connection in Qt Designer due to bug - forward declaration
  // class QListBoxItem; is not added to h file.
  connect( m_pColumnsSelector, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotColumnAdded(QListBoxItem*) ) );
  connect( m_pColumnsSelector, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotColumnRemoved(QListBoxItem*) ) );
}

KPGCopyFromTableWidget1::~KPGCopyFromTableWidget1()
{
}

void KPGCopyFromTableWidget1::slotUrlChanged(const QString &strURL)
{
  if(strURL.isEmpty())
    emit sigEnableNextButton(false);
  else
  {
    if(m_pCheckBoxAllColumns->isChecked())
      emit sigEnableNextButton(true);
    else
    {
      if(m_pColumnsSelector->selectedListBox()->count() == 0)
        emit sigEnableNextButton(false);
    }
  }
}

void KPGCopyFromTableWidget1::slotAllColumnsToggled(bool bAllColumns)
{
  m_pColumnsSelector->setEnabled(!bAllColumns);
  if(bAllColumns)
    emit sigEnableNextButton(!m_pURLRequesterFile->url().isEmpty());
  else
  {
    if(m_pColumnsSelector->selectedListBox()->count() == 0)
       emit sigEnableNextButton(false);
  }
}

void KPGCopyFromTableWidget1::slotColumnAdded(QListBoxItem *)
{
  emit sigEnableNextButton(!m_pURLRequesterFile->url().isEmpty());
}

void KPGCopyFromTableWidget1::slotColumnRemoved(QListBoxItem *)
{
  if(m_pColumnsSelector->selectedListBox()->count() == 0)
    emit sigEnableNextButton(false);
} 

void KPGCopyFromTableWidget1::slotCsvToggled(bool bCsv)
{
  QString strURL(m_pURLRequesterFile->url());
  
  if(bCsv && strURL.endsWith(".txt"))
    {
      strURL = strURL.left(strURL.length() - 4);
      strURL.append(".csv");
      m_pURLRequesterFile->setURL(strURL);
    }
    
  if(!bCsv && strURL.endsWith(".csv"))
    {
      strURL = strURL.left(strURL.length() - 4);
      strURL.append(".txt");
      m_pURLRequesterFile->setURL(strURL);
    }
}

const QString KPGCopyFromTableWidget1::getSQL() const
{
  QString strSQL("COPY ");
  
  strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
  
  if(m_pCheckBoxAllColumns->isChecked() == false)
  {
    strSQL.append(" (");
    
    for(unsigned int i = 0; i < m_pColumnsSelector->selectedListBox()->count(); i++)
    {
      strSQL.append(KPGUtil::quotedName(m_pColumnsSelector->selectedListBox()->text(i)));
      
      if(i < m_pColumnsSelector->selectedListBox()->count() - 1)
        strSQL.append(", ");
    }
    
    strSQL.append(")");
  }
  
  strSQL.append("\nTO '");
  strSQL.append(m_pURLRequesterFile->url());
  strSQL.append("'");
  
  return strSQL;
}

#include "kpgcopyfromtablewidget1.moc"
