//
// C++ Implementation: kpgtableindexesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableindexesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgtableindexesfolder.h"


KPGTableIndexesFolderPropPage::KPGTableIndexesFolderPropPage(QWidget* parent, KPGTableIndexesFolder * pTableIndexesFolder)
	: KPGPropertyPage(parent, "KPGTableIndexesFolderPropPage")
{
	m_pTableIndexesFolder = pTableIndexesFolder;
	displayProperties();
}


KPGTableIndexesFolderPropPage::~KPGTableIndexesFolderPropPage()
{
}

void KPGTableIndexesFolderPropPage::displayProperties()
{
	// Get pointer to server for version info
	//                      table   -> tblfold-> schema ->database->server 
	KPGServer *pServer = static_cast <KPGServer *> (m_pTableIndexesFolder->parent()->parent()->parent()->parent()->parent());
	
    bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	int iColumns = 7;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
       iColumns += 1;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
		iColumns += 1;
	}
	
	setLabelText(i18n("Endexes &list:"));
		
	QHeader* pHeader = m_pTableItems->horizontalHeader();

	int nCol = 0;
  	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Type"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Index key"));
	pHeader->setLabel(nCol++, i18n("Is Unique"));
	pHeader->setLabel(nCol++, i18n("Is Primary"));
	pHeader->setLabel(nCol++, i18n("Is Clustered"));
	if(bVersion80_OrNewer) pHeader->setLabel(nCol++, i18n("Tablespace"));
	if(bVersion81_OrNewer) pHeader->setLabel(nCol++, i18n("Size"));
		
	KPGUtil::fillPropertiesTable(m_pTableIndexesFolder->resultIndexes(), m_pTableItems, true, iColumns);
}


