//
// C++ Implementation: kpgaggregatesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgaggregatesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgaggregatesfolder.h"

KPGAggregatesFolderPropPage::KPGAggregatesFolderPropPage(QWidget* parent, KPGAggregatesFolder * pAggregatesFolder)
	: KPGPropertyPage(parent, "KPGAggregatesFolderPropPage")
{
	m_pAggregatesFolder = pAggregatesFolder;
	displayProperties();
}


KPGAggregatesFolderPropPage::~KPGAggregatesFolderPropPage()
{
}

void KPGAggregatesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Agregates &list:"));
		
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Aggregate function"));
  	pHeader->setLabel(nCol++, i18n("Owner"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Transition function"));
  	pHeader->setLabel(nCol++, i18n("Final function"));
	pHeader->setLabel(nCol++, i18n("Input type"));
	pHeader->setLabel(nCol++, i18n("Transition type"));
	pHeader->setLabel(nCol++, i18n("Return type"));
	pHeader->setLabel(nCol++, i18n("Initial value"));
	
	KPGUtil::fillPropertiesTable(m_pAggregatesFolder->resultAggregates(), m_pTableItems);
}


