/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <KDebug>
#include <KLocale>

#include "komparator.h"
#include "komparatorwidget.h"

#include <version.h>

Komparator::Komparator( bool start_minimized, const KUrl &url1, const KUrl &url2 )
		: KMainWindow(),
		m_komparator_widget( new KomparatorWidget( url1, url2, this ) )
{
	really_close = false;
	setCentralWidget( (QWidget *)m_komparator_widget );
	if ( start_minimized && m_komparator_widget->isSystrayVisible() )
	{
		hide();
	}
	else
	{
		show();
	}
}

Komparator::~Komparator()
{
}

void Komparator::slotQuit()
{
	really_close = true;
	close();
	QApplication::quit();
}

bool Komparator::queryClose()
{
	if ( really_close ) return true;

	if ( m_komparator_widget->isSystrayVisible() )
	{
		hide();
		return false;
	}

	QApplication::quit(); // why does it need to be here?
	return true;
}

#include "komparator.moc"
