/***************************************************************************
                          options.cpp  -  description
                             -------------------
    begin                : Wed May 3 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include	<kapp.h>
#include  <stdlib.h>
#include <qmessagebox.h>
#include <dirent.h>

#include "komba2.h"

#include "options.h"
Options::Options (QObject * parent, const char *name):
QObject (parent, name)
{
  host_accounts = new QList < host_account >;
  wg_accounts = new QList < wg_account >;
  share_accounts = new QList < share_account >;
  readAll ();
}

Options::~Options ()
{
}

void
Options::saveShareToMount ()
{
  KConfig *config = kapp->config ();
  config->setGroup ("OTHERS");
  config->writeEntry ("SHARESTOMOUNT", sharestomount);
  config->writeEntry ("HOSTSTOMOUNT", hosts_mntshares);

}


void
Options::saveAll ()
{
  KConfig *config = kapp->config ();
  config->setGroup ("IP_RANGES");
  config->writeEntry ("IPS", ipranges);

  config->setGroup ("HOSTS");
  config->writeEntry ("HOST", hosts);

  config->setGroup ("FILE");
  config->writeEntry ("MOUNTPATH", mountpath);

  config->setGroup ("OTHERS");
  config->writeEntry ("SCANALLHOSTS", (scanallhosts && scanallworkgroups));
  config->writeEntry ("SCANALLWORKGROUPS", scanallworkgroups);
  config->writeEntry ("UNMOUNTONEXIT", unmountallonexit);
  config->writeEntry ("HIDEIPCSHARES", hideipcshares);
  config->writeEntry ("HIDE$SHARES", hidedollarshares);
  config->writeEntry ("HIDEPRINTERS", hideprinters);
  config->writeEntry ("EXPLOREAFTERMOUNT", exploreaftermount);
  config->writeEntry ("SAVE_PASSWORDS", savepasswords);
  config->writeEntry ("NOPASSWORDDIALOG", nopassworddialog);
  config->writeEntry ("KOMBAVERSION", VERSION);
  config->writeEntry ("MNT_LAST_SESSION_SHARES",
		      (mntlastsessionshares && unmountallonexit));
  config->writeEntry ("SHARESTOMOUNT", sharestomount);
  config->writeEntry ("CLEANUPONUNMOUNT", cleanuponunmount);

  config->setGroup ("SMBMOUNT");
  config->writeEntry ("SMBMOUNTVER", smbmountversion);
  config->writeEntry ("HOSTSTOMOUNT", hosts_mntshares);

  config->setGroup ("SHAREACCOUNTS");
  share_account *shareitem = share_accounts->first ();
  while (shareitem)
    {
      config->writeEntry (QString ("//") + shareitem->hostname +
			  QString ("/") + shareitem->sharename +
			  QString ("_User"),
			  encryptStr (shareitem->username));
      config->writeEntry (QString ("//") + shareitem->hostname +
			  QString ("/") + shareitem->sharename +
			  QString ("_Password"),
			  encryptStr (shareitem->password));
      config->writeEntry (QString ("//") + shareitem->hostname +
			  QString ("/") + shareitem->sharename +
			  QString ("_AskForPassword"),
			  shareitem->ask_for_password);
      shareitem = share_accounts->next ();
    }
  config->setGroup ("HOSTACCOUNTS");
  host_account *hostitem = host_accounts->first ();
  while (hostitem)
    {
      config->writeEntry (hostitem->hostname + QString ("_User"),
			  encryptStr (hostitem->username));
      config->writeEntry (hostitem->hostname + QString ("_Password"),
			  encryptStr (hostitem->password));
      config->writeEntry (hostitem->hostname + QString ("_AskForPassword"),
			  hostitem->ask_for_password);
      hostitem = host_accounts->next ();
    }
  config->setGroup ("DOMAINACCOUNTS");
  wg_account *wgitem = wg_accounts->first ();
  while (wgitem)
    {
      config->writeEntry (wgitem->wgname + QString ("_User"),
			  encryptStr (wgitem->username));
      config->writeEntry (wgitem->wgname + QString ("_Password"),
			  encryptStr (wgitem->password));
      config->writeEntry (wgitem->wgname + QString ("_AskForPassword"),
			  wgitem->ask_for_password);
      wgitem = wg_accounts->next ();
    }
}

/**  */
void
Options::readAll ()
{
  KConfig *config = kapp->config ();
  config->setGroup ("IP_RANGES");
  config->readListEntry ("IPS", ipranges);

  config->setGroup ("HOSTS");
  config->readListEntry ("HOST", hosts);

  config->setGroup ("FILE");
  QString mp = QString (getenv ("HOME"));
  mountpath = config->readEntry ("MOUNTPATH", mp + "/komba/");

  config->setGroup ("OTHERS");
  scanallhosts = config->readBoolEntry ("SCANALLHOSTS", false);
  scanallworkgroups = config->readBoolEntry ("SCANALLWORKGROUPS", false);
  unmountallonexit = config->readBoolEntry ("UNMOUNTONEXIT", false);
  hideipcshares = config->readBoolEntry ("HIDEIPCSHARES", true);
  hidedollarshares = config->readBoolEntry ("HIDE$SHARES", false);
  hideprinters = config->readBoolEntry ("HIDEPRINTERS", false);
  mntlastsessionshares =
    config->readBoolEntry ("MNT_LAST_SESSION_SHARES", false);
  savepasswords = config->readBoolEntry ("SAVE_PASSWORDS", false);
  exploreaftermount = config->readBoolEntry ("EXPLOREAFTERMOUNT", true);
  nopassworddialog = config->readBoolEntry ("NOPASSWORDDIALOG", false);
  cleanuponunmount = config->readBoolEntry ("CLEANUPONUNMOUNT", false);

  config->readListEntry ("SHARESTOMOUNT", sharestomount);
  config->readListEntry ("HOSTSTOMOUNT", hosts_mntshares);

  config->setGroup ("SMBMOUNT");
  smbmountversion = config->readNumEntry ("SMBMOUNTVER", 207);
  // Accounts will be read
  QMap < QString, QString >::Iterator it;
  QString key;
  QString hostname;
  QString sharename;
  QString username;
  QString password;
  bool askForPassword;
  QMap < QString, QString > map = config->entryMap ("SHAREACCOUNTS");
  for (it = map.begin (); it != map.end (); it++)
    {
      // Username
      if (it.key ().right (QString ("_User").length ()) == QString ("_User"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_User").length ());
	  hostname = HostOf (key);
	  sharename = ShareOf (key);
	  username = decryptStr (it.data ());
	  setShareAccount (hostname, sharename, username, QString::null, true,
			   1);
	}
      // Password
      if (it.key ().right (QString ("_Password").length ()) ==
	  QString ("_Password"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_Password").length ());
	  hostname = HostOf (key);
	  sharename = ShareOf (key);
	  password = decryptStr (it.data ());
	  setShareAccount (hostname, sharename, QString::null, password, true,
			   2);
	}
      // Ask_for_Password
      if (it.key ().right (QString ("_AskForPassword").length ()) ==
	  QString ("_AskForPassword"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_AskForPassword").length ());
	  hostname = HostOf (key);
	  sharename = ShareOf (key);
	  askForPassword = ((it.data () == "1") || (it.data () == "TRUE")
			    || (it.data () == "true"));
	  setShareAccount (hostname, sharename, QString::null, QString::null,
			   askForPassword, 3);
	}
    }
  map.clear ();
  // Hostaccounts
  map = config->entryMap ("HOSTACCOUNTS");
  for (it = map.begin (); it != map.end (); it++)
    {
      // Username                     
      if (it.key ().right (QString ("_User").length ()) == QString ("_User"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_User").length ());
	  hostname = key;
	  username = decryptStr (it.data ());
	  setHostAccount (hostname, username, QString::null, true, 1);
	}
      // Password
      if (it.key ().right (QString ("_Password").length ()) ==
	  QString ("_Password"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_Password").length ());
	  hostname = key;
	  password = decryptStr (it.data ());
	  setHostAccount (hostname, QString::null, password, true, 2);
	}
      // Ask_for_Password
      if (it.key ().right (QString ("_AskForPassword").length ()) ==
	  QString ("_AskForPassword"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_AskForPassword").length ());
	  hostname = key;
	  askForPassword = ((it.data () == "1") || (it.data () == "TRUE")
			    || (it.data () == "true"));
	  setHostAccount (hostname, QString::null, QString::null,
			  askForPassword, 3);
	}
    }
  map.clear ();
  // Workgroup (Domain)-Accounts
  QString wgname;
  map = config->entryMap ("DOMAINACCOUNTS");
  for (it = map.begin (); it != map.end (); it++)
    {
      // Username
      if (it.key ().right (QString ("_User").length ()) == QString ("_User"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_User").length ());
	  wgname = key;
	  username = decryptStr (it.data ());
	  setWorkgroupAccount (wgname, username, QString::null, true, 1);
	}
      // Password
      if (it.key ().right (QString ("_Password").length ()) ==
	  QString ("_Password"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_Password").length ());
	  wgname = key;
	  password = decryptStr (it.data ());
	  setWorkgroupAccount (wgname, QString::null, password, true, 2);
	}
      // Ask_for_Password
      if (it.key ().right (QString ("_AskForPassword").length ()) ==
	  QString ("_AskForPassword"))
	{
	  key =
	    it.key ().left (it.key ().length () -
			    QString ("_AskForPassword").length ());
	  wgname = key;
	  askForPassword = ((it.data () == "1") || (it.data () == "TRUE")
			    || (it.data () == "true"));
	  setWorkgroupAccount (wgname, QString::null, QString::null,
			       askForPassword, 3);
	}
    }
  map.clear ();

}

bool
  Options::getPreferences (const char *group, const char *name,
			   QString * setting)
{
  KConfig *config = kapp->config ();
  config->setGroup (group);
  *setting = config->readEntry (name);
  return !(setting->length () == 0);

}

void
Options::setShareAccount (const QString host, const QString share,
			  const QString username, const QString password,
			  bool ask_for_pw, int save)
{
  share_account *item = share_accounts->first ();
  while ((item != 0)
	 && ((item->hostname.compare (host) != 0)
	     || (item->sharename.compare (share) != 0)))
    item = share_accounts->next ();
  if (item == 0)
    {
      item = new share_account;
      item->hostname = host;
      item->sharename = share;
      share_accounts->append (item);
    }
  if ((save == 0) || (save == 1))
    item->username = username;
  if ((save == 0) || (save == 2))
    item->password = password;
  if ((save == 0) || (save == 3))
    item->ask_for_password = ask_for_pw;
}

bool
  Options::getShareAccount (const QString host, const QString share,
			    QString & username, QString & password,
			    bool * ask)
{
  share_account *item = share_accounts->first ();
  while ((item != 0)
	 && ((item->hostname.compare (host) != 0)
	     || (item->sharename.compare (share) != 0)))
    item = share_accounts->next ();
  if (item)
    {
      username = item->username;
      password = item->password;
      *ask = item->ask_for_password;
      return true;
    }
  return false;
}

void
Options::setHostAccount (const QString host, const QString username,
			 const QString password, bool ask_for_pw, int save)
{
  host_account *item = host_accounts->first ();
  while ((item != 0) && (item->hostname.compare (host) != 0))
    item = host_accounts->next ();
  if (item == 0)
    {
      item = new host_account;
      item->hostname = host;
      item->ask_for_password = true;
      host_accounts->append (item);
    }
  if ((save == 0) || (save == 1))
    item->username = username;
  if ((save == 0) || (save == 2))
    item->password = password;
  if ((save == 0) || (save == 3))
    {
      item->ask_for_password = ask_for_pw;
    }
}

bool
  Options::getHostAccount (const QString host, QString & username,
			   QString & password, bool * ask)
{
  host_account *item = host_accounts->first ();
  while ((item != 0) && (item->hostname.compare (host) != 0))
    item = host_accounts->next ();
  if (item)
    {
      username = item->username;
      password = item->password;
      *ask = item->ask_for_password;
      return true;
    }
  return false;
}

void
Options::setWorkgroupAccount (const QString wg, const QString username,
			      const QString password, bool ask_for_pw,
			      int save)
{
  wg_account *item = wg_accounts->first ();
  while ((item != 0) && (item->wgname.compare (wg) != 0))
    item = wg_accounts->next ();
  if (item == 0)
    {
      item = new wg_account;
      item->wgname = wg;
      wg_accounts->append (item);
    }
  if ((save == 0) || (save == 1))
    item->username = username;
  if ((save == 0) || (save == 2))
    item->password = password;
  if ((save == 0) || (save == 3))
    item->ask_for_password = ask_for_pw;
}

bool
  Options::getWorkgroupAccount (const QString wg, QString & username,
				QString & password)
{
  wg_account *item = wg_accounts->first ();
  while ((item != 0) && (item->wgname.compare (wg) != 0))
    item = wg_accounts->next ();
  if (item)
    {
      username = item->username;
      password = item->password;
      return true;
    }
  return false;
}

/**  */
QString Options::ShareOf (QString stm)
{
  int
    i =
    stm.
    findRev ("/");
  if (i > 0)
    return stm.right (stm.length () - i - 1);
  else
    return "";

}

/*  */
QString Options::HostOf (QString stm)
{
  int
    i =
    stm.
    findRev ("/");
  int
    i1 =
    stm.
    findRev ("//");
  if ((i > 0) && (i1 >= 0))
    return stm.mid (i1 + 2, i - i1 - 2);
  else
    return "";

}

void
Options::appendShareToMount (QString wg, QString h, QString s)
{
  QString ins ("//");
  ins += h;
  ins += "/";
  ins += s;
  sharestomount.append (ins);
  ins = h;
  ins += "\t";
  ins += wg;
  hosts_mntshares.append (ins);
}

/** Look for if share is to mount (LastSessionShares) */
bool Options::isToMount (QString sname)
{
  if (firstShareToMount ())
    {
      do
	{
	  if (currentShareOfShareToMount () == sname)
	    return true;
	}
      while (nextShareToMount ());
    }
  return false;
}

//////////////////////////////////////////////////////////
//      encryptStr()            +++ from KMail 1.2 ++++
// KMAcctExpPop.cpp
// Authors: Don Sanders, (based on kmacctpop by)
//          Stefan Taferner and Markus Wuebben
//
//      Description : encrypt a String , second time you get the
//                                                              Original
///////////////////////////////////////////////////////////
const
  QString
Options::encryptStr (const QString aStr) const
{
  unsigned int i, val;
  unsigned int len = aStr.length ();
  QCString result;
  result.resize (len + 1);

  for (i = 0; i < len; i++)
    {
      val = aStr[i] - ' ';
      val = (255 - ' ') - val;
      result[i] = (char) (val + ' ');
    }
  result[i] = '\0';

  return result;
}

//////////////////////////////////////////////////////////
//      encryptStr()            +++ from KMail 1.2 ++++
// KMAcctExpPop.cpp
// Authors: Don Sanders, (based on kmacctpop by)
//          Stefan Taferner and Markus Wuebben
//
//      Description : decrypt a encrypted String
///////////////////////////////////////////////////////////
const QString
Options::decryptStr (const QString aStr) const
{
  return encryptStr (aStr);
}
