/***************************************************************************
                          knutclient.cpp  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutprefdlg.h"
#include "knutprintupsvar.h"
#include "knutinstcomms.h"
#include "knutrwvar.h"
#include "knutclient.h"

#include <qdatetime.h>
#include <qmutex.h>

#include <kconfig.h>
#include <ksimpleconfig.h>

#include <kwin.h>

#include <unistd.h>  // for function sleep and other ...

//#include <iostream>




//  const char *nameUpsVars1[] = {
//  "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID","BATTVOLT","OUTVOLT",CURRENT};
//  const char *nameUpsVars2[] = {
//    "none", "input.voltage", "battery.charge", "ups.temperature", "input.frequency", "ups.load", "ambient.temperature",
//"ambient.humidity","battery.voltage","output.voltage","output.current","battery.temperature","battery.current"};

  extern const char *nameUpsVars1[];
  extern const char *nameUpsVars2[];

KNutClient::KNutClient(bool noDock, QObject* parent, const char *name) : QObject(parent, name) {

  upsRecords = new KNutUpsData();
  analogRecords = new KNutVarData();

  m_upsTimer = new QTimer (this);
  connect( m_upsTimer, SIGNAL(timeout()), SLOT(slotTimeout()) );

  m_reconnectTimer = new QTimer(this);
  connect( m_reconnectTimer, SIGNAL(timeout()), SLOT(slotReconnectTimeout()) );


  //  data for combo
  m_listKNutEvent = new QStringList();

  // init and load of configuration
  initVars();

  loadConfiguration();

  if (!noDock) {
    m_myDock = new KNutDock(&m_mainUpsInfo,&settingData,upsRecords);

    m_myDock->show();
    connect(m_myDock, SIGNAL(endApplication()), this, SLOT(slotExitApplication()));
    connect(m_myDock, SIGNAL(activeMainWindow()), this, SLOT(slotActiveMainWindow()));
    connect(m_myDock, SIGNAL(minimize()), this, SLOT(closeMainWindow()));
    connect(m_myDock, SIGNAL(UPSChanged(QString)), this, SLOT(slotSetNewUPS (QString)));

    connect(m_myDock, SIGNAL(preferences()),this, SLOT(slotPreferenceUps()));
    connect(m_myDock, SIGNAL(printUPSVars()),this, SLOT(slotPrintUPSVars()));
    connect(m_myDock, SIGNAL(instComms()),this, SLOT(slotInstComms()));
    connect(m_myDock, SIGNAL(RWVars()),this, SLOT(slotRWVars()));
    connect(m_myDock, SIGNAL(makeRefreshConnection()),this, SLOT(slotRefreshConnection()));
    }

  addEventString(i18n("Ready."));


  // nastavime data pro vybranou polozku
  // sets data for selected item
  setActiveUpsInfo(m_mainUpsInfo.record.name);

  // sets mainUpsInfo.oldState to const value KNutNet::initStatus
  m_mainUpsInfo.oldState=KNutNet::initState;


 //makes connect to UPS, connection is non blocking operation
  //we have to use signal firstConnection and connectionError from KNutNet class 
  m_mainUpsInfo.upsNet = new KNutNet( m_mainUpsInfo.record.upsAddress, m_mainUpsInfo.record.upsName, m_mainUpsInfo.record.port,5,200);


  connect(m_mainUpsInfo.upsNet, SIGNAL(firstConnection(void)),this, SLOT(slotFirstConnection(void)));
  connect(m_mainUpsInfo.upsNet, SIGNAL(connectionError(int)),this, SLOT(slotErrorConnection(int)));
  connect(m_mainUpsInfo.upsNet, SIGNAL(connectionClosed(void )),this, SLOT(slotConnectionClosed(void)));
  connect(m_mainUpsInfo.upsNet, SIGNAL(tryFirstConnection(int )),this, SLOT(slotTryFirstConnection(int)));
  connect(m_mainUpsInfo.upsNet, SIGNAL(tryRepeatFirstConnection(int )),this, SLOT(slotTryReepatFirstConnection( int )));


// state of connection to usbd, this isn't state of knutnet
//  if (mainUpsInfo.record.upsName !="") {
//    mainUpsInfo.upsDriverState=knc::connecting;
 //   }
 // else   mainUpsInfo.upsDriverState=knc::notConnected;

 // repaints the dock
  if (m_myDock) m_myDock->clearDockValues();

  if (settingData.useMainWindow == KNutVarData::mw_yes || noDock ||
     (settingData.useMainWindow == KNutVarData::mw_auto && settingData.activatedMainWindow )) makeMainWindow ();

  if (m_myDock) m_myMessMan = new KNutMessageManager(this);

  //tries connecting to server
  m_mainUpsInfo.upsDriverState=knc::connecting;
  m_mainUpsInfo.upsNet->open();
  }


KNutClient::~KNutClient(void) {

  if (m_myMessMan) delete m_myMessMan;

  // melo by uz byt zruseno - jistota
  if (m_myDock) { m_myDock->close(); m_myDock=0l;}

  if (m_mainUpsInfo.upsNet) {
  // melo by uz byt zruseno - jistota
    delete m_mainUpsInfo.upsNet;
    m_mainUpsInfo.upsNet = 0;
    }
  m_listKNutEvent->clear();
  delete m_listKNutEvent;

  // melo by uz byt zruseno - jistota
  if (mainWindow) delete mainWindow;

  delete upsRecords;
  delete analogRecords;
  }



void KNutClient::slotTryFirstConnection (int maxCount) {
//qDebug ("KNutClient::slotTryFirstConnection");

//knutNet begin the first test of connection (connectToHost will be made after emiting signal tryFirstConnection )
// repaints icon 
  if (m_myDock) m_myDock->repaintDock(true);
  if (mainWindow) mainWindow->startConnectPB(maxCount);
  }


void KNutClient::slotTryReepatFirstConnection (int number ) {
//qDebug ("KNutClient::slotTryFirstConnection");
//knutNet begin nexts test of connection 

  if (mainWindow) mainWindow->setProgressConnectPB (number); 
  }



void KNutClient::slotFirstConnection (void) {
//qDebug ("sKNutClient::slotFirstConnection");
//TCP - UDP connection to server was made

  bool reconnecting = m_mainUpsInfo.reconnecting;


  m_mainUpsInfo.reconnecting =false;
  m_reconnectTimer->stop();

  m_mainUpsInfo.nutVariables = m_mainUpsInfo.upsNet->getNutVariables();
  m_mainUpsInfo.nutProtocol = m_mainUpsInfo.upsNet->getNutProtocol();

  if (mainWindow) mainWindow->hideConnectPB();


  // reads UPS's variables

    int countRevision = 2; // pocet max opakovani po kterych muzeme zjistovat hodnoty
    do {
      if (!(m_mainUpsInfo.netError = m_mainUpsInfo.upsNet->getUpsVars())) break;
      if (!(m_mainUpsInfo.netError)) break;  // no error
      if (m_mainUpsInfo.netError == KNutNet::UnknownUps) break;
      if (m_mainUpsInfo.netError == KNutNet::DriverNotConnected) break;
      countRevision--;
      if (countRevision) sleep (2);
      }
    while (countRevision);

  if (m_mainUpsInfo.netError) {
    m_mainUpsInfo.errorUpsData=true;
    // mainUpsInfo.upsDriverState is state of connection to usbd, this isn't state of knutnet
    if (m_mainUpsInfo.netError == KNutNet::DriverNotConnected)
      m_mainUpsInfo.upsDriverState=knc::notConnected;
    else
      m_mainUpsInfo.upsDriverState=knc::error;

    if (m_myDock) m_myDock->repaintDock(true);
    addEventString (KNutVarData::errorToText(m_mainUpsInfo.netError),m_mainUpsInfo.record.name);
//    KNutVarData::showError (mainUpsInfo.netError);
    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);
    }
  else {

    if (reconnecting) {
      addEventString(i18n("The connection was renewed."),m_mainUpsInfo.record.name);
      if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("The connection was renewed."),knc::errorLevel,true,true);
    }


  m_mainUpsInfo.upsDriverState=knc::connected;
    m_mainUpsInfo.errorUpsData=false;

    switch (m_mainUpsInfo.nutVariables) { // type of variables, old or new (with dot)
        case 1:
//qDebug ("sKNutClient::slotFirstConnection - var 1");
          if (!(m_mainUpsInfo.upsNet->existName("BATT_RUNTIME"))) m_mainUpsInfo.runtimeVar="BATT_RUNTIME";
          else m_mainUpsInfo.runtimeVar="RUNTIME";
          m_mainUpsInfo.upsLoadVar="LOADPCT";
          m_mainUpsInfo.lowxferVar="LOWXFER";
          m_mainUpsInfo.highxferVar="HIGHXFER";
          m_mainUpsInfo.statusVar="STATUS";
        break;
        case 2:
//qDebug ("sKNutClient::slotFirstConnection - var 2");
          m_mainUpsInfo.runtimeVar="battery.runtime";
          m_mainUpsInfo.upsLoadVar="ups.load";
          m_mainUpsInfo.lowxferVar="input.transfer.low";
          m_mainUpsInfo.highxferVar="input.transfer.high";
          m_mainUpsInfo.statusVar="ups.status";
       }


    if ((settingData.useDescription) && (!m_mainUpsInfo.upsNet->isDescription())) m_mainUpsInfo.upsNet->getDescription();
      // test presunut do setActiveUpsVars
    if (mainWindow) setActiveUpsVars(true);
    else setActiveUpsVars(false);

    // repaints main window and dock immediately
    if (mainWindow) mainWindow->showUpsData();
//    if (myDock) myDock->repaintDock(mainUpsInfo.netError,true); // dock is repainting always
    if (m_myDock) m_myDock->repaintDock(true); // dock is repainting always

    m_panelsAreZeroing=false; // analog panels isn't setting to zero
    }
  if ((m_mainUpsInfo.upsNet->getState() == KNutNet::Connected) && (!m_mainUpsInfo.errorUpsData)) {
    showStatusEvent();
    // getUpsVars loads informations about variables, but their values too
    m_upsTimer->start( m_mainUpsInfo.record.delay, TRUE ); // nastartujeme casovac - starts timer
    }
  }


void KNutClient::slotErrorConnection (int error) {

//qDebug ("KNutClient::slotErrorConnection (1)");

  if (mainWindow) mainWindow->hideConnectPB();

  m_mainUpsInfo.netError = error;
  m_mainUpsInfo.errorUpsData=true;
  if (m_mainUpsInfo.netError == KNutNet::DriverNotConnected)
    m_mainUpsInfo.upsDriverState=knc::notConnected;
  else
    m_mainUpsInfo.upsDriverState=knc::error;
  if (m_myDock) m_myDock->repaintDock(true);

  if (m_mainUpsInfo.reconnecting) {
//qDebug ("KNutClient::slotErrorConnection (2)");
    m_mainUpsInfo.reconnectCount++;
    if (m_mainUpsInfo.reconnectCount > countNextConnDelay) m_mainUpsInfo.reconnectCount = countNextConnDelay;

    addEventString(i18n("The connection failed. The next connection will make after %1 sec.").arg(nextConnDelay[m_mainUpsInfo.reconnectCount-1]),m_mainUpsInfo.record.name);
    m_reconnectTimer->start( nextConnDelay[m_mainUpsInfo.reconnectCount-1]*1000, TRUE ); // starts reconnect timer again
    }
  else {
//qDebug ("KNutClient::slotErrorConnection (3)");
    addEventString (KNutVarData::errorToText(m_mainUpsInfo.netError),m_mainUpsInfo.record.name);
//    KNutVarData::showError (mainUpsInfo.netError);
    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);


    }
  }



void KNutClient::initVars (void) {
// Nasledujici data jsou nastavena pri natazeni konfigurace
//Next data is setted when konfiguration is loaded
  settingData.panelFlags = KNutFrontPanel::DefaultPanelFlags; // informace v hlavnim panelu // information in main panel
  settingData.toolTipFlags = KNutDock::DefaultToolTipFlags; // informace v hlavnim panelu // information in main panel

  m_mainUpsInfo.record.name="";
  m_mainUpsInfo.upsNet=0L;
  m_mainUpsInfo.netError=0; // no error zadna chyba 
  m_mainUpsInfo.name="";
  m_mainUpsInfo.password="";
  m_mainUpsInfo.errorUpsData=false;
  m_mainUpsInfo.nutVariables=0;
  m_mainUpsInfo.runtimeVar="";
  m_mainUpsInfo.lowxferVar="";
  m_mainUpsInfo.highxferVar="";
  m_mainUpsInfo.statusVar="";
  m_mainUpsInfo.upsLoadVar="";
  m_mainUpsInfo.upsDriverState=knc::notConnected;
  m_mainUpsInfo.reconnectCount = 1;
  m_mainUpsInfo.reconnecting = false;

  m_panelsAreZeroing=false;
  m_lastError=0; // no error


  mainWindow=0;
  m_myDock=0;
  m_myMessMan=0;
  settingData.activatedMainWindow=false;
  }


  void KNutClient::loadConfiguration ( void ) {

  QString groupName;
  KNutUpsData::upsRecordDef upsData; // structure includes informations about UPS // struktura obsahuje udaje o UPS
  QFont appFont = kapp->font(); // systemovy font pri startu
  kapp->config()->setGroup ("");
  settingData.areYouSure=kapp->config()->readBoolEntry("AreYouSure",FALSE);

  int helpInt=kapp->config()->readNumEntry("UseMainWindow",TRUE);

//std::cout << "readNumEntry " <<  helpInt << "--" << std::endl;
  switch (helpInt) {
    case 0 : settingData.useMainWindow=KNutVarData::mw_yes;break;
    case 1 : settingData.useMainWindow=KNutVarData::mw_no;break;
    default : settingData.useMainWindow=KNutVarData::mw_auto;break;
    }


  settingData.useMessageWindow=kapp->config()->readBoolEntry("UseMessageWindow",FALSE);
  settingData.activatedMainWindow=kapp->config()->readBoolEntry("PreviousMainWindow",FALSE);
  settingData.x=kapp->config()->readNumEntry("PosX",0);
  settingData.y=kapp->config()->readNumEntry("PosY",0);
  settingData.width=kapp->config()->readNumEntry("Width",300);
  settingData.height=kapp->config()->readNumEntry("Height",200);
  settingData.useDescription=kapp->config()->readBoolEntry("UseDescription",FALSE);
  settingData.countCols=kapp->config()->readNumEntry("NumberOfCols",knc::DefaultCountCols);
  settingData.panelFlags=kapp->config()->readUnsignedNumEntry("PanelFlags",KNutFrontPanel::DefaultPanelFlags);
  settingData.inputFrequency=kapp->config()->readNumEntry("InputFrequency",knc::DefaultInputFrequency);
  settingData.inputVoltage=kapp->config()->readNumEntry("InputVoltage",knc::DefaultInputVoltage);
  settingData.lowHighXfer=kapp->config()->readBoolEntry("LowHighXfer",FALSE);
  settingData.customFont=kapp->config()->readBoolEntry("CustomFont",FALSE);
  settingData.aPanelFont=kapp->config()->readFontEntry("AnalogPanelFont",&appFont);
  settingData.mPanelFont=kapp->config()->readFontEntry("MainPanelFont",&appFont);
  int upsCount=kapp->config()->readNumEntry("NumberOfUpsRecords",0);
  settingData.customBColor=kapp->config()->readBoolEntry("CustomBColor",FALSE);
  settingData.mainBackgroundColor=kapp->config()->readColorEntry ("MainBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.customBPanelColor=kapp->config()->readBoolEntry("CustomBPanelColor",FALSE);
  settingData.customBAnalogColor=kapp->config()->readBoolEntry("CustomBAnalogColor",FALSE);
  settingData.customOAnalogColor=kapp->config()->readBoolEntry("CustomOAnalogColor",FALSE);
  settingData.mPanelBackgroundColor=kapp->config()->readColorEntry ("MPanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.aPanelBackgroundColor=kapp->config()->readColorEntry ("APanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.analogFingerColor=kapp->config()->readColorEntry ("AnalogFingerColor",& DEFAULT_FINGER_COLOR);
  settingData.analogOKColor=kapp->config()->readColorEntry ("AnalogOKColor",& DEFAULT_OK_COLOR);
  settingData.analogWarnningColor=kapp->config()->readColorEntry ("AnalogWarnningColor",& DEFAULT_WARNNING_COLOR);
  settingData.analogErrorColor=kapp->config()->readColorEntry ("AnalogErrorColor",& DEFAULT_ERROR_COLOR);
  settingData.analogScaleColor=kapp->config()->readColorEntry ("AnalogScaleColor",& DEFAULT_SCALE_COLOR);
  settingData.analogFontColor=kapp->config()->readColorEntry ("AnalogFontColor",& DEFAULT_FONT_COLOR);
  settingData.toolTipFlags=kapp->config()->readUnsignedNumEntry("ToolTipFlags",KNutDock::DefaultToolTipFlags);
  settingData.customKIconColor=kapp->config()->readBoolEntry("CustomKIconColor",FALSE);
  settingData.kIconBackgroundColor=kapp->config()->readColorEntry ("KIconBackGroundColor",& DEFAULT_KICON_COLOR);
  settingData.typeOfKIcon=kapp->config()->readBoolEntry("TypeOfKIcon", KNutDock::pictureKI);
  settingData.typeDigitalProcessing=kapp->config()->readNumEntry("DigitalProcessingOfPointers", 2);


  m_mainUpsInfo.record.name=kapp->config()->readEntry("ActiveUps","");


  for (int i = 0; i < upsCount; i++) {
    groupName.sprintf ("UPS %d",i);
    kapp->config()->setGroup (groupName);
    if ((upsData.name = kapp->config()->readEntry ("Name")) != QChar::null) {
      // record exist, we will go next part
      //if ActiveUps is empty, we use name of first ups from ups list
      if ((m_mainUpsInfo.record.name.isEmpty()) && (!(upsData.name.isEmpty())))
           m_mainUpsInfo.record.name = upsData.name;
      upsData.upsName = kapp->config()->readEntry ("UpsName","");
      if (((upsData.upsAddress = kapp->config()->readEntry ("UpsAddress")) != QChar::null)
        || (( upsData.upsAddress == QChar::null)  &&    (upsData.upsName != QChar::null ))) {

        // only for backwards compatibility with older release then 0.7
        if (upsData.upsAddress.isEmpty()) {
          int charPos;
          if ((charPos=upsData.upsName.find('@')) == -1) {
            upsData.upsAddress=upsData.upsName;
            upsData.upsName="";
            }
          else {
            upsData.upsAddress=upsData.upsName.mid(charPos+1);
            upsData.upsName=upsData.upsName.left(charPos);
            }
          }
        // zaznam existuje pokracujeme dale a nacteme zbytek hodnotet
       // record exists, we go next and will read rest of values
        upsData.delay = kapp->config()->readNumEntry("Delay",knc::DefaultDelay);
        upsData.port = (unsigned short)kapp->config()->readNumEntry("Port",knc::DefaultPort);
        upsData.userName=kapp->config()->readEntry("UserName","");
        upsData.password=kapp->config()->readEntry("Password","");
        upsData.savePassword=kapp->config()->readBoolEntry("SavePassword",false);
        for (int j=0; j < knc::NumberOfVars; j++) {
          groupName.sprintf ("Var %d",j);
          upsData.upsVarCode[j]=kapp->config()->readNumEntry (groupName,0);
          if ((upsData.upsVarCode[j] < 0) || (upsData.upsVarCode[j] > knc::NumberOfTypes))
             upsData.upsVarCode[j] = 0;
          }
        upsRecords->add (upsData);
        }
      }
    }
  }

void KNutClient::saveConfiguration ( bool all ) {
  QString groupName;
  QString codeName;
  KNutUpsData::upsRecordDef upsData; // struktura obsahuje udaje o UPS // structure includes information about UPS
  int upsCount = upsRecords->getCount();

  kapp->config()->setGroup ("");

  if (all) {
    kapp->config()->writeEntry ("DigitalProcessingOfPointers",settingData.typeDigitalProcessing);
    kapp->config()->writeEntry ("TypeOfKIcon",settingData.typeOfKIcon);
    kapp->config()->writeEntry ("KIconBackGroundColor",settingData.kIconBackgroundColor);
    kapp->config()->writeEntry ("CustomKIconColor",(settingData.customKIconColor));
    kapp->config()->writeEntry ("ToolTipFlags",(settingData.toolTipFlags));
    }

  //if name of active ups isn't knowly, will use name of the firt ups from ups list
  if ((m_mainUpsInfo.record.name.isEmpty()) &&  (upsCount > 0)) {
      upsRecords->get(0,upsData);
      kapp->config()->writeEntry ("ActiveUps",upsData.name);
    }
  else kapp->config()->writeEntry ("ActiveUps",(QString)m_mainUpsInfo.record.name); //

  if (all) {
    kapp->config()->writeEntry ("AnalogFontColor",settingData.analogFontColor);
    kapp->config()->writeEntry ("AnalogScaleColor",settingData.analogScaleColor);
    kapp->config()->writeEntry ("AnalogErrorColor",settingData.analogErrorColor);
    kapp->config()->writeEntry ("AnalogWarnningColor",settingData.analogWarnningColor);
    kapp->config()->writeEntry ("AnalogOKColor",settingData.analogOKColor);
    kapp->config()->writeEntry ("AnalogFingerColor",settingData.analogFingerColor);
    kapp->config()->writeEntry ("APanelBackGroundColor",settingData.aPanelBackgroundColor);
    kapp->config()->writeEntry ("MPanelBackGroundColor",settingData.mPanelBackgroundColor);
    kapp->config()->writeEntry ("MainBackGroundColor",settingData.mainBackgroundColor);
    kapp->config()->writeEntry ("NumberOfUpsRecords",upsCount);
    kapp->config()->writeEntry ("CustomFont",settingData.customFont);
    kapp->config()->writeEntry ("AnalogPanelFont",settingData.aPanelFont);
    kapp->config()->writeEntry ("MainPanelFont",settingData.mPanelFont);
    kapp->config()->writeEntry ("CustomBColor",(settingData.customBColor));
    kapp->config()->writeEntry ("CustomBPanelColor",(settingData.customBPanelColor));
    kapp->config()->writeEntry ("CustomBAnalogColor",(settingData.customBAnalogColor));
    kapp->config()->writeEntry ("CustomOAnalogColor",(settingData.customOAnalogColor));
    kapp->config()->writeEntry ("LowHighXfer",(settingData.lowHighXfer));
    kapp->config()->writeEntry ("InputVoltage",(settingData.inputVoltage));
    kapp->config()->writeEntry ("InputFrequency",(settingData.inputFrequency));
    kapp->config()->writeEntry ("PanelFlags",(settingData.panelFlags | 3));
    kapp->config()->writeEntry ("NumberOfCols",settingData.countCols);
    kapp->config()->writeEntry ("UseDescription",settingData.useDescription);
    kapp->config()->writeEntry ("AreYouSure",settingData.areYouSure);
    kapp->config()->writeEntry ("UseMainWindow",settingData.useMainWindow);
    kapp->config()->writeEntry ("UseMessageWindow",settingData.useMessageWindow);
    }

  kapp->config()->writeEntry ("Height",settingData.height); //
  kapp->config()->writeEntry ("Width",settingData.width); //
  kapp->config()->writeEntry ("PosY",settingData.y); //
  kapp->config()->writeEntry ("PosX",settingData.x); //
  kapp->config()->writeEntry ("PreviousMainWindow",settingData.activatedMainWindow);

  if (all) {
    for (int i=0; i<upsCount; i++) {
      groupName.sprintf ("UPS %d",i);
      kapp->config()->setGroup (groupName);
      upsRecords->get(i,upsData);
      kapp->config()->writeEntry ("Port",upsData.port);
      kapp->config()->writeEntry ("Delay",upsData.delay);
      kapp->config()->writeEntry ("UpsAddress",upsData.upsAddress);
      kapp->config()->writeEntry ("UpsName",upsData.upsName);
      kapp->config()->writeEntry ("Name",upsData.name);
      if (upsData.savePassword) {
        kapp->config()->writeEntry ("UserName",upsData.userName);
        kapp->config()->writeEntry ("Password",upsData.password);
        }
      kapp->config()->writeEntry ("SavePassword",upsData.savePassword);
      for (int j=0; j < knc::NumberOfVars; j++) {
        groupName.sprintf ("Var %d",j);
        kapp->config()->writeEntry (groupName,upsData.upsVarCode[j]);
        }
      kapp->config()->setGroup ("");
      }
    }
  kapp->config()->sync();
  }


bool KNutClient::commitData (QSessionManager&) {

  saveConfiguration(false);
  return true;
  }

  bool KNutClient::saveState (QSessionManager&) {

  saveConfiguration(false);
  return true;
  }



void KNutClient::upsActivate (void) {

//qDebug ("KNutClient::upsActivate");

  m_mainUpsInfo.upsNet = new KNutNet( m_mainUpsInfo.record.upsAddress,m_mainUpsInfo.record.upsName,m_mainUpsInfo.record.port,0,1);
  if (m_mainUpsInfo.upsNet->getState() != KNutNet::Connected) {
    m_mainUpsInfo.netError=m_mainUpsInfo.upsNet->getError(); // aktivace ups skoncila s chybou
//    KNutVarData::showError(mainUpsInfo.netError);

    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);


    m_mainUpsInfo.errorUpsData=true;
    m_mainUpsInfo.upsDriverState=knc::notConnected;
    }
  else {
    if (m_mainUpsInfo.upsNet->switchedToTCP())
      addEventString (i18n("upsd > 1.2 doesn't support UDP. Connection is switched to TCP"),m_mainUpsInfo.record.name);
    m_mainUpsInfo.nutVariables = m_mainUpsInfo.upsNet->getNutVariables();
    m_mainUpsInfo.nutProtocol = m_mainUpsInfo.upsNet->getNutProtocol();

    int countRevision = 2; // pocet max opakovani po kterych muzeme zjistovat hodnoty
    do {
      if (!(m_mainUpsInfo.netError = m_mainUpsInfo.upsNet->getUpsVars())) break;
      if (m_mainUpsInfo.netError == KNutNet::UnknownUps) break;
      if (m_mainUpsInfo.netError == KNutNet::DriverNotConnected) break;
      countRevision--;
      if (countRevision) sleep (2);
      }
    while (countRevision);

    if (m_mainUpsInfo.netError) {
       addEventString (KNutVarData::errorToText(m_mainUpsInfo.netError),m_mainUpsInfo.record.name);
//       KNutVarData::showError (mainUpsInfo.netError);

    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);

       m_mainUpsInfo.errorUpsData=true;
       if (m_mainUpsInfo.netError == KNutNet::DriverNotConnected)
         m_mainUpsInfo.upsDriverState=knc::notConnected;
       else
         m_mainUpsInfo.upsDriverState=knc::error;
       }
    else {
      m_mainUpsInfo.upsDriverState=knc::connected;

      switch (m_mainUpsInfo.nutVariables) {
          case 1:
            if (!(m_mainUpsInfo.upsNet->existName("BATT_RUNTIME"))) m_mainUpsInfo.runtimeVar="BATT_RUNTIME";
            else m_mainUpsInfo.runtimeVar="RUNTIME";
            m_mainUpsInfo.upsLoadVar="LOADPCT";
            m_mainUpsInfo.lowxferVar="LOWXFER";
            m_mainUpsInfo.highxferVar="HIGHXFER";
            m_mainUpsInfo.statusVar="STATUS";
          break;
          case 2:
            m_mainUpsInfo.runtimeVar="battery.runtime";
            m_mainUpsInfo.upsLoadVar="ups.load";
            m_mainUpsInfo.lowxferVar="input.transfer.low";
            m_mainUpsInfo.highxferVar="input.transfer.high";
            m_mainUpsInfo.statusVar="ups.status";
         }

      if ((settingData.useDescription) && (!m_mainUpsInfo.upsNet->isDescription())) m_mainUpsInfo.upsNet->getDescription();
        // test presunut do setActiveUpsVars
      if (mainWindow) setActiveUpsVars(true);
      else setActiveUpsVars(false);
      }
    }
  }

void KNutClient::upsDeactivate (void) {

  // this function isn't interuptable function
//  upsDeactivateMutex.lock();
  QMutexLocker upsDeactivateLocker( &m_upsDeactivateMutex );
  m_mainUpsInfo.upsNet->close(); // close connection 
  // state of connection to usbd, this isn't state of knutnet 
  m_mainUpsInfo.upsDriverState=knc::notConnected;
  m_mainUpsInfo.netError=0; // no error
  m_mainUpsInfo.nutVariables=0;
//  upsDeactivateMutex.unlock();
  }

void KNutClient::setActiveUpsVars (bool mWindow) {
  // nastavujeme jen pokud existuji nejake promene
  if ( m_mainUpsInfo.upsNet->readNumberVars() > 0) {
    // deaktivujeme veskere promene
    m_mainUpsInfo.upsNet->unSetActivateAll();

    if (mWindow) {
      for (int j=0; j < knc::NumberOfVars; j++) {
        switch (m_mainUpsInfo.nutVariables) {
          case 1:
            if (m_mainUpsInfo.record.upsVarCode[j] != 0 ) m_mainUpsInfo.upsNet->setActivate(nameUpsVars1[m_mainUpsInfo.record.upsVarCode[j]]);
          break;
          case 2:
            if (m_mainUpsInfo.record.upsVarCode[j] != 0 ) m_mainUpsInfo.upsNet->setActivate(nameUpsVars2[m_mainUpsInfo.record.upsVarCode[j]]);
          break;
          }
        }
      }
    m_mainUpsInfo.upsNet->setActivate(m_mainUpsInfo.runtimeVar); //runtime je vzdy pridano v merenym polozkam
    if (m_myDock) m_mainUpsInfo.upsNet->setActivate(m_mainUpsInfo.upsLoadVar);
    // status se nastavi vzdy
    m_mainUpsInfo.upsNet->setActivate(m_mainUpsInfo.statusVar);
    // xfer se nastavi vzdy pokud existuje
    // podrebujeme ho znat jeste pred startem a pak behen behu programu
    setActiveXFerVars(true);
    }
  }


void KNutClient::setActiveXFerVars (bool activate) {
  if (activate) {
    // podkud neexistuje jedna z promenych neaktivujeme ani jednu
    if (!(m_mainUpsInfo.upsNet->setActivate(m_mainUpsInfo.lowxferVar)))
      if (m_mainUpsInfo.upsNet->setActivate(m_mainUpsInfo.highxferVar))
        m_mainUpsInfo.upsNet->unSetActivate(m_mainUpsInfo.lowxferVar);
    }
  else {
    m_mainUpsInfo.upsNet->unSetActivate(m_mainUpsInfo.lowxferVar);
    m_mainUpsInfo.upsNet->unSetActivate(m_mainUpsInfo.highxferVar);
    }
  }

void KNutClient::setActiveUpsInfo (QString name) {
  //presuneme jmena  z databaze ups-ek - je nahrana z config. souboru
  KNutUpsData::upsRecordDef* upsRecordPointer;

  if ((!name.isNull()) && (!name.isEmpty()) && ((upsRecordPointer = upsRecords->findName(name)) != 0L)) {

    m_mainUpsInfo.record.upsName = upsRecordPointer->upsName;
    m_mainUpsInfo.record.upsAddress = upsRecordPointer->upsAddress;
    m_mainUpsInfo.record.delay = upsRecordPointer->delay;
    m_mainUpsInfo.record.port = upsRecordPointer->port;
//    mainUpsInfo.record.tcp = upsRecordPointer->tcp;
    m_mainUpsInfo.record.userName = upsRecordPointer->userName;
    m_mainUpsInfo.record.password = upsRecordPointer->password;
    for (int i =0; i < knc::NumberOfVars; i++) m_mainUpsInfo.record.upsVarCode[i] = 0; // vynulujeme polozky
    int ii = 0;
    for (int i =0; i < knc::NumberOfVars; i++)
      if (upsRecordPointer->upsVarCode[i]>0) m_mainUpsInfo.record.upsVarCode[ii++] = upsRecordPointer->upsVarCode[i];
    }
  }


void KNutClient::getUpsData (void) {
  int runNetError;

//qDebug("KNutClient::getUpsData");

  //loads values for selected variables <getUpsValues(false)>  / activate values
  if (!(runNetError=m_mainUpsInfo.upsNet->getUpsValues(false))) { // data from upsNet is ok
    // we read all values of UPS
    //  nacetli jsme vsechny hodnoty pro ups
    m_mainUpsInfo.netError=runNetError;
    if (m_mainUpsInfo.errorUpsData) { // changes status from error to ok
      m_mainUpsInfo.errorUpsData=false;
      addEventString (i18n("Data OK"),m_mainUpsInfo.record.name);
      if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("Data OK"),knc::errorLevel,true,true);
      }
    }
  else { // data from upsNet isn't ok
    m_mainUpsInfo.netError=runNetError;
    if (!m_mainUpsInfo.errorUpsData) { //change status from ok to error
      addEventString (KNutVarData::errorToText(runNetError), m_mainUpsInfo.record.name);
      if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(KNutVarData::errorToText(runNetError),knc::errorLevel);
      m_lastError=runNetError;
      m_mainUpsInfo.errorUpsData=true;
      }
    else {
      if (m_lastError != runNetError) { // change status from error to other error
        addEventString (KNutVarData::errorToText(runNetError),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(KNutVarData::errorToText(runNetError),knc::errorLevel);
        m_lastError=runNetError;
        }
      }
    }
  }


void KNutClient::addEventString (const QString text, const QString UPSAddress) {

  if (mainWindow)
    mainWindow->addComboStatusItem (text,UPSAddress);
  else
    {
      QString dateTime(QDate::currentDate().toString());
      dateTime +=" " + QTime::currentTime().toString();
      if (UPSAddress.isEmpty()) m_listKNutEvent->append(dateTime+" "+text);
      else m_listKNutEvent->append(dateTime+" "+UPSAddress+" : "+text);
      if (m_listKNutEvent->count() > knc::maxCountKNutEvent) m_listKNutEvent->remove(m_listKNutEvent->begin());
      }
    }

/*********************************************************************************************/
/*                                                                                           */
/*                             PRIVATE SLOTS                                                 */
/*                                                                                           */
/*********************************************************************************************/


void KNutClient::slotReconnectTimeout (void) {

    m_mainUpsInfo.netError=0; //clears netError
    m_mainUpsInfo.upsDriverState=knc::connecting;
    m_mainUpsInfo.upsNet->open();
  }



void KNutClient::slotTimeout (void) {

  getUpsData();
  if (!m_mainUpsInfo.errorUpsData) { // no error
    if (mainWindow) {
      mainWindow->repaintPanel();
      mainWindow->repaintAnalogs();
      }
    m_panelsAreZeroing=false;
    showStatusEvent();
    }
  else { // error
    if ((mainWindow) && (!m_panelsAreZeroing)) mainWindow->zeroingPanels();
    m_panelsAreZeroing=true;
    if (m_myDock) m_myDock->clearDockValues();
    }
  if (m_myDock) m_myDock->repaintDock();
  m_upsTimer->start( m_mainUpsInfo.record.delay, TRUE ); // nastartujem znovu
  }


void KNutClient::slotConnectionClosed(void) {
//qDebug("KNutClient::slotConnectionClosed");

  m_mainUpsInfo.netError = KNutNet::ConnetionClosedByServer;

  m_upsTimer->stop();
  upsDeactivate();
  //sets netError this, because procedure upsDeactivate sets netError to zero
  m_mainUpsInfo.netError = KNutNet::ConnetionClosedByServer;

  if (mainWindow) {
    mainWindow->hideConnectPB();
    mainWindow->cleanPanels();
    }
  if (m_myDock) {
    // clears values of dock and set standard icon of dock
   m_myDock->clearDockValues();
   }

  addEventString(i18n("The connection was closed by the second side (upsd)."),m_mainUpsInfo.record.name);
  if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("The connection was closed by the second side (upsd)."),knc::errorLevel,true);

  m_mainUpsInfo.reconnecting = true;
  m_mainUpsInfo.reconnectCount = 1;
  m_reconnectTimer->start( nextConnDelay[0]*1000, TRUE ); // start timer for reconnect delay
  }

void KNutClient::showStatusEvent(void) {


//qDebug ("KNutClient::showStatusEvent");
  int myState = m_mainUpsInfo.upsNet->readStatus();
  if (myState != m_mainUpsInfo.oldState) {

    if ((myState & KNutNet::OFF) != (m_mainUpsInfo.oldState & KNutNet::OFF)) {
      if (myState & KNutNet::OFF) {
        addEventString(i18n("UPS is off."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is off."),knc::criticalLevel);
        }
      else {
        addEventString(i18n("UPS is back on."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is back on."),knc::criticalLevel,true);
        }
      }
    if ((myState & KNutNet::OL) != (m_mainUpsInfo.oldState & KNutNet::OL)){
       if (myState & KNutNet::OL)  {
         addEventString(i18n("Power is back online."),m_mainUpsInfo.record.name);
         if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("Power is back online."),knc::warningLevel,true);
         }
       }
    if ((myState & KNutNet::OB) != (m_mainUpsInfo.oldState & KNutNet::OB)) {
      if (myState & KNutNet::OB)  {
        addEventString(i18n("UPS is on battery."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is on battery."),knc::warningLevel);
        }
      }
    if ((myState & KNutNet::LB) != (m_mainUpsInfo.oldState & KNutNet::LB)) {
      if (myState & KNutNet::LB) {
        addEventString(i18n("UPS battery is low."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS battery is low."),knc::criticalLevel);
        }
      else {
        addEventString(i18n("UPS battery is OK."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS battery is OK."),knc::criticalLevel,true);
        }
      }
    if ((myState & KNutNet::RB) != (m_mainUpsInfo.oldState & KNutNet::RB)) {
      if (myState & KNutNet::RB) {
        addEventString(i18n("UPS battery is bad and needs be replaced."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS battery is bad and needs be replaced."),knc::infoLevel);
        }
      }
    if ((myState & KNutNet::OVER) != (m_mainUpsInfo.oldState & KNutNet::OVER)) {
      if (myState & KNutNet::OVER) {
        addEventString(i18n("UPS is overloaded."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is overloaded."),knc::lowWarningLevel);
        }
      else {
        addEventString(i18n("UPS isn't overloaded."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS isn't overloaded."),knc::lowWarningLevel,true);
        }
      }
    if ((myState & KNutNet::CAL) != (m_mainUpsInfo.oldState & KNutNet::CAL)) {
      if (myState & KNutNet::CAL) {
        addEventString(i18n("UPS is performing calibration")+".",m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is performing calibration")+".",knc::infoLevel);
        }
      else {
        addEventString(i18n("Calibration of UPS is ended."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("Calibration of UPS is ended."),knc::infoLevel,true);
        }
      }
    if ((myState & KNutNet::BOOST) != (m_mainUpsInfo.oldState & KNutNet::BOOST)) {
      if (myState & KNutNet::BOOST) {
        addEventString(i18n("UPS is boosting incoming voltage."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is boosting incoming voltage."),knc::infoLevel);
        }
      else {
        addEventString(i18n("Boosting of UPS is ended."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("Boosting of UPS is ended."),knc::infoLevel,true);
        }
      }
    if ((myState & KNutNet::TRIM) != (m_mainUpsInfo.oldState & KNutNet::TRIM)) {
      if (myState & KNutNet::TRIM) {
        addEventString(i18n("UPS is trimming incoming voltage."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("UPS is trimming incoming voltage."),knc::infoLevel);
        }
      else {
        addEventString(i18n("Trimming of UPS is ended."),m_mainUpsInfo.record.name);
        if ((m_myMessMan) and (settingData.useMessageWindow)) m_myMessMan->addMessage(i18n("Trimming of UPS is ended."),knc::infoLevel,true);
        }
      }
    m_mainUpsInfo.oldState=myState;
    }
  }

void KNutClient::slotSetNewUPS (QString name) {

  m_mainUpsInfo.reconnecting =false;
  m_reconnectTimer->stop();

  if (name  != m_mainUpsInfo.record.name) {
    m_upsTimer->stop();
    upsDeactivate(); 

    addEventString(i18n("Switched"),name);
    if (m_myMessMan) m_myMessMan->deleteMessage();

    m_mainUpsInfo.record.name=name;
    m_mainUpsInfo.errorUpsData=false;
    setActiveUpsInfo(m_mainUpsInfo.record.name);

    //new connection name and password are cleaned
    m_mainUpsInfo.name = "";
    m_mainUpsInfo.password = "";

    if (mainWindow) {
      mainWindow->setCombo(name);
//      mainWindow->showUpsData();
      mainWindow->cleanPanels();
      }

   if (m_myDock) {
      // clears values of dock and set standard icon of dock
     m_myDock->clearDockValues();
     m_myDock->setNewUPS(); // sets miniIcon in list of UPSes for selected UPS
     }

    m_panelsAreZeroing=false;
    m_lastError=0; // zadna chyba
    m_mainUpsInfo.oldState=KNutNet::initState; // init variable of last UPS state

    // nova cast

    m_mainUpsInfo.upsNet->newUPS(m_mainUpsInfo.record.upsAddress,m_mainUpsInfo.record.upsName, m_mainUpsInfo.record.port);
     // state of connection to usbd, this isn't state of knutnet
    m_mainUpsInfo.upsDriverState=knc::connecting;
    m_mainUpsInfo.upsNet->open();
    }
  }


void KNutClient::slotPreferenceUps (void) {

  KNutPrefDlg* prefDlg = new KNutPrefDlg ( upsRecords, analogRecords, &settingData, m_mainUpsInfo.record.name ); // aktivujeme dialog pro preference
  connect (prefDlg,SIGNAL(signalChangeConfig(unsigned int)),this,SLOT(slotSetConfig(unsigned int)));
  prefDlg->exec();
  delete prefDlg;
  }


void KNutClient::slotSetConfig (unsigned int changeSetting) {

  if (changeSetting) {
    // cely blok konfiguraci ukladame jen zde // all block of configurations is saved only here
    saveConfiguration(true);
    if (changeSetting & KNutPrefDlg::ChangeXFer) {
      if (settingData.lowHighXfer)
        setActiveXFerVars(false);
      else
        setActiveXFerVars(true);
      }

    if (changeSetting & KNutPrefDlg::ChangeUpsSetting) {
    //we have changed active UPS
//********** same code like code into slotSetNewUPS -- stejny kod jako v slotSetNewUPS
      m_upsTimer->stop();
      upsDeactivate();

      if (m_mainUpsInfo.record.name == "") {
        // the first record was added, because the first UPS is active UPS always
        QString name = upsRecords->getName(0);
        addEventString(i18n("Switched"),name);
        m_mainUpsInfo.record.name=name;
        m_mainUpsInfo.errorUpsData=false;
        m_myMessMan->deleteMessage();
        saveConfiguration(false); // saves information of new/first active UPS
        }
      else {
        if (upsRecords->getCount() == 0) {
        // the last record was deleted, because the last UPS is active UPS
          addEventString(i18n("Switched"),"");
          m_mainUpsInfo.record.name="";
          m_mainUpsInfo.errorUpsData=false;
          m_mainUpsInfo.record.upsName = "";
          m_mainUpsInfo.record.upsAddress = "";
          m_myMessMan->deleteMessage();
          saveConfiguration(false); // saves information of no UPS, list of UPS is empty
          }
        }
      setActiveUpsInfo(m_mainUpsInfo.record.name);
//      upsActivate();
//      getUpsData(); // provedeme hned natazeni zbytku promenych oby se nastavili meraky
                    // protoze UPS byla odpojena a znovu pripojena
      // zde je nutno hned provest prekresleni
      // showUpsData je nutno udelat take proto ze se mohl zmenit vyber meraku
//      if (mainWindow) mainWindow->showUpsData();
      if (mainWindow) mainWindow->cleanPanels();
//      if (myDock) myDock->repaintDock(mainUpsInfo.netError);
      if (m_myDock) m_myDock->clearDockValues();

      m_mainUpsInfo.upsNet->newUPS(m_mainUpsInfo.record.upsAddress,m_mainUpsInfo.record.upsName, m_mainUpsInfo.record.port);
     // state of connection to usbd, this isn't state of knutnet
      m_mainUpsInfo.upsDriverState=knc::connecting;
      m_mainUpsInfo.upsNet->open();
//      if ((mainUpsInfo.upsNet->getState() == KNutNet::Connected) && (!mainUpsInfo.errorUpsData)) {
//        showStatusEvent();
//        upsTimer->start( mainUpsInfo.record.delay, TRUE ); // nastartujeme casovac
//        }
      }

    if (changeSetting & KNutPrefDlg::ChangeUpsCount) {
      if (m_myDock) m_myDock->changeUps();
      }

    if (changeSetting & KNutPrefDlg::ChangeTypeOfKIcon) {
      if (m_myDock) m_myDock->changeKIcon();
      }

    if (changeSetting & KNutPrefDlg::ChangeCustomKIconColor) {
      if (m_myDock) m_myDock->changeKIBColor();
      }

    if (changeSetting & KNutPrefDlg::ChangeKIconBColor) {
      if (m_myDock) m_myDock->changeKIBColor();
      }

    if (changeSetting & KNutPrefDlg::ChangeToolTip) {
      if (m_myDock) m_myDock->changeToolTip();
      }

    //for other settings will call functions from mainWindow class
    if (mainWindow) mainWindow->setConfig (changeSetting);
    }
  }


void KNutClient::slotPrintUPSVars(void) {

 if (m_mainUpsInfo.upsDriverState == knc::connected) {
    if (!m_mainUpsInfo.errorUpsData) {
      if ((m_mainUpsInfo.upsNet->readNumberVars (KNutNet::AllVars)) || (m_mainUpsInfo.upsNet->readNumberComms ())) {
        KNutPrintUpsVar *windowUpsVars = new KNutPrintUpsVar(m_mainUpsInfo.upsNet,settingData.useDescription);
        if (windowUpsVars->upsOk()) windowUpsVars->exec();
        delete windowUpsVars;
        }
      } else {
        //  KNutVarData::showError (mainUpsInfo.netError);
          if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);
      }
    } else {
      //  KNutVarData::showError (KNutNet::NotConnection);
        if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(KNutNet::NotConnection),knc::errorLevel,true);

       }
  }


void KNutClient::slotInstComms(void) {

  if (m_mainUpsInfo.upsDriverState == knc::connected) {
    if (!m_mainUpsInfo.errorUpsData) {
      if (m_mainUpsInfo.upsNet->readNumberComms ()) {
        KNutInstComms *windowInstComms = new KNutInstComms(&m_mainUpsInfo.name,&m_mainUpsInfo.password,m_mainUpsInfo.record.userName,m_mainUpsInfo.record.password,m_mainUpsInfo.upsNet);
        if (windowInstComms->upsOk()) windowInstComms->exec();
        delete windowInstComms;
        }
      }
    else { 
//      KNutVarData::showError (mainUpsInfo.netError);
      if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);
      }
    }
  else {
//    KNutVarData::showError (KNutNet::NotConnection);
    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(KNutNet::NotConnection),knc::errorLevel,true);
    }
  }

void KNutClient::slotRWVars(void) {

  if (m_mainUpsInfo.upsDriverState == knc::connected) {
    if (!m_mainUpsInfo.errorUpsData) {
      if (m_mainUpsInfo.upsNet->readNumberVars (KNutNet::RWVars)) {
        KNutRWVar *windowRWVars = new KNutRWVar(&m_mainUpsInfo.name,&m_mainUpsInfo.password,m_mainUpsInfo.record.userName,m_mainUpsInfo.record.password,m_mainUpsInfo.upsNet);
        connect (windowRWVars,SIGNAL(signalChangeRWVars(QString)),this,SLOT(slotChangeRWVars(QString)));
        if (windowRWVars->upsOk())  windowRWVars->exec();
        delete windowRWVars;
       }
     }
   else {
    // KNutVarData::showError (mainUpsInfo.netError);
     if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(m_mainUpsInfo.netError),knc::errorLevel,true);
      }
    }
  else {
   // KNutVarData::showError (mainUpsInfo.netError);
    if ((m_myMessMan)) m_myMessMan->addMessage(KNutVarData::errorToText(KNutNet::NotConnection),knc::errorLevel,true);
    }
  }


void KNutClient::slotRefreshConnection(void) {

  m_reconnectMutex.lock();

  m_mainUpsInfo.reconnecting =false;
  m_reconnectTimer->stop();
  m_upsTimer->stop();
  upsDeactivate(); // closes connections

    // nastavime na docku iconu
    // sets icon for dock
  if (m_myDock) {
    m_myDock->clearDockValues();
 //     myDock->initImage();
 //     myDock->repaint();
    }
  if (mainWindow) {
    mainWindow->cleanPanels();
    }
  addEventString(i18n("Reconnect"),m_mainUpsInfo.record.name);
  if (m_myMessMan) m_myMessMan->deleteMessage();

//    mainUpsInfo.record.name=name;
  m_mainUpsInfo.errorUpsData=false;
  setActiveUpsInfo(m_mainUpsInfo.record.name);

  //new connection name and password are cleaned
  m_mainUpsInfo.name = "";
  m_mainUpsInfo.password = "";


  m_panelsAreZeroing=false;
  m_lastError=0; // zadna chyba
  m_mainUpsInfo.oldState=KNutNet::initState;

  m_mainUpsInfo.upsNet->newUPS(m_mainUpsInfo.record.upsAddress,m_mainUpsInfo.record.upsName, m_mainUpsInfo.record.port);
  // state of connection to usbd, this isn't state of knutnet
  m_mainUpsInfo.upsDriverState=knc::connecting;
  m_mainUpsInfo.upsNet->open();
  m_reconnectMutex.unlock();
  }


void KNutClient::slotChangeRWVars( QString ) {
  // informace ze doslo k uspesne zmene promene
  // vzhledem k asynchronimu zpracovani muze upsd vratit tuto hodnotu az za nejakou dobu
  // nevim zda bude potreba
  }


void KNutClient::exitMainWindow (void) {

  mainWindow=0;
  if (m_mainUpsInfo.upsNet) setActiveUpsVars(false);
  // Pokud neni aktivovan dock musime ukoncit aplikaci..
  // When dock isn't activated we must close application.
  if (m_myDock == 0) {
    saveConfiguration(false);
    if (m_mainUpsInfo.upsNet) {
      delete m_mainUpsInfo.upsNet;
      m_mainUpsInfo.upsNet = 0;
      }
    kapp->quit();
    }
  }


void KNutClient::makeMainWindow (void) {

  mainWindow = new KNutMainWindow(m_listKNutEvent ,&m_mainUpsInfo, &settingData, upsRecords, analogRecords);
  connect(mainWindow, SIGNAL(UPSChanged (QString)), this, SLOT(slotSetNewUPS (QString)));
  connect(mainWindow, SIGNAL(preferenceUps()),this, SLOT(slotPreferenceUps()));
  connect(mainWindow, SIGNAL(showUPSVars()),this, SLOT(slotPrintUPSVars()));
  connect(mainWindow, SIGNAL(makeInstComms()),this, SLOT(slotInstComms()));
  connect(mainWindow, SIGNAL(makeRWVars()),this, SLOT(slotRWVars()));
  connect(mainWindow, SIGNAL(makeRefreshConnection()),this, SLOT(slotRefreshConnection()));
  connect(mainWindow, SIGNAL(saveConf()),this, SLOT(slotSaveConf()));




  connect(mainWindow, SIGNAL(endApplication()), this, SLOT(slotExitApplication()));
  connect(mainWindow, SIGNAL(destroyed()), this, SLOT(exitMainWindow()));
  }



void KNutClient::slotActiveMainWindow (void) {

  if (!mainWindow) {
    //  pred activaci nastaveme promenne znovu precteme data
    // state of connection to usbd, this isn't state of knutnet
    if (m_mainUpsInfo.upsDriverState==knc::connected) {
      m_upsTimer->stop();
      setActiveUpsVars(true);
      getUpsData();
      makeMainWindow();
      if (m_myDock) m_myDock->repaintDock(m_mainUpsInfo.netError);
      m_upsTimer->start( 1, TRUE ); // nastartujem znovu
      // 1 proto aby se zpracovali pripadne udalosti o zruseni spojeni
      }
    else {
      setActiveUpsVars(true);
      //getUpsData();  zrusene protoze kdyz nebylo spojeni navazeno vratil by prikaz
      // getValues error=0 a doslo by vypsani data ok.
      makeMainWindow();
      if (!m_mainUpsInfo.errorUpsData) {
        if (m_myDock) m_myDock->repaintDock(m_mainUpsInfo.netError);
        }
      }
    }
  else {   // end if mainWindow
    //activates main window
    mainWindow->raise();
    KWin::activateWindow(mainWindow->winId());
    }
  }

void KNutClient::slotSaveConf (void) {
  saveConfiguration(true); // saves all configuration
}

void KNutClient::closeMainWindow (void) {
  if (mainWindow) {
    if (m_myDock) m_myDock->repaintDock(m_mainUpsInfo.netError);
    m_upsTimer->stop();
    mainWindow->close();
    mainWindow=0;
    m_upsTimer->start( 1, TRUE ); // starts timer // nastartujeme casovac
    }
  }


void KNutClient::slotExitApplication(void) {

  m_upsTimer->stop();
  if (mainWindow) {
    // odpojime protoze exitMainWindow by byl vykonan az po zkonceni procedury;
    disconnect(mainWindow, SIGNAL(destroyed()), this, SLOT(exitMainWindow()));
    delete mainWindow;
    mainWindow = 0;
    }
  saveConfiguration(false);
  if (m_mainUpsInfo.upsNet) {
    delete m_mainUpsInfo.upsNet;
    m_mainUpsInfo.upsNet = 0;
    }
  if (m_myDock) { m_myDock->close(); m_myDock = 0;}
  kapp->quit();
  }

#include "knutclient.moc"  

