/***************************************************************************
                          knutmessage.h  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTMESSAGE_H
#define KNUTMESSAGE_H

#include <kdialogbase.h>

//#include <qpixmap.h>
//#include <qtimer.h>


/**
  *@author Daniel Prynych
  */


class QTimer;
class QPixmap;

/**
 * Tato trida zobrazi okno zpravy v modeless rezimu.
 * Okno pracuje nezavisle na ostatnich oknech a NEPOZASTAVUJE jejich cinnost.
 *
 * @author Daniel Prynych
 * @short window message
 * @version 0.1
  */
class KNutMessage : public KDialogBase  {
    Q_OBJECT
public: 

enum typeOfMessage {
  infoMess,
  warningMess,
  criticalMess
  };


/**
 * Konstruktor - vytvori okno zpravy.
 *
 * @param  messageText je text zpravu.
 * @param  type je typ zpravy blize Type Of Message
 * @param  timeValidity maximalni doba zobrazeni okna, je-li rovna nule je neomezena.
 * @since  0.1
 */
  KNutMessage(const QString messageText, const typeOfMessage type=infoMess, const long int timeValidity=0, QWidget *parent=0, const char *name=0);

/**
 * Destruktor.
 *
 * @since  0.1.2
 **/
  ~KNutMessage();

signals:
/**
 * Je emitovan kdyz dojde ke stisku tlacitka OK, nebo vyprsi doba platnosti (timeValidity).
 *
 * @since  0.1
 **/
  void endMessage(void);

/**
 * Is emited when window of message is moved;
 * Je emitovan kdyz dojde presunu okna.
 *
 * @since  0.1
 **/

  void messageMoved (int, int);

private slots:

/**
 * @internal
 * Je aktivivan, kdyz vyprsi doba platnosti (timeValidity).
 *
 * @since  0.1
 **/
  void timeout(void);

/**
 * @internal
 * Is activated when button OK was pressed
 * Je aktivovan kdyz se stiskne tlacitko OK
 *
 * @since  0.1
 **/
  virtual void slotOk (void);


private:
  static const int maxTime = 3600;

  QPixmap m_ret;
  QTimer* m_messageTimer;

protected:
  void moveEvent ( QMoveEvent * e);


};

#endif
