/***************************************************************************
                          wiz_setup.h  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WIZ_SETUP_H
#define WIZ_SETUP_H

#include <kwizard.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include "resource.h"
#include "definitions.h"
#include "knightstextview.h"

/**
  *@author Troy Corbin Jr.
  */

class wiz_setup : public KWizard
{
		Q_OBJECT
		public:
									wiz_setup( QWidget *parent=0, const char *name=0, resource *Rsrc=0 );
									~wiz_setup();
		protected slots:
			void				slot_Work( const QString& pageTitle );
			void				slot_License( int );
		protected:
			void			  initPage1( void );
			void			  initPage2( void );
			void			  initPage3( void );
			void			  initPage4( void );
			void			  initPage5( void );
			void			  initPage6( void );
			void				findEngines( void );
			void				setupServers( void );
			void				setupPGN( void );
		private:
			resource		*myResource;
			int					steps;

			QFrame				*Page1;
				QGridLayout		*P1B1;
					QLabel			*SideImage1;
					QLabel			*WelcomeMessage;
			QFrame				*Page2;
				QGridLayout		*P2B1;
					QLabel				*SideImage2;
					QLabel				*pgnExplain;
					QButtonGroup	*pgnButtons;
						QRadioButton	*pgnYes;
						QRadioButton	*pgnNo;
			QFrame				*Page3;
				QGridLayout		*P3B1;
					QLabel			*SideImage3;
					QLabel			*engineExplain;
					QButtonGroup	*engineButtons;
						QRadioButton	*engineYes;
						QRadioButton	*engineNo;
			QFrame				*Page4;
				QGridLayout		*P4B1;
					QLabel			*SideImage4;
					QLabel			*serverExplain;
					QButtonGroup	*serverButtons;
						QRadioButton	*serverYes;
						QRadioButton	*serverNo;
			QFrame				*Page5;
				QGridLayout		*P5B1;
					QLabel			*SideImage5;
					QLabel			*FinishExplain;
			QVBox					*Page6;
				KnightsTextView	*licenseView;
				QButtonGroup	*licenseButtons;
					QRadioButton	*licenseYes;
					QRadioButton	*licenseNo;
};

#endif
