/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef D_SETTINGSUI_H
#define D_SETTINGSUI_H

#include <kconfigdialog.h>
#include "ui_sDevice.h"
#include "ui_sPhone.h"
#include "ui_sPhoneBook.h"
#include "ui_sSMS.h"

#include "c_config.h"
extern c_config* Config;

/**
@author Marco Gulino
*/
class d_settingsUI : public KConfigDialog
{
Q_OBJECT
public:
    d_settingsUI(QWidget *parent = 0, const char *name = 0, KConfigSkeleton *config = Config);
    ~d_settingsUI();

private:
	ui_sPhone* s_Phone;
	ui_sPhoneBook* s_PhoneBook;
	ui_sSMS* s_SMS;
	ui_sDevice* s_Device;
public slots:
    void phoneProfileChanged( int );
    void pb_overwriteChanged(int item);
    void parseMemSlotsPB();
    void parseMemSlotsSMS();
    void saveSettings();
	void SMSMemChg() { s_SMS->kcfg_sms_memchanged->setChecked( !Config->getSMSMemChg() ); }

};

#endif
