#ifndef __PROPDEV
#define __PROPDEV

#include <qdialog.h>
class KLineEdit;

class QWidget;
class QLabel;
class QPushButton;
class QRadioButton;
class QButtonGroup;
class QCheckBox;

class NetWidget;
class XDevice;
class InverterScrollWidget;
class RAMScrollWidget;

class PropDev : public QDialog
{
    Q_OBJECT

public:
    PropDev(QWidget *, const char *, NetWidget *, Circuit *, XDevice *);

private:
    void done(int);
    void setSize(int);

    QPushButton *bEQU;
    QPushButton *bOK;
    QPushButton *bCancel;
    KLineEdit *devname;
    KLineEdit *delay;
    KLineEdit *size;
    InverterScrollWidget *inverterw;
    RAMScrollWidget *ramw;
    QPushButton *bRAMClrSet;
    QButtonGroup *bg_undef;
    QRadioButton *undef[2];
    QButtonGroup *bg_invert;
    QRadioButton *invert[2];
    QButtonGroup *bg_clock;
    QRadioButton *clock[7];
    QButtonGroup *bg_master;
    QRadioButton *master[2];
    QCheckBox *cb_display_name;
    QCheckBox *cb_enable_tristate;
    QCheckBox *cb_HugeWidth;
    QButtonGroup *bg_muxDemux;
    QRadioButton *rb_muxDemux[2];
    QButtonGroup *bg_led;
    QRadioButton *led_red;
    QRadioButton *led_blue;
    QRadioButton *led_green;
    QRadioButton *led_yellow;

    NetWidget *netw;
    Circuit *dnet;
    XDevice *dev;
    int osize;
    int omaster;
    Global::Device::CLOCKTYPE oclock;
    int curr_invert;
    int curr_undef;
    Global::Device::CLOCKTYPE curr_clock;
    int curr_mux;

    int ram_clr;

private slots:
    void RAMClrSet();
    void showDeviceEquations();
    void setSize(const QString &);
    void setUndefinedValue(int);
    void setInverted(int);
    void setClock(int);
    void setMaster(int);
    void setLEDColor(int);
    void setMux(int);
};

#endif
