/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "newsgroup.h"
#include <qdir.h>

NewsGroup::~NewsGroup()
{
	if (listItem)
		delete listItem;
	db->close(0);
	delete db;
	db=0;
// 	qDebug("Database %s closed", (const char *) dbName);
	
}


NewsGroup::NewsGroup( DbEnv * _dbEnv, QString _ngName,  QString _saveDir) {
	updating=false;
    ngName=_ngName;
    dbName=ngName;
	totalArticles=0;
	unreadArticles=0;
	showOnlyComplete=false;
	showOnlyUnread=false;
	sortColumn = -1;
	ascending = true;
	view =0;
	deleteOlder=0;
	listItem = 0;
    
	saveDir=_saveDir+'/';
    dbEnv = _dbEnv; //Probably not needed...

    db=new Db(dbEnv,0);
    int ret=0;
    if (!db)
        qDebug("Error opening database: %s", dbEnv->strerror(ret));
//     else
//         qDebug("Database %s initialized", (const char *) dbName);
	if (db->set_pagesize(PAGE_SIZE) != 0)
		qDebug("Error setting a page size");
// 	else qDebug("Page size set");
    
	if ((ret=db->open(NULL, dbName, NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644)) != 0)
        qDebug("Error opening database: %s", dbEnv->strerror(ret));
	else qDebug("Database %s opened", ngName.latin1());
//     	qDebug("Database %s (non trans) opened", (const char *) dbName);
#if INDEXDB_VERSION != 0
	QMap<int, int>::iterator it;
	for (it = high.begin(); it != high.end(); ++it) {
		if (it.data() != -1) {
			//Ok, server is enabled, create/open index
			//TODO: delete or open when enabling/disabling from the property dialog
			sdb[it.key()] = new Db(dbEnv, 0);
			ret = sdb[it.key()]->open(NULL, dbName + '.' +  QString::number(it.key()), NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644);
			if (ret == 0)
				qDebug("Opened secondary db %s", (const char *) (dbName + '.' +QString::number(it.key())));
			else qDebug("Error opening secondary db %s: %d", (const char *) (dbName + '.' + QString::number(it.key())), ret);
			
		}
		

		
	}
#endif



}

char* NewsGroup::insert(QString s, char* p) {
    int strlen=s.length();
    int suint = sizeof(strlen);
    memcpy(p, &strlen, suint);

    p+=suint;
    memcpy(p, (const char *)s, strlen);
    p+=strlen;
    return p;



}

char* NewsGroup::retrieve(char* i,QString &s) {


    int strlen;
    int ssize=sizeof(strlen);

    char *temp;
    memcpy(&strlen, i, ssize);

    i+=ssize;
    temp=new char[strlen+1];
    memcpy(temp, i, strlen);
    temp[strlen]='\0';
    s=temp;
    delete [] temp;
    i+=strlen;
    return i;



}

char * NewsGroup::data( ) {
	char *p=new char[getRecordSize()];
	char *i=&p[0];
// 	qDebug("Am i crashing?");
	i=insert(ngName, i);
	i=insert(alias, i);
	i=insert(category,i);
	i=insert(dbName, i);
	i=insert(saveDir,i);
	int szInt=sizeof(uint);
	memcpy(i, &totalArticles, szInt);
	i+=szInt;
// 	qDebug("data() - Unread articles: %d", unreadArticles);
	memcpy(i, &unreadArticles, szInt);
	i+=szInt;
	
	memcpy(i, &showOnlyUnread, sizeof(bool));
	i+=sizeof(bool);
	memcpy(i, &showOnlyComplete, sizeof(bool));
	i+=sizeof(bool);
	memcpy(i, &deleteOlder, szInt);
	i+=szInt;
	
	
	int count=high.count();
	memcpy(i, &count, szInt);
	i+=szInt;
	int id, w;
	for (it = high.begin(); it != high.end(); ++it) {
		id=it.key();
		w=it.data();
		memcpy(i, &id, szInt);
		i+=szInt;
		memcpy(i, &w, szInt);
		i+=szInt;		
		
	}
	count=low.count();
	memcpy(i, &count, szInt);
	i+=szInt;
	for (it=low.begin(); it != low.end(); ++it) {
		id=it.key();
		w=it.data();
		memcpy(i, &id, szInt);
		i+=szInt;
		memcpy(i, &w, szInt);
		i+=szInt;
		
	}
	
	//New in version 5: remember sort column, sort order, column widths, column reordering
	count = colOrder.count();
	memcpy(i, &count, szInt);
	i+=szInt;
	for (it = colOrder.begin(); it != colOrder.end(); ++it)
	{
		id = it.key();
		w = it.data();
		memcpy(i, &id, szInt);
		i+=szInt;
		memcpy(i, &w, szInt);
		i+=szInt;
// 		kdDebug() << "Column: " << id << " index: " << w << endl;
	}
	
	count = colSize.count();
	memcpy(i, &count, szInt);
	i+=szInt;
	
	for (it = colSize.begin(); it != colSize.end(); ++it)
	{
		id = it.key();
		w = it.data();
		memcpy(i, &id, szInt);
		i+=szInt;
		memcpy(i, &w, szInt);
		i+=szInt;
	}
	
	memcpy(i, &sortColumn, szInt);
	i+=szInt;
	
	memcpy(i, &ascending, sizeof(bool));
	
	
	
	
	
// 	qDebug("or not?");
// 	qDebug("data(): i-p: %d", i-p);
	return p;
	
		
	
}

uint NewsGroup::getRecordSize( )
{
// 	qDebug("Low.count: %d", low.count());
// 	qDebug("High.count: %d", high.count());
// 	qDebug("Size of string: %d", ngName.length());
// 	qDebug("Size of string: %d", dbName.length());
// 	qDebug("Size of string: %d", saveDir.length());
	return (13*sizeof(uint) + ngName.length() + alias.length() + category.length()+ dbName.length() + saveDir.length() + 2*high.count()*sizeof(uint) + 2*low.count()*sizeof(uint) + 2*sizeof(bool) +2*colOrder.count()*sizeof(int) + 2 * colSize.count() * sizeof(int) +sizeof(bool) );
}

NewsGroup::NewsGroup( DbEnv *_dbEnv, char *data, uint version )
{
	char *p=data;
	p=retrieve(p, ngName);
	if (version >=2) {
		p=retrieve(p, alias);
		p=retrieve(p, category);
	}
	
	p=retrieve(p, dbName);
	p=retrieve(p, saveDir);
	saveDir=QDir::cleanDirPath(saveDir);
	saveDir+='/';
	
	
	memcpy(&totalArticles, p, sizeof(uint));
	p+=sizeof(uint);
	
	if (version >= 1) {
		memcpy(&unreadArticles, p, sizeof(uint));
		p+=sizeof(uint);
		
	}
	
	if (version >=3) {
		memcpy(&showOnlyUnread, p, sizeof(bool));
		p+=sizeof(bool);
		memcpy(&showOnlyComplete, p, sizeof(bool));
		p+=sizeof(bool);
	}
	if (version >= 4) {
		memcpy(&deleteOlder, p, szInt);
		p+=szInt;
// 		qDebug("Deleteolder: %d", deleteOlder);
	}
	
// 	qDebug("ngName: %s", (const char *) ngName);
// 	qDebug("dbName: %s", (const char *) dbName);
// 	qDebug("Savedir: %s", (const char *) saveDir);
	
	int count, id, w;
	int szInt=sizeof(uint);
	
	memcpy(&count, p, szInt);
	p+=szInt;
// 	qDebug("NewsGroup() - HighCount: %d", count);
// 	qDebug("Count: %d", count);
	for (int i = 0; i < count ; i++) {
		memcpy(&id, p, szInt);
		p+=szInt;
		memcpy(&w, p, szInt);
		p+=szInt;
		high.insert(id, w);
		
	}
	
	memcpy(&count, p, szInt);
	p+=szInt;
	for (int i = 0; i < count ; i++) {
		memcpy(&id, p, szInt);
		p+=szInt;
		memcpy(&w, p, szInt);
		p+=szInt;
		low.insert(id, w);
		
	}
	
	//new in version 5
	if (version >= 5) {
		memcpy(&count, p, szInt);
		p+=szInt;
		for (int i = 0; i < count; i++) {
			memcpy(&id, p, szInt);
			p+=szInt;
			memcpy(&w, p, szInt);
			p+=szInt;
			colOrder.insert(id, w);
// 			kdDebug() << "Column order: " << id << " index: " << w << endl;
			
		}
		
		memcpy(&count, p, szInt);
		p+=szInt;
		for (int i = 0; i < count; i++) {
			memcpy(&id, p, szInt);
			p+=szInt;
			memcpy(&w, p, szInt);
			p+=szInt;
			colSize.insert(id, w);
		}
		memcpy(&sortColumn, p, szInt);
		p+=szInt;
		memcpy(&ascending, p, sizeof(bool));
		
	
	}
	
	
// 	qDebug("p-data: %d", p-data);
	dbEnv=_dbEnv;
	db=new Db(dbEnv,0);
    uint ret=0;
    if (!db)
        qDebug("Error  creating database handle: %s", dbEnv->strerror(ret));
	if (db->set_pagesize(PAGE_SIZE) != 0)
		qDebug("Error setting a page size");
	if ((ret=db->open(NULL, dbName, NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644)) != 0)
		qDebug("Error opening database: %s", dbEnv->strerror(ret));
// 	else qDebug("Database %s opened", ngName.latin1());
// 	else qDebug("Page size set");
	
	
//         else
//             qDebug("Database %s (non trans) opened", (const char *) dbName);

	updating=false;
	view=0;
	listItem=0;
	
#if INDEXDB_VERSION != 0
	QMap<int, int>::iterator it;
	for (it = high.begin(); it != high.end(); ++it) {
		if (it.data() != -1) {
			//Ok, server is enabled, create/open index
			//TODO: delete or open when enabling/disabling from the property dialog
			sdb[it.key()] = new Db(dbEnv, 0);
			ret = sdb[it.key()]->open(NULL, dbName + '.' +  QString::number(it.key()), NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644);
			if (ret == 0)
				qDebug("Opened secondary db %s", (const char *) (dbName + '.' +QString::number(it.key())));
			else qDebug("Error opening secondary db %s: %d", (const char *) (dbName + '.' + QString::number(it.key())), ret);
			
		}
		

		
	}
#endif
	
	
	
}

void NewsGroup::decUnread( )
{
	if (unreadArticles > 0)
		unreadArticles--;
	else unreadArticles = 0;
		
}



void NewsGroup::startUpdating( )
{
	ngLock.lock();
	updating=true;
	ngLock.unlock();
}

void NewsGroup::stopUpdating()
{
	ngLock.lock();
	updating = false;
	ngLock.unlock();
}

bool NewsGroup::isUpdating()
{
	bool tmp;
	ngLock.lock();
	tmp = updating;
	ngLock.unlock();
	return tmp;
}

void NewsGroup::setAlias( QString  s )
{
	alias = s;
}

void NewsGroup::setCategory( QString  c )
{
	category = c;
}

uchar * NewsGroup::getBinHeader( QString index)
{
	Dbt key, data;
	data.set_flags(DB_DBT_MALLOC);
	key.set_flags(DB_DBT_USERMEM);
	
	key.set_data((void*)index.latin1());
	key.set_size(index.length());
	int ret;
	if ( (ret=db->get(NULL, &key, &data, 0)) != 0 )
		qDebug("Error getting binheader: %d", ret);
	
	return (uchar*) data.get_data();
	
	
	
	
}

int NewsGroup::close( )
{
	int ret=db->close(0);
	delete db;
	return ret;
	
}

int NewsGroup::open( )
{
	db=new Db(dbEnv,0);
	return db->open(NULL, dbName, NULL, DB_BTREE, DB_THREAD, 0644);
		
}

void NewsGroup::resetSettings( )
{
	showOnlyComplete=false;
	showOnlyUnread=false;
}

#ifndef NDEBUG

void NewsGroup::validate() 
{
	kdDebug() << "Validating " << getName() << endl;
// 	kdDebug() << "Active Servers:\n";
	QMap<int, int>::iterator it;
	
	QMap<int, int> calcLow;
	QMap<int, int>calcHigh;
	Dbc *cursor;
	db->cursor(0, &cursor, 0);
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_flags(DB_DBT_MALLOC);
	data.set_flags(DB_DBT_MALLOC);
	BinHeader *bh;
	QMap<int,int> bhLow;
	int ret;
	int totalItems=0, failedItems=0;
	while ( (ret = cursor->get(&key, &data, DB_NEXT)) != DB_NOTFOUND) {
		if (ret == 0) {
			bh=new BinHeader((uchar*) data.get_data());
			free(data.get_data());
			bhLow.clear();
			totalItems++;
	// 		bool print = false;
			for (bh->pnmit=bh->partNum.begin(); bh->pnmit != bh->partNum.end(); ++(bh->pnmit)) {
				for (bh->snmit=bh->pnmit.data().begin(); bh->snmit != bh->pnmit.data().end(); ++(bh->snmit)) {
					
					
					if (calcLow.contains(bh->snmit.key())) {
						if (bh->snmit.data() < calcLow[bh->snmit.key()])
							calcLow[bh->snmit.key()] = bh->snmit.data();
					} else calcLow[bh->snmit.key()] = bh->snmit.data();
					
					if (calcHigh.contains(bh->snmit.key())) {
						if (bh->snmit.data() > calcHigh[bh->snmit.key()])
							calcHigh[bh->snmit.key()] = bh->snmit.data();
					} else calcHigh[bh->snmit.key()] = bh->snmit.data();
					
					if (bhLow.contains(bh->snmit.key()) ) {
						if (bh->snmit.data() < bhLow[bh->snmit.key()])
							bhLow[bh->snmit.key()] = bh->snmit.data();
						
					} else bhLow[bh->snmit.key()] = bh->snmit.data();
					
	// 				if (bh->snmit.data() == 28829962)
	// 					print = true;
					
						
					
					
				}
			}
			for (it = bh->serverLowest.begin(); it != bh->serverLowest.end(); ++it) {
// 			if (print) {
// 				kdDebug() << "Explicit print command\n";
// 				kdDebug() << "Id: " << it.key() << " stored lowest: " << bh->serverLowest[it.key()] << " Calculated: " << bhLow[it.key()] << endl;
// 				bh->printServerPart();
// 				bh->expire(3, 28829971);
// 				kdDebug() << endl << "Lowest After expiring: " << bh->serverLowest[3] << endl;
// 				bh->printServerPart();
				// 			
				// 				
// 			}
			
				if (bhLow[it.key()] != bh->serverLowest[it.key()]) {
				
					kdDebug() << "Error: stored and calculated lows differ: \n";
					kdDebug() << "Subject: " << bh->getSubj() << endl;
					kdDebug() << "Stored: " << bh->serverLowest[it.key()] << " Calculated " << bhLow[it.key()] << endl;
					bh->printServerPart();
					kdDebug() << "Trying to expire with " << low[it.key()] << endl;
					bh->expire(it.key(), low[it.key()]);
					kdDebug() << "Now the article is:\n";
					bh->printServerPart();


				
					failedItems++;
				}
			
			}
		
		
		
		
		
		//Clean up
			delete bh;
			free(key.get_data());
		} else {
			kdDebug() << "Error reading record: " << ret << "; " << dbEnv->strerror(ret) << endl;
		}
			
		
			
		

		memset(&key, 0, sizeof(key));
		memset(&data, 0, sizeof(data));
		key.set_flags(DB_DBT_MALLOC);
		data.set_flags(DB_DBT_MALLOC);
		
	}
	kdDebug() << "Total items: " << totalItems << " Failed items: " << failedItems << endl;
	kdDebug() << "Calculated Watermarks for active server(s):\n";
	for (it = high.begin(); it != high.end(); ++it) {
		kdDebug() << "Id: " << it.key() << " watermarks: " << low[it.key()] << " - " << it.data() << endl;
	}
	for (it = high.begin(); it != high.end(); ++it) {
		kdDebug() << "Id: " << it.key()  << " Calculated low: " << calcLow[it.key()] << " Calculated High: " << calcHigh[it.key()] << endl;
	}
	
	
	cursor->close();
	
	
	
}

#endif //#ifdef NDEBUG

void NewsGroup::decTotal( )
{
	if (totalArticles > 0)
		totalArticles--;
	else totalArticles = 0;
}

void NewsGroup::setColIndex( int col, int index )
{
	colOrder[col] = index;
}

int NewsGroup::getColIndex( int col )
{
	if (colOrder.contains(col))
		return colOrder[col];
	else return -1;
}

void NewsGroup::setColSize( int col, int size )
{
	colSize[col] = size;
}

int NewsGroup::getColSize( int col )
{
	if (colSize.contains(col))
		return colSize[col];
	else return -1;
}

