#include <stdio.h>
#include <glib.h>

#include <glib/gmessages.h>

#include "kpcalendarentry.h"
#include "kptraininglog.h"
#include "kpsettings.h"

void src_run_tests (void);
gboolean test_training_log (void);
gboolean test_settings (void);
gboolean test_workout (void);

int
main ()
{

  g_type_init ();
  src_run_tests ();

  return 0;
}

void
src_run_tests (void)
{
  puts ("****************************************************");
  puts ("* RUNNING SOME TESTS.. ");
  puts ("****************************************************");

  if (test_settings())
    puts ("settings: Successsful!");
  else
    puts ("settings: Failed!");
  
/*  if (test_workout ())
    puts ("workout: Successful!");
  else
    puts ("workout: Failed!");

  if (test_training_log ())
    puts ("training_log: Successful!");
  else
    puts ("training_log: Failed!");
*/
}

gboolean
test_settings (void)
{
  GSList *list;
  kp_settings_init (NULL);

  list = kp_settings_get_list ("preset_sport");
  while (list) {
    g_print("%s\n", (gchar *)list->data);
    list = list->next;
  }

  kp_settings_list_free (list);
  
  return TRUE;
}

gboolean
test_workout (void)
{
  KPCalendarEntry *entry;
  KPWorkout *wo;

  entry = g_object_new (KP_TYPE_CALENDAR_ENTRY, NULL);

  entry = kp_calendar_entry_new ();
  g_assert (KP_IS_CALENDAR_ENTRY (entry));

  wo = kp_workout_new ();
  g_assert (KP_IS_CALENDAR_ENTRY (wo));
  g_assert (KP_IS_WORKOUT (wo));

  return TRUE;
}

gboolean
test_training_log (void)
{
  KPWorkout *w[10];
  KPTrainingLog *training_log;
  guint i;
  GList *mon;
  GList *list;

  training_log = kp_training_log_new ();
  g_assert (training_log != NULL);

  for (i = 0; i < 10; i++) {
    w[i] = kp_workout_new ();
    if (i < 5)
      KP_CALENDAR_ENTRY (w[i])->datetime =
        kp_calendar_time_new_dmyhms (12, 5, 2000 + i, -1, -1, -1);
    else
      KP_CALENDAR_ENTRY (w[i])->datetime =
        kp_calendar_time_new_dmyhms (20 + i, 5, 2000, -1, -1, -1);

    kp_training_log_add (training_log, KP_CALENDAR_ENTRY (w[i]));
    g_assert (kp_training_log_get_size (training_log) == i + 1);
  }

  list = kp_training_log_get_all_entries (training_log);
  while (list) {
    g_print("Listaa tulee\n");
    list=list->next;
  }
  /*g_list_foreach (list, puts, NULL);*/
  
  kp_training_log_dump (training_log);
  for (i = 0; i < 10; i++) {
    g_assert (kp_training_log_get_size (training_log) == 10 - i);
    g_assert (kp_training_log_remove (training_log, KP_CALENDAR_ENTRY (w[i])) ==
              TRUE);
  }
  g_assert (kp_training_log_get_size (training_log) == 0);

  kp_training_log_destroy (training_log);

  printf ("FROM FILE: \n");

  mon = kp_training_log_get_month (training_log, 2003, 5);
  kp_training_log_dump (training_log);

  /*data = training_log_get_month_as_chart_data (training_log, 2003, 5, 31, "distance");
     for (i = 0; i < 31; i++) {
     if (data[0][i] > 0)
     printf ("d[%d]=%.3f ", i, data[0][i]);
     } */
  kp_training_log_dump (training_log);
  kp_training_log_destroy (training_log);

  return TRUE;
}
