#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kpnewcommentdialog.h"
#include "kpcalendarview.h"
#include "kpguiutils.h"

#include "../kptraininglog.h"
#include "../kipina-i18n.h"
#include "../kpsettings.h"
#include "../kputil.h"
#include "../kpworkout.h"

static void kp_new_comment_dialog_class_init  (KPNewCommentDialogClass *klass);
static void kp_new_comment_dialog_init        (KPNewCommentDialog *dialog);
static void kp_new_comment_dialog_finalize    (GObject *object);
static void kp_new_comment_dialog_response_cb (GtkDialog *gtkdialog,
                                               int response_id,
                                               KPNewCommentDialog *dialog);

typedef struct KPNewCommentDialogPrivateData_
{
  KPComment *comment;
  GDate *date;

  GtkWidget *title_entry;
  GtkWidget *textview;
  GtkWidget *calendar;

  GtkWidget *okbutton;
  GtkWidget *cancelbutton;

} KPNewCommentDialogPrivateData;

#define KP_NEW_COMMENT_DIALOG_PRIVATE_DATA(widget) (((KPNewCommentDialogPrivateData*) \
        (KP_NEW_COMMENT_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_new_comment_dialog_get_type (void)
{
  static GType kp_new_comment_dialog_type = 0;

  if (kp_new_comment_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPNewCommentDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_new_comment_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPNewCommentDialog),
      0,
      (GInstanceInitFunc) kp_new_comment_dialog_init,
      NULL,
    };

    kp_new_comment_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                         "KPNewCommentDialog",
                                                         &our_info, 0);
  }

  return kp_new_comment_dialog_type;
}

static void
kp_new_comment_dialog_class_init (KPNewCommentDialogClass * klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  object_class->finalize = kp_new_comment_dialog_finalize;
}


static void
kp_new_comment_dialog_init (KPNewCommentDialog * dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  GladeXML *xml;

  xml = kp_gui_load ("new_comment", "new_comment");

  dialog->private_data = g_new0 (KPNewCommentDialogPrivateData, 1);
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);

  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Add a new comment to the log."));

  p_data->cancelbutton = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                                GTK_STOCK_CANCEL,
                                                GTK_RESPONSE_CANCEL);

  p_data->okbutton = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                            GTK_STOCK_ADD,
                                            GTK_RESPONSE_OK);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "new_comment"));


  g_signal_connect (G_OBJECT (dialog),
                   "response",
                    G_CALLBACK (kp_new_comment_dialog_response_cb), dialog);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);

  /* Put widgets to private data */
  p_data->title_entry = KP_W (xml, "title_entry");
  p_data->textview = KP_W (xml, "textview");  
  p_data->calendar = KP_W (xml, "calendar");
 
  g_object_unref (G_OBJECT (xml));
}


static void
kp_new_comment_dialog_finalize (GObject * object)
{
  KPNewCommentDialog *dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (KP_IS_NEW_COMMENT_DIALOG (object));

  dialog = KP_NEW_COMMENT_DIALOG (object);

  g_return_if_fail (dialog->private_data != NULL);
  g_free (dialog->private_data);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
kp_new_comment_dialog_new (GDate *date, KPComment *comment)
{
  KPNewCommentDialogPrivateData *p_data;
  KPNewCommentDialog *dialog;

  dialog = g_object_new (KP_TYPE_NEW_COMMENT_DIALOG, NULL);

  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  p_data->comment = comment;
  p_data->date = date;
  
  gtk_calendar_select_month (GTK_CALENDAR (p_data->calendar),
                             g_date_get_month (p_data->date),
                             g_date_get_year (p_data->date));
  gtk_calendar_select_day (GTK_CALENDAR (p_data->calendar),
                           g_date_get_day (p_data->date));
 
  return GTK_WIDGET (dialog);
}


static void
kp_new_comment_dialog_response_cb (GtkDialog * gtk_dialog, int response_id,
    KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  GtkTextBuffer *buffer;
  GtkTextIter start;
  GtkTextIter end;
  const gchar *title;
  gchar *text;
  guint d, m, y;
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);

  if (response_id != GTK_RESPONSE_OK) {
    kp_comment_set_title (p_data->comment, "");
    kp_comment_set_text (p_data->comment, "");
    return;
  }
  title = gtk_entry_get_text (GTK_ENTRY (p_data->title_entry));
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (p_data->textview));
  gtk_text_buffer_get_start_iter (buffer, &start);
  gtk_text_buffer_get_end_iter (buffer, &end);
  text = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);

  gtk_calendar_get_date (GTK_CALENDAR (p_data->calendar), &y, &m, &d);

  kp_calendar_time_set_dmy (KP_CALENDAR_ENTRY (p_data->comment)->datetime, d, m, y);

  kp_comment_set_title (p_data->comment, title);
  kp_comment_set_text (p_data->comment, text);
}

