/* $Id: we_colors.c 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/
static void       color_changed_cb(GtkColorButton *btn,
                                   gpointer data);
static void       set_default_colors_cb(GtkButton *btn, gpointer data);



GtkWidget *
get_we_colors_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *panel;
  GtkWidget *table;
  GtkWidget *btnDefault;
  GtkWidget *colorBtnAnsi;
  GtkWidget *colorBtnDeffore;
  GtkWidget *colorBtnDefbold;
  GtkWidget *colorBtnDefback;
  GtkWidget *colorBtnDefboldback;
  gchar      btnname[18]; /* 18 is enough to hold the button names */

  int i;


  panel = glade_xml_get_widget(gladexml, "we_panel_colors");

  /* Ansi colors category */
  table = glade_xml_get_widget(gladexml, "table_ansi_colors");
  gtk_table_set_col_spacing(GTK_TABLE(table), 2, 32);

  for (i = 0; i < 16; ++i) {
    sprintf(btnname, "colorBtnAnsi[%d]", i);
    colorBtnAnsi = glade_xml_get_widget(gladexml, btnname);
    gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnAnsi),
                                                &world->ansicolors[i]);
    g_object_set_data(G_OBJECT(colorBtnAnsi),
                      "colorptr", &world->ansicolors[i]);
    g_signal_connect(G_OBJECT(colorBtnAnsi), "color-set",
                     G_CALLBACK(color_changed_cb), world);
  }

  /* Default colors category */
  table = glade_xml_get_widget(gladexml, "table_default_colors");
  gtk_table_set_col_spacing(GTK_TABLE(table), 2, 32);

  colorBtnDeffore = glade_xml_get_widget(gladexml, "colorBtnDeffore");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDeffore),
                             world->deffore);
  g_object_set_data(G_OBJECT(colorBtnDeffore),
                    "colorptr", world->deffore);
  g_signal_connect(G_OBJECT(colorBtnDeffore), "color-set",
                   G_CALLBACK(color_changed_cb), world);

  colorBtnDefbold = glade_xml_get_widget(gladexml, "colorBtnDefbold");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefbold),
                             world->defbold);
  g_object_set_data(G_OBJECT(colorBtnDefbold),
                    "colorptr", world->defbold);
  g_signal_connect(G_OBJECT(colorBtnDefbold), "color-set",
                   G_CALLBACK(color_changed_cb), world);

  colorBtnDefback = glade_xml_get_widget(gladexml, "colorBtnDefback");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefback),
                             world->defback);
  g_object_set_data(G_OBJECT(colorBtnDefback),
                    "colorptr", world->defback);
  g_signal_connect(G_OBJECT(colorBtnDefback), "color-set",
                   G_CALLBACK(color_changed_cb), world);

  colorBtnDefboldback = glade_xml_get_widget(gladexml, "colorBtnDefboldback");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefboldback),
                             world->defboldback);
  g_object_set_data(G_OBJECT(colorBtnDefboldback),
                    "colorptr", world->defboldback);
  g_signal_connect(G_OBJECT(colorBtnDefboldback), "color-set",
                   G_CALLBACK(color_changed_cb), world);

  /* Revert to default category */
  btnDefault = glade_xml_get_widget(gladexml, "btnDefault");
  g_signal_connect(G_OBJECT(btnDefault), "clicked",
                   G_CALLBACK(set_default_colors_cb), world);

  return panel;
}


static
void
color_changed_cb(GtkColorButton *btn, gpointer data)
{
  World    *world = (World *) data;
  WorldGUI *gui   = world->gui;
  GdkColor *color = (GdkColor *) g_object_get_data(G_OBJECT(btn),
                                                   "colorptr");

  gtk_color_button_get_color(btn, color);
  if (gui) {
    ansitextview_update_color_tags(gui, gui->world);
  }
}


static
void
set_default_colors_cb(GtkButton *btn, gpointer data)
{
  World     *world = (World *) data;
  WorldGUI  *gui   = world->gui;
  GladeXML  *gladexml;
  GtkWidget *colorBtnAnsi;
  GtkWidget *colorBtnDeffore;
  GtkWidget *colorBtnDefbold;
  GtkWidget *colorBtnDefback;
  GtkWidget *colorBtnDefboldback;
  gchar      btnname[18]; /* 18 is enough to hold the button names */
  int        i;

  gladexml = glade_get_widget_tree(GTK_WIDGET(btn));

  colorBtnDeffore     = glade_xml_get_widget(gladexml, "colorBtnDeffore");
  colorBtnDefbold     = glade_xml_get_widget(gladexml, "colorBtnDefbold");
  colorBtnDefback     = glade_xml_get_widget(gladexml, "colorBtnDefback");
  colorBtnDefboldback = glade_xml_get_widget(gladexml, "colorBtnDefboldback");

  memcpy(world->deffore, &deffore, sizeof(GdkColor));
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDeffore),
                             world->deffore);

  memcpy(world->defbold, &defbold, sizeof(GdkColor));
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefbold),
                             world->defbold);

  memcpy(world->defback, &defback, sizeof(GdkColor));
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefback),
                             world->defback);

  memcpy(world->defboldback, &defboldback, sizeof(GdkColor));
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefboldback),
                             world->defboldback);

  memcpy(world->ansicolors, &defansi, 16*sizeof(GdkColor));
  for (i = 0; i < 16; ++i) {
    sprintf(btnname, "colorBtnAnsi[%d]", i);
    colorBtnAnsi = glade_xml_get_widget(gladexml, btnname);
    gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnAnsi),
                               &world->ansicolors[i]);
  }

  if (gui) {
    ansitextview_update_color_tags(gui, gui->world);
  }
}
