/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * $FreeBSD$
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(int sysnum, void *params, uint64_t *uarg, int *n_args)
{
	int64_t *iarg  = (int64_t *) uarg;
	switch (sysnum) {
#define	nosys	linux_nosys
	/* sys_exit */
	case 1: {
		struct sys_exit_args *p = params;
		iarg[0] = p->rval; /* int */
		*n_args = 1;
		break;
	}
	/* linux_fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* read */
	case 3: {
		struct read_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->nbyte; /* u_int */
		*n_args = 3;
		break;
	}
	/* write */
	case 4: {
		struct write_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->nbyte; /* u_int */
		*n_args = 3;
		break;
	}
	/* linux_open */
	case 5: {
		struct linux_open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* l_int */
		iarg[2] = p->mode; /* l_int */
		*n_args = 3;
		break;
	}
	/* close */
	case 6: {
		struct close_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* linux_waitpid */
	case 7: {
		struct linux_waitpid_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		uarg[1] = (intptr_t) p->status; /* l_int * */
		iarg[2] = p->options; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_creat */
	case 8: {
		struct linux_creat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* l_int */
		*n_args = 2;
		break;
	}
	/* linux_link */
	case 9: {
		struct linux_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->to; /* char * */
		*n_args = 2;
		break;
	}
	/* linux_unlink */
	case 10: {
		struct linux_unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_execve */
	case 11: {
		struct linux_execve_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->argp; /* u_int32_t * */
		uarg[2] = (intptr_t) p->envp; /* u_int32_t * */
		*n_args = 3;
		break;
	}
	/* linux_chdir */
	case 12: {
		struct linux_chdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_time */
	case 13: {
		struct linux_time_args *p = params;
		uarg[0] = (intptr_t) p->tm; /* l_time_t * */
		*n_args = 1;
		break;
	}
	/* linux_mknod */
	case 14: {
		struct linux_mknod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* l_int */
		iarg[2] = p->dev; /* l_dev_t */
		*n_args = 3;
		break;
	}
	/* linux_chmod */
	case 15: {
		struct linux_chmod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* l_mode_t */
		*n_args = 2;
		break;
	}
	/* linux_lchown16 */
	case 16: {
		struct linux_lchown16_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* l_uid16_t */
		iarg[2] = p->gid; /* l_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux_stat */
	case 18: {
		struct linux_stat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->up; /* struct linux_stat * */
		*n_args = 2;
		break;
	}
	/* linux_lseek */
	case 19: {
		struct linux_lseek_args *p = params;
		iarg[0] = p->fdes; /* l_uint */
		iarg[1] = p->off; /* l_off_t */
		iarg[2] = p->whence; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* linux_mount */
	case 21: {
		struct linux_mount_args *p = params;
		uarg[0] = (intptr_t) p->specialfile; /* char * */
		uarg[1] = (intptr_t) p->dir; /* char * */
		uarg[2] = (intptr_t) p->filesystemtype; /* char * */
		iarg[3] = p->rwflag; /* l_ulong */
		uarg[4] = (intptr_t) p->data; /* void * */
		*n_args = 5;
		break;
	}
	/* linux_oldumount */
	case 22: {
		struct linux_oldumount_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_setuid16 */
	case 23: {
		struct linux_setuid16_args *p = params;
		iarg[0] = p->uid; /* l_uid16_t */
		*n_args = 1;
		break;
	}
	/* linux_getuid16 */
	case 24: {
		*n_args = 0;
		break;
	}
	/* linux_stime */
	case 25: {
		*n_args = 0;
		break;
	}
	/* linux_ptrace */
	case 26: {
		struct linux_ptrace_args *p = params;
		iarg[0] = p->req; /* l_long */
		iarg[1] = p->pid; /* l_long */
		iarg[2] = p->addr; /* l_long */
		iarg[3] = p->data; /* l_long */
		*n_args = 4;
		break;
	}
	/* linux_alarm */
	case 27: {
		struct linux_alarm_args *p = params;
		iarg[0] = p->secs; /* l_uint */
		*n_args = 1;
		break;
	}
	/* linux_pause */
	case 29: {
		*n_args = 0;
		break;
	}
	/* linux_utime */
	case 30: {
		struct linux_utime_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->times; /* struct l_utimbuf * */
		*n_args = 2;
		break;
	}
	/* linux_access */
	case 33: {
		struct linux_access_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->amode; /* l_int */
		*n_args = 2;
		break;
	}
	/* linux_nice */
	case 34: {
		struct linux_nice_args *p = params;
		iarg[0] = p->inc; /* l_int */
		*n_args = 1;
		break;
	}
	/* sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* linux_kill */
	case 37: {
		struct linux_kill_args *p = params;
		iarg[0] = p->pid; /* l_int */
		iarg[1] = p->signum; /* l_int */
		*n_args = 2;
		break;
	}
	/* linux_rename */
	case 38: {
		struct linux_rename_args *p = params;
		uarg[0] = (intptr_t) p->from; /* char * */
		uarg[1] = (intptr_t) p->to; /* char * */
		*n_args = 2;
		break;
	}
	/* linux_mkdir */
	case 39: {
		struct linux_mkdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* l_int */
		*n_args = 2;
		break;
	}
	/* linux_rmdir */
	case 40: {
		struct linux_rmdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* dup */
	case 41: {
		struct dup_args *p = params;
		uarg[0] = p->fd; /* u_int */
		*n_args = 1;
		break;
	}
	/* linux_pipe */
	case 42: {
		struct linux_pipe_args *p = params;
		uarg[0] = (intptr_t) p->pipefds; /* l_ulong * */
		*n_args = 1;
		break;
	}
	/* linux_times */
	case 43: {
		struct linux_times_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* struct l_times_argv * */
		*n_args = 1;
		break;
	}
	/* linux_brk */
	case 45: {
		struct linux_brk_args *p = params;
		iarg[0] = p->dsend; /* l_ulong */
		*n_args = 1;
		break;
	}
	/* linux_setgid16 */
	case 46: {
		struct linux_setgid16_args *p = params;
		iarg[0] = p->gid; /* l_gid16_t */
		*n_args = 1;
		break;
	}
	/* linux_getgid16 */
	case 47: {
		*n_args = 0;
		break;
	}
	/* linux_signal */
	case 48: {
		struct linux_signal_args *p = params;
		iarg[0] = p->sig; /* l_int */
		iarg[1] = p->handler; /* l_handler_t */
		*n_args = 2;
		break;
	}
	/* linux_geteuid16 */
	case 49: {
		*n_args = 0;
		break;
	}
	/* linux_getegid16 */
	case 50: {
		*n_args = 0;
		break;
	}
	/* acct */
	case 51: {
		struct acct_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_umount */
	case 52: {
		struct linux_umount_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* l_int */
		*n_args = 2;
		break;
	}
	/* linux_ioctl */
	case 54: {
		struct linux_ioctl_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		iarg[1] = p->cmd; /* l_uint */
		uarg[2] = p->arg; /* uintptr_t */
		*n_args = 3;
		break;
	}
	/* linux_fcntl */
	case 55: {
		struct linux_fcntl_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		iarg[1] = p->cmd; /* l_uint */
		uarg[2] = p->arg; /* uintptr_t */
		*n_args = 3;
		break;
	}
	/* setpgid */
	case 57: {
		struct setpgid_args *p = params;
		iarg[0] = p->pid; /* int */
		iarg[1] = p->pgid; /* int */
		*n_args = 2;
		break;
	}
	/* linux_olduname */
	case 59: {
		*n_args = 0;
		break;
	}
	/* umask */
	case 60: {
		struct umask_args *p = params;
		iarg[0] = p->newmask; /* int */
		*n_args = 1;
		break;
	}
	/* chroot */
	case 61: {
		struct chroot_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_ustat */
	case 62: {
		struct linux_ustat_args *p = params;
		iarg[0] = p->dev; /* l_dev_t */
		uarg[1] = (intptr_t) p->ubuf; /* struct l_ustat * */
		*n_args = 2;
		break;
	}
	/* dup2 */
	case 63: {
		struct dup2_args *p = params;
		uarg[0] = p->from; /* u_int */
		uarg[1] = p->to; /* u_int */
		*n_args = 2;
		break;
	}
	/* linux_getppid */
	case 64: {
		*n_args = 0;
		break;
	}
	/* getpgrp */
	case 65: {
		*n_args = 0;
		break;
	}
	/* setsid */
	case 66: {
		*n_args = 0;
		break;
	}
	/* linux_sigaction */
	case 67: {
		struct linux_sigaction_args *p = params;
		iarg[0] = p->sig; /* l_int */
		uarg[1] = (intptr_t) p->nsa; /* l_osigaction_t * */
		uarg[2] = (intptr_t) p->osa; /* l_osigaction_t * */
		*n_args = 3;
		break;
	}
	/* linux_sgetmask */
	case 68: {
		*n_args = 0;
		break;
	}
	/* linux_ssetmask */
	case 69: {
		struct linux_ssetmask_args *p = params;
		iarg[0] = p->mask; /* l_osigset_t */
		*n_args = 1;
		break;
	}
	/* linux_setreuid16 */
	case 70: {
		struct linux_setreuid16_args *p = params;
		iarg[0] = p->ruid; /* l_uid16_t */
		iarg[1] = p->euid; /* l_uid16_t */
		*n_args = 2;
		break;
	}
	/* linux_setregid16 */
	case 71: {
		struct linux_setregid16_args *p = params;
		iarg[0] = p->rgid; /* l_gid16_t */
		iarg[1] = p->egid; /* l_gid16_t */
		*n_args = 2;
		break;
	}
	/* linux_sigsuspend */
	case 72: {
		struct linux_sigsuspend_args *p = params;
		iarg[0] = p->hist0; /* l_int */
		iarg[1] = p->hist1; /* l_int */
		iarg[2] = p->mask; /* l_osigset_t */
		*n_args = 3;
		break;
	}
	/* linux_sigpending */
	case 73: {
		struct linux_sigpending_args *p = params;
		uarg[0] = (intptr_t) p->mask; /* l_osigset_t * */
		*n_args = 1;
		break;
	}
	/* linux_sethostname */
	case 74: {
		struct linux_sethostname_args *p = params;
		uarg[0] = (intptr_t) p->hostname; /* char * */
		uarg[1] = p->len; /* u_int */
		*n_args = 2;
		break;
	}
	/* linux_setrlimit */
	case 75: {
		struct linux_setrlimit_args *p = params;
		iarg[0] = p->resource; /* l_uint */
		uarg[1] = (intptr_t) p->rlim; /* struct l_rlimit * */
		*n_args = 2;
		break;
	}
	/* linux_old_getrlimit */
	case 76: {
		struct linux_old_getrlimit_args *p = params;
		iarg[0] = p->resource; /* l_uint */
		uarg[1] = (intptr_t) p->rlim; /* struct l_rlimit * */
		*n_args = 2;
		break;
	}
	/* linux_getrusage */
	case 77: {
		struct linux_getrusage_args *p = params;
		iarg[0] = p->who; /* int */
		uarg[1] = (intptr_t) p->rusage; /* struct l_rusage * */
		*n_args = 2;
		break;
	}
	/* linux_gettimeofday */
	case 78: {
		struct linux_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct l_timeval * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_settimeofday */
	case 79: {
		struct linux_settimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct l_timeval * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_getgroups16 */
	case 80: {
		struct linux_getgroups16_args *p = params;
		iarg[0] = p->gidsetsize; /* l_uint */
		uarg[1] = (intptr_t) p->gidset; /* l_gid16_t * */
		*n_args = 2;
		break;
	}
	/* linux_setgroups16 */
	case 81: {
		struct linux_setgroups16_args *p = params;
		iarg[0] = p->gidsetsize; /* l_uint */
		uarg[1] = (intptr_t) p->gidset; /* l_gid16_t * */
		*n_args = 2;
		break;
	}
	/* linux_old_select */
	case 82: {
		struct linux_old_select_args *p = params;
		uarg[0] = (intptr_t) p->ptr; /* struct l_old_select_argv * */
		*n_args = 1;
		break;
	}
	/* linux_symlink */
	case 83: {
		struct linux_symlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->to; /* char * */
		*n_args = 2;
		break;
	}
	/* linux_lstat */
	case 84: {
		struct linux_lstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->up; /* struct linux_lstat * */
		*n_args = 2;
		break;
	}
	/* linux_readlink */
	case 85: {
		struct linux_readlink_args *p = params;
		uarg[0] = (intptr_t) p->name; /* char * */
		uarg[1] = (intptr_t) p->buf; /* char * */
		iarg[2] = p->count; /* l_int */
		*n_args = 3;
		break;
	}
	/* swapon */
	case 87: {
		struct swapon_args *p = params;
		uarg[0] = (intptr_t) p->name; /* char * */
		*n_args = 1;
		break;
	}
	/* linux_reboot */
	case 88: {
		struct linux_reboot_args *p = params;
		iarg[0] = p->magic1; /* l_int */
		iarg[1] = p->magic2; /* l_int */
		iarg[2] = p->cmd; /* l_uint */
		uarg[3] = (intptr_t) p->arg; /* void * */
		*n_args = 4;
		break;
	}
	/* linux_readdir */
	case 89: {
		struct linux_readdir_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->dent; /* struct l_dirent * */
		iarg[2] = p->count; /* l_uint */
		*n_args = 3;
		break;
	}
	/* linux_mmap */
	case 90: {
		struct linux_mmap_args *p = params;
		uarg[0] = (intptr_t) p->ptr; /* struct l_mmap_argv * */
		*n_args = 1;
		break;
	}
	/* munmap */
	case 91: {
		struct munmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		iarg[1] = p->len; /* int */
		*n_args = 2;
		break;
	}
	/* linux_truncate */
	case 92: {
		struct linux_truncate_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->length; /* l_ulong */
		*n_args = 2;
		break;
	}
	/* linux_ftruncate */
	case 93: {
		struct linux_ftruncate_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->length; /* long */
		*n_args = 2;
		break;
	}
	/* fchmod */
	case 94: {
		struct fchmod_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* fchown */
	case 95: {
		struct fchown_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* linux_getpriority */
	case 96: {
		struct linux_getpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		*n_args = 2;
		break;
	}
	/* setpriority */
	case 97: {
		struct setpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		iarg[2] = p->prio; /* int */
		*n_args = 3;
		break;
	}
	/* linux_statfs */
	case 99: {
		struct linux_statfs_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* struct l_statfs_buf * */
		*n_args = 2;
		break;
	}
	/* linux_fstatfs */
	case 100: {
		struct linux_fstatfs_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->buf; /* struct l_statfs_buf * */
		*n_args = 2;
		break;
	}
	/* linux_socketcall */
	case 102: {
		struct linux_socketcall_args *p = params;
		iarg[0] = p->what; /* l_int */
		iarg[1] = p->args; /* l_ulong */
		*n_args = 2;
		break;
	}
	/* linux_syslog */
	case 103: {
		struct linux_syslog_args *p = params;
		iarg[0] = p->type; /* l_int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		iarg[2] = p->len; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_setitimer */
	case 104: {
		struct linux_setitimer_args *p = params;
		iarg[0] = p->which; /* l_int */
		uarg[1] = (intptr_t) p->itv; /* struct l_itimerval * */
		uarg[2] = (intptr_t) p->oitv; /* struct l_itimerval * */
		*n_args = 3;
		break;
	}
	/* linux_getitimer */
	case 105: {
		struct linux_getitimer_args *p = params;
		iarg[0] = p->which; /* l_int */
		uarg[1] = (intptr_t) p->itv; /* struct l_itimerval * */
		*n_args = 2;
		break;
	}
	/* linux_newstat */
	case 106: {
		struct linux_newstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* struct l_newstat * */
		*n_args = 2;
		break;
	}
	/* linux_newlstat */
	case 107: {
		struct linux_newlstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* struct l_newstat * */
		*n_args = 2;
		break;
	}
	/* linux_newfstat */
	case 108: {
		struct linux_newfstat_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->buf; /* struct l_newstat * */
		*n_args = 2;
		break;
	}
	/* linux_uname */
	case 109: {
		*n_args = 0;
		break;
	}
	/* linux_iopl */
	case 110: {
		struct linux_iopl_args *p = params;
		iarg[0] = p->level; /* l_ulong */
		*n_args = 1;
		break;
	}
	/* linux_vhangup */
	case 111: {
		*n_args = 0;
		break;
	}
	/* linux_wait4 */
	case 114: {
		struct linux_wait4_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		uarg[1] = (intptr_t) p->status; /* l_uint * */
		iarg[2] = p->options; /* l_int */
		uarg[3] = (intptr_t) p->rusage; /* struct l_rusage * */
		*n_args = 4;
		break;
	}
	/* linux_swapoff */
	case 115: {
		*n_args = 0;
		break;
	}
	/* linux_sysinfo */
	case 116: {
		struct linux_sysinfo_args *p = params;
		uarg[0] = (intptr_t) p->info; /* struct l_sysinfo * */
		*n_args = 1;
		break;
	}
	/* linux_ipc */
	case 117: {
		struct linux_ipc_args *p = params;
		iarg[0] = p->what; /* l_uint */
		iarg[1] = p->arg1; /* l_int */
		iarg[2] = p->arg2; /* l_int */
		iarg[3] = p->arg3; /* l_int */
		uarg[4] = (intptr_t) p->ptr; /* void * */
		iarg[5] = p->arg5; /* l_long */
		*n_args = 6;
		break;
	}
	/* fsync */
	case 118: {
		struct fsync_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* linux_sigreturn */
	case 119: {
		struct linux_sigreturn_args *p = params;
		uarg[0] = (intptr_t) p->sfp; /* struct l_sigframe * */
		*n_args = 1;
		break;
	}
	/* linux_clone */
	case 120: {
		struct linux_clone_args *p = params;
		iarg[0] = p->flags; /* l_int */
		uarg[1] = (intptr_t) p->stack; /* void * */
		uarg[2] = (intptr_t) p->parent_tidptr; /* void * */
		uarg[3] = (intptr_t) p->tls; /* void * */
		uarg[4] = (intptr_t) p->child_tidptr; /* void * */
		*n_args = 5;
		break;
	}
	/* linux_setdomainname */
	case 121: {
		struct linux_setdomainname_args *p = params;
		uarg[0] = (intptr_t) p->name; /* char * */
		iarg[1] = p->len; /* int */
		*n_args = 2;
		break;
	}
	/* linux_newuname */
	case 122: {
		struct linux_newuname_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* struct l_new_utsname * */
		*n_args = 1;
		break;
	}
	/* linux_adjtimex */
	case 124: {
		*n_args = 0;
		break;
	}
	/* linux_mprotect */
	case 125: {
		struct linux_mprotect_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		iarg[1] = p->len; /* int */
		iarg[2] = p->prot; /* int */
		*n_args = 3;
		break;
	}
	/* linux_sigprocmask */
	case 126: {
		struct linux_sigprocmask_args *p = params;
		iarg[0] = p->how; /* l_int */
		uarg[1] = (intptr_t) p->mask; /* l_osigset_t * */
		uarg[2] = (intptr_t) p->omask; /* l_osigset_t * */
		*n_args = 3;
		break;
	}
	/* linux_create_module */
	case 127: {
		*n_args = 0;
		break;
	}
	/* linux_init_module */
	case 128: {
		*n_args = 0;
		break;
	}
	/* linux_delete_module */
	case 129: {
		*n_args = 0;
		break;
	}
	/* linux_get_kernel_syms */
	case 130: {
		*n_args = 0;
		break;
	}
	/* linux_quotactl */
	case 131: {
		*n_args = 0;
		break;
	}
	/* getpgid */
	case 132: {
		struct getpgid_args *p = params;
		iarg[0] = p->pid; /* int */
		*n_args = 1;
		break;
	}
	/* fchdir */
	case 133: {
		struct fchdir_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* linux_bdflush */
	case 134: {
		*n_args = 0;
		break;
	}
	/* linux_sysfs */
	case 135: {
		struct linux_sysfs_args *p = params;
		iarg[0] = p->option; /* l_int */
		iarg[1] = p->arg1; /* l_ulong */
		iarg[2] = p->arg2; /* l_ulong */
		*n_args = 3;
		break;
	}
	/* linux_personality */
	case 136: {
		struct linux_personality_args *p = params;
		iarg[0] = p->per; /* l_ulong */
		*n_args = 1;
		break;
	}
	/* linux_setfsuid16 */
	case 138: {
		struct linux_setfsuid16_args *p = params;
		iarg[0] = p->uid; /* l_uid16_t */
		*n_args = 1;
		break;
	}
	/* linux_setfsgid16 */
	case 139: {
		struct linux_setfsgid16_args *p = params;
		iarg[0] = p->gid; /* l_gid16_t */
		*n_args = 1;
		break;
	}
	/* linux_llseek */
	case 140: {
		struct linux_llseek_args *p = params;
		iarg[0] = p->fd; /* l_int */
		iarg[1] = p->ohigh; /* l_ulong */
		iarg[2] = p->olow; /* l_ulong */
		uarg[3] = (intptr_t) p->res; /* l_loff_t * */
		iarg[4] = p->whence; /* l_uint */
		*n_args = 5;
		break;
	}
	/* linux_getdents */
	case 141: {
		struct linux_getdents_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->dent; /* void * */
		iarg[2] = p->count; /* l_uint */
		*n_args = 3;
		break;
	}
	/* linux_select */
	case 142: {
		struct linux_select_args *p = params;
		iarg[0] = p->nfds; /* l_int */
		uarg[1] = (intptr_t) p->readfds; /* l_fd_set * */
		uarg[2] = (intptr_t) p->writefds; /* l_fd_set * */
		uarg[3] = (intptr_t) p->exceptfds; /* l_fd_set * */
		uarg[4] = (intptr_t) p->timeout; /* struct l_timeval * */
		*n_args = 5;
		break;
	}
	/* flock */
	case 143: {
		struct flock_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->how; /* int */
		*n_args = 2;
		break;
	}
	/* linux_msync */
	case 144: {
		struct linux_msync_args *p = params;
		iarg[0] = p->addr; /* l_ulong */
		iarg[1] = p->len; /* l_size_t */
		iarg[2] = p->fl; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_readv */
	case 145: {
		struct linux_readv_args *p = params;
		iarg[0] = p->fd; /* l_ulong */
		uarg[1] = (intptr_t) p->iovp; /* struct l_iovec32 * */
		iarg[2] = p->iovcnt; /* l_ulong */
		*n_args = 3;
		break;
	}
	/* linux_writev */
	case 146: {
		struct linux_writev_args *p = params;
		iarg[0] = p->fd; /* l_ulong */
		uarg[1] = (intptr_t) p->iovp; /* struct l_iovec32 * */
		iarg[2] = p->iovcnt; /* l_ulong */
		*n_args = 3;
		break;
	}
	/* linux_getsid */
	case 147: {
		struct linux_getsid_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		*n_args = 1;
		break;
	}
	/* linux_fdatasync */
	case 148: {
		struct linux_fdatasync_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		*n_args = 1;
		break;
	}
	/* linux_sysctl */
	case 149: {
		struct linux_sysctl_args *p = params;
		uarg[0] = (intptr_t) p->args; /* struct l___sysctl_args * */
		*n_args = 1;
		break;
	}
	/* mlock */
	case 150: {
		struct mlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* munlock */
	case 151: {
		struct munlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* mlockall */
	case 152: {
		struct mlockall_args *p = params;
		iarg[0] = p->how; /* int */
		*n_args = 1;
		break;
	}
	/* munlockall */
	case 153: {
		*n_args = 0;
		break;
	}
	/* sched_setparam */
	case 154: {
		struct sched_setparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* const struct sched_param * */
		*n_args = 2;
		break;
	}
	/* sched_getparam */
	case 155: {
		struct sched_getparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* struct sched_param * */
		*n_args = 2;
		break;
	}
	/* linux_sched_setscheduler */
	case 156: {
		struct linux_sched_setscheduler_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		iarg[1] = p->policy; /* l_int */
		uarg[2] = (intptr_t) p->param; /* struct l_sched_param * */
		*n_args = 3;
		break;
	}
	/* linux_sched_getscheduler */
	case 157: {
		struct linux_sched_getscheduler_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		*n_args = 1;
		break;
	}
	/* sched_yield */
	case 158: {
		*n_args = 0;
		break;
	}
	/* linux_sched_get_priority_max */
	case 159: {
		struct linux_sched_get_priority_max_args *p = params;
		iarg[0] = p->policy; /* l_int */
		*n_args = 1;
		break;
	}
	/* linux_sched_get_priority_min */
	case 160: {
		struct linux_sched_get_priority_min_args *p = params;
		iarg[0] = p->policy; /* l_int */
		*n_args = 1;
		break;
	}
	/* linux_sched_rr_get_interval */
	case 161: {
		struct linux_sched_rr_get_interval_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		uarg[1] = (intptr_t) p->interval; /* struct l_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_nanosleep */
	case 162: {
		struct linux_nanosleep_args *p = params;
		uarg[0] = (intptr_t) p->rqtp; /* const struct l_timespec * */
		uarg[1] = (intptr_t) p->rmtp; /* struct l_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_mremap */
	case 163: {
		struct linux_mremap_args *p = params;
		iarg[0] = p->addr; /* l_ulong */
		iarg[1] = p->old_len; /* l_ulong */
		iarg[2] = p->new_len; /* l_ulong */
		iarg[3] = p->flags; /* l_ulong */
		iarg[4] = p->new_addr; /* l_ulong */
		*n_args = 5;
		break;
	}
	/* linux_setresuid16 */
	case 164: {
		struct linux_setresuid16_args *p = params;
		iarg[0] = p->ruid; /* l_uid16_t */
		iarg[1] = p->euid; /* l_uid16_t */
		iarg[2] = p->suid; /* l_uid16_t */
		*n_args = 3;
		break;
	}
	/* linux_getresuid16 */
	case 165: {
		struct linux_getresuid16_args *p = params;
		uarg[0] = (intptr_t) p->ruid; /* l_uid16_t * */
		uarg[1] = (intptr_t) p->euid; /* l_uid16_t * */
		uarg[2] = (intptr_t) p->suid; /* l_uid16_t * */
		*n_args = 3;
		break;
	}
	/* linux_query_module */
	case 167: {
		*n_args = 0;
		break;
	}
	/* poll */
	case 168: {
		struct poll_args *p = params;
		uarg[0] = (intptr_t) p->fds; /* struct pollfd * */
		uarg[1] = p->nfds; /* unsigned int */
		iarg[2] = p->timeout; /* int */
		*n_args = 3;
		break;
	}
	/* linux_nfsservctl */
	case 169: {
		*n_args = 0;
		break;
	}
	/* linux_setresgid16 */
	case 170: {
		struct linux_setresgid16_args *p = params;
		iarg[0] = p->rgid; /* l_gid16_t */
		iarg[1] = p->egid; /* l_gid16_t */
		iarg[2] = p->sgid; /* l_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux_getresgid16 */
	case 171: {
		struct linux_getresgid16_args *p = params;
		uarg[0] = (intptr_t) p->rgid; /* l_gid16_t * */
		uarg[1] = (intptr_t) p->egid; /* l_gid16_t * */
		uarg[2] = (intptr_t) p->sgid; /* l_gid16_t * */
		*n_args = 3;
		break;
	}
	/* linux_prctl */
	case 172: {
		struct linux_prctl_args *p = params;
		iarg[0] = p->option; /* l_int */
		iarg[1] = p->arg2; /* l_int */
		iarg[2] = p->arg3; /* l_int */
		iarg[3] = p->arg4; /* l_int */
		iarg[4] = p->arg5; /* l_int */
		*n_args = 5;
		break;
	}
	/* linux_rt_sigreturn */
	case 173: {
		struct linux_rt_sigreturn_args *p = params;
		uarg[0] = (intptr_t) p->ucp; /* struct l_ucontext * */
		*n_args = 1;
		break;
	}
	/* linux_rt_sigaction */
	case 174: {
		struct linux_rt_sigaction_args *p = params;
		iarg[0] = p->sig; /* l_int */
		uarg[1] = (intptr_t) p->act; /* l_sigaction_t * */
		uarg[2] = (intptr_t) p->oact; /* l_sigaction_t * */
		iarg[3] = p->sigsetsize; /* l_size_t */
		*n_args = 4;
		break;
	}
	/* linux_rt_sigprocmask */
	case 175: {
		struct linux_rt_sigprocmask_args *p = params;
		iarg[0] = p->how; /* l_int */
		uarg[1] = (intptr_t) p->mask; /* l_sigset_t * */
		uarg[2] = (intptr_t) p->omask; /* l_sigset_t * */
		iarg[3] = p->sigsetsize; /* l_size_t */
		*n_args = 4;
		break;
	}
	/* linux_rt_sigpending */
	case 176: {
		struct linux_rt_sigpending_args *p = params;
		uarg[0] = (intptr_t) p->set; /* l_sigset_t * */
		iarg[1] = p->sigsetsize; /* l_size_t */
		*n_args = 2;
		break;
	}
	/* linux_rt_sigtimedwait */
	case 177: {
		struct linux_rt_sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) p->mask; /* l_sigset_t * */
		uarg[1] = (intptr_t) p->ptr; /* l_siginfo_t * */
		uarg[2] = (intptr_t) p->timeout; /* struct l_timeval * */
		iarg[3] = p->sigsetsize; /* l_size_t */
		*n_args = 4;
		break;
	}
	/* linux_rt_sigqueueinfo */
	case 178: {
		*n_args = 0;
		break;
	}
	/* linux_rt_sigsuspend */
	case 179: {
		struct linux_rt_sigsuspend_args *p = params;
		uarg[0] = (intptr_t) p->newset; /* l_sigset_t * */
		iarg[1] = p->sigsetsize; /* l_size_t */
		*n_args = 2;
		break;
	}
	/* linux_pread */
	case 180: {
		struct linux_pread_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->buf; /* char * */
		iarg[2] = p->nbyte; /* l_size_t */
		iarg[3] = p->offset; /* l_loff_t */
		*n_args = 4;
		break;
	}
	/* linux_pwrite */
	case 181: {
		struct linux_pwrite_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->buf; /* char * */
		iarg[2] = p->nbyte; /* l_size_t */
		iarg[3] = p->offset; /* l_loff_t */
		*n_args = 4;
		break;
	}
	/* linux_chown16 */
	case 182: {
		struct linux_chown16_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* l_uid16_t */
		iarg[2] = p->gid; /* l_gid16_t */
		*n_args = 3;
		break;
	}
	/* linux_getcwd */
	case 183: {
		struct linux_getcwd_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* char * */
		iarg[1] = p->bufsize; /* l_ulong */
		*n_args = 2;
		break;
	}
	/* linux_capget */
	case 184: {
		struct linux_capget_args *p = params;
		uarg[0] = (intptr_t) p->hdrp; /* struct l_user_cap_header * */
		uarg[1] = (intptr_t) p->datap; /* struct l_user_cap_data * */
		*n_args = 2;
		break;
	}
	/* linux_capset */
	case 185: {
		struct linux_capset_args *p = params;
		uarg[0] = (intptr_t) p->hdrp; /* struct l_user_cap_header * */
		uarg[1] = (intptr_t) p->datap; /* struct l_user_cap_data * */
		*n_args = 2;
		break;
	}
	/* linux_sigaltstack */
	case 186: {
		struct linux_sigaltstack_args *p = params;
		uarg[0] = (intptr_t) p->uss; /* l_stack_t * */
		uarg[1] = (intptr_t) p->uoss; /* l_stack_t * */
		*n_args = 2;
		break;
	}
	/* linux_sendfile */
	case 187: {
		*n_args = 0;
		break;
	}
	/* linux_vfork */
	case 190: {
		*n_args = 0;
		break;
	}
	/* linux_getrlimit */
	case 191: {
		struct linux_getrlimit_args *p = params;
		iarg[0] = p->resource; /* l_uint */
		uarg[1] = (intptr_t) p->rlim; /* struct l_rlimit * */
		*n_args = 2;
		break;
	}
	/* linux_mmap2 */
	case 192: {
		struct linux_mmap2_args *p = params;
		iarg[0] = p->addr; /* l_ulong */
		iarg[1] = p->len; /* l_ulong */
		iarg[2] = p->prot; /* l_ulong */
		iarg[3] = p->flags; /* l_ulong */
		iarg[4] = p->fd; /* l_ulong */
		iarg[5] = p->pgoff; /* l_ulong */
		*n_args = 6;
		break;
	}
	/* linux_truncate64 */
	case 193: {
		struct linux_truncate64_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->length; /* l_loff_t */
		*n_args = 2;
		break;
	}
	/* linux_ftruncate64 */
	case 194: {
		struct linux_ftruncate64_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		iarg[1] = p->length; /* l_loff_t */
		*n_args = 2;
		break;
	}
	/* linux_stat64 */
	case 195: {
		struct linux_stat64_args *p = params;
		uarg[0] = (intptr_t) p->filename; /* char * */
		uarg[1] = (intptr_t) p->statbuf; /* struct l_stat64 * */
		iarg[2] = p->flags; /* l_long */
		*n_args = 3;
		break;
	}
	/* linux_lstat64 */
	case 196: {
		struct linux_lstat64_args *p = params;
		uarg[0] = (intptr_t) p->filename; /* char * */
		uarg[1] = (intptr_t) p->statbuf; /* struct l_stat64 * */
		iarg[2] = p->flags; /* l_long */
		*n_args = 3;
		break;
	}
	/* linux_fstat64 */
	case 197: {
		struct linux_fstat64_args *p = params;
		iarg[0] = p->fd; /* l_ulong */
		uarg[1] = (intptr_t) p->statbuf; /* struct l_stat64 * */
		iarg[2] = p->flags; /* l_long */
		*n_args = 3;
		break;
	}
	/* linux_lchown */
	case 198: {
		struct linux_lchown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* l_uid_t */
		iarg[2] = p->gid; /* l_gid_t */
		*n_args = 3;
		break;
	}
	/* linux_getuid */
	case 199: {
		*n_args = 0;
		break;
	}
	/* linux_getgid */
	case 200: {
		*n_args = 0;
		break;
	}
	/* geteuid */
	case 201: {
		*n_args = 0;
		break;
	}
	/* getegid */
	case 202: {
		*n_args = 0;
		break;
	}
	/* setreuid */
	case 203: {
		struct setreuid_args *p = params;
		uarg[0] = p->ruid; /* uid_t */
		uarg[1] = p->euid; /* uid_t */
		*n_args = 2;
		break;
	}
	/* setregid */
	case 204: {
		struct setregid_args *p = params;
		iarg[0] = p->rgid; /* gid_t */
		iarg[1] = p->egid; /* gid_t */
		*n_args = 2;
		break;
	}
	/* linux_getgroups */
	case 205: {
		struct linux_getgroups_args *p = params;
		iarg[0] = p->gidsetsize; /* l_int */
		uarg[1] = (intptr_t) p->grouplist; /* l_gid_t * */
		*n_args = 2;
		break;
	}
	/* linux_setgroups */
	case 206: {
		struct linux_setgroups_args *p = params;
		iarg[0] = p->gidsetsize; /* l_int */
		uarg[1] = (intptr_t) p->grouplist; /* l_gid_t * */
		*n_args = 2;
		break;
	}
	/* fchown */
	case 207: {
		*n_args = 0;
		break;
	}
	/* setresuid */
	case 208: {
		struct setresuid_args *p = params;
		uarg[0] = p->ruid; /* uid_t */
		uarg[1] = p->euid; /* uid_t */
		uarg[2] = p->suid; /* uid_t */
		*n_args = 3;
		break;
	}
	/* getresuid */
	case 209: {
		struct getresuid_args *p = params;
		uarg[0] = (intptr_t) p->ruid; /* uid_t * */
		uarg[1] = (intptr_t) p->euid; /* uid_t * */
		uarg[2] = (intptr_t) p->suid; /* uid_t * */
		*n_args = 3;
		break;
	}
	/* setresgid */
	case 210: {
		struct setresgid_args *p = params;
		iarg[0] = p->rgid; /* gid_t */
		iarg[1] = p->egid; /* gid_t */
		iarg[2] = p->sgid; /* gid_t */
		*n_args = 3;
		break;
	}
	/* getresgid */
	case 211: {
		struct getresgid_args *p = params;
		uarg[0] = (intptr_t) p->rgid; /* gid_t * */
		uarg[1] = (intptr_t) p->egid; /* gid_t * */
		uarg[2] = (intptr_t) p->sgid; /* gid_t * */
		*n_args = 3;
		break;
	}
	/* linux_chown */
	case 212: {
		struct linux_chown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* l_uid_t */
		iarg[2] = p->gid; /* l_gid_t */
		*n_args = 3;
		break;
	}
	/* setuid */
	case 213: {
		struct setuid_args *p = params;
		uarg[0] = p->uid; /* uid_t */
		*n_args = 1;
		break;
	}
	/* setgid */
	case 214: {
		struct setgid_args *p = params;
		iarg[0] = p->gid; /* gid_t */
		*n_args = 1;
		break;
	}
	/* linux_setfsuid */
	case 215: {
		struct linux_setfsuid_args *p = params;
		iarg[0] = p->uid; /* l_uid_t */
		*n_args = 1;
		break;
	}
	/* linux_setfsgid */
	case 216: {
		struct linux_setfsgid_args *p = params;
		iarg[0] = p->gid; /* l_gid_t */
		*n_args = 1;
		break;
	}
	/* linux_pivot_root */
	case 217: {
		struct linux_pivot_root_args *p = params;
		uarg[0] = (intptr_t) p->new_root; /* char * */
		uarg[1] = (intptr_t) p->put_old; /* char * */
		*n_args = 2;
		break;
	}
	/* linux_mincore */
	case 218: {
		struct linux_mincore_args *p = params;
		iarg[0] = p->start; /* l_ulong */
		iarg[1] = p->len; /* l_size_t */
		uarg[2] = (intptr_t) p->vec; /* u_char * */
		*n_args = 3;
		break;
	}
	/* madvise */
	case 219: {
		struct madvise_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->behav; /* int */
		*n_args = 3;
		break;
	}
	/* linux_getdents64 */
	case 220: {
		struct linux_getdents64_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		uarg[1] = (intptr_t) p->dirent; /* void * */
		iarg[2] = p->count; /* l_uint */
		*n_args = 3;
		break;
	}
	/* linux_fcntl64 */
	case 221: {
		struct linux_fcntl64_args *p = params;
		iarg[0] = p->fd; /* l_uint */
		iarg[1] = p->cmd; /* l_uint */
		uarg[2] = p->arg; /* uintptr_t */
		*n_args = 3;
		break;
	}
	/* linux_gettid */
	case 224: {
		*n_args = 0;
		break;
	}
	/* linux_setxattr */
	case 226: {
		*n_args = 0;
		break;
	}
	/* linux_lsetxattr */
	case 227: {
		*n_args = 0;
		break;
	}
	/* linux_fsetxattr */
	case 228: {
		*n_args = 0;
		break;
	}
	/* linux_getxattr */
	case 229: {
		*n_args = 0;
		break;
	}
	/* linux_lgetxattr */
	case 230: {
		*n_args = 0;
		break;
	}
	/* linux_fgetxattr */
	case 231: {
		*n_args = 0;
		break;
	}
	/* linux_listxattr */
	case 232: {
		*n_args = 0;
		break;
	}
	/* linux_llistxattr */
	case 233: {
		*n_args = 0;
		break;
	}
	/* linux_flistxattr */
	case 234: {
		*n_args = 0;
		break;
	}
	/* linux_removexattr */
	case 235: {
		*n_args = 0;
		break;
	}
	/* linux_lremovexattr */
	case 236: {
		*n_args = 0;
		break;
	}
	/* linux_fremovexattr */
	case 237: {
		*n_args = 0;
		break;
	}
	/* linux_tkill */
	case 238: {
		struct linux_tkill_args *p = params;
		iarg[0] = p->tid; /* int */
		iarg[1] = p->sig; /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_futex */
	case 240: {
		struct linux_sys_futex_args *p = params;
		uarg[0] = (intptr_t) p->uaddr; /* void * */
		iarg[1] = p->op; /* int */
		uarg[2] = p->val; /* uint32_t */
		uarg[3] = (intptr_t) p->timeout; /* struct l_timespec * */
		uarg[4] = (intptr_t) p->uaddr2; /* uint32_t * */
		uarg[5] = p->val3; /* uint32_t */
		*n_args = 6;
		break;
	}
	/* linux_sched_setaffinity */
	case 241: {
		struct linux_sched_setaffinity_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		iarg[1] = p->len; /* l_uint */
		uarg[2] = (intptr_t) p->user_mask_ptr; /* l_ulong * */
		*n_args = 3;
		break;
	}
	/* linux_sched_getaffinity */
	case 242: {
		struct linux_sched_getaffinity_args *p = params;
		iarg[0] = p->pid; /* l_pid_t */
		iarg[1] = p->len; /* l_uint */
		uarg[2] = (intptr_t) p->user_mask_ptr; /* l_ulong * */
		*n_args = 3;
		break;
	}
	/* linux_set_thread_area */
	case 243: {
		struct linux_set_thread_area_args *p = params;
		uarg[0] = (intptr_t) p->desc; /* struct l_user_desc * */
		*n_args = 1;
		break;
	}
	/* linux_fadvise64 */
	case 250: {
		struct linux_fadvise64_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->offset; /* l_loff_t */
		iarg[2] = p->len; /* l_size_t */
		iarg[3] = p->advice; /* int */
		*n_args = 4;
		break;
	}
	/* linux_exit_group */
	case 252: {
		struct linux_exit_group_args *p = params;
		iarg[0] = p->error_code; /* int */
		*n_args = 1;
		break;
	}
	/* linux_lookup_dcookie */
	case 253: {
		*n_args = 0;
		break;
	}
	/* linux_epoll_create */
	case 254: {
		*n_args = 0;
		break;
	}
	/* linux_epoll_ctl */
	case 255: {
		*n_args = 0;
		break;
	}
	/* linux_epoll_wait */
	case 256: {
		*n_args = 0;
		break;
	}
	/* linux_remap_file_pages */
	case 257: {
		*n_args = 0;
		break;
	}
	/* linux_set_tid_address */
	case 258: {
		struct linux_set_tid_address_args *p = params;
		uarg[0] = (intptr_t) p->tidptr; /* int * */
		*n_args = 1;
		break;
	}
	/* linux_timer_create */
	case 259: {
		*n_args = 0;
		break;
	}
	/* linux_timer_settime */
	case 260: {
		*n_args = 0;
		break;
	}
	/* linux_timer_gettime */
	case 261: {
		*n_args = 0;
		break;
	}
	/* linux_timer_getoverrun */
	case 262: {
		*n_args = 0;
		break;
	}
	/* linux_timer_delete */
	case 263: {
		*n_args = 0;
		break;
	}
	/* linux_clock_settime */
	case 264: {
		struct linux_clock_settime_args *p = params;
		iarg[0] = p->which; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct l_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_clock_gettime */
	case 265: {
		struct linux_clock_gettime_args *p = params;
		iarg[0] = p->which; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct l_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_clock_getres */
	case 266: {
		struct linux_clock_getres_args *p = params;
		iarg[0] = p->which; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct l_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_clock_nanosleep */
	case 267: {
		struct linux_clock_nanosleep_args *p = params;
		iarg[0] = p->which; /* clockid_t */
		iarg[1] = p->flags; /* int */
		uarg[2] = (intptr_t) p->rqtp; /* struct l_timespec * */
		uarg[3] = (intptr_t) p->rmtp; /* struct l_timespec * */
		*n_args = 4;
		break;
	}
	/* linux_statfs64 */
	case 268: {
		struct linux_statfs64_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = p->bufsize; /* size_t */
		uarg[2] = (intptr_t) p->buf; /* struct l_statfs64_buf * */
		*n_args = 3;
		break;
	}
	/* linux_fstatfs64 */
	case 269: {
		*n_args = 0;
		break;
	}
	/* linux_tgkill */
	case 270: {
		struct linux_tgkill_args *p = params;
		iarg[0] = p->tgid; /* int */
		iarg[1] = p->pid; /* int */
		iarg[2] = p->sig; /* int */
		*n_args = 3;
		break;
	}
	/* linux_utimes */
	case 271: {
		struct linux_utimes_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->tptr; /* struct l_timeval * */
		*n_args = 2;
		break;
	}
	/* linux_fadvise64_64 */
	case 272: {
		struct linux_fadvise64_64_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->offset; /* l_loff_t */
		iarg[2] = p->len; /* l_loff_t */
		iarg[3] = p->advice; /* int */
		*n_args = 4;
		break;
	}
	/* linux_mbind */
	case 274: {
		*n_args = 0;
		break;
	}
	/* linux_get_mempolicy */
	case 275: {
		*n_args = 0;
		break;
	}
	/* linux_set_mempolicy */
	case 276: {
		*n_args = 0;
		break;
	}
	/* linux_mq_open */
	case 277: {
		*n_args = 0;
		break;
	}
	/* linux_mq_unlink */
	case 278: {
		*n_args = 0;
		break;
	}
	/* linux_mq_timedsend */
	case 279: {
		*n_args = 0;
		break;
	}
	/* linux_mq_timedreceive */
	case 280: {
		*n_args = 0;
		break;
	}
	/* linux_mq_notify */
	case 281: {
		*n_args = 0;
		break;
	}
	/* linux_mq_getsetattr */
	case 282: {
		*n_args = 0;
		break;
	}
	/* linux_kexec_load */
	case 283: {
		*n_args = 0;
		break;
	}
	/* linux_waitid */
	case 284: {
		*n_args = 0;
		break;
	}
	/* linux_add_key */
	case 286: {
		*n_args = 0;
		break;
	}
	/* linux_request_key */
	case 287: {
		*n_args = 0;
		break;
	}
	/* linux_keyctl */
	case 288: {
		*n_args = 0;
		break;
	}
	/* linux_ioprio_set */
	case 289: {
		*n_args = 0;
		break;
	}
	/* linux_ioprio_get */
	case 290: {
		*n_args = 0;
		break;
	}
	/* linux_inotify_init */
	case 291: {
		*n_args = 0;
		break;
	}
	/* linux_inotify_add_watch */
	case 292: {
		*n_args = 0;
		break;
	}
	/* linux_inotify_rm_watch */
	case 293: {
		*n_args = 0;
		break;
	}
	/* linux_migrate_pages */
	case 294: {
		*n_args = 0;
		break;
	}
	/* linux_openat */
	case 295: {
		struct linux_openat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* const char * */
		iarg[2] = p->flags; /* l_int */
		iarg[3] = p->mode; /* l_int */
		*n_args = 4;
		break;
	}
	/* linux_mkdirat */
	case 296: {
		struct linux_mkdirat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->pathname; /* const char * */
		iarg[2] = p->mode; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_mknodat */
	case 297: {
		struct linux_mknodat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* const char * */
		iarg[2] = p->mode; /* l_int */
		iarg[3] = p->dev; /* l_uint */
		*n_args = 4;
		break;
	}
	/* linux_fchownat */
	case 298: {
		struct linux_fchownat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* const char * */
		iarg[2] = p->uid; /* l_uid16_t */
		iarg[3] = p->gid; /* l_gid16_t */
		iarg[4] = p->flag; /* l_int */
		*n_args = 5;
		break;
	}
	/* linux_futimesat */
	case 299: {
		struct linux_futimesat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* char * */
		uarg[2] = (intptr_t) p->utimes; /* struct l_timeval * */
		*n_args = 3;
		break;
	}
	/* linux_fstatat64 */
	case 300: {
		struct linux_fstatat64_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->pathname; /* char * */
		uarg[2] = (intptr_t) p->statbuf; /* struct l_stat64 * */
		iarg[3] = p->flag; /* l_int */
		*n_args = 4;
		break;
	}
	/* linux_unlinkat */
	case 301: {
		struct linux_unlinkat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->pathname; /* const char * */
		iarg[2] = p->flag; /* l_int */
		*n_args = 3;
		break;
	}
	/* linux_renameat */
	case 302: {
		struct linux_renameat_args *p = params;
		iarg[0] = p->olddfd; /* l_int */
		uarg[1] = (intptr_t) p->oldname; /* const char * */
		iarg[2] = p->newdfd; /* l_int */
		uarg[3] = (intptr_t) p->newname; /* const char * */
		*n_args = 4;
		break;
	}
	/* linux_linkat */
	case 303: {
		struct linux_linkat_args *p = params;
		iarg[0] = p->olddfd; /* l_int */
		uarg[1] = (intptr_t) p->oldname; /* const char * */
		iarg[2] = p->newdfd; /* l_int */
		uarg[3] = (intptr_t) p->newname; /* const char * */
		iarg[4] = p->flag; /* l_int */
		*n_args = 5;
		break;
	}
	/* linux_symlinkat */
	case 304: {
		struct linux_symlinkat_args *p = params;
		uarg[0] = (intptr_t) p->oldname; /* const char * */
		iarg[1] = p->newdfd; /* l_int */
		uarg[2] = (intptr_t) p->newname; /* const char * */
		*n_args = 3;
		break;
	}
	/* linux_readlinkat */
	case 305: {
		struct linux_readlinkat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->path; /* const char * */
		uarg[2] = (intptr_t) p->buf; /* char * */
		iarg[3] = p->bufsiz; /* l_int */
		*n_args = 4;
		break;
	}
	/* linux_fchmodat */
	case 306: {
		struct linux_fchmodat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* const char * */
		iarg[2] = p->mode; /* l_mode_t */
		*n_args = 3;
		break;
	}
	/* linux_faccessat */
	case 307: {
		struct linux_faccessat_args *p = params;
		iarg[0] = p->dfd; /* l_int */
		uarg[1] = (intptr_t) p->filename; /* const char * */
		iarg[2] = p->amode; /* l_int */
		iarg[3] = p->flag; /* int */
		*n_args = 4;
		break;
	}
	/* linux_pselect6 */
	case 308: {
		*n_args = 0;
		break;
	}
	/* linux_ppoll */
	case 309: {
		*n_args = 0;
		break;
	}
	/* linux_unshare */
	case 310: {
		*n_args = 0;
		break;
	}
	/* linux_set_robust_list */
	case 311: {
		struct linux_set_robust_list_args *p = params;
		uarg[0] = (intptr_t) p->head; /* struct linux_robust_list_head * */
		iarg[1] = p->len; /* l_size_t */
		*n_args = 2;
		break;
	}
	/* linux_get_robust_list */
	case 312: {
		struct linux_get_robust_list_args *p = params;
		iarg[0] = p->pid; /* l_int */
		uarg[1] = (intptr_t) p->head; /* struct linux_robust_list_head * */
		uarg[2] = (intptr_t) p->len; /* l_size_t * */
		*n_args = 3;
		break;
	}
	/* linux_splice */
	case 313: {
		*n_args = 0;
		break;
	}
	/* linux_sync_file_range */
	case 314: {
		*n_args = 0;
		break;
	}
	/* linux_tee */
	case 315: {
		*n_args = 0;
		break;
	}
	/* linux_vmsplice */
	case 316: {
		*n_args = 0;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
#define	nosys	linux_nosys
	/* sys_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_fork */
	case 2:
		break;
	/* read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_open */
	case 5:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_waitpid */
	case 7:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "l_int *";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_creat */
	case 8:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_link */
	case 9:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_execve */
	case 11:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int32_t *";
			break;
		case 2:
			p = "u_int32_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_time */
	case 13:
		switch(ndx) {
		case 0:
			p = "l_time_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_dev_t";
			break;
		default:
			break;
		};
		break;
	/* linux_chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_mode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_lchown16 */
	case 16:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_uid16_t";
			break;
		case 2:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_stat */
	case 18:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct linux_stat *";
			break;
		default:
			break;
		};
		break;
	/* linux_lseek */
	case 19:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_off_t";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_getpid */
	case 20:
		break;
	/* linux_mount */
	case 21:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "l_ulong";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_oldumount */
	case 22:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_setuid16 */
	case 23:
		switch(ndx) {
		case 0:
			p = "l_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getuid16 */
	case 24:
		break;
	/* linux_stime */
	case 25:
		break;
	/* linux_ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "l_long";
			break;
		case 1:
			p = "l_long";
			break;
		case 2:
			p = "l_long";
			break;
		case 3:
			p = "l_long";
			break;
		default:
			break;
		};
		break;
	/* linux_alarm */
	case 27:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_pause */
	case 29:
		break;
	/* linux_utime */
	case 30:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_utimbuf *";
			break;
		default:
			break;
		};
		break;
	/* linux_access */
	case 33:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_nice */
	case 34:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* sync */
	case 36:
		break;
	/* linux_kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_rename */
	case 38:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_mkdir */
	case 39:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_rmdir */
	case 40:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_pipe */
	case 42:
		switch(ndx) {
		case 0:
			p = "l_ulong *";
			break;
		default:
			break;
		};
		break;
	/* linux_times */
	case 43:
		switch(ndx) {
		case 0:
			p = "struct l_times_argv *";
			break;
		default:
			break;
		};
		break;
	/* linux_brk */
	case 45:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_setgid16 */
	case 46:
		switch(ndx) {
		case 0:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getgid16 */
	case 47:
		break;
	/* linux_signal */
	case 48:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_handler_t";
			break;
		default:
			break;
		};
		break;
	/* linux_geteuid16 */
	case 49:
		break;
	/* linux_getegid16 */
	case 50:
		break;
	/* acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_umount */
	case 52:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_uint";
			break;
		case 2:
			p = "uintptr_t";
			break;
		default:
			break;
		};
		break;
	/* linux_fcntl */
	case 55:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_uint";
			break;
		case 2:
			p = "uintptr_t";
			break;
		default:
			break;
		};
		break;
	/* setpgid */
	case 57:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_olduname */
	case 59:
		break;
	/* umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_ustat */
	case 62:
		switch(ndx) {
		case 0:
			p = "l_dev_t";
			break;
		case 1:
			p = "struct l_ustat *";
			break;
		default:
			break;
		};
		break;
	/* dup2 */
	case 63:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_getppid */
	case 64:
		break;
	/* getpgrp */
	case 65:
		break;
	/* setsid */
	case 66:
		break;
	/* linux_sigaction */
	case 67:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_osigaction_t *";
			break;
		case 2:
			p = "l_osigaction_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sgetmask */
	case 68:
		break;
	/* linux_ssetmask */
	case 69:
		switch(ndx) {
		case 0:
			p = "l_osigset_t";
			break;
		default:
			break;
		};
		break;
	/* linux_setreuid16 */
	case 70:
		switch(ndx) {
		case 0:
			p = "l_uid16_t";
			break;
		case 1:
			p = "l_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_setregid16 */
	case 71:
		switch(ndx) {
		case 0:
			p = "l_gid16_t";
			break;
		case 1:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sigsuspend */
	case 72:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_osigset_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sigpending */
	case 73:
		switch(ndx) {
		case 0:
			p = "l_osigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sethostname */
	case 74:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_setrlimit */
	case 75:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_rlimit *";
			break;
		default:
			break;
		};
		break;
	/* linux_old_getrlimit */
	case 76:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_rlimit *";
			break;
		default:
			break;
		};
		break;
	/* linux_getrusage */
	case 77:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct l_rusage *";
			break;
		default:
			break;
		};
		break;
	/* linux_gettimeofday */
	case 78:
		switch(ndx) {
		case 0:
			p = "struct l_timeval *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_settimeofday */
	case 79:
		switch(ndx) {
		case 0:
			p = "struct l_timeval *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_getgroups16 */
	case 80:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_setgroups16 */
	case 81:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_old_select */
	case 82:
		switch(ndx) {
		case 0:
			p = "struct l_old_select_argv *";
			break;
		default:
			break;
		};
		break;
	/* linux_symlink */
	case 83:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_lstat */
	case 84:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct linux_lstat *";
			break;
		default:
			break;
		};
		break;
	/* linux_readlink */
	case 85:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* swapon */
	case 87:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_reboot */
	case 88:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_uint";
			break;
		case 3:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_readdir */
	case 89:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_dirent *";
			break;
		case 2:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_mmap */
	case 90:
		switch(ndx) {
		case 0:
			p = "struct l_mmap_argv *";
			break;
		default:
			break;
		};
		break;
	/* munmap */
	case 91:
		switch(ndx) {
		case 0:
			p = "caddr_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_truncate */
	case 92:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_ftruncate */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* fchmod */
	case 94:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchown */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_getpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* setpriority */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_statfs */
	case 99:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_statfs_buf *";
			break;
		default:
			break;
		};
		break;
	/* linux_fstatfs */
	case 100:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_statfs_buf *";
			break;
		default:
			break;
		};
		break;
	/* linux_socketcall */
	case 102:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_syslog */
	case 103:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_setitimer */
	case 104:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "struct l_itimerval *";
			break;
		case 2:
			p = "struct l_itimerval *";
			break;
		default:
			break;
		};
		break;
	/* linux_getitimer */
	case 105:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "struct l_itimerval *";
			break;
		default:
			break;
		};
		break;
	/* linux_newstat */
	case 106:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_newstat *";
			break;
		default:
			break;
		};
		break;
	/* linux_newlstat */
	case 107:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_newstat *";
			break;
		default:
			break;
		};
		break;
	/* linux_newfstat */
	case 108:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_newstat *";
			break;
		default:
			break;
		};
		break;
	/* linux_uname */
	case 109:
		break;
	/* linux_iopl */
	case 110:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_vhangup */
	case 111:
		break;
	/* linux_wait4 */
	case 114:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "l_uint *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "struct l_rusage *";
			break;
		default:
			break;
		};
		break;
	/* linux_swapoff */
	case 115:
		break;
	/* linux_sysinfo */
	case 116:
		switch(ndx) {
		case 0:
			p = "struct l_sysinfo *";
			break;
		default:
			break;
		};
		break;
	/* linux_ipc */
	case 117:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "l_int";
			break;
		case 4:
			p = "void *";
			break;
		case 5:
			p = "l_long";
			break;
		default:
			break;
		};
		break;
	/* fsync */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sigreturn */
	case 119:
		switch(ndx) {
		case 0:
			p = "struct l_sigframe *";
			break;
		default:
			break;
		};
		break;
	/* linux_clone */
	case 120:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_setdomainname */
	case 121:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_newuname */
	case 122:
		switch(ndx) {
		case 0:
			p = "struct l_new_utsname *";
			break;
		default:
			break;
		};
		break;
	/* linux_adjtimex */
	case 124:
		break;
	/* linux_mprotect */
	case 125:
		switch(ndx) {
		case 0:
			p = "caddr_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sigprocmask */
	case 126:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_osigset_t *";
			break;
		case 2:
			p = "l_osigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_create_module */
	case 127:
		break;
	/* linux_init_module */
	case 128:
		break;
	/* linux_delete_module */
	case 129:
		break;
	/* linux_get_kernel_syms */
	case 130:
		break;
	/* linux_quotactl */
	case 131:
		break;
	/* getpgid */
	case 132:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* fchdir */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_bdflush */
	case 134:
		break;
	/* linux_sysfs */
	case 135:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_ulong";
			break;
		case 2:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_personality */
	case 136:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_setfsuid16 */
	case 138:
		switch(ndx) {
		case 0:
			p = "l_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_setfsgid16 */
	case 139:
		switch(ndx) {
		case 0:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_llseek */
	case 140:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_ulong";
			break;
		case 2:
			p = "l_ulong";
			break;
		case 3:
			p = "l_loff_t *";
			break;
		case 4:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_getdents */
	case 141:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_select */
	case 142:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_fd_set *";
			break;
		case 2:
			p = "l_fd_set *";
			break;
		case 3:
			p = "l_fd_set *";
			break;
		case 4:
			p = "struct l_timeval *";
			break;
		default:
			break;
		};
		break;
	/* flock */
	case 143:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_msync */
	case 144:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "l_size_t";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_readv */
	case 145:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "struct l_iovec32 *";
			break;
		case 2:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_writev */
	case 146:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "struct l_iovec32 *";
			break;
		case 2:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_getsid */
	case 147:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_fdatasync */
	case 148:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_sysctl */
	case 149:
		switch(ndx) {
		case 0:
			p = "struct l___sysctl_args *";
			break;
		default:
			break;
		};
		break;
	/* mlock */
	case 150:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* munlock */
	case 151:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* mlockall */
	case 152:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* munlockall */
	case 153:
		break;
	/* sched_setparam */
	case 154:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sched_getparam */
	case 155:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_setscheduler */
	case 156:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "struct l_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_getscheduler */
	case 157:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		default:
			break;
		};
		break;
	/* sched_yield */
	case 158:
		break;
	/* linux_sched_get_priority_max */
	case 159:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_get_priority_min */
	case 160:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_rr_get_interval */
	case 161:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_nanosleep */
	case 162:
		switch(ndx) {
		case 0:
			p = "const struct l_timespec *";
			break;
		case 1:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_mremap */
	case 163:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "l_ulong";
			break;
		case 2:
			p = "l_ulong";
			break;
		case 3:
			p = "l_ulong";
			break;
		case 4:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_setresuid16 */
	case 164:
		switch(ndx) {
		case 0:
			p = "l_uid16_t";
			break;
		case 1:
			p = "l_uid16_t";
			break;
		case 2:
			p = "l_uid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getresuid16 */
	case 165:
		switch(ndx) {
		case 0:
			p = "l_uid16_t *";
			break;
		case 1:
			p = "l_uid16_t *";
			break;
		case 2:
			p = "l_uid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_query_module */
	case 167:
		break;
	/* poll */
	case 168:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_nfsservctl */
	case 169:
		break;
	/* linux_setresgid16 */
	case 170:
		switch(ndx) {
		case 0:
			p = "l_gid16_t";
			break;
		case 1:
			p = "l_gid16_t";
			break;
		case 2:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getresgid16 */
	case 171:
		switch(ndx) {
		case 0:
			p = "l_gid16_t *";
			break;
		case 1:
			p = "l_gid16_t *";
			break;
		case 2:
			p = "l_gid16_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_prctl */
	case 172:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "l_int";
			break;
		case 4:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigreturn */
	case 173:
		switch(ndx) {
		case 0:
			p = "struct l_ucontext *";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigaction */
	case 174:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_sigaction_t *";
			break;
		case 2:
			p = "l_sigaction_t *";
			break;
		case 3:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigprocmask */
	case 175:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_sigset_t *";
			break;
		case 2:
			p = "l_sigset_t *";
			break;
		case 3:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigpending */
	case 176:
		switch(ndx) {
		case 0:
			p = "l_sigset_t *";
			break;
		case 1:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigtimedwait */
	case 177:
		switch(ndx) {
		case 0:
			p = "l_sigset_t *";
			break;
		case 1:
			p = "l_siginfo_t *";
			break;
		case 2:
			p = "struct l_timeval *";
			break;
		case 3:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_rt_sigqueueinfo */
	case 178:
		break;
	/* linux_rt_sigsuspend */
	case 179:
		switch(ndx) {
		case 0:
			p = "l_sigset_t *";
			break;
		case 1:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_pread */
	case 180:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "l_size_t";
			break;
		case 3:
			p = "l_loff_t";
			break;
		default:
			break;
		};
		break;
	/* linux_pwrite */
	case 181:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "l_size_t";
			break;
		case 3:
			p = "l_loff_t";
			break;
		default:
			break;
		};
		break;
	/* linux_chown16 */
	case 182:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_uid16_t";
			break;
		case 2:
			p = "l_gid16_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getcwd */
	case 183:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_capget */
	case 184:
		switch(ndx) {
		case 0:
			p = "struct l_user_cap_header *";
			break;
		case 1:
			p = "struct l_user_cap_data *";
			break;
		default:
			break;
		};
		break;
	/* linux_capset */
	case 185:
		switch(ndx) {
		case 0:
			p = "struct l_user_cap_header *";
			break;
		case 1:
			p = "struct l_user_cap_data *";
			break;
		default:
			break;
		};
		break;
	/* linux_sigaltstack */
	case 186:
		switch(ndx) {
		case 0:
			p = "l_stack_t *";
			break;
		case 1:
			p = "l_stack_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sendfile */
	case 187:
		break;
	/* linux_vfork */
	case 190:
		break;
	/* linux_getrlimit */
	case 191:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "struct l_rlimit *";
			break;
		default:
			break;
		};
		break;
	/* linux_mmap2 */
	case 192:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "l_ulong";
			break;
		case 2:
			p = "l_ulong";
			break;
		case 3:
			p = "l_ulong";
			break;
		case 4:
			p = "l_ulong";
			break;
		case 5:
			p = "l_ulong";
			break;
		default:
			break;
		};
		break;
	/* linux_truncate64 */
	case 193:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_loff_t";
			break;
		default:
			break;
		};
		break;
	/* linux_ftruncate64 */
	case 194:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_loff_t";
			break;
		default:
			break;
		};
		break;
	/* linux_stat64 */
	case 195:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_stat64 *";
			break;
		case 2:
			p = "l_long";
			break;
		default:
			break;
		};
		break;
	/* linux_lstat64 */
	case 196:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_stat64 *";
			break;
		case 2:
			p = "l_long";
			break;
		default:
			break;
		};
		break;
	/* linux_fstat64 */
	case 197:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "struct l_stat64 *";
			break;
		case 2:
			p = "l_long";
			break;
		default:
			break;
		};
		break;
	/* linux_lchown */
	case 198:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_uid_t";
			break;
		case 2:
			p = "l_gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getuid */
	case 199:
		break;
	/* linux_getgid */
	case 200:
		break;
	/* geteuid */
	case 201:
		break;
	/* getegid */
	case 202:
		break;
	/* setreuid */
	case 203:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* setregid */
	case 204:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_getgroups */
	case 205:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_gid_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_setgroups */
	case 206:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "l_gid_t *";
			break;
		default:
			break;
		};
		break;
	/* fchown */
	case 207:
		break;
	/* setresuid */
	case 208:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* getresuid */
	case 209:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		case 1:
			p = "uid_t *";
			break;
		case 2:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* setresgid */
	case 210:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* getresgid */
	case 211:
		switch(ndx) {
		case 0:
			p = "gid_t *";
			break;
		case 1:
			p = "gid_t *";
			break;
		case 2:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_chown */
	case 212:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "l_uid_t";
			break;
		case 2:
			p = "l_gid_t";
			break;
		default:
			break;
		};
		break;
	/* setuid */
	case 213:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* setgid */
	case 214:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_setfsuid */
	case 215:
		switch(ndx) {
		case 0:
			p = "l_uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_setfsgid */
	case 216:
		switch(ndx) {
		case 0:
			p = "l_gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_pivot_root */
	case 217:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_mincore */
	case 218:
		switch(ndx) {
		case 0:
			p = "l_ulong";
			break;
		case 1:
			p = "l_size_t";
			break;
		case 2:
			p = "u_char *";
			break;
		default:
			break;
		};
		break;
	/* madvise */
	case 219:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_getdents64 */
	case 220:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_fcntl64 */
	case 221:
		switch(ndx) {
		case 0:
			p = "l_uint";
			break;
		case 1:
			p = "l_uint";
			break;
		case 2:
			p = "uintptr_t";
			break;
		default:
			break;
		};
		break;
	/* linux_gettid */
	case 224:
		break;
	/* linux_setxattr */
	case 226:
		break;
	/* linux_lsetxattr */
	case 227:
		break;
	/* linux_fsetxattr */
	case 228:
		break;
	/* linux_getxattr */
	case 229:
		break;
	/* linux_lgetxattr */
	case 230:
		break;
	/* linux_fgetxattr */
	case 231:
		break;
	/* linux_listxattr */
	case 232:
		break;
	/* linux_llistxattr */
	case 233:
		break;
	/* linux_flistxattr */
	case 234:
		break;
	/* linux_removexattr */
	case 235:
		break;
	/* linux_lremovexattr */
	case 236:
		break;
	/* linux_fremovexattr */
	case 237:
		break;
	/* linux_tkill */
	case 238:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_futex */
	case 240:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "uint32_t";
			break;
		case 3:
			p = "struct l_timespec *";
			break;
		case 4:
			p = "uint32_t *";
			break;
		case 5:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_setaffinity */
	case 241:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "l_uint";
			break;
		case 2:
			p = "l_ulong *";
			break;
		default:
			break;
		};
		break;
	/* linux_sched_getaffinity */
	case 242:
		switch(ndx) {
		case 0:
			p = "l_pid_t";
			break;
		case 1:
			p = "l_uint";
			break;
		case 2:
			p = "l_ulong *";
			break;
		default:
			break;
		};
		break;
	/* linux_set_thread_area */
	case 243:
		switch(ndx) {
		case 0:
			p = "struct l_user_desc *";
			break;
		default:
			break;
		};
		break;
	/* linux_fadvise64 */
	case 250:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "l_loff_t";
			break;
		case 2:
			p = "l_size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_exit_group */
	case 252:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_lookup_dcookie */
	case 253:
		break;
	/* linux_epoll_create */
	case 254:
		break;
	/* linux_epoll_ctl */
	case 255:
		break;
	/* linux_epoll_wait */
	case 256:
		break;
	/* linux_remap_file_pages */
	case 257:
		break;
	/* linux_set_tid_address */
	case 258:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_timer_create */
	case 259:
		break;
	/* linux_timer_settime */
	case 260:
		break;
	/* linux_timer_gettime */
	case 261:
		break;
	/* linux_timer_getoverrun */
	case 262:
		break;
	/* linux_timer_delete */
	case 263:
		break;
	/* linux_clock_settime */
	case 264:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_clock_gettime */
	case 265:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_clock_getres */
	case 266:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_clock_nanosleep */
	case 267:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct l_timespec *";
			break;
		case 3:
			p = "struct l_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_statfs64 */
	case 268:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct l_statfs64_buf *";
			break;
		default:
			break;
		};
		break;
	/* linux_fstatfs64 */
	case 269:
		break;
	/* linux_tgkill */
	case 270:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_utimes */
	case 271:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "struct l_timeval *";
			break;
		default:
			break;
		};
		break;
	/* linux_fadvise64_64 */
	case 272:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "l_loff_t";
			break;
		case 2:
			p = "l_loff_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_mbind */
	case 274:
		break;
	/* linux_get_mempolicy */
	case 275:
		break;
	/* linux_set_mempolicy */
	case 276:
		break;
	/* linux_mq_open */
	case 277:
		break;
	/* linux_mq_unlink */
	case 278:
		break;
	/* linux_mq_timedsend */
	case 279:
		break;
	/* linux_mq_timedreceive */
	case 280:
		break;
	/* linux_mq_notify */
	case 281:
		break;
	/* linux_mq_getsetattr */
	case 282:
		break;
	/* linux_kexec_load */
	case 283:
		break;
	/* linux_waitid */
	case 284:
		break;
	/* linux_add_key */
	case 286:
		break;
	/* linux_request_key */
	case 287:
		break;
	/* linux_keyctl */
	case 288:
		break;
	/* linux_ioprio_set */
	case 289:
		break;
	/* linux_ioprio_get */
	case 290:
		break;
	/* linux_inotify_init */
	case 291:
		break;
	/* linux_inotify_add_watch */
	case 292:
		break;
	/* linux_inotify_rm_watch */
	case 293:
		break;
	/* linux_migrate_pages */
	case 294:
		break;
	/* linux_openat */
	case 295:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_mkdirat */
	case 296:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_mknodat */
	case 297:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "l_uint";
			break;
		default:
			break;
		};
		break;
	/* linux_fchownat */
	case 298:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_uid16_t";
			break;
		case 3:
			p = "l_gid16_t";
			break;
		case 4:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_futimesat */
	case 299:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "struct l_timeval *";
			break;
		default:
			break;
		};
		break;
	/* linux_fstatat64 */
	case 300:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "struct l_stat64 *";
			break;
		case 3:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_unlinkat */
	case 301:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_renameat */
	case 302:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_linkat */
	case 303:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "const char *";
			break;
		case 4:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_symlinkat */
	case 304:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "l_int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_readlinkat */
	case 305:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "l_int";
			break;
		default:
			break;
		};
		break;
	/* linux_fchmodat */
	case 306:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_mode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_faccessat */
	case 307:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "l_int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_pselect6 */
	case 308:
		break;
	/* linux_ppoll */
	case 309:
		break;
	/* linux_unshare */
	case 310:
		break;
	/* linux_set_robust_list */
	case 311:
		switch(ndx) {
		case 0:
			p = "struct linux_robust_list_head *";
			break;
		case 1:
			p = "l_size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_get_robust_list */
	case 312:
		switch(ndx) {
		case 0:
			p = "l_int";
			break;
		case 1:
			p = "struct linux_robust_list_head *";
			break;
		case 2:
			p = "l_size_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_splice */
	case 313:
		break;
	/* linux_sync_file_range */
	case 314:
		break;
	/* linux_tee */
	case 315:
		break;
	/* linux_vmsplice */
	case 316:
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
#define	nosys	linux_nosys
	/* sys_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* linux_fork */
	case 2:
	/* read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_waitpid */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_creat */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_execve */
	case 11:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_time */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lchown16 */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_stat */
	case 18:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lseek */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getpid */
	case 20:
	/* linux_mount */
	case 21:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_oldumount */
	case 22:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setuid16 */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getuid16 */
	case 24:
	/* linux_stime */
	case 25:
	/* linux_ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_alarm */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pause */
	case 29:
	/* linux_utime */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_nice */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sync */
	case 36:
	/* linux_kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rename */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mkdir */
	case 39:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rmdir */
	case 40:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pipe */
	case 42:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_times */
	case 43:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_brk */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setgid16 */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getgid16 */
	case 47:
	/* linux_signal */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_geteuid16 */
	case 49:
	/* linux_getegid16 */
	case 50:
	/* acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_umount */
	case 52:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fcntl */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setpgid */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_olduname */
	case 59:
	/* umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_ustat */
	case 62:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* dup2 */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getppid */
	case 64:
	/* getpgrp */
	case 65:
	/* setsid */
	case 66:
	/* linux_sigaction */
	case 67:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sgetmask */
	case 68:
	/* linux_ssetmask */
	case 69:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setreuid16 */
	case 70:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setregid16 */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sigsuspend */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sigpending */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sethostname */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setrlimit */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_old_getrlimit */
	case 76:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getrusage */
	case 77:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_gettimeofday */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_settimeofday */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getgroups16 */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setgroups16 */
	case 81:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_old_select */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_symlink */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lstat */
	case 84:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_readlink */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* swapon */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_reboot */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_readdir */
	case 89:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mmap */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munmap */
	case 91:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_truncate */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_ftruncate */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchmod */
	case 94:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchown */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setpriority */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_statfs */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fstatfs */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_socketcall */
	case 102:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_syslog */
	case 103:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setitimer */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getitimer */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_newstat */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_newlstat */
	case 107:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_newfstat */
	case 108:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_uname */
	case 109:
	/* linux_iopl */
	case 110:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_vhangup */
	case 111:
	/* linux_wait4 */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_swapoff */
	case 115:
	/* linux_sysinfo */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_ipc */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fsync */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sigreturn */
	case 119:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_clone */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setdomainname */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_newuname */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_adjtimex */
	case 124:
	/* linux_mprotect */
	case 125:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sigprocmask */
	case 126:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_create_module */
	case 127:
	/* linux_init_module */
	case 128:
	/* linux_delete_module */
	case 129:
	/* linux_get_kernel_syms */
	case 130:
	/* linux_quotactl */
	case 131:
	/* getpgid */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchdir */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_bdflush */
	case 134:
	/* linux_sysfs */
	case 135:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_personality */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setfsuid16 */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setfsgid16 */
	case 139:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_llseek */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getdents */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_select */
	case 142:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* flock */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_msync */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_readv */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_writev */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getsid */
	case 147:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fdatasync */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sysctl */
	case 149:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mlock */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munlock */
	case 151:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* mlockall */
	case 152:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* munlockall */
	case 153:
	/* sched_setparam */
	case 154:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_getparam */
	case 155:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_setscheduler */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_getscheduler */
	case 157:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sched_yield */
	case 158:
	/* linux_sched_get_priority_max */
	case 159:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_get_priority_min */
	case 160:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_rr_get_interval */
	case 161:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_nanosleep */
	case 162:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mremap */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setresuid16 */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getresuid16 */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_query_module */
	case 167:
	/* poll */
	case 168:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_nfsservctl */
	case 169:
	/* linux_setresgid16 */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getresgid16 */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_prctl */
	case 172:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigreturn */
	case 173:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigaction */
	case 174:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigprocmask */
	case 175:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigpending */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigtimedwait */
	case 177:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_rt_sigqueueinfo */
	case 178:
	/* linux_rt_sigsuspend */
	case 179:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pread */
	case 180:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pwrite */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_chown16 */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getcwd */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_capget */
	case 184:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_capset */
	case 185:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sigaltstack */
	case 186:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sendfile */
	case 187:
	/* linux_vfork */
	case 190:
	/* linux_getrlimit */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mmap2 */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_truncate64 */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_ftruncate64 */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_stat64 */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lstat64 */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fstat64 */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lchown */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getuid */
	case 199:
	/* linux_getgid */
	case 200:
	/* geteuid */
	case 201:
	/* getegid */
	case 202:
	/* setreuid */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setregid */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getgroups */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setgroups */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* fchown */
	case 207:
	/* setresuid */
	case 208:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getresuid */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setresgid */
	case 210:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* getresgid */
	case 211:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_chown */
	case 212:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setuid */
	case 213:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* setgid */
	case 214:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setfsuid */
	case 215:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_setfsgid */
	case 216:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pivot_root */
	case 217:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mincore */
	case 218:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* madvise */
	case 219:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_getdents64 */
	case 220:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fcntl64 */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_gettid */
	case 224:
	/* linux_setxattr */
	case 226:
	/* linux_lsetxattr */
	case 227:
	/* linux_fsetxattr */
	case 228:
	/* linux_getxattr */
	case 229:
	/* linux_lgetxattr */
	case 230:
	/* linux_fgetxattr */
	case 231:
	/* linux_listxattr */
	case 232:
	/* linux_llistxattr */
	case 233:
	/* linux_flistxattr */
	case 234:
	/* linux_removexattr */
	case 235:
	/* linux_lremovexattr */
	case 236:
	/* linux_fremovexattr */
	case 237:
	/* linux_tkill */
	case 238:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_futex */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_setaffinity */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sched_getaffinity */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_set_thread_area */
	case 243:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fadvise64 */
	case 250:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_exit_group */
	case 252:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_lookup_dcookie */
	case 253:
	/* linux_epoll_create */
	case 254:
	/* linux_epoll_ctl */
	case 255:
	/* linux_epoll_wait */
	case 256:
	/* linux_remap_file_pages */
	case 257:
	/* linux_set_tid_address */
	case 258:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_timer_create */
	case 259:
	/* linux_timer_settime */
	case 260:
	/* linux_timer_gettime */
	case 261:
	/* linux_timer_getoverrun */
	case 262:
	/* linux_timer_delete */
	case 263:
	/* linux_clock_settime */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_clock_gettime */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_clock_getres */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_clock_nanosleep */
	case 267:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_statfs64 */
	case 268:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fstatfs64 */
	case 269:
	/* linux_tgkill */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_utimes */
	case 271:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fadvise64_64 */
	case 272:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mbind */
	case 274:
	/* linux_get_mempolicy */
	case 275:
	/* linux_set_mempolicy */
	case 276:
	/* linux_mq_open */
	case 277:
	/* linux_mq_unlink */
	case 278:
	/* linux_mq_timedsend */
	case 279:
	/* linux_mq_timedreceive */
	case 280:
	/* linux_mq_notify */
	case 281:
	/* linux_mq_getsetattr */
	case 282:
	/* linux_kexec_load */
	case 283:
	/* linux_waitid */
	case 284:
	/* linux_add_key */
	case 286:
	/* linux_request_key */
	case 287:
	/* linux_keyctl */
	case 288:
	/* linux_ioprio_set */
	case 289:
	/* linux_ioprio_get */
	case 290:
	/* linux_inotify_init */
	case 291:
	/* linux_inotify_add_watch */
	case 292:
	/* linux_inotify_rm_watch */
	case 293:
	/* linux_migrate_pages */
	case 294:
	/* linux_openat */
	case 295:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mkdirat */
	case 296:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_mknodat */
	case 297:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fchownat */
	case 298:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_futimesat */
	case 299:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fstatat64 */
	case 300:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_unlinkat */
	case 301:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_renameat */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_linkat */
	case 303:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_symlinkat */
	case 304:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_readlinkat */
	case 305:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_fchmodat */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_faccessat */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_pselect6 */
	case 308:
	/* linux_ppoll */
	case 309:
	/* linux_unshare */
	case 310:
	/* linux_set_robust_list */
	case 311:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_get_robust_list */
	case 312:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_splice */
	case 313:
	/* linux_sync_file_range */
	case 314:
	/* linux_tee */
	case 315:
	/* linux_vmsplice */
	case 316:
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
