/*-
 * Copyright 2007-2010 Solarflare Communications Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	_SYS_EFX_EF10_REGS_H
#define	_SYS_EFX_EF10_REGS_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * BIU_HW_REV_ID_REG(32bit):
 * 
 */

#define	ER_DZ_BIU_HW_REV_ID_REG 0x00000000
/* hunta0=pcie_pf_bar2 */

#define	ERF_DZ_HW_REV_ID_LBN 0
#define	ERF_DZ_HW_REV_ID_WIDTH 32


/*
 * BIU_MC_SFT_STATUS_REG(32bit):
 * 
 */

#define	ER_DZ_BIU_MC_SFT_STATUS_REG 0x00000010
/* hunta0=pcie_pf_bar2 */
#define	ER_DZ_BIU_MC_SFT_STATUS_REG_STEP 4
#define	ER_DZ_BIU_MC_SFT_STATUS_REG_ROWS 8

#define	ERF_DZ_MC_SFT_STATUS_LBN 0
#define	ERF_DZ_MC_SFT_STATUS_WIDTH 32


/*
 * BIU_INT_ISR_REG(32bit):
 * 
 */

#define	ER_DZ_BIU_INT_ISR_REG 0x00000090
/* hunta0=pcie_pf_bar2 */

#define	ERF_DZ_ISR_REG_LBN 0
#define	ERF_DZ_ISR_REG_WIDTH 32


/*
 * MC_DB_LWRD_REG(32bit):
 * 
 */

#define	ER_DZ_MC_DB_LWRD_REG 0x00000200
/* hunta0=pcie_pf_bar2 */

#define	ERF_DZ_MC_DOORBELL_L_LBN 0
#define	ERF_DZ_MC_DOORBELL_L_WIDTH 32


/*
 * MC_DB_HWRD_REG(32bit):
 * 
 */

#define	ER_DZ_MC_DB_HWRD_REG 0x00000204
/* hunta0=pcie_pf_bar2 */

#define	ERF_DZ_MC_DOORBELL_H_LBN 0
#define	ERF_DZ_MC_DOORBELL_H_WIDTH 32


/*
 * EVQ_RPTR_REG(32bit):
 * 
 */

#define	ER_DZ_EVQ_RPTR_REG 0x00000400
/* hunta0=pcie_pf_bar2 */
#define	ER_DZ_EVQ_RPTR_REG_STEP 4096
#define	ER_DZ_EVQ_RPTR_REG_ROWS 2048

#define	ERF_DZ_EVQ_RPTR_VLD_LBN 15
#define	ERF_DZ_EVQ_RPTR_VLD_WIDTH 1
#define	ERF_DZ_EVQ_RPTR_LBN 0
#define	ERF_DZ_EVQ_RPTR_WIDTH 15


/*
 * EVQ_TMR_REG(32bit):
 * 
 */

#define	ER_DZ_EVQ_TMR_REG 0x00000420
/* hunta0=pcie_pf_bar2 */
#define	ER_DZ_EVQ_TMR_REG_STEP 4096
#define	ER_DZ_EVQ_TMR_REG_ROWS 2048

#define	ERF_DZ_TC_TIMER_MODE_LBN 14
#define	ERF_DZ_TC_TIMER_MODE_WIDTH 2
#define	ERF_DZ_TC_TIMER_VAL_LBN 0
#define	ERF_DZ_TC_TIMER_VAL_WIDTH 14


/*
 * RX_DESC_UPD_REG(32bit):
 * 
 */

#define	ER_DZ_RX_DESC_UPD_REG 0x00000830
/* hunta0=pcie_pf_bar2 */
#define	ER_DZ_RX_DESC_UPD_REG_STEP 4096
#define	ER_DZ_RX_DESC_UPD_REG_ROWS 2048

#define	ERF_DZ_RX_DESC_WPTR_LBN 0
#define	ERF_DZ_RX_DESC_WPTR_WIDTH 12


/*
 * TX_DESC_UPD_REG(76bit):
 * 
 */

#define	ER_DZ_TX_DESC_UPD_REG 0x00000a10
/* hunta0=pcie_pf_bar2 */
#define	ER_DZ_TX_DESC_UPD_REG_STEP 4096
#define	ER_DZ_TX_DESC_UPD_REG_ROWS 2048

#define	ERF_DZ_TX_DESC_WPTR_LBN 64
#define	ERF_DZ_TX_DESC_WPTR_WIDTH 12
#define	ERF_DZ_TX_DESC_HWORD_LBN 32
#define	ERF_DZ_TX_DESC_HWORD_WIDTH 32
#define	ERF_DZ_TX_DESC_LWORD_LBN 0
#define	ERF_DZ_TX_DESC_LWORD_WIDTH 32


/* ES_DRIVER_EV */
#define	ESF_DZ_DRV_CODE_LBN 60
#define	ESF_DZ_DRV_CODE_WIDTH 4
#define	ESF_DZ_DRV_SUB_CODE_LBN 56
#define	ESF_DZ_DRV_SUB_CODE_WIDTH 4
#define	ESE_DZ_DRV_TIMER_EV 10
#define	ESE_DZ_DRV_WAKE_UP_EV 6
#define	ESF_DZ_DRV_SUB_DATA_DW0_LBN 0
#define	ESF_DZ_DRV_SUB_DATA_DW0_WIDTH 32
#define	ESF_DZ_DRV_SUB_DATA_DW1_LBN 32
#define	ESF_DZ_DRV_SUB_DATA_DW1_WIDTH 24
#define	ESF_DZ_DRV_SUB_DATA_LBN 0
#define	ESF_DZ_DRV_SUB_DATA_WIDTH 56
#define	ESF_DZ_DRV_EVQ_ID_LBN 0
#define	ESF_DZ_DRV_EVQ_ID_WIDTH 14
#define	ESF_DZ_DRV_TMR_ID_LBN 0
#define	ESF_DZ_DRV_TMR_ID_WIDTH 14


/* ES_EVENT_ENTRY */
#define	ESF_DZ_EV_CODE_LBN 60
#define	ESF_DZ_EV_CODE_WIDTH 4
#define	ESE_DZ_EV_CODE_MCDI_EV 12
#define	ESE_DZ_EV_CODE_DRIVER_EV 5
#define	ESE_DZ_EV_CODE_TX_EV 2
#define	ESE_DZ_EV_CODE_RX_EV 0
#define	ESE_DZ_OTHER other
#define	ESF_DZ_EV_DATA_DW0_LBN 0
#define	ESF_DZ_EV_DATA_DW0_WIDTH 32
#define	ESF_DZ_EV_DATA_DW1_LBN 32
#define	ESF_DZ_EV_DATA_DW1_WIDTH 28
#define	ESF_DZ_EV_DATA_LBN 0
#define	ESF_DZ_EV_DATA_WIDTH 60


/* ES_FF_UMSG_CPU2DL_DESC_FETCH */
#define	ESF_DZ_C2DDF_DSCR_CACHE_RPTR_LBN 112
#define	ESF_DZ_C2DDF_DSCR_CACHE_RPTR_WIDTH 6
#define	ESF_DZ_C2DDF_QID_LBN 96
#define	ESF_DZ_C2DDF_QID_WIDTH 11
#define	ESF_DZ_C2DDF_DSCR_BASE_PAGE_ID_LBN 64
#define	ESF_DZ_C2DDF_DSCR_BASE_PAGE_ID_WIDTH 18
#define	ESF_DZ_C2DDF_DSCR_HW_RPTR_LBN 48
#define	ESF_DZ_C2DDF_DSCR_HW_RPTR_WIDTH 12
#define	ESF_DZ_C2DDF_DSCR_HW_WPTR_LBN 32
#define	ESF_DZ_C2DDF_DSCR_HW_WPTR_WIDTH 12
#define	ESF_DZ_C2DDF_OID_LBN 16
#define	ESF_DZ_C2DDF_OID_WIDTH 12
#define	ESF_DZ_C2DDF_DSCR_SIZE_LBN 13
#define	ESF_DZ_C2DDF_DSCR_SIZE_WIDTH 3
#define	ESE_DZ_C2DDF_DSCR_SIZE_512 7
#define	ESE_DZ_C2DDF_DSCR_SIZE_1K 6
#define	ESE_DZ_C2DDF_DSCR_SIZE_2K 5
#define	ESE_DZ_C2DDF_DSCR_SIZE_4K 4
#define	ESF_DZ_C2DDF_BIU_ARGS_LBN 0
#define	ESF_DZ_C2DDF_BIU_ARGS_WIDTH 13


/* ES_FF_UMSG_CPU2DL_DESC_PUSH */
#define	ESF_DZ_C2DDP_DESC_DW0_LBN 128
#define	ESF_DZ_C2DDP_DESC_DW0_WIDTH 32
#define	ESF_DZ_C2DDP_DESC_DW1_LBN 160
#define	ESF_DZ_C2DDP_DESC_DW1_WIDTH 32
#define	ESF_DZ_C2DDP_DESC_LBN 128
#define	ESF_DZ_C2DDP_DESC_WIDTH 64
#define	ESF_DZ_C2DDP_QID_LBN 96
#define	ESF_DZ_C2DDP_QID_WIDTH 11
#define	ESF_DZ_C2DDP_DSCR_HW_RPTR_LBN 48
#define	ESF_DZ_C2DDP_DSCR_HW_RPTR_WIDTH 12
#define	ESF_DZ_C2DDP_DSCR_HW_WPTR_LBN 32
#define	ESF_DZ_C2DDP_DSCR_HW_WPTR_WIDTH 12
#define	ESF_DZ_C2DDP_OID_LBN 16
#define	ESF_DZ_C2DDP_OID_WIDTH 12
#define	ESF_DZ_C2DDP_DSCR_SIZE_LBN 0
#define	ESF_DZ_C2DDP_DSCR_SIZE_WIDTH 3
#define	ESE_DZ_C2DDF_DSCR_SIZE_512 7
#define	ESE_DZ_C2DDF_DSCR_SIZE_1K 6
#define	ESE_DZ_C2DDF_DSCR_SIZE_2K 5
#define	ESE_DZ_C2DDF_DSCR_SIZE_4K 4


/* ES_FF_UMSG_CPU2DL_GPRD */
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_DW0_LBN 64
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_DW1_LBN 96
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_LBN 64
#define	ESF_DZ_C2DG_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_C2DG_SMC_ADDR_LBN 16
#define	ESF_DZ_C2DG_SMC_ADDR_WIDTH 16
#define	ESF_DZ_C2DG_BIU_ARGS_LBN 0
#define	ESF_DZ_C2DG_BIU_ARGS_WIDTH 14


/* ES_FF_UMSG_CPU2EV_SOFT */
#define	ESF_DZ_C2ES_TBD_LBN 0
#define	ESF_DZ_C2ES_TBD_WIDTH 1


/* ES_FF_UMSG_CPU2EV_TXCMPLT */
#define	ESF_DZ_C2ET_EV_SOFT0_LBN 32
#define	ESF_DZ_C2ET_EV_SOFT0_WIDTH 16
#define	ESF_DZ_C2ET_DSCR_IDX_LBN 16
#define	ESF_DZ_C2ET_DSCR_IDX_WIDTH 16
#define	ESF_DZ_C2ET_EV_QID_LBN 5
#define	ESF_DZ_C2ET_EV_QID_WIDTH 11
#define	ESF_DZ_C2ET_EV_QLABEL_LBN 0
#define	ESF_DZ_C2ET_EV_QLABEL_WIDTH 5


/* ES_FF_UMSG_CPU2RXDP_INGR_BUFOP */
#define	ESF_DZ_C2RIB_EV_DISABLE_LBN 191
#define	ESF_DZ_C2RIB_EV_DISABLE_WIDTH 1
#define	ESF_DZ_C2RIB_EV_SOFT_LBN 188
#define	ESF_DZ_C2RIB_EV_SOFT_WIDTH 3
#define	ESF_DZ_C2RIB_EV_DESC_PTR_LBN 176
#define	ESF_DZ_C2RIB_EV_DESC_PTR_WIDTH 12
#define	ESF_DZ_C2RIB_EV_ARG1_LBN 160
#define	ESF_DZ_C2RIB_EV_ARG1_WIDTH 16
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_DW0_LBN 64
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_DW1_LBN 96
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_LBN 64
#define	ESF_DZ_C2RIB_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_C2RIB_BIU_ARGS_LBN 16
#define	ESF_DZ_C2RIB_BIU_ARGS_WIDTH 13
#define	ESF_DZ_C2RIB_EV_QID_LBN 5
#define	ESF_DZ_C2RIB_EV_QID_WIDTH 11
#define	ESF_DZ_C2RIB_EV_QLABEL_LBN 0
#define	ESF_DZ_C2RIB_EV_QLABEL_WIDTH 5


/* ES_FF_UMSG_CPU2RXDP_INGR_PDISP */
#define	ESF_DZ_C2RIP_BUF_LEN_LBN 240
#define	ESF_DZ_C2RIP_BUF_LEN_WIDTH 16
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_DW0_LBN 192
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_DW1_LBN 224
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_LBN 192
#define	ESF_DZ_C2RIP_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_C2RIP_EV_DISABLE_LBN 191
#define	ESF_DZ_C2RIP_EV_DISABLE_WIDTH 1
#define	ESF_DZ_C2RIP_EV_SOFT_LBN 188
#define	ESF_DZ_C2RIP_EV_SOFT_WIDTH 3
#define	ESF_DZ_C2RIP_EV_DESC_PTR_LBN 176
#define	ESF_DZ_C2RIP_EV_DESC_PTR_WIDTH 12
#define	ESF_DZ_C2RIP_EV_ARG1_LBN 160
#define	ESF_DZ_C2RIP_EV_ARG1_WIDTH 16
#define	ESF_DZ_C2RIP_UPD_CRC_MODE_LBN 157
#define	ESF_DZ_C2RIP_UPD_CRC_MODE_WIDTH 3
#define	ESE_DZ_C2RIP_FCOIP_MPA 5
#define	ESE_DZ_C2RIP_FCOIP_FCOE 4
#define	ESE_DZ_C2RIP_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_C2RIP_ISCSI_HDR 2
#define	ESE_DZ_C2RIP_FCOE 1
#define	ESE_DZ_C2RIP_OFF 0
#define	ESF_DZ_C2RIP_BIU_ARGS_LBN 144
#define	ESF_DZ_C2RIP_BIU_ARGS_WIDTH 13
#define	ESF_DZ_C2RIP_EV_QID_LBN 133
#define	ESF_DZ_C2RIP_EV_QID_WIDTH 11
#define	ESF_DZ_C2RIP_EV_QLABEL_LBN 128
#define	ESF_DZ_C2RIP_EV_QLABEL_WIDTH 5
#define	ESF_DZ_C2RIP_PEDIT_DELTA_LBN 104
#define	ESF_DZ_C2RIP_PEDIT_DELTA_WIDTH 8
#define	ESF_DZ_C2RIP_PYLOAD_OFST_LBN 96
#define	ESF_DZ_C2RIP_PYLOAD_OFST_WIDTH 8
#define	ESF_DZ_C2RIP_L4_HDR_OFST_LBN 88
#define	ESF_DZ_C2RIP_L4_HDR_OFST_WIDTH 8
#define	ESF_DZ_C2RIP_L3_HDR_OFST_LBN 80
#define	ESF_DZ_C2RIP_L3_HDR_OFST_WIDTH 8
#define	ESF_DZ_C2RIP_IS_UDP_LBN 69
#define	ESF_DZ_C2RIP_IS_UDP_WIDTH 1
#define	ESF_DZ_C2RIP_IS_TCP_LBN 68
#define	ESF_DZ_C2RIP_IS_TCP_WIDTH 1
#define	ESF_DZ_C2RIP_IS_IPV6_LBN 67
#define	ESF_DZ_C2RIP_IS_IPV6_WIDTH 1
#define	ESF_DZ_C2RIP_IS_IPV4_LBN 66
#define	ESF_DZ_C2RIP_IS_IPV4_WIDTH 1
#define	ESF_DZ_C2RIP_IS_FCOE_LBN 65
#define	ESF_DZ_C2RIP_IS_FCOE_WIDTH 1
#define	ESF_DZ_C2RIP_PARSE_INCOMP_LBN 64
#define	ESF_DZ_C2RIP_PARSE_INCOMP_WIDTH 1
#define	ESF_DZ_C2RIP_FINFO_WRD3_LBN 48
#define	ESF_DZ_C2RIP_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_C2RIP_FINFO_WRD2_LBN 32
#define	ESF_DZ_C2RIP_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_C2RIP_FINFO_WRD1_LBN 16
#define	ESF_DZ_C2RIP_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_C2RIP_FINFO_SRCDST_LBN 0
#define	ESF_DZ_C2RIP_FINFO_SRCDST_WIDTH 16


/* ES_FF_UMSG_CPU2RXDP_INGR_SOFT */
#define	ESF_DZ_C2RIS_SOFT3_LBN 48
#define	ESF_DZ_C2RIS_SOFT3_WIDTH 16
#define	ESF_DZ_C2RIS_SOFT2_LBN 32
#define	ESF_DZ_C2RIS_SOFT2_WIDTH 16
#define	ESF_DZ_C2RIS_SOFT1_LBN 16
#define	ESF_DZ_C2RIS_SOFT1_WIDTH 16
#define	ESF_DZ_C2RIS_SOFT0_LBN 0
#define	ESF_DZ_C2RIS_SOFT0_WIDTH 16


/* ES_FF_UMSG_CPU2SMC_BUFLKUP */
#define	ESF_DZ_C2SB_PAGE_ID_LBN 16
#define	ESF_DZ_C2SB_PAGE_ID_WIDTH 18
#define	ESF_DZ_C2SB_EXP_PAGE_ID_LBN 0
#define	ESF_DZ_C2SB_EXP_PAGE_ID_WIDTH 12


/* ES_FF_UMSG_CPU2SMC_DESCOP */
#define	ESF_DZ_C2SD_LEN_LBN 112
#define	ESF_DZ_C2SD_LEN_WIDTH 14
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_DW0_LBN 64
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_DW1_LBN 96
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_LBN 64
#define	ESF_DZ_C2SD_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_C2SD_OFFSET_LBN 48
#define	ESF_DZ_C2SD_OFFSET_WIDTH 8
#define	ESF_DZ_C2SD_QID_LBN 32
#define	ESF_DZ_C2SD_QID_WIDTH 11
#define	ESF_DZ_C2SD_CONT_LBN 16
#define	ESF_DZ_C2SD_CONT_WIDTH 1
#define	ESF_DZ_C2SD_TYPE_LBN 0
#define	ESF_DZ_C2SD_TYPE_WIDTH 1


/* ES_FF_UMSG_CPU2SMC_GPOP */
#define	ESF_DZ_C2SG_DATA_DW0_LBN 64
#define	ESF_DZ_C2SG_DATA_DW0_WIDTH 32
#define	ESF_DZ_C2SG_DATA_DW1_LBN 96
#define	ESF_DZ_C2SG_DATA_DW1_WIDTH 32
#define	ESF_DZ_C2SG_DATA_LBN 64
#define	ESF_DZ_C2SG_DATA_WIDTH 64
#define	ESF_DZ_C2SG_SOFT_LBN 48
#define	ESF_DZ_C2SG_SOFT_WIDTH 4
#define	ESF_DZ_C2SG_REFLECT_LBN 32
#define	ESF_DZ_C2SG_REFLECT_WIDTH 1
#define	ESF_DZ_C2SG_ADDR_LBN 0
#define	ESF_DZ_C2SG_ADDR_WIDTH 16


/* ES_FF_UMSG_CPU2TXDP_DMA_BUFREQ */
#define	ESF_DZ_C2TDB_BUF_LEN_LBN 176
#define	ESF_DZ_C2TDB_BUF_LEN_WIDTH 16
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_DW0_LBN 128
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_DW1_LBN 160
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_LBN 128
#define	ESF_DZ_C2TDB_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_C2TDB_SOFT_LBN 112
#define	ESF_DZ_C2TDB_SOFT_WIDTH 14
#define	ESF_DZ_C2TDB_DESC_IDX_LBN 96
#define	ESF_DZ_C2TDB_DESC_IDX_WIDTH 16
#define	ESF_DZ_C2TDB_UPD_CRC_MODE_LBN 93
#define	ESF_DZ_C2TDB_UPD_CRC_MODE_WIDTH 3
#define	ESE_DZ_C2RIP_FCOIP_MPA 5
#define	ESE_DZ_C2RIP_FCOIP_FCOE 4
#define	ESE_DZ_C2RIP_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_C2RIP_ISCSI_HDR 2
#define	ESE_DZ_C2RIP_FCOE 1
#define	ESE_DZ_C2RIP_OFF 0
#define	ESF_DZ_C2TDB_BIU_ARGS_LBN 80
#define	ESF_DZ_C2TDB_BIU_ARGS_WIDTH 13
#define	ESF_DZ_C2TDB_CONT_LBN 64
#define	ESF_DZ_C2TDB_CONT_WIDTH 1
#define	ESF_DZ_C2TDB_FINFO_WRD3_LBN 48
#define	ESF_DZ_C2TDB_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_C2TDB_FINFO_WRD2_LBN 32
#define	ESF_DZ_C2TDB_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_C2TDB_FINFO_WRD1_LBN 16
#define	ESF_DZ_C2TDB_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_C2TDB_FINFO_SRCDST_LBN 0
#define	ESF_DZ_C2TDB_FINFO_SRCDST_WIDTH 16


/* ES_FF_UMSG_CPU2TXDP_DMA_PKTABORT */
#define	ESF_DZ_C2TDP_SOFT_LBN 48
#define	ESF_DZ_C2TDP_SOFT_WIDTH 14
#define	ESF_DZ_C2TDP_DESC_IDX_LBN 32
#define	ESF_DZ_C2TDP_DESC_IDX_WIDTH 16
#define	ESF_DZ_C2TDP_BIU_ARGS_LBN 16
#define	ESF_DZ_C2TDP_BIU_ARGS_WIDTH 14


/* ES_FF_UMSG_CPU2TXDP_DMA_SOFT */
#define	ESF_DZ_C2TDS_SOFT3_LBN 48
#define	ESF_DZ_C2TDS_SOFT3_WIDTH 16
#define	ESF_DZ_C2TDS_SOFT2_LBN 32
#define	ESF_DZ_C2TDS_SOFT2_WIDTH 16
#define	ESF_DZ_C2TDS_SOFT1_LBN 16
#define	ESF_DZ_C2TDS_SOFT1_WIDTH 16
#define	ESF_DZ_C2TDS_SOFT0_LBN 0
#define	ESF_DZ_C2TDS_SOFT0_WIDTH 16


/* ES_FF_UMSG_CPU2TXDP_EGR */
#define	ESF_DZ_C2TE_PEDIT_DELTA_LBN 168
#define	ESF_DZ_C2TE_PEDIT_DELTA_WIDTH 8
#define	ESF_DZ_C2TE_PYLOAD_OFST_LBN 160
#define	ESF_DZ_C2TE_PYLOAD_OFST_WIDTH 8
#define	ESF_DZ_C2TE_L4_HDR_OFST_LBN 152
#define	ESF_DZ_C2TE_L4_HDR_OFST_WIDTH 8
#define	ESF_DZ_C2TE_L3_HDR_OFST_LBN 144
#define	ESF_DZ_C2TE_L3_HDR_OFST_WIDTH 8
#define	ESF_DZ_C2TE_IS_UDP_LBN 133
#define	ESF_DZ_C2TE_IS_UDP_WIDTH 1
#define	ESF_DZ_C2TE_IS_TCP_LBN 132
#define	ESF_DZ_C2TE_IS_TCP_WIDTH 1
#define	ESF_DZ_C2TE_IS_IPV6_LBN 131
#define	ESF_DZ_C2TE_IS_IPV6_WIDTH 1
#define	ESF_DZ_C2TE_IS_IPV4_LBN 130
#define	ESF_DZ_C2TE_IS_IPV4_WIDTH 1
#define	ESF_DZ_C2TE_IS_FCOE_LBN 129
#define	ESF_DZ_C2TE_IS_FCOE_WIDTH 1
#define	ESF_DZ_C2TE_PARSE_INCOMP_LBN 128
#define	ESF_DZ_C2TE_PARSE_INCOMP_WIDTH 1
#define	ESF_DZ_C2TE_PKT_LEN_LBN 112
#define	ESF_DZ_C2TE_PKT_LEN_WIDTH 16
#define	ESF_DZ_C2TE_UPD_TCPUDPCSUM_MODE_LBN 97
#define	ESF_DZ_C2TE_UPD_TCPUDPCSUM_MODE_WIDTH 1
#define	ESF_DZ_C2TE_UPD_IPCSUM_MODE_LBN 96
#define	ESF_DZ_C2TE_UPD_IPCSUM_MODE_WIDTH 1
#define	ESF_DZ_C2TE_UPD_CRC_MODE_LBN 93
#define	ESF_DZ_C2TE_UPD_CRC_MODE_WIDTH 3
#define	ESE_DZ_C2RIP_FCOIP_MPA 5
#define	ESE_DZ_C2RIP_FCOIP_FCOE 4
#define	ESE_DZ_C2RIP_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_C2RIP_ISCSI_HDR 2
#define	ESE_DZ_C2RIP_FCOE 1
#define	ESE_DZ_C2RIP_OFF 0
#define	ESF_DZ_C2TE_FINFO_WRD3_LBN 48
#define	ESF_DZ_C2TE_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_C2TE_FINFO_WRD2_LBN 32
#define	ESF_DZ_C2TE_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_C2TE_FINFO_WRD1_LBN 16
#define	ESF_DZ_C2TE_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_C2TE_FINFO_SRCDST_LBN 0
#define	ESF_DZ_C2TE_FINFO_SRCDST_WIDTH 16


/* ES_FF_UMSG_CPU2TXDP_EGR_SOFT */
#define	ESF_DZ_C2TES_SOFT3_LBN 48
#define	ESF_DZ_C2TES_SOFT3_WIDTH 16
#define	ESF_DZ_C2TES_SOFT2_LBN 32
#define	ESF_DZ_C2TES_SOFT2_WIDTH 16
#define	ESF_DZ_C2TES_SOFT1_LBN 16
#define	ESF_DZ_C2TES_SOFT1_WIDTH 16
#define	ESF_DZ_C2TES_SOFT0_LBN 0
#define	ESF_DZ_C2TES_SOFT0_WIDTH 16


/* ES_FF_UMSG_DL2CPU_DESC_FETCH */
#define	ESF_DZ_D2CDF_REFL_DSCR_HW_WPTR_LBN 64
#define	ESF_DZ_D2CDF_REFL_DSCR_HW_WPTR_WIDTH 12
#define	ESF_DZ_D2CDF_FAIL_LBN 48
#define	ESF_DZ_D2CDF_FAIL_WIDTH 1
#define	ESF_DZ_D2CDF_QID_LBN 32
#define	ESF_DZ_D2CDF_QID_WIDTH 11
#define	ESF_DZ_D2CDF_NUM_DESC_LBN 16
#define	ESF_DZ_D2CDF_NUM_DESC_WIDTH 7
#define	ESF_DZ_D2CDF_NEW_DSCR_HW_RPTR_LBN 0
#define	ESF_DZ_D2CDF_NEW_DSCR_HW_RPTR_WIDTH 12


/* ES_FF_UMSG_DL2CPU_GPRD */
#define	ESF_DZ_D2CG_BIU_ARGS_LBN 0
#define	ESF_DZ_D2CG_BIU_ARGS_WIDTH 14


/* ES_FF_UMSG_DPCPU_PACER_TXQ_D_R_I_REQ */
#define	ESF_DZ_FRM_LEN_LBN 16
#define	ESF_DZ_FRM_LEN_WIDTH 15
#define	ESF_DZ_TXQ_ID_LBN 0
#define	ESF_DZ_TXQ_ID_WIDTH 10


/* ES_FF_UMSG_PACER_BKT_TBL_RD_REQ */
#define	ESF_DZ_BKT_ID_LBN 0
#define	ESF_DZ_BKT_ID_WIDTH 9


/* ES_FF_UMSG_PACER_BKT_TBL_RD_RSP */
#define	ESF_DZ_DUE_TIME_LBN 80
#define	ESF_DZ_DUE_TIME_WIDTH 16
#define	ESF_DZ_LAST_FILL_TIME_LBN 64
#define	ESF_DZ_LAST_FILL_TIME_WIDTH 16
#define	ESF_DZ_RATE_REC_LBN 48
#define	ESF_DZ_RATE_REC_WIDTH 16
#define	ESF_DZ_RATE_LBN 32
#define	ESF_DZ_RATE_WIDTH 16
#define	ESF_DZ_FILL_LEVEL_LBN 16
#define	ESF_DZ_FILL_LEVEL_WIDTH 16
#define	ESF_DZ_IDLE_LBN 15
#define	ESF_DZ_IDLE_WIDTH 1
#define	ESF_DZ_USED_LBN 14
#define	ESF_DZ_USED_WIDTH 1
#define	ESF_DZ_MAX_FILL_REG_LBN 12
#define	ESF_DZ_MAX_FILL_REG_WIDTH 2
#define	ESF_DZ_BKT_ID_LBN 0
#define	ESF_DZ_BKT_ID_WIDTH 9


/* ES_FF_UMSG_PACER_BKT_TBL_WR_REQ */
#define	ESF_DZ_RATE_REC_LBN 48
#define	ESF_DZ_RATE_REC_WIDTH 16
#define	ESF_DZ_RATE_LBN 32
#define	ESF_DZ_RATE_WIDTH 16
#define	ESF_DZ_FILL_LEVEL_LBN 16
#define	ESF_DZ_FILL_LEVEL_WIDTH 16
#define	ESF_DZ_IDLE_LBN 15
#define	ESF_DZ_IDLE_WIDTH 1
#define	ESF_DZ_USED_LBN 14
#define	ESF_DZ_USED_WIDTH 1
#define	ESF_DZ_MAX_FILL_REG_LBN 12
#define	ESF_DZ_MAX_FILL_REG_WIDTH 2
#define	ESF_DZ_BKT_ID_LBN 0
#define	ESF_DZ_BKT_ID_WIDTH 9


/* ES_FF_UMSG_PACER_TXQ_TBL_RD_REQ */
#define	ESF_DZ_TXQ_ID_LBN 0
#define	ESF_DZ_TXQ_ID_WIDTH 10


/* ES_FF_UMSG_PACER_TXQ_TBL_RD_RSP */
#define	ESF_DZ_MAX_BKT2_LBN 112
#define	ESF_DZ_MAX_BKT2_WIDTH 9
#define	ESF_DZ_MAX_BKT1_LBN 96
#define	ESF_DZ_MAX_BKT1_WIDTH 9
#define	ESF_DZ_MAX_BKT0_LBN 80
#define	ESF_DZ_MAX_BKT0_WIDTH 9
#define	ESF_DZ_MIN_BKT_LBN 64
#define	ESF_DZ_MIN_BKT_WIDTH 9
#define	ESF_DZ_LABEL_LBN 48
#define	ESF_DZ_LABEL_WIDTH 4
#define	ESF_DZ_PQ_FLAGS_LBN 32
#define	ESF_DZ_PQ_FLAGS_WIDTH 3
#define	ESF_DZ_DSBL_LBN 16
#define	ESF_DZ_DSBL_WIDTH 1
#define	ESF_DZ_TXQ_ID_LBN 0
#define	ESF_DZ_TXQ_ID_WIDTH 10


/* ES_FF_UMSG_PACER_TXQ_TBL_WR_REQ */
#define	ESF_DZ_MAX_BKT2_LBN 112
#define	ESF_DZ_MAX_BKT2_WIDTH 9
#define	ESF_DZ_MAX_BKT1_LBN 96
#define	ESF_DZ_MAX_BKT1_WIDTH 9
#define	ESF_DZ_MAX_BKT0_LBN 80
#define	ESF_DZ_MAX_BKT0_WIDTH 9
#define	ESF_DZ_MIN_BKT_LBN 64
#define	ESF_DZ_MIN_BKT_WIDTH 9
#define	ESF_DZ_LABEL_LBN 48
#define	ESF_DZ_LABEL_WIDTH 4
#define	ESF_DZ_PQ_FLAGS_LBN 32
#define	ESF_DZ_PQ_FLAGS_WIDTH 3
#define	ESF_DZ_DSBL_LBN 16
#define	ESF_DZ_DSBL_WIDTH 1
#define	ESF_DZ_TXQ_ID_LBN 0
#define	ESF_DZ_TXQ_ID_WIDTH 10


/* ES_FF_UMSG_PE */
#define	ESF_DZ_PE_PKT_OFST_LBN 47
#define	ESF_DZ_PE_PKT_OFST_WIDTH 17
#define	ESF_DZ_PE_PEDIT_DELTA_LBN 40
#define	ESF_DZ_PE_PEDIT_DELTA_WIDTH 8
#define	ESF_DZ_PE_PYLOAD_OFST_LBN 32
#define	ESF_DZ_PE_PYLOAD_OFST_WIDTH 8
#define	ESF_DZ_PE_L4_HDR_OFST_LBN 24
#define	ESF_DZ_PE_L4_HDR_OFST_WIDTH 8
#define	ESF_DZ_PE_L3_HDR_OFST_LBN 16
#define	ESF_DZ_PE_L3_HDR_OFST_WIDTH 8
#define	ESF_DZ_PE_HAVE_UDP_HDR_LBN 5
#define	ESF_DZ_PE_HAVE_UDP_HDR_WIDTH 1
#define	ESF_DZ_PE_HAVE_TCP_HDR_LBN 4
#define	ESF_DZ_PE_HAVE_TCP_HDR_WIDTH 1
#define	ESF_DZ_PE_HAVE_IPV6_HDR_LBN 3
#define	ESF_DZ_PE_HAVE_IPV6_HDR_WIDTH 1
#define	ESF_DZ_PE_HAVE_IPV4_HDR_LBN 2
#define	ESF_DZ_PE_HAVE_IPV4_HDR_WIDTH 1
#define	ESF_DZ_PE_HAVE_FCOE_LBN 1
#define	ESF_DZ_PE_HAVE_FCOE_WIDTH 1
#define	ESF_DZ_PE_PARSE_INCOMP_LBN 0
#define	ESF_DZ_PE_PARSE_INCOMP_WIDTH 1


/* ES_FF_UMSG_RXDP_EGR2CPU_SOFT */
#define	ESF_DZ_RE2CS_SOFT3_LBN 48
#define	ESF_DZ_RE2CS_SOFT3_WIDTH 16
#define	ESF_DZ_RE2CS_SOFT2_LBN 32
#define	ESF_DZ_RE2CS_SOFT2_WIDTH 16
#define	ESF_DZ_RE2CS_SOFT1_LBN 16
#define	ESF_DZ_RE2CS_SOFT1_WIDTH 16
#define	ESF_DZ_RE2CS_SOFT0_LBN 0
#define	ESF_DZ_RE2CS_SOFT0_WIDTH 16


/* ES_FF_UMSG_RXDP_INGR2CPU */
#define	ESF_DZ_RI2C_LEN_LBN 208
#define	ESF_DZ_RI2C_LEN_WIDTH 16
#define	ESF_DZ_RI2C_L4_CLASS_LBN 202
#define	ESF_DZ_RI2C_L4_CLASS_WIDTH 3
#define	ESF_DZ_RI2C_L3_CLASS_LBN 199
#define	ESF_DZ_RI2C_L3_CLASS_WIDTH 3
#define	ESF_DZ_RI2C_ETHTAG_CLASS_LBN 196
#define	ESF_DZ_RI2C_ETHTAG_CLASS_WIDTH 3
#define	ESF_DZ_RI2C_ETHBASE_CLASS_LBN 193
#define	ESF_DZ_RI2C_ETHBASE_CLASS_WIDTH 3
#define	ESF_DZ_RI2C_MAC_CLASS_LBN 192
#define	ESF_DZ_RI2C_MAC_CLASS_WIDTH 1
#define	ESF_DZ_RI2C_PKT_OFST_LBN 176
#define	ESF_DZ_RI2C_PKT_OFST_WIDTH 16
#define	ESF_DZ_RI2C_PEDIT_DELTA_LBN 168
#define	ESF_DZ_RI2C_PEDIT_DELTA_WIDTH 8
#define	ESF_DZ_RI2C_PYLOAD_OFST_LBN 160
#define	ESF_DZ_RI2C_PYLOAD_OFST_WIDTH 8
#define	ESF_DZ_RI2C_L4_HDR_OFST_LBN 152
#define	ESF_DZ_RI2C_L4_HDR_OFST_WIDTH 8
#define	ESF_DZ_RI2C_L3_HDR_OFST_LBN 144
#define	ESF_DZ_RI2C_L3_HDR_OFST_WIDTH 8
#define	ESF_DZ_RI2C_HAVE_UDP_HDR_LBN 133
#define	ESF_DZ_RI2C_HAVE_UDP_HDR_WIDTH 1
#define	ESF_DZ_RI2C_HAVE_TCP_HDR_LBN 132
#define	ESF_DZ_RI2C_HAVE_TCP_HDR_WIDTH 1
#define	ESF_DZ_RI2C_HAVE_IPV6_HDR_LBN 131
#define	ESF_DZ_RI2C_HAVE_IPV6_HDR_WIDTH 1
#define	ESF_DZ_RI2C_HAVE_IPV4_HDR_LBN 130
#define	ESF_DZ_RI2C_HAVE_IPV4_HDR_WIDTH 1
#define	ESF_DZ_RI2C_HAVE_FCOE_LBN 129
#define	ESF_DZ_RI2C_HAVE_FCOE_WIDTH 1
#define	ESF_DZ_RI2C_PARSE_INCOMP_LBN 128
#define	ESF_DZ_RI2C_PARSE_INCOMP_WIDTH 1
#define	ESF_DZ_RI2C_EFINFO_WRD3_LBN 112
#define	ESF_DZ_RI2C_EFINFO_WRD3_WIDTH 16
#define	ESF_DZ_RI2C_EFINFO_WRD2_LBN 96
#define	ESF_DZ_RI2C_EFINFO_WRD2_WIDTH 16
#define	ESF_DZ_RI2C_EFINFO_WRD1_LBN 80
#define	ESF_DZ_RI2C_EFINFO_WRD1_WIDTH 16
#define	ESF_DZ_RI2C_EFINFO_WRD0_LBN 64
#define	ESF_DZ_RI2C_EFINFO_WRD0_WIDTH 16
#define	ESF_DZ_RI2C_FINFO_WRD3_LBN 48
#define	ESF_DZ_RI2C_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_RI2C_FINFO_WRD2_LBN 32
#define	ESF_DZ_RI2C_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_RI2C_FINFO_WRD1_LBN 16
#define	ESF_DZ_RI2C_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_RI2C_FINFO_SRCDST_LBN 0
#define	ESF_DZ_RI2C_FINFO_SRCDST_WIDTH 16


/* ES_FF_UMSG_SMC2CPU_BUFLKUP */
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_DW0_LBN 0
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_DW0_WIDTH 32
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_DW1_LBN 32
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_DW1_WIDTH 16
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_LBN 0
#define	ESF_DZ_S2CB_ENCODED_PAGE_ADDR_WIDTH 48
#define	ESF_DZ_S2CB_FAIL_LBN 32
#define	ESF_DZ_S2CB_FAIL_WIDTH 1


/* ES_FF_UMSG_SMC2CPU_DESCRD */
#define	ESF_DZ_S2CD_BUF_LEN_LBN 112
#define	ESF_DZ_S2CD_BUF_LEN_WIDTH 14
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_DW0_LBN 64
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_DW0_WIDTH 32
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_DW1_LBN 96
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_DW1_WIDTH 16
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_LBN 64
#define	ESF_DZ_S2CD_ENCODED_HOST_ADDR_WIDTH 48
#define	ESF_DZ_S2CD_CONT_LBN 16
#define	ESF_DZ_S2CD_CONT_WIDTH 1
#define	ESF_DZ_S2CD_TYPE_LBN 0
#define	ESF_DZ_S2CD_TYPE_WIDTH 1


/* ES_FF_UMSG_SMC2CPU_GPRD */
#define	ESF_DZ_S2CG_DATA_DW0_LBN 64
#define	ESF_DZ_S2CG_DATA_DW0_WIDTH 32
#define	ESF_DZ_S2CG_DATA_DW1_LBN 96
#define	ESF_DZ_S2CG_DATA_DW1_WIDTH 32
#define	ESF_DZ_S2CG_DATA_LBN 64
#define	ESF_DZ_S2CG_DATA_WIDTH 64
#define	ESF_DZ_S2CG_SOFT_LBN 48
#define	ESF_DZ_S2CG_SOFT_WIDTH 4
#define	ESF_DZ_S2CG_FAIL_LBN 32
#define	ESF_DZ_S2CG_FAIL_WIDTH 1


/* ES_FF_UMSG_TXDP_DMA2CPU_PKTRDY */
#define	ESF_DZ_TD2CP_L4_CLASS_LBN 250
#define	ESF_DZ_TD2CP_L4_CLASS_WIDTH 3
#define	ESF_DZ_TD2CP_L3_CLASS_LBN 247
#define	ESF_DZ_TD2CP_L3_CLASS_WIDTH 3
#define	ESF_DZ_TD2CP_ETHTAG_CLASS_LBN 244
#define	ESF_DZ_TD2CP_ETHTAG_CLASS_WIDTH 3
#define	ESF_DZ_TD2CP_ETHBASE_CLASS_LBN 241
#define	ESF_DZ_TD2CP_ETHBASE_CLASS_WIDTH 3
#define	ESF_DZ_TD2CP_MAC_CLASS_LBN 240
#define	ESF_DZ_TD2CP_MAC_CLASS_WIDTH 1
#define	ESF_DZ_TD2CP_SOFT_LBN 226
#define	ESF_DZ_TD2CP_SOFT_WIDTH 14
#define	ESF_DZ_TD2CP_PKT_ABORT_LBN 225
#define	ESF_DZ_TD2CP_PKT_ABORT_WIDTH 1
#define	ESF_DZ_TD2CP_PCIE_ERR_LBN 224
#define	ESF_DZ_TD2CP_PCIE_ERR_WIDTH 1
#define	ESF_DZ_TD2CP_DESC_IDX_LBN 208
#define	ESF_DZ_TD2CP_DESC_IDX_WIDTH 16
#define	ESF_DZ_TD2CP_PKT_LEN_LBN 192
#define	ESF_DZ_TD2CP_PKT_LEN_WIDTH 16
#define	ESF_DZ_TD2CP_PKT_OFFST_OR_FIRST_DESC_IDX_LBN 176
#define	ESF_DZ_TD2CP_PKT_OFFST_OR_FIRST_DESC_IDX_WIDTH 7
#define	ESF_DZ_TD2CP_PEDIT_DELTA_LBN 168
#define	ESF_DZ_TD2CP_PEDIT_DELTA_WIDTH 8
#define	ESF_DZ_TD2CP_PYLOAD_OFST_LBN 160
#define	ESF_DZ_TD2CP_PYLOAD_OFST_WIDTH 8
#define	ESF_DZ_TD2CP_L4_HDR_OFST_LBN 152
#define	ESF_DZ_TD2CP_L4_HDR_OFST_WIDTH 8
#define	ESF_DZ_TD2CP_L3_HDR_OFST_LBN 144
#define	ESF_DZ_TD2CP_L3_HDR_OFST_WIDTH 8
#define	ESF_DZ_TD2CP_IS_UDP_LBN 133
#define	ESF_DZ_TD2CP_IS_UDP_WIDTH 1
#define	ESF_DZ_TD2CP_IS_TCP_LBN 132
#define	ESF_DZ_TD2CP_IS_TCP_WIDTH 1
#define	ESF_DZ_TD2CP_IS_IPV6_LBN 131
#define	ESF_DZ_TD2CP_IS_IPV6_WIDTH 1
#define	ESF_DZ_TD2CP_IS_IPV4_LBN 130
#define	ESF_DZ_TD2CP_IS_IPV4_WIDTH 1
#define	ESF_DZ_TD2CP_IS_FCOE_LBN 129
#define	ESF_DZ_TD2CP_IS_FCOE_WIDTH 1
#define	ESF_DZ_TD2CP_PARSE_INCOMP_LBN 128
#define	ESF_DZ_TD2CP_PARSE_INCOMP_WIDTH 1
#define	ESF_DZ_TD2CP_EFINFO_WRD3_LBN 112
#define	ESF_DZ_TD2CP_EFINFO_WRD3_WIDTH 16
#define	ESF_DZ_TD2CP_EFINFO_WRD2_LBN 96
#define	ESF_DZ_TD2CP_EFINFO_WRD2_WIDTH 16
#define	ESF_DZ_TD2CP_EFINFO_WRD1_LBN 80
#define	ESF_DZ_TD2CP_EFINFO_WRD1_WIDTH 16
#define	ESF_DZ_TD2CP_EFINFO_WRD0_LBN 64
#define	ESF_DZ_TD2CP_EFINFO_WRD0_WIDTH 16
#define	ESF_DZ_TD2CP_FINFO_WRD3_LBN 48
#define	ESF_DZ_TD2CP_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_TD2CP_FINFO_WRD2_LBN 32
#define	ESF_DZ_TD2CP_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_TD2CP_FINFO_WRD1_LBN 16
#define	ESF_DZ_TD2CP_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_TD2CP_FINFO_SRCDST_LBN 0
#define	ESF_DZ_TD2CP_FINFO_SRCDST_WIDTH 16


/* ES_FF_UMSG_TXDP_DMA2CPU_SOFT */
#define	ESF_DZ_TD2CS_SOFT3_LBN 48
#define	ESF_DZ_TD2CS_SOFT3_WIDTH 16
#define	ESF_DZ_TD2CS_SOFT2_LBN 32
#define	ESF_DZ_TD2CS_SOFT2_WIDTH 16
#define	ESF_DZ_TD2CS_SOFT1_LBN 16
#define	ESF_DZ_TD2CS_SOFT1_WIDTH 16
#define	ESF_DZ_TD2CS_SOFT0_LBN 0
#define	ESF_DZ_TD2CS_SOFT0_WIDTH 16


/* ES_FF_UMSG_TXDP_EGR2CPU_SOFT */
#define	ESF_DZ_TE2CS_SOFT3_LBN 48
#define	ESF_DZ_TE2CS_SOFT3_WIDTH 16
#define	ESF_DZ_TE2CS_SOFT2_LBN 32
#define	ESF_DZ_TE2CS_SOFT2_WIDTH 16
#define	ESF_DZ_TE2CS_SOFT1_LBN 16
#define	ESF_DZ_TE2CS_SOFT1_WIDTH 16
#define	ESF_DZ_TE2CS_SOFT0_LBN 0
#define	ESF_DZ_TE2CS_SOFT0_WIDTH 16


/* ES_FF_UMSG_VICTL2CPU */
#define	ESF_DZ_V2C_DESC_WORD3_LBN 112
#define	ESF_DZ_V2C_DESC_WORD3_WIDTH 17
#define	ESF_DZ_V2C_DESC_WORD2_LBN 96
#define	ESF_DZ_V2C_DESC_WORD2_WIDTH 16
#define	ESF_DZ_V2C_DESC_WORD1_LBN 80
#define	ESF_DZ_V2C_DESC_WORD1_WIDTH 16
#define	ESF_DZ_V2C_DESC_WORD0_LBN 64
#define	ESF_DZ_V2C_DESC_WORD0_WIDTH 16
#define	ESF_DZ_V2C_NEW_DSCR_WPTR_LBN 32
#define	ESF_DZ_V2C_NEW_DSCR_WPTR_WIDTH 12
#define	ESF_DZ_V2C_DESC_PUSH_LBN 16
#define	ESF_DZ_V2C_DESC_PUSH_WIDTH 1


/* ES_LUE_DB_MATCH_ENTRY */
#define	ESF_DZ_LUE_DSCRMNTR_LBN 140
#define	ESF_DZ_LUE_DSCRMNTR_WIDTH 4
#define	ESF_DZ_LUE_MATCH_VAL_DW0_LBN 44
#define	ESF_DZ_LUE_MATCH_VAL_DW0_WIDTH 32
#define	ESF_DZ_LUE_MATCH_VAL_DW1_LBN 76
#define	ESF_DZ_LUE_MATCH_VAL_DW1_WIDTH 32
#define	ESF_DZ_LUE_MATCH_VAL_DW2_LBN 108
#define	ESF_DZ_LUE_MATCH_VAL_DW2_WIDTH 32
#define	ESF_DZ_LUE_MATCH_VAL_LBN 44
#define	ESF_DZ_LUE_MATCH_VAL_WIDTH 96
#define	ESF_DZ_LUE_ME_SOFT_LBN 35
#define	ESF_DZ_LUE_ME_SOFT_WIDTH 9
#define	ESF_DZ_LUE_TX_MCAST_LBN 33
#define	ESF_DZ_LUE_TX_MCAST_WIDTH 2
#define	ESF_DZ_LUE_TX_DOMAIN_LBN 25
#define	ESF_DZ_LUE_TX_DOMAIN_WIDTH 8
#define	ESF_DZ_LUE_RX_MCAST_LBN 24
#define	ESF_DZ_LUE_RX_MCAST_WIDTH 1
#define	ESE_DZ_LUE_MULTI 1
#define	ESE_DZ_LUE_SINGLE 0
#define	ESF_DZ_LUE_RCPNTR_LBN 0
#define	ESF_DZ_LUE_RCPNTR_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR_ME_PTR_LBN 0
#define	ESF_DZ_LUE_RCPNTR_ME_PTR_WIDTH 14


/* ES_LUE_DB_NONMATCH_ENTRY */
#define	ESF_DZ_LUE_DSCRMNTR_LBN 140
#define	ESF_DZ_LUE_DSCRMNTR_WIDTH 4
#define	ESF_DZ_LUE_TERMINAL_LBN 139
#define	ESF_DZ_LUE_TERMINAL_WIDTH 1
#define	ESF_DZ_LUE_LAST_LBN 138
#define	ESF_DZ_LUE_LAST_WIDTH 1
#define	ESF_DZ_LUE_NE_SOFT_LBN 137
#define	ESF_DZ_LUE_NE_SOFT_WIDTH 1
#define	ESF_DZ_LUE_RCPNTR_NUM_LBN 134
#define	ESF_DZ_LUE_RCPNTR_NUM_WIDTH 3
#define	ESF_DZ_LUE_RCPNTR0_LBN 110
#define	ESF_DZ_LUE_RCPNTR0_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR1_LBN 86
#define	ESF_DZ_LUE_RCPNTR1_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR2_LBN 62
#define	ESF_DZ_LUE_RCPNTR2_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR3_LBN 38
#define	ESF_DZ_LUE_RCPNTR3_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR4_LBN 14
#define	ESF_DZ_LUE_RCPNTR4_WIDTH 24
#define	ESF_DZ_LUE_RCPNTR_NE_PTR_LBN 0
#define	ESF_DZ_LUE_RCPNTR_NE_PTR_WIDTH 14


/* ES_LUE_MC_DIRECT_REQUEST_MSG */
#define	ESF_DZ_MC2L_DR_PAD_DW0_LBN 22
#define	ESF_DZ_MC2L_DR_PAD_DW0_WIDTH 32
#define	ESF_DZ_MC2L_DR_PAD_DW1_LBN 54
#define	ESF_DZ_MC2L_DR_PAD_DW1_WIDTH 32
#define	ESF_DZ_MC2L_DR_PAD_DW2_LBN 86
#define	ESF_DZ_MC2L_DR_PAD_DW2_WIDTH 32
#define	ESF_DZ_MC2L_DR_PAD_DW3_LBN 118
#define	ESF_DZ_MC2L_DR_PAD_DW3_WIDTH 32
#define	ESF_DZ_MC2L_DR_PAD_DW4_LBN 150
#define	ESF_DZ_MC2L_DR_PAD_DW4_WIDTH 16
#define	ESF_DZ_MC2L_DR_PAD_LBN 22
#define	ESF_DZ_MC2L_DR_PAD_WIDTH 144
#define	ESF_DZ_MC2L_DR_ADDR_LBN 8
#define	ESF_DZ_MC2L_DR_ADDR_WIDTH 14
#define	ESF_DZ_MC2L_DR_THREAD_ID_LBN 5
#define	ESF_DZ_MC2L_DR_THREAD_ID_WIDTH 3
#define	ESF_DZ_MC2L_DR_CLIENT_ID_LBN 2
#define	ESF_DZ_MC2L_DR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_MC2L_DR_OP_LBN 0
#define	ESF_DZ_MC2L_DR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_DIRECT_RESPONSE_MSG */
#define	ESF_DZ_L2MC_DR_PAD_LBN 146
#define	ESF_DZ_L2MC_DR_PAD_WIDTH 6
#define	ESF_DZ_L2MC_DR_RCPNT_PTR_LBN 132
#define	ESF_DZ_L2MC_DR_RCPNT_PTR_WIDTH 14
#define	ESF_DZ_L2MC_DR_RCPNT4_LBN 108
#define	ESF_DZ_L2MC_DR_RCPNT4_WIDTH 24
#define	ESF_DZ_L2MC_DR_RCPNT3_LBN 84
#define	ESF_DZ_L2MC_DR_RCPNT3_WIDTH 24
#define	ESF_DZ_L2MC_DR_RCPNT2_LBN 60
#define	ESF_DZ_L2MC_DR_RCPNT2_WIDTH 24
#define	ESF_DZ_L2MC_DR_RCPNT1_LBN 36
#define	ESF_DZ_L2MC_DR_RCPNT1_WIDTH 24
#define	ESF_DZ_L2MC_DR_RCPNT0_LBN 12
#define	ESF_DZ_L2MC_DR_RCPNT0_WIDTH 24
#define	ESF_DZ_L2MC_DR_RCPNT_NUM_LBN 9
#define	ESF_DZ_L2MC_DR_RCPNT_NUM_WIDTH 3
#define	ESF_DZ_L2MC_DR_LAST_LBN 8
#define	ESF_DZ_L2MC_DR_LAST_WIDTH 1
#define	ESF_DZ_L2MC_DR_THREAD_ID_LBN 5
#define	ESF_DZ_L2MC_DR_THREAD_ID_WIDTH 3
#define	ESF_DZ_L2MC_DR_CLIENT_ID_LBN 2
#define	ESF_DZ_L2MC_DR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_L2MC_DR_OP_LBN 0
#define	ESF_DZ_L2MC_DR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_GP_RD_REQUEST_MSG */
#define	ESF_DZ_MC2L_GPR_PAD_DW0_LBN 22
#define	ESF_DZ_MC2L_GPR_PAD_DW0_WIDTH 32
#define	ESF_DZ_MC2L_GPR_PAD_DW1_LBN 54
#define	ESF_DZ_MC2L_GPR_PAD_DW1_WIDTH 32
#define	ESF_DZ_MC2L_GPR_PAD_DW2_LBN 86
#define	ESF_DZ_MC2L_GPR_PAD_DW2_WIDTH 32
#define	ESF_DZ_MC2L_GPR_PAD_DW3_LBN 118
#define	ESF_DZ_MC2L_GPR_PAD_DW3_WIDTH 32
#define	ESF_DZ_MC2L_GPR_PAD_DW4_LBN 150
#define	ESF_DZ_MC2L_GPR_PAD_DW4_WIDTH 16
#define	ESF_DZ_MC2L_GPR_PAD_LBN 22
#define	ESF_DZ_MC2L_GPR_PAD_WIDTH 144
#define	ESF_DZ_MC2L_GPR_ADDR_LBN 8
#define	ESF_DZ_MC2L_GPR_ADDR_WIDTH 14
#define	ESF_DZ_MC2L_GPR_THREAD_ID_LBN 5
#define	ESF_DZ_MC2L_GPR_THREAD_ID_WIDTH 3
#define	ESF_DZ_MC2L_GPR_CLIENT_ID_LBN 2
#define	ESF_DZ_MC2L_GPR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_MC2L_GPR_OP_LBN 0
#define	ESF_DZ_MC2L_GPR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_GP_RD_RESPONSE_MSG */
#define	ESF_DZ_L2MC_GPR_DATA_DW0_LBN 8
#define	ESF_DZ_L2MC_GPR_DATA_DW0_WIDTH 32
#define	ESF_DZ_L2MC_GPR_DATA_DW1_LBN 40
#define	ESF_DZ_L2MC_GPR_DATA_DW1_WIDTH 32
#define	ESF_DZ_L2MC_GPR_DATA_DW2_LBN 72
#define	ESF_DZ_L2MC_GPR_DATA_DW2_WIDTH 32
#define	ESF_DZ_L2MC_GPR_DATA_DW3_LBN 104
#define	ESF_DZ_L2MC_GPR_DATA_DW3_WIDTH 32
#define	ESF_DZ_L2MC_GPR_DATA_DW4_LBN 136
#define	ESF_DZ_L2MC_GPR_DATA_DW4_WIDTH 16
#define	ESF_DZ_L2MC_GPR_DATA_LBN 8
#define	ESF_DZ_L2MC_GPR_DATA_WIDTH 144
#define	ESF_DZ_L2MC_GPR_THREAD_ID_LBN 5
#define	ESF_DZ_L2MC_GPR_THREAD_ID_WIDTH 3
#define	ESF_DZ_L2MC_GPR_CLIENT_ID_LBN 2
#define	ESF_DZ_L2MC_GPR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_L2MC_GPR_OP_LBN 0
#define	ESF_DZ_L2MC_GPR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_GP_WR_REQUEST_MSG */
#define	ESF_DZ_MC2L_GPW_DATA_DW0_LBN 22
#define	ESF_DZ_MC2L_GPW_DATA_DW0_WIDTH 32
#define	ESF_DZ_MC2L_GPW_DATA_DW1_LBN 54
#define	ESF_DZ_MC2L_GPW_DATA_DW1_WIDTH 32
#define	ESF_DZ_MC2L_GPW_DATA_DW2_LBN 86
#define	ESF_DZ_MC2L_GPW_DATA_DW2_WIDTH 32
#define	ESF_DZ_MC2L_GPW_DATA_DW3_LBN 118
#define	ESF_DZ_MC2L_GPW_DATA_DW3_WIDTH 32
#define	ESF_DZ_MC2L_GPW_DATA_DW4_LBN 150
#define	ESF_DZ_MC2L_GPW_DATA_DW4_WIDTH 16
#define	ESF_DZ_MC2L_GPW_DATA_LBN 22
#define	ESF_DZ_MC2L_GPW_DATA_WIDTH 144
#define	ESF_DZ_MC2L_GPW_ADDR_LBN 8
#define	ESF_DZ_MC2L_GPW_ADDR_WIDTH 14
#define	ESF_DZ_MC2L_GPW_THREAD_ID_LBN 5
#define	ESF_DZ_MC2L_GPW_THREAD_ID_WIDTH 3
#define	ESF_DZ_MC2L_GPW_CLIENT_ID_LBN 2
#define	ESF_DZ_MC2L_GPW_CLIENT_ID_WIDTH 3
#define	ESF_DZ_MC2L_GPW_OP_LBN 0
#define	ESF_DZ_MC2L_GPW_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_MATCH_REQUEST_MSG */
#define	ESF_DZ_MC2L_MR_PAD_LBN 135
#define	ESF_DZ_MC2L_MR_PAD_WIDTH 31
#define	ESF_DZ_MC2L_MR_HASH2_LBN 122
#define	ESF_DZ_MC2L_MR_HASH2_WIDTH 13
#define	ESF_DZ_MC2L_MR_HASH1_LBN 108
#define	ESF_DZ_MC2L_MR_HASH1_WIDTH 14
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW0_LBN 12
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW0_WIDTH 32
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW1_LBN 44
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW1_WIDTH 32
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW2_LBN 76
#define	ESF_DZ_MC2L_MR_MATCH_BITS_DW2_WIDTH 32
#define	ESF_DZ_MC2L_MR_MATCH_BITS_LBN 12
#define	ESF_DZ_MC2L_MR_MATCH_BITS_WIDTH 96
#define	ESF_DZ_MC2L_MR_DSCRMNTR_LBN 8
#define	ESF_DZ_MC2L_MR_DSCRMNTR_WIDTH 4
#define	ESF_DZ_MC2L_MR_THREAD_ID_LBN 5
#define	ESF_DZ_MC2L_MR_THREAD_ID_WIDTH 3
#define	ESF_DZ_MC2L_MR_CLIENT_ID_LBN 2
#define	ESF_DZ_MC2L_MR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_MC2L_MR_OP_LBN 0
#define	ESF_DZ_MC2L_MR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MC_MATCH_RESPONSE_MSG */
#define	ESF_DZ_L2MC_MR_PAD_DW0_LBN 53
#define	ESF_DZ_L2MC_MR_PAD_DW0_WIDTH 32
#define	ESF_DZ_L2MC_MR_PAD_DW1_LBN 85
#define	ESF_DZ_L2MC_MR_PAD_DW1_WIDTH 32
#define	ESF_DZ_L2MC_MR_PAD_DW2_LBN 117
#define	ESF_DZ_L2MC_MR_PAD_DW2_WIDTH 32
#define	ESF_DZ_L2MC_MR_PAD_DW3_LBN 149
#define	ESF_DZ_L2MC_MR_PAD_DW3_WIDTH 3
#define	ESF_DZ_L2MC_MR_PAD_LBN 53
#define	ESF_DZ_L2MC_MR_PAD_WIDTH 99
#define	ESF_DZ_L2MC_MR_LUE_RCPNT_LBN 29
#define	ESF_DZ_L2MC_MR_LUE_RCPNT_WIDTH 24
#define	ESF_DZ_L2MC_MR_RX_MCAST_LBN 28
#define	ESF_DZ_L2MC_MR_RX_MCAST_WIDTH 1
#define	ESF_DZ_L2MC_MR_TX_DOMAIN_LBN 20
#define	ESF_DZ_L2MC_MR_TX_DOMAIN_WIDTH 8
#define	ESF_DZ_L2MC_MR_TX_MCAST_LBN 18
#define	ESF_DZ_L2MC_MR_TX_MCAST_WIDTH 2
#define	ESF_DZ_L2MC_MR_SOFT_LBN 9
#define	ESF_DZ_L2MC_MR_SOFT_WIDTH 9
#define	ESF_DZ_L2MC_MR_MATCH_LBN 8
#define	ESF_DZ_L2MC_MR_MATCH_WIDTH 1
#define	ESF_DZ_L2MC_MR_THREAD_ID_LBN 5
#define	ESF_DZ_L2MC_MR_THREAD_ID_WIDTH 3
#define	ESF_DZ_L2MC_MR_CLIENT_ID_LBN 2
#define	ESF_DZ_L2MC_MR_CLIENT_ID_WIDTH 3
#define	ESF_DZ_L2MC_MR_OP_LBN 0
#define	ESF_DZ_L2MC_MR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_BASE_REQ */
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW0_LBN 8
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW0_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW1_LBN 40
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW1_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW2_LBN 72
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW2_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW3_LBN 104
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW3_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW4_LBN 136
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_DW4_WIDTH 30
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_LBN 8
#define	ESF_DZ_LUE_HW_REQ_BASE_REQ_MSG_DATA_WIDTH 158
#define	ESF_DZ_LUE_HW_REQ_BASE_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_REQ_BASE_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_REQ_BASE_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_REQ_BASE_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_REQ_BASE_OP_LBN 0
#define	ESF_DZ_LUE_HW_REQ_BASE_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_BASE_RESP */
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW0_LBN 8
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW0_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW1_LBN 40
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW1_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW2_LBN 72
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW2_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW3_LBN 104
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW3_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW4_LBN 136
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_DW4_WIDTH 16
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_LBN 8
#define	ESF_DZ_LUE_HW_RSP_BASE_RSP_DATA_WIDTH 144
#define	ESF_DZ_LUE_HW_RSP_BASE_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_RSP_BASE_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_RSP_BASE_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_RSP_BASE_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_RSP_BASE_OP_LBN 0
#define	ESF_DZ_LUE_HW_RSP_BASE_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_DIRECT_REQ */
#define	ESF_DZ_LUE_HW_REQ_DIR_ADDR_LBN 8
#define	ESF_DZ_LUE_HW_REQ_DIR_ADDR_WIDTH 14
#define	ESF_DZ_LUE_HW_REQ_DIR_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_REQ_DIR_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_REQ_DIR_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_REQ_DIR_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_REQ_DIR_OP_LBN 0
#define	ESF_DZ_LUE_HW_REQ_DIR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_DIRECT_RESP */
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT_PTR_LBN 132
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT_PTR_WIDTH 14
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT4_LBN 108
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT4_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT3_LBN 84
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT3_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT2_LBN 60
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT2_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT1_LBN 36
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT1_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT0_LBN 12
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT0_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT_NUM_LBN 9
#define	ESF_DZ_LUE_HW_RSP_DIR_RCPNT_NUM_WIDTH 3
#define	ESF_DZ_LUE_HW_RSP_DIR_LAST_LBN 8
#define	ESF_DZ_LUE_HW_RSP_DIR_LAST_WIDTH 1
#define	ESF_DZ_LUE_HW_RSP_DIR_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_RSP_DIR_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_RSP_DIR_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_RSP_DIR_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_RSP_DIR_OP_LBN 0
#define	ESF_DZ_LUE_HW_RSP_DIR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_GP_RD_REQ */
#define	ESF_DZ_LUE_HW_REQ_GPRD_ADDR_LBN 8
#define	ESF_DZ_LUE_HW_REQ_GPRD_ADDR_WIDTH 14
#define	ESF_DZ_LUE_HW_REQ_GPRD_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_REQ_GPRD_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_REQ_GPRD_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_REQ_GPRD_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_REQ_GPRD_OP_LBN 0
#define	ESF_DZ_LUE_HW_REQ_GPRD_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_GP_RD_RESP */
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW0_LBN 8
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW0_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW1_LBN 40
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW1_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW2_LBN 72
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW2_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW3_LBN 104
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW3_WIDTH 32
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW4_LBN 136
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_DW4_WIDTH 16
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_LBN 8
#define	ESF_DZ_LUE_HW_RSP_GPRD_LUE_DATA_WIDTH 144
#define	ESF_DZ_LUE_HW_RSP_GPRD_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_RSP_GPRD_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_RSP_GPRD_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_RSP_GPRD_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_RSP_GPRD_OP_LBN 0
#define	ESF_DZ_LUE_HW_RSP_GPRD_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_GP_WR_REQ */
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW0_LBN 22
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW0_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW1_LBN 54
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW1_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW2_LBN 86
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW2_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW3_LBN 118
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW3_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW4_LBN 150
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_DW4_WIDTH 16
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_LBN 22
#define	ESF_DZ_LUE_HW_REQ_GPWR_LUE_DATA_WIDTH 144
#define	ESF_DZ_LUE_HW_REQ_GPWR_ADDR_LBN 8
#define	ESF_DZ_LUE_HW_REQ_GPWR_ADDR_WIDTH 14
#define	ESF_DZ_LUE_HW_REQ_GPWR_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_REQ_GPWR_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_REQ_GPWR_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_REQ_GPWR_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_REQ_GPWR_OP_LBN 0
#define	ESF_DZ_LUE_HW_REQ_GPWR_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_MATCH_REQ */
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_REQ_COUNT_LBN 135
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_REQ_COUNT_WIDTH 6
#define	ESF_DZ_LUE_HW_REQ_MATCH_HASH2_LBN 122
#define	ESF_DZ_LUE_HW_REQ_MATCH_HASH2_WIDTH 13
#define	ESF_DZ_LUE_HW_REQ_MATCH_HASH1_LBN 108
#define	ESF_DZ_LUE_HW_REQ_MATCH_HASH1_WIDTH 14
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW0_LBN 12
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW0_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW1_LBN 44
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW1_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW2_LBN 76
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_DW2_WIDTH 32
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_LBN 12
#define	ESF_DZ_LUE_HW_REQ_MATCH_MATCH_BITS_WIDTH 96
#define	ESF_DZ_LUE_HW_REQ_MATCH_DSCRMNTR_LBN 8
#define	ESF_DZ_LUE_HW_REQ_MATCH_DSCRMNTR_WIDTH 4
#define	ESF_DZ_LUE_HW_REQ_MATCH_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_REQ_MATCH_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_REQ_MATCH_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_REQ_MATCH_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_REQ_MATCH_OP_LBN 0
#define	ESF_DZ_LUE_HW_REQ_MATCH_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_MSG_MATCH_RESP */
#define	ESF_DZ_LUE_HW_RSP_MATCH_LUE_RCPNT_LBN 29
#define	ESF_DZ_LUE_HW_RSP_MATCH_LUE_RCPNT_WIDTH 24
#define	ESF_DZ_LUE_HW_RSP_MATCH_RX_MCAST_LBN 28
#define	ESF_DZ_LUE_HW_RSP_MATCH_RX_MCAST_WIDTH 1
#define	ESF_DZ_LUE_HW_RSP_MATCH_TX_DOMAIN_LBN 20
#define	ESF_DZ_LUE_HW_RSP_MATCH_TX_DOMAIN_WIDTH 8
#define	ESF_DZ_LUE_HW_RSP_MATCH_TX_MCAST_LBN 18
#define	ESF_DZ_LUE_HW_RSP_MATCH_TX_MCAST_WIDTH 2
#define	ESF_DZ_LUE_HW_RSP_MATCH_SOFT_LBN 9
#define	ESF_DZ_LUE_HW_RSP_MATCH_SOFT_WIDTH 9
#define	ESF_DZ_LUE_HW_RSP_MATCH_MATCH_LBN 8
#define	ESF_DZ_LUE_HW_RSP_MATCH_MATCH_WIDTH 1
#define	ESF_DZ_LUE_HW_RSP_MATCH_THREAD_ID_LBN 5
#define	ESF_DZ_LUE_HW_RSP_MATCH_THREAD_ID_WIDTH 3
#define	ESF_DZ_LUE_HW_RSP_MATCH_CLIENT_ID_LBN 2
#define	ESF_DZ_LUE_HW_RSP_MATCH_CLIENT_ID_WIDTH 3
#define	ESE_DZ_LUE_MC_ID 7
#define	ESE_DZ_LUE_MATCH_REQ_FIFO_ID 3
#define	ESE_DZ_LUE_TX_DICPU_ID 1
#define	ESE_DZ_LUE_RX_DICPU_ID 0
#define	ESF_DZ_LUE_HW_RSP_MATCH_OP_LBN 0
#define	ESF_DZ_LUE_HW_RSP_MATCH_OP_WIDTH 2
#define	ESE_DZ_LUE_GP_WR 3
#define	ESE_DZ_LUE_GP_RD 2
#define	ESE_DZ_LUE_DIR_REQ 1
#define	ESE_DZ_LUE_MATCH_REQ 0


/* ES_LUE_RCPNTR_TYPE */
#define	ESF_DZ_LUE_RXQ_LBN 14
#define	ESF_DZ_LUE_RXQ_WIDTH 10
#define	ESF_DZ_LUE_RSS_INFO_LBN 8
#define	ESF_DZ_LUE_RSS_INFO_WIDTH 6
#define	ESF_DZ_LUE_DEST_LBN 5
#define	ESF_DZ_LUE_DEST_WIDTH 3
#define	ESF_DZ_LUE_SOFT_LBN 0
#define	ESF_DZ_LUE_SOFT_WIDTH 5


/* ES_LUE_UMSG_LU2DI_HASH_RESP */
#define	ESF_DZ_L2DHR_LASTREC_ENTRY_STATUS_LBN 50
#define	ESF_DZ_L2DHR_LASTREC_ENTRY_STATUS_WIDTH 1
#define	ESF_DZ_L2DHR_MULTITYPE_STATUS_LBN 50
#define	ESF_DZ_L2DHR_MULTITYPE_STATUS_WIDTH 1
#define	ESF_DZ_L2DHR_LASTREC_STATUS_LBN 49
#define	ESF_DZ_L2DHR_LASTREC_STATUS_WIDTH 1
#define	ESF_DZ_L2DHR_MATCH_STATUS_LBN 48
#define	ESF_DZ_L2DHR_MATCH_STATUS_WIDTH 1
#define	ESF_DZ_L2DHR_HASH_LBN 0
#define	ESF_DZ_L2DHR_HASH_WIDTH 32


/* ES_LUE_UMSG_LU2DI_RXLU_MULTI_MATCH_RESP */
#define	ESF_DZ_L2DRMMR_SOFT_LBN 112
#define	ESF_DZ_L2DRMMR_SOFT_WIDTH 9
#define	ESF_DZ_L2DRMMR_RCPNTR_PTR_LBN 96
#define	ESF_DZ_L2DRMMR_RCPNTR_PTR_WIDTH 14
#define	ESF_DZ_L2DRMMR_TX_MCAST_LBN 80
#define	ESF_DZ_L2DRMMR_TX_MCAST_WIDTH 2
#define	ESF_DZ_L2DRMMR_MULTITYPE_STATUS_LBN 67
#define	ESF_DZ_L2DRMMR_MULTITYPE_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMMR_LASTREC_ENTRY_STATUS_LBN 66
#define	ESF_DZ_L2DRMMR_LASTREC_ENTRY_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMMR_LASTREC_STATUS_LBN 65
#define	ESF_DZ_L2DRMMR_LASTREC_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMMR_MATCH_STATUS_LBN 64
#define	ESF_DZ_L2DRMMR_MATCH_STATUS_WIDTH 1


/* ES_LUE_UMSG_LU2DI_RXLU_MULTI_RECORD_RESP */
#define	ESF_DZ_L2DRMRR_SOFT_LBN 112
#define	ESF_DZ_L2DRMRR_SOFT_WIDTH 9
#define	ESF_DZ_L2DRMRR_RCPNTR_PTR_LBN 96
#define	ESF_DZ_L2DRMRR_RCPNTR_PTR_WIDTH 14
#define	ESF_DZ_L2DRMRR_RCPNTR_NUM_LBN 80
#define	ESF_DZ_L2DRMRR_RCPNTR_NUM_WIDTH 3
#define	ESF_DZ_L2DRMRR_MULTITYPE_STATUS_LBN 67
#define	ESF_DZ_L2DRMRR_MULTITYPE_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMRR_LASTREC_ENTRY_STATUS_LBN 66
#define	ESF_DZ_L2DRMRR_LASTREC_ENTRY_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMRR_LASTREC_STATUS_LBN 65
#define	ESF_DZ_L2DRMRR_LASTREC_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMRR_MATCH_STATUS_LBN 64
#define	ESF_DZ_L2DRMRR_MATCH_STATUS_WIDTH 1
#define	ESF_DZ_L2DRMRR_RCPNTR_SOFT_LBN 48
#define	ESF_DZ_L2DRMRR_RCPNTR_SOFT_WIDTH 6
#define	ESF_DZ_L2DRMRR_RCPNTR_RSS_INFO_LBN 32
#define	ESF_DZ_L2DRMRR_RCPNTR_RSS_INFO_WIDTH 5
#define	ESF_DZ_L2DRMRR_RCPNTR_RXQ_LBN 16
#define	ESF_DZ_L2DRMRR_RCPNTR_RXQ_WIDTH 10
#define	ESF_DZ_L2DRMRR_HOST_LBN 7
#define	ESF_DZ_L2DRMRR_HOST_WIDTH 1
#define	ESF_DZ_L2DRMRR_MC_LBN 6
#define	ESF_DZ_L2DRMRR_MC_WIDTH 1
#define	ESF_DZ_L2DRMRR_PORT0_MAC_LBN 5
#define	ESF_DZ_L2DRMRR_PORT0_MAC_WIDTH 1
#define	ESF_DZ_L2DRMRR_PORT1_MAC_LBN 4
#define	ESF_DZ_L2DRMRR_PORT1_MAC_WIDTH 1


/* ES_LUE_UMSG_LU2DI_RXLU_SINGLE_MATCH_RESP */
#define	ESF_DZ_L2DRSMR_MULTITYPE_STATUS_LBN 67
#define	ESF_DZ_L2DRSMR_MULTITYPE_STATUS_WIDTH 1
#define	ESF_DZ_L2DRSMR_LASTREC_ENTRY_STATUS_LBN 66
#define	ESF_DZ_L2DRSMR_LASTREC_ENTRY_STATUS_WIDTH 1
#define	ESF_DZ_L2DRSMR_LASTREC_STATUS_LBN 65
#define	ESF_DZ_L2DRSMR_LASTREC_STATUS_WIDTH 1
#define	ESF_DZ_L2DRSMR_MATCH_STATUS_LBN 64
#define	ESF_DZ_L2DRSMR_MATCH_STATUS_WIDTH 1
#define	ESF_DZ_L2DRSMR_RCPNTR_SOFT_LBN 48
#define	ESF_DZ_L2DRSMR_RCPNTR_SOFT_WIDTH 6
#define	ESF_DZ_L2DRSMR_RCPNTR_RSS_INFO_LBN 32
#define	ESF_DZ_L2DRSMR_RCPNTR_RSS_INFO_WIDTH 5
#define	ESF_DZ_L2DRSMR_RCPNTR_RXQ_LBN 16
#define	ESF_DZ_L2DRSMR_RCPNTR_RXQ_WIDTH 10
#define	ESF_DZ_L2DRSMR_HOST_LBN 7
#define	ESF_DZ_L2DRSMR_HOST_WIDTH 1
#define	ESF_DZ_L2DRSMR_MC_LBN 6
#define	ESF_DZ_L2DRSMR_MC_WIDTH 1
#define	ESF_DZ_L2DRSMR_PORT0_MAC_LBN 5
#define	ESF_DZ_L2DRSMR_PORT0_MAC_WIDTH 1
#define	ESF_DZ_L2DRSMR_PORT1_MAC_LBN 4
#define	ESF_DZ_L2DRSMR_PORT1_MAC_WIDTH 1


/* ES_LUE_UMSG_LU2DI_TXLU_MATCH_RESP */
#define	ESF_DZ_L2DTMR_RCPNTR_SOFT_LBN 112
#define	ESF_DZ_L2DTMR_RCPNTR_SOFT_WIDTH 6
#define	ESF_DZ_L2DTMR_RCPNTR_RSS_INFO_LBN 96
#define	ESF_DZ_L2DTMR_RCPNTR_RSS_INFO_WIDTH 5
#define	ESF_DZ_L2DTMR_RCPNTR__RXQ_LBN 80
#define	ESF_DZ_L2DTMR_RCPNTR__RXQ_WIDTH 10
#define	ESF_DZ_L2DTMR_MULTITYPE_STATUS_LBN 67
#define	ESF_DZ_L2DTMR_MULTITYPE_STATUS_WIDTH 1
#define	ESF_DZ_L2DTMR_LASTREC_ENTRY_STATUS_LBN 66
#define	ESF_DZ_L2DTMR_LASTREC_ENTRY_STATUS_WIDTH 1
#define	ESF_DZ_L2DTMR_LASTREC_STATUS_LBN 65
#define	ESF_DZ_L2DTMR_LASTREC_STATUS_WIDTH 1
#define	ESF_DZ_L2DTMR_MATCH_STATUS_LBN 64
#define	ESF_DZ_L2DTMR_MATCH_STATUS_WIDTH 1
#define	ESF_DZ_L2DTMR_ME_SOFT_LBN 48
#define	ESF_DZ_L2DTMR_ME_SOFT_WIDTH 9
#define	ESF_DZ_L2DTMR_TX_MCAST_LBN 32
#define	ESF_DZ_L2DTMR_TX_MCAST_WIDTH 2
#define	ESF_DZ_L2DTMR_TX_DOMAIN_LBN 16
#define	ESF_DZ_L2DTMR_TX_DOMAIN_WIDTH 8
#define	ESF_DZ_L2DTMR_PORT1_MAC_LBN 6
#define	ESF_DZ_L2DTMR_PORT1_MAC_WIDTH 1
#define	ESF_DZ_L2DTMR_PMEM_LBN 6
#define	ESF_DZ_L2DTMR_PMEM_WIDTH 1
#define	ESF_DZ_L2DTMR_PORT0_MAC_LBN 5
#define	ESF_DZ_L2DTMR_PORT0_MAC_WIDTH 1


/* ES_MC_EVENT */
#define	ESF_DZ_MC_CODE_LBN 60
#define	ESF_DZ_MC_CODE_WIDTH 4
#define	ESF_DZ_MC_OVERRIDE_HOLDOFF_LBN 59
#define	ESF_DZ_MC_OVERRIDE_HOLDOFF_WIDTH 1
#define	ESF_DZ_MC_DROP_EVENT_LBN 58
#define	ESF_DZ_MC_DROP_EVENT_WIDTH 1
#define	ESF_DZ_MC_SOFT_DW0_LBN 0
#define	ESF_DZ_MC_SOFT_DW0_WIDTH 32
#define	ESF_DZ_MC_SOFT_DW1_LBN 32
#define	ESF_DZ_MC_SOFT_DW1_WIDTH 26
#define	ESF_DZ_MC_SOFT_LBN 0
#define	ESF_DZ_MC_SOFT_WIDTH 58


/* ES_MC_XGMAC_FLTR_RULE_DEF */
#define	ESF_DZ_MC_XFRC_MODE_LBN 416
#define	ESF_DZ_MC_XFRC_MODE_WIDTH 1
#define	ESE_DZ_MC_XFRC_MODE_LAYERED 1
#define	ESE_DZ_MC_XFRC_MODE_SIMPLE 0
#define	ESF_DZ_MC_XFRC_HASH_LBN 384
#define	ESF_DZ_MC_XFRC_HASH_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW0_LBN 256
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW0_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW1_LBN 288
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW1_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW2_LBN 320
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW2_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW3_LBN 352
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_DW3_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_LBN 256
#define	ESF_DZ_MC_XFRC_LAYER4_BYTE_MASK_WIDTH 128
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW0_LBN 128
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW0_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW1_LBN 160
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW1_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW2_LBN 192
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW2_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW3_LBN 224
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_DW3_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_LBN 128
#define	ESF_DZ_MC_XFRC_LAYER3_BYTE_MASK_WIDTH 128
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW0_LBN 0
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW0_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW1_LBN 32
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW1_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW2_LBN 64
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW2_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW3_LBN 96
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_DW3_WIDTH 32
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_LBN 0
#define	ESF_DZ_MC_XFRC_LAYER2_OR_SIMPLE_BYTE_MASK_WIDTH 128


/* ES_RX_EVENT */
#define	ESF_DZ_RX_CODE_LBN 60
#define	ESF_DZ_RX_CODE_WIDTH 4
#define	ESF_DZ_RX_OVERRIDE_HOLDOFF_LBN 59
#define	ESF_DZ_RX_OVERRIDE_HOLDOFF_WIDTH 1
#define	ESF_DZ_RX_DROP_EVENT_LBN 58
#define	ESF_DZ_RX_DROP_EVENT_WIDTH 1
#define	ESF_DZ_RX_EV_RSVD2_LBN 55
#define	ESF_DZ_RX_EV_RSVD2_WIDTH 3
#define	ESF_DZ_RX_EV_SOFT2_LBN 52
#define	ESF_DZ_RX_EV_SOFT2_WIDTH 3
#define	ESF_DZ_RX_DSC_PTR_LBITS_LBN 48
#define	ESF_DZ_RX_DSC_PTR_LBITS_WIDTH 4
#define	ESF_DZ_RX_L4_CLASS_LBN 45
#define	ESF_DZ_RX_L4_CLASS_WIDTH 3
#define	ESE_DZ_L4_CLASS_RSVD7 7
#define	ESE_DZ_L4_CLASS_RSVD6 6
#define	ESE_DZ_L4_CLASS_RSVD5 5
#define	ESE_DZ_L4_CLASS_RSVD4 4
#define	ESE_DZ_L4_CLASS_RSVD3 3
#define	ESE_DZ_L4_CLASS_UDP 2
#define	ESE_DZ_L4_CLASS_TCP 1
#define	ESE_DZ_L4_CLASS_UNKNOWN 0
#define	ESF_DZ_RX_L3_CLASS_LBN 42
#define	ESF_DZ_RX_L3_CLASS_WIDTH 3
#define	ESE_DZ_L3_CLASS_RSVD7 7
#define	ESE_DZ_L3_CLASS_IP6_FRAG 6
#define	ESE_DZ_L3_CLASS_ARP 5
#define	ESE_DZ_L3_CLASS_IP4_FRAG 4
#define	ESE_DZ_L3_CLASS_FCOE 3
#define	ESE_DZ_L3_CLASS_IP6 2
#define	ESE_DZ_L3_CLASS_IP4 1
#define	ESE_DZ_L3_CLASS_UNKNOWN 0
#define	ESF_DZ_RX_ETH_TAG_CLASS_LBN 39
#define	ESF_DZ_RX_ETH_TAG_CLASS_WIDTH 3
#define	ESE_DZ_ETH_TAG_CLASS_RSVD7 7
#define	ESE_DZ_ETH_TAG_CLASS_RSVD6 6
#define	ESE_DZ_ETH_TAG_CLASS_RSVD5 5
#define	ESE_DZ_ETH_TAG_CLASS_RSVD4 4
#define	ESE_DZ_ETH_TAG_CLASS_RSVD3 3
#define	ESE_DZ_ETH_TAG_CLASS_VLAN2 2
#define	ESE_DZ_ETH_TAG_CLASS_VLAN1 1
#define	ESE_DZ_ETH_TAG_CLASS_NONE 0
#define	ESF_DZ_RX_ETH_BASE_CLASS_LBN 36
#define	ESF_DZ_RX_ETH_BASE_CLASS_WIDTH 3
#define	ESE_DZ_ETH_BASE_CLASS_LLC_SNAP 2
#define	ESE_DZ_ETH_BASE_CLASS_LLC 1
#define	ESE_DZ_ETH_BASE_CLASS_ETH2 0
#define	ESF_DZ_RX_MAC_CLASS_LBN 35
#define	ESF_DZ_RX_MAC_CLASS_WIDTH 1
#define	ESE_DZ_MAC_CLASS_MCAST 1
#define	ESE_DZ_MAC_CLASS_UCAST 0
#define	ESF_DZ_RX_EV_SOFT1_LBN 32
#define	ESF_DZ_RX_EV_SOFT1_WIDTH 3
#define	ESF_DZ_RX_EV_RSVD1_LBN 30
#define	ESF_DZ_RX_EV_RSVD1_WIDTH 2
#define	ESF_DZ_RX_ECC_ERR_LBN 29
#define	ESF_DZ_RX_ECC_ERR_WIDTH 1
#define	ESF_DZ_RX_CRC1_ERR_LBN 28
#define	ESF_DZ_RX_CRC1_ERR_WIDTH 1
#define	ESF_DZ_RX_CRC0_ERR_LBN 27
#define	ESF_DZ_RX_CRC0_ERR_WIDTH 1
#define	ESF_DZ_RX_TCPUDP_CKSUM_ERR_LBN 26
#define	ESF_DZ_RX_TCPUDP_CKSUM_ERR_WIDTH 1
#define	ESF_DZ_RX_IPCKSUM_ERR_LBN 25
#define	ESF_DZ_RX_IPCKSUM_ERR_WIDTH 1
#define	ESF_DZ_RX_ECRC_ERR_LBN 24
#define	ESF_DZ_RX_ECRC_ERR_WIDTH 1
#define	ESF_DZ_RX_QLABEL_LBN 16
#define	ESF_DZ_RX_QLABEL_WIDTH 8
#define	ESF_DZ_RX_PARSE_INCOMPLETE_LBN 15
#define	ESF_DZ_RX_PARSE_INCOMPLETE_WIDTH 1
#define	ESF_DZ_RX_CONT_LBN 14
#define	ESF_DZ_RX_CONT_WIDTH 1
#define	ESF_DZ_RX_BYTES_LBN 0
#define	ESF_DZ_RX_BYTES_WIDTH 14


/* ES_RX_KER_DESC */
#define	ESF_DZ_RX_KER_RESERVED_LBN 62
#define	ESF_DZ_RX_KER_RESERVED_WIDTH 2
#define	ESF_DZ_RX_KER_BYTE_CNT_LBN 48
#define	ESF_DZ_RX_KER_BYTE_CNT_WIDTH 14
#define	ESF_DZ_RX_KER_BUF_ADDR_DW0_LBN 0
#define	ESF_DZ_RX_KER_BUF_ADDR_DW0_WIDTH 32
#define	ESF_DZ_RX_KER_BUF_ADDR_DW1_LBN 32
#define	ESF_DZ_RX_KER_BUF_ADDR_DW1_WIDTH 16
#define	ESF_DZ_RX_KER_BUF_ADDR_LBN 0
#define	ESF_DZ_RX_KER_BUF_ADDR_WIDTH 48


/* ES_RX_USER_DESC */
#define	ESF_DZ_RX_USR_RESERVED_LBN 62
#define	ESF_DZ_RX_USR_RESERVED_WIDTH 2
#define	ESF_DZ_RX_USR_BYTE_CNT_LBN 48
#define	ESF_DZ_RX_USR_BYTE_CNT_WIDTH 14
#define	ESF_DZ_RX_USR_BUF_PAGE_SIZE_LBN 44
#define	ESF_DZ_RX_USR_BUF_PAGE_SIZE_WIDTH 4
#define	ESE_DZ_USR_BUF_PAGE_SZ_4MB 10
#define	ESE_DZ_USR_BUF_PAGE_SZ_1MB 8
#define	ESE_DZ_USR_BUF_PAGE_SZ_64KB 4
#define	ESE_DZ_USR_BUF_PAGE_SZ_4KB 0
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_DW0_LBN 0
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_DW0_WIDTH 32
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_DW1_LBN 32
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_DW1_WIDTH 12
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_LBN 0
#define	ESF_DZ_RX_USR_BUF_ID_OFFSET_WIDTH 44
#define	ESF_DZ_RX_USR_4KBPS_BUF_ID_LBN 12
#define	ESF_DZ_RX_USR_4KBPS_BUF_ID_WIDTH 32
#define	ESF_DZ_RX_USR_64KBPS_BUF_ID_LBN 16
#define	ESF_DZ_RX_USR_64KBPS_BUF_ID_WIDTH 28
#define	ESF_DZ_RX_USR_1MBPS_BUF_ID_LBN 20
#define	ESF_DZ_RX_USR_1MBPS_BUF_ID_WIDTH 24
#define	ESF_DZ_RX_USR_4MBPS_BUF_ID_LBN 22
#define	ESF_DZ_RX_USR_4MBPS_BUF_ID_WIDTH 22
#define	ESF_DZ_RX_USR_4MBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_RX_USR_4MBPS_BYTE_OFFSET_WIDTH 22
#define	ESF_DZ_RX_USR_1MBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_RX_USR_1MBPS_BYTE_OFFSET_WIDTH 20
#define	ESF_DZ_RX_USR_64KBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_RX_USR_64KBPS_BYTE_OFFSET_WIDTH 16
#define	ESF_DZ_RX_USR_4KBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_RX_USR_4KBPS_BYTE_OFFSET_WIDTH 12


/* ES_RX_U_QSTATE_TBL0_ENTRY */
#define	ESF_DZ_RX_U_DC_FILL_LBN 112
#define	ESF_DZ_RX_U_DC_FILL_WIDTH 7
#define	ESF_DZ_RX_U_SOFT7_B1R1_0_LBN 112
#define	ESF_DZ_RX_U_SOFT7_B1R1_0_WIDTH 7
#define	ESF_DZ_RX_U_DSCR_HW_RPTR_LBN 96
#define	ESF_DZ_RX_U_DSCR_HW_RPTR_WIDTH 12
#define	ESF_DZ_RX_U_SOFT12_B1R2_0_LBN 96
#define	ESF_DZ_RX_U_SOFT12_B1R2_0_WIDTH 12
#define	ESF_DZ_RX_U_DC_RPTR_LBN 80
#define	ESF_DZ_RX_U_DC_RPTR_WIDTH 6
#define	ESF_DZ_RX_U_SOFT6_B1R1_0_LBN 80
#define	ESF_DZ_RX_U_SOFT6_B1R1_0_WIDTH 6
#define	ESF_DZ_RX_U_NOTIFY_PENDING_LBN 70
#define	ESF_DZ_RX_U_NOTIFY_PENDING_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_6_LBN 70
#define	ESF_DZ_RX_U_SOFT1_B1R0_6_WIDTH 1
#define	ESF_DZ_RX_U_DATA_ACTIVE_LBN 69
#define	ESF_DZ_RX_U_DATA_ACTIVE_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_5_LBN 69
#define	ESF_DZ_RX_U_SOFT1_B1R0_5_WIDTH 1
#define	ESF_DZ_RX_U_FAST_PATH_LBN 68
#define	ESF_DZ_RX_U_FAST_PATH_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_4_LBN 68
#define	ESF_DZ_RX_U_SOFT1_B1R0_4_WIDTH 1
#define	ESF_DZ_RX_U_NO_FLUSH_LBN 67
#define	ESF_DZ_RX_U_NO_FLUSH_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_3_LBN 67
#define	ESF_DZ_RX_U_SOFT1_B1R0_3_WIDTH 1
#define	ESF_DZ_RX_U_DESC_ACTIVE_LBN 66
#define	ESF_DZ_RX_U_DESC_ACTIVE_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_2_LBN 66
#define	ESF_DZ_RX_U_SOFT1_B1R0_2_WIDTH 1
#define	ESF_DZ_RX_U_HDR_SPLIT_LBN 65
#define	ESF_DZ_RX_U_HDR_SPLIT_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_1_LBN 65
#define	ESF_DZ_RX_U_SOFT1_B1R0_1_WIDTH 1
#define	ESF_DZ_RX_U_Q_ENABLE_LBN 64
#define	ESF_DZ_RX_U_Q_ENABLE_WIDTH 1
#define	ESF_DZ_RX_U_SOFT1_B1R0_0_LBN 64
#define	ESF_DZ_RX_U_SOFT1_B1R0_0_WIDTH 1
#define	ESF_DZ_RX_U_UPD_CRC_MODE_LBN 29
#define	ESF_DZ_RX_U_UPD_CRC_MODE_WIDTH 3
#define	ESE_DZ_C2RIP_FCOIP_MPA 5
#define	ESE_DZ_C2RIP_FCOIP_FCOE 4
#define	ESE_DZ_C2RIP_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_C2RIP_ISCSI_HDR 2
#define	ESE_DZ_C2RIP_FCOE 1
#define	ESE_DZ_C2RIP_OFF 0
#define	ESF_DZ_RX_U_SOFT16_B0R1_LBN 16
#define	ESF_DZ_RX_U_SOFT16_B0R1_WIDTH 16
#define	ESF_DZ_RX_U_BIU_ARGS_LBN 16
#define	ESF_DZ_RX_U_BIU_ARGS_WIDTH 13
#define	ESF_DZ_RX_U_EV_QID_LBN 5
#define	ESF_DZ_RX_U_EV_QID_WIDTH 11
#define	ESF_DZ_RX_U_SOFT16_B0R0_LBN 0
#define	ESF_DZ_RX_U_SOFT16_B0R0_WIDTH 16
#define	ESF_DZ_RX_U_EV_QLABEL_LBN 0
#define	ESF_DZ_RX_U_EV_QLABEL_WIDTH 5


/* ES_RX_U_QSTATE_TBL1_ENTRY */
#define	ESF_DZ_RX_U_DSCR_BASE_PAGE_ID_LBN 64
#define	ESF_DZ_RX_U_DSCR_BASE_PAGE_ID_WIDTH 18
#define	ESF_DZ_RX_U_SOFT18_B1R0_0_LBN 64
#define	ESF_DZ_RX_U_SOFT18_B1R0_0_WIDTH 18
#define	ESF_DZ_RX_U_QST1_SPARE_LBN 52
#define	ESF_DZ_RX_U_QST1_SPARE_WIDTH 12
#define	ESF_DZ_RX_U_SOFT16_B0R3_0_LBN 48
#define	ESF_DZ_RX_U_SOFT16_B0R3_0_WIDTH 16
#define	ESF_DZ_RX_U_PKT_EDIT_LBN 51
#define	ESF_DZ_RX_U_PKT_EDIT_WIDTH 1
#define	ESF_DZ_RX_U_DOORBELL_ENABLED_LBN 50
#define	ESF_DZ_RX_U_DOORBELL_ENABLED_WIDTH 1
#define	ESF_DZ_RX_U_WORK_PENDING_LBN 49
#define	ESF_DZ_RX_U_WORK_PENDING_WIDTH 1
#define	ESF_DZ_RX_U_ERROR_LBN 48
#define	ESF_DZ_RX_U_ERROR_WIDTH 1
#define	ESF_DZ_RX_U_DSCR_SW_WPTR_LBN 32
#define	ESF_DZ_RX_U_DSCR_SW_WPTR_WIDTH 12
#define	ESF_DZ_RX_U_SOFT12_B0R2_0_LBN 32
#define	ESF_DZ_RX_U_SOFT12_B0R2_0_WIDTH 12
#define	ESF_DZ_RX_U_OWNER_ID_LBN 16
#define	ESF_DZ_RX_U_OWNER_ID_WIDTH 12
#define	ESF_DZ_RX_U_SOFT12_B0R1_0_LBN 16
#define	ESF_DZ_RX_U_SOFT12_B0R1_0_WIDTH 12
#define	ESF_DZ_RX_U_DSCR_SIZE_LBN 0
#define	ESF_DZ_RX_U_DSCR_SIZE_WIDTH 3
#define	ESE_DZ_RX_DSCR_SIZE_512 7
#define	ESE_DZ_RX_DSCR_SIZE_1K 6
#define	ESE_DZ_RX_DSCR_SIZE_2K 5
#define	ESE_DZ_RX_DSCR_SIZE_4K 4
#define	ESF_DZ_RX_U_SOFT3_B0R0_0_LBN 0
#define	ESF_DZ_RX_U_SOFT3_B0R0_0_WIDTH 3


/* ES_SMC_BUFTBL_CNTRL_ENTRY */
#define	ESF_DZ_SMC_SW_CNTXT_DW0_LBN 16
#define	ESF_DZ_SMC_SW_CNTXT_DW0_WIDTH 32
#define	ESF_DZ_SMC_SW_CNTXT_DW1_LBN 48
#define	ESF_DZ_SMC_SW_CNTXT_DW1_WIDTH 24
#define	ESF_DZ_SMC_SW_CNTXT_LBN 16
#define	ESF_DZ_SMC_SW_CNTXT_WIDTH 56
#define	ESF_DZ_SMC_PAGE_SIZE_LBN 12
#define	ESF_DZ_SMC_PAGE_SIZE_WIDTH 4
#define	ESF_DZ_SMC_OWNER_ID_LBN 0
#define	ESF_DZ_SMC_OWNER_ID_WIDTH 12


/* ES_SMC_BUFTBL_TRANSL_ENTRY */
#define	ESF_DZ_SMC_PAGE_INDEX0_DW0_LBN 36
#define	ESF_DZ_SMC_PAGE_INDEX0_DW0_WIDTH 32
#define	ESF_DZ_SMC_PAGE_INDEX0_DW1_LBN 68
#define	ESF_DZ_SMC_PAGE_INDEX0_DW1_WIDTH 4
#define	ESF_DZ_SMC_PAGE_INDEX0_LBN 36
#define	ESF_DZ_SMC_PAGE_INDEX0_WIDTH 36
#define	ESF_DZ_SMC_PAGE_INDEX1_DW0_LBN 0
#define	ESF_DZ_SMC_PAGE_INDEX1_DW0_WIDTH 32
#define	ESF_DZ_SMC_PAGE_INDEX1_DW1_LBN 32
#define	ESF_DZ_SMC_PAGE_INDEX1_DW1_WIDTH 4
#define	ESF_DZ_SMC_PAGE_INDEX1_LBN 0
#define	ESF_DZ_SMC_PAGE_INDEX1_WIDTH 36


/* ES_SMC_DSCR_CACHE_ENTRY */
#define	ESF_DZ_SMC_BTE_PAD_LBN 64
#define	ESF_DZ_SMC_BTE_PAD_WIDTH 8
#define	ESF_DZ_SMC_DSCR_DW0_LBN 0
#define	ESF_DZ_SMC_DSCR_DW0_WIDTH 32
#define	ESF_DZ_SMC_DSCR_DW1_LBN 32
#define	ESF_DZ_SMC_DSCR_DW1_WIDTH 32
#define	ESF_DZ_SMC_DSCR_LBN 0
#define	ESF_DZ_SMC_DSCR_WIDTH 64


/* ES_SMC_GEN_STORAGE_ENTRY */
#define	ESF_DZ_SMC_DATA_DW0_LBN 0
#define	ESF_DZ_SMC_DATA_DW0_WIDTH 32
#define	ESF_DZ_SMC_DATA_DW1_LBN 32
#define	ESF_DZ_SMC_DATA_DW1_WIDTH 32
#define	ESF_DZ_SMC_DATA_DW2_LBN 64
#define	ESF_DZ_SMC_DATA_DW2_WIDTH 8
#define	ESF_DZ_SMC_DATA_LBN 0
#define	ESF_DZ_SMC_DATA_WIDTH 72


/* ES_SMC_MSG_BASE_REQ */
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW0_LBN 11
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW0_WIDTH 32
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW1_LBN 43
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW1_WIDTH 32
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW2_LBN 75
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_DW2_WIDTH 26
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_LBN 11
#define	ESF_DZ_MC2S_BASE_REQ_MSG_DATA_WIDTH 90
#define	ESF_DZ_MC2S_BASE_SOFT_LBN 7
#define	ESF_DZ_MC2S_BASE_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_BASE_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_BASE_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_BASE_OP_LBN 0
#define	ESF_DZ_MC2S_BASE_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_RESP_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_RESP_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_RESP_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_RESP_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0
#define	ESE_DZ_SMC_RESP_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_BUFTBL_LOOKUP_REQ */
#define	ESF_DZ_MC2S_BL_BUF_ID_LBN 28
#define	ESF_DZ_MC2S_BL_BUF_ID_WIDTH 18
#define	ESF_DZ_MC2S_BL_EXP_PAGE_SIZE_LBN 24
#define	ESF_DZ_MC2S_BL_EXP_PAGE_SIZE_WIDTH 4
#define	ESE_DZ_SMC_PAGE_SIZE_4M 10
#define	ESE_DZ_SMC_PAGE_SIZE_1M 8
#define	ESE_DZ_SMC_PAGE_SIZE_64K 4
#define	ESE_DZ_SMC_PAGE_SIZE_4K 0
#define	ESF_DZ_MC2S_BL_EXP_OWNER_ID_LBN 12
#define	ESF_DZ_MC2S_BL_EXP_OWNER_ID_WIDTH 12
#define	ESF_DZ_MC2S_BL_REFLECT_LBN 11
#define	ESF_DZ_MC2S_BL_REFLECT_WIDTH 1
#define	ESF_DZ_MC2S_BL_SOFT_LBN 7
#define	ESF_DZ_MC2S_BL_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_BL_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_BL_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_BL_OP_LBN 0
#define	ESF_DZ_MC2S_BL_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_BUFTBL_LOOKUP_RESP */
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_DW0_LBN 12
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_DW0_WIDTH 32
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_DW1_LBN 44
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_DW1_WIDTH 4
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_LBN 12
#define	ESF_DZ_S2MC_BL_BUFTBL_ENTRY_WIDTH 36
#define	ESF_DZ_S2MC_BL_FAIL_LBN 11
#define	ESF_DZ_S2MC_BL_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_BL_SOFT_LBN 7
#define	ESF_DZ_S2MC_BL_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_BL_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_BL_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_BL_OP_LBN 0
#define	ESF_DZ_S2MC_BL_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_DSCR_RD_REQ */
#define	ESF_DZ_MC2S_DR_DSCR_OFST_LBN 24
#define	ESF_DZ_MC2S_DR_DSCR_OFST_WIDTH 6
#define	ESF_DZ_MC2S_DR_QID_LBN 13
#define	ESF_DZ_MC2S_DR_QID_WIDTH 11
#define	ESF_DZ_MC2S_DR_IS_TX_LBN 12
#define	ESF_DZ_MC2S_DR_IS_TX_WIDTH 1
#define	ESF_DZ_MC2S_DR_REFLECT_LBN 11
#define	ESF_DZ_MC2S_DR_REFLECT_WIDTH 1
#define	ESF_DZ_MC2S_DR_SOFT_LBN 7
#define	ESF_DZ_MC2S_DR_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_DR_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_DR_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_DR_OP_LBN 0
#define	ESF_DZ_MC2S_DR_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_DSCR_RD_RESP */
#define	ESF_DZ_S2MC_DR_DSCR_DW0_LBN 12
#define	ESF_DZ_S2MC_DR_DSCR_DW0_WIDTH 32
#define	ESF_DZ_S2MC_DR_DSCR_DW1_LBN 44
#define	ESF_DZ_S2MC_DR_DSCR_DW1_WIDTH 32
#define	ESF_DZ_S2MC_DR_DSCR_LBN 12
#define	ESF_DZ_S2MC_DR_DSCR_WIDTH 64
#define	ESF_DZ_S2MC_DR_FAIL_LBN 11
#define	ESF_DZ_S2MC_DR_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_DR_SOFT_LBN 7
#define	ESF_DZ_S2MC_DR_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_DR_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_DR_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_DR_OP_LBN 0
#define	ESF_DZ_S2MC_DR_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_DSCR_WR_REQ */
#define	ESF_DZ_MC2S_DW_DSCR_DW0_LBN 30
#define	ESF_DZ_MC2S_DW_DSCR_DW0_WIDTH 32
#define	ESF_DZ_MC2S_DW_DSCR_DW1_LBN 62
#define	ESF_DZ_MC2S_DW_DSCR_DW1_WIDTH 32
#define	ESF_DZ_MC2S_DW_DSCR_LBN 30
#define	ESF_DZ_MC2S_DW_DSCR_WIDTH 64
#define	ESF_DZ_MC2S_DW_DSCR_OFST_LBN 24
#define	ESF_DZ_MC2S_DW_DSCR_OFST_WIDTH 6
#define	ESF_DZ_MC2S_DW_QID_LBN 13
#define	ESF_DZ_MC2S_DW_QID_WIDTH 11
#define	ESF_DZ_MC2S_DW_IS_TX_LBN 12
#define	ESF_DZ_MC2S_DW_IS_TX_WIDTH 1
#define	ESF_DZ_MC2S_DW_REFLECT_LBN 11
#define	ESF_DZ_MC2S_DW_REFLECT_WIDTH 1
#define	ESF_DZ_MC2S_DW_SOFT_LBN 7
#define	ESF_DZ_MC2S_DW_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_DW_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_DW_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_DW_OP_LBN 0
#define	ESF_DZ_MC2S_DW_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_DSCR_WR_RESP */
#define	ESF_DZ_S2MC_DW_FAIL_LBN 11
#define	ESF_DZ_S2MC_DW_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_DW_SOFT_LBN 7
#define	ESF_DZ_S2MC_DW_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_DW_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_DW_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_DW_OP_LBN 0
#define	ESF_DZ_S2MC_DW_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_RD_REQ */
#define	ESF_DZ_MC2S_RD_ADDR_LBN 12
#define	ESF_DZ_MC2S_RD_ADDR_WIDTH 17
#define	ESF_DZ_MC2S_RD_REFLECT_LBN 11
#define	ESF_DZ_MC2S_RD_REFLECT_WIDTH 1
#define	ESF_DZ_MC2S_RD_SOFT_LBN 7
#define	ESF_DZ_MC2S_RD_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_RD_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_RD_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_RD_OP_LBN 0
#define	ESF_DZ_MC2S_RD_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_RD_RESP */
#define	ESF_DZ_S2MC_RD_DATA_DW0_LBN 12
#define	ESF_DZ_S2MC_RD_DATA_DW0_WIDTH 32
#define	ESF_DZ_S2MC_RD_DATA_DW1_LBN 44
#define	ESF_DZ_S2MC_RD_DATA_DW1_WIDTH 32
#define	ESF_DZ_S2MC_RD_DATA_DW2_LBN 76
#define	ESF_DZ_S2MC_RD_DATA_DW2_WIDTH 8
#define	ESF_DZ_S2MC_RD_DATA_LBN 12
#define	ESF_DZ_S2MC_RD_DATA_WIDTH 72
#define	ESF_DZ_S2MC_RD_FAIL_LBN 11
#define	ESF_DZ_S2MC_RD_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_RD_SOFT_LBN 7
#define	ESF_DZ_S2MC_RD_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_RD_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_RD_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_RD_OP_LBN 0
#define	ESF_DZ_S2MC_RD_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_RESP */
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW0_LBN 12
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW0_WIDTH 32
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW1_LBN 44
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW1_WIDTH 32
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW2_LBN 76
#define	ESF_DZ_S2MC_BASE_RSP_DATA_DW2_WIDTH 8
#define	ESF_DZ_S2MC_BASE_RSP_DATA_LBN 12
#define	ESF_DZ_S2MC_BASE_RSP_DATA_WIDTH 72
#define	ESF_DZ_S2MC_BASE_FAIL_LBN 11
#define	ESF_DZ_S2MC_BASE_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_BASE_SOFT_LBN 7
#define	ESF_DZ_S2MC_BASE_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_BASE_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_BASE_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_BASE_OP_LBN 0
#define	ESF_DZ_S2MC_BASE_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_WR_REQ */
#define	ESF_DZ_MC2S_WR_DATA_DW0_LBN 29
#define	ESF_DZ_MC2S_WR_DATA_DW0_WIDTH 32
#define	ESF_DZ_MC2S_WR_DATA_DW1_LBN 61
#define	ESF_DZ_MC2S_WR_DATA_DW1_WIDTH 32
#define	ESF_DZ_MC2S_WR_DATA_DW2_LBN 93
#define	ESF_DZ_MC2S_WR_DATA_DW2_WIDTH 8
#define	ESF_DZ_MC2S_WR_DATA_LBN 29
#define	ESF_DZ_MC2S_WR_DATA_WIDTH 72
#define	ESF_DZ_MC2S_WR_ADDR_LBN 12
#define	ESF_DZ_MC2S_WR_ADDR_WIDTH 17
#define	ESF_DZ_MC2S_WR_REFLECT_LBN 11
#define	ESF_DZ_MC2S_WR_REFLECT_WIDTH 1
#define	ESF_DZ_MC2S_WR_SOFT_LBN 7
#define	ESF_DZ_MC2S_WR_SOFT_WIDTH 4
#define	ESF_DZ_MC2S_WR_CLIENT_ID_LBN 3
#define	ESF_DZ_MC2S_WR_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_MC2S_WR_OP_LBN 0
#define	ESF_DZ_MC2S_WR_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_SMC_MSG_WR_RESP */
#define	ESF_DZ_S2MC_WR_FAIL_LBN 11
#define	ESF_DZ_S2MC_WR_FAIL_WIDTH 1
#define	ESF_DZ_S2MC_WR_SOFT_LBN 7
#define	ESF_DZ_S2MC_WR_SOFT_WIDTH 4
#define	ESF_DZ_S2MC_WR_CLIENT_ID_LBN 3
#define	ESF_DZ_S2MC_WR_CLIENT_ID_WIDTH 4
#define	ESE_DZ_SMC_MACRO_ENGINE_ID 15
#define	ESE_DZ_SMC_TX_DICPU_ID 14
#define	ESE_DZ_SMC_RX_DICPU_ID 13
#define	ESE_DZ_SMC_MC_ID 12
#define	ESE_DZ_SMC_DL_ID 10
#define	ESE_DZ_SMC_EV_ID 8
#define	ESE_DZ_SMC_TX_DPCPU1_ID 5
#define	ESE_DZ_SMC_TX_DPCPU0_ID 4
#define	ESE_DZ_SMC_RX_DPCPU_ID 0
#define	ESF_DZ_S2MC_WR_OP_LBN 0
#define	ESF_DZ_S2MC_WR_OP_WIDTH 3
#define	ESE_DZ_SMC_REQ_WR 4
#define	ESE_DZ_SMC_REQ_RD 3
#define	ESE_DZ_SMC_REQ_DSCR_WRITE 2
#define	ESE_DZ_SMC_REQ_DSCR_READ 1
#define	ESE_DZ_SMC_REQ_BUFTBL_LOOKUP 0


/* ES_TX_EVENT */
#define	ESF_DZ_TX_CODE_LBN 60
#define	ESF_DZ_TX_CODE_WIDTH 4
#define	ESF_DZ_TX_OVERRIDE_HOLDOFF_LBN 59
#define	ESF_DZ_TX_OVERRIDE_HOLDOFF_WIDTH 1
#define	ESF_DZ_TX_DROP_EVENT_LBN 58
#define	ESF_DZ_TX_DROP_EVENT_WIDTH 1
#define	ESF_DZ_TX_EV_RSVD_LBN 48
#define	ESF_DZ_TX_EV_RSVD_WIDTH 10
#define	ESF_DZ_TX_SOFT2_LBN 32
#define	ESF_DZ_TX_SOFT2_WIDTH 16
#define	ESF_DZ_TX_SOFT1_LBN 24
#define	ESF_DZ_TX_SOFT1_WIDTH 8
#define	ESF_DZ_TX_QLABEL_LBN 16
#define	ESF_DZ_TX_QLABEL_WIDTH 8
#define	ESF_DZ_TX_DESCR_INDX_LBN 0
#define	ESF_DZ_TX_DESCR_INDX_WIDTH 16


/* ES_TX_KER_DESC */
#define	ESF_DZ_TX_KER_TYPE_LBN 63
#define	ESF_DZ_TX_KER_TYPE_WIDTH 1
#define	ESF_DZ_TX_KER_CONT_LBN 62
#define	ESF_DZ_TX_KER_CONT_WIDTH 1
#define	ESF_DZ_TX_KER_BYTE_CNT_LBN 48
#define	ESF_DZ_TX_KER_BYTE_CNT_WIDTH 14
#define	ESF_DZ_TX_KER_BUF_ADDR_DW0_LBN 0
#define	ESF_DZ_TX_KER_BUF_ADDR_DW0_WIDTH 32
#define	ESF_DZ_TX_KER_BUF_ADDR_DW1_LBN 32
#define	ESF_DZ_TX_KER_BUF_ADDR_DW1_WIDTH 16
#define	ESF_DZ_TX_KER_BUF_ADDR_LBN 0
#define	ESF_DZ_TX_KER_BUF_ADDR_WIDTH 48


/* ES_TX_OPTION_DESC */
#define	ESF_DZ_TX_DESC_IS_OPT_LBN 63
#define	ESF_DZ_TX_DESC_IS_OPT_WIDTH 1
#define	ESF_DZ_TX_OPTION_TYPE_LBN 60
#define	ESF_DZ_TX_OPTION_TYPE_WIDTH 3
#define	ESE_DZ_TX_OPTION_DESC_TSO 4
#define	ESE_DZ_TX_OPTION_DESC_CRC_CSUM 0
#define	ESF_DZ_TX_TSO_TCP_FLAGS_LBN 48
#define	ESF_DZ_TX_TSO_TCP_FLAGS_WIDTH 8
#define	ESF_DZ_TX_TSO_TCP_MSS_LBN 32
#define	ESF_DZ_TX_TSO_TCP_MSS_WIDTH 16
#define	ESF_DZ_TX_TSO_TCP_SEQNO_LBN 0
#define	ESF_DZ_TX_TSO_TCP_SEQNO_WIDTH 32
#define	ESF_DZ_TX_OPTION_CRC_MODE_LBN 2
#define	ESF_DZ_TX_OPTION_CRC_MODE_WIDTH 3
#define	ESE_DZ_TX_OPTION_CRC_FCOIP_MPA 5
#define	ESE_DZ_TX_OPTION_CRC_FCOIP_FCOE 4
#define	ESE_DZ_TX_OPTION_CRC_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_TX_OPTION_CRC_ISCSI_HDR 2
#define	ESE_DZ_TX_OPTION_CRC_FCOE 1
#define	ESE_DZ_TX_OPTION_CRC_OFF 0
#define	ESF_DZ_TX_OPTION_UDP_TCP_CSUM_LBN 1
#define	ESF_DZ_TX_OPTION_UDP_TCP_CSUM_WIDTH 1
#define	ESF_DZ_TX_OPTION_IP_CSUM_LBN 0
#define	ESF_DZ_TX_OPTION_IP_CSUM_WIDTH 1


/* ES_TX_PACER_BASE_MSG */
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW0_LBN 11
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW0_WIDTH 32
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW1_LBN 43
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW1_WIDTH 32
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW2_LBN 75
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_DW2_WIDTH 23
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_LBN 11
#define	ESF_DZ_TXP_BASE_REQ_MSG_DATA_WIDTH 87
#define	ESF_DZ_TXP_BASE_OP_LBN 2
#define	ESF_DZ_TXP_BASE_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BASE_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BASE_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_BKT_D_R_REQ */
#define	ESF_DZ_TXP_BKT_D_R_REQ_FRM_LEN_LBN 45
#define	ESF_DZ_TXP_BKT_D_R_REQ_FRM_LEN_WIDTH 14
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT2_LBN 35
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT2_WIDTH 10
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT1_LBN 25
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT1_WIDTH 10
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT0_LBN 15
#define	ESF_DZ_TXP_BKT_D_R_REQ_MAX_BKT0_WIDTH 10
#define	ESF_DZ_TXP_BKT_D_R_REQ_MIN_BKT_LBN 5
#define	ESF_DZ_TXP_BKT_D_R_REQ_MIN_BKT_WIDTH 10
#define	ESF_DZ_TXP_BKT_D_R_REQ_OP_LBN 2
#define	ESF_DZ_TXP_BKT_D_R_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BKT_D_R_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BKT_D_R_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_BKT_TBL_D_R_RSP */
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_DUE_TIME_WITH_MIN_BKT_LBN 21
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_DUE_TIME_WITH_MIN_BKT_WIDTH 26
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_DUE_TIME_LBN 5
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_DUE_TIME_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_OP_LBN 2
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BKT_TBL_D_R_RSP_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_BKT_TBL_RD_REQ */
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_BKT_ID_LBN 5
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_BKT_ID_WIDTH 10
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_OP_LBN 2
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BKT_TBL_RD_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_BKT_TBL_RD_RSP */
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_IDLE_LBN 97
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_IDLE_WIDTH 1
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_USED_LBN 96
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_USED_WIDTH 1
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_MAX_FILL_REG_LBN 94
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_MAX_FILL_REG_WIDTH 2
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_RATE_REC_LBN 78
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_RATE_REC_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_RATE_LBN 62
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_RATE_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_FILL_LEVEL_LBN 47
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_FILL_LEVEL_WIDTH 15
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_DUE_TIME_LBN 31
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_DUE_TIME_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_LAST_FILL_TIME_LBN 15
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_LAST_FILL_TIME_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_BKT_ID_LBN 5
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_BKT_ID_WIDTH 10
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_OP_LBN 2
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BKT_TBL_RD_RSP_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_BKT_TBL_WR_REQ */
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_IDLE_LBN 65
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_IDLE_WIDTH 1
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_USED_LBN 64
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_USED_WIDTH 1
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_MAX_FILL_REG_LBN 62
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_MAX_FILL_REG_WIDTH 2
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_RATE_REC_LBN 46
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_RATE_REC_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_RATE_LBN 30
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_RATE_WIDTH 16
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_FILL_LEVEL_LBN 15
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_FILL_LEVEL_WIDTH 15
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_BKT_ID_LBN 5
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_BKT_ID_WIDTH 10
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_OP_LBN 2
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_BKT_TBL_WR_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_TXQ_D_R_I_REQ */
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_FRM_LEN_LBN 15
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_FRM_LEN_WIDTH 14
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_TXQ_ID_LBN 5
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_TXQ_ID_WIDTH 10
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_OP_LBN 2
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_TXQ_D_R_I_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_TXQ_TBL_RD_REQ */
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_TXQ_ID_LBN 5
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_TXQ_ID_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_OP_LBN 2
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_TXQ_TBL_RD_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_TXQ_TBL_RD_RSP */
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT2_LBN 53
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT2_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT1_LBN 43
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT1_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT0_LBN 33
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MAX_BKT0_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MIN_BKT_LBN 23
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_MIN_BKT_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_LABEL_LBN 19
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_LABEL_WIDTH 4
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_PQ_FLAGS_LBN 16
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_PQ_FLAGS_WIDTH 3
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_DSBL_LBN 15
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_DSBL_WIDTH 1
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_TXQ_ID_LBN 5
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_TXQ_ID_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_OP_LBN 2
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_TXQ_TBL_RD_RSP_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_PACER_TXQ_TBL_WR_REQ */
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT2_LBN 53
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT2_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT1_LBN 43
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT1_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT0_LBN 33
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MAX_BKT0_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MIN_BKT_LBN 23
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_MIN_BKT_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_LABEL_LBN 19
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_LABEL_WIDTH 4
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_PQ_FLAGS_LBN 16
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_PQ_FLAGS_WIDTH 3
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_DSBL_LBN 15
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_DSBL_WIDTH 1
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_TXQ_ID_LBN 5
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_TXQ_ID_WIDTH 10
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_OP_LBN 2
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_OP_WIDTH 3
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_RD 7
#define	ESE_DZ_DPCPU_PACER_BKT_TBL_WR 6
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_RD 5
#define	ESE_DZ_DPCPU_PACER_TXQ_TBL_WR 4
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_NI 3
#define	ESE_DZ_DPCPU_PACER_TXQ_D_R_I 2
#define	ESE_DZ_DPCPU_PACER_BKT_D_R_RD 1
#define	ESE_DZ_DPCPU_PACER_BKT_D_RD 0
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_CLIENT_ID_LBN 0
#define	ESF_DZ_TXP_TXQ_TBL_WR_REQ_CLIENT_ID_WIDTH 2
#define	ESE_DZ_DPCPU_PACER_CPU_CLIENT 2
#define	ESE_DZ_DPCPU_PACER_CMD_CTL_CLIENT 1
#define	ESE_DZ_DPCPU_PACER_ALRT_CTL_CLIENT 0


/* ES_TX_USER_DESC */
#define	ESF_DZ_TX_USR_TYPE_LBN 63
#define	ESF_DZ_TX_USR_TYPE_WIDTH 1
#define	ESF_DZ_TX_USR_CONT_LBN 62
#define	ESF_DZ_TX_USR_CONT_WIDTH 1
#define	ESF_DZ_TX_USR_BYTE_CNT_LBN 48
#define	ESF_DZ_TX_USR_BYTE_CNT_WIDTH 14
#define	ESF_DZ_TX_USR_BUF_PAGE_SIZE_LBN 44
#define	ESF_DZ_TX_USR_BUF_PAGE_SIZE_WIDTH 4
#define	ESE_DZ_USR_BUF_PAGE_SZ_4MB 10
#define	ESE_DZ_USR_BUF_PAGE_SZ_1MB 8
#define	ESE_DZ_USR_BUF_PAGE_SZ_64KB 4
#define	ESE_DZ_USR_BUF_PAGE_SZ_4KB 0
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_DW0_LBN 0
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_DW0_WIDTH 32
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_DW1_LBN 32
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_DW1_WIDTH 12
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_LBN 0
#define	ESF_DZ_TX_USR_BUF_ID_OFFSET_WIDTH 44
#define	ESF_DZ_TX_USR_4KBPS_BUF_ID_LBN 12
#define	ESF_DZ_TX_USR_4KBPS_BUF_ID_WIDTH 32
#define	ESF_DZ_TX_USR_64KBPS_BUF_ID_LBN 16
#define	ESF_DZ_TX_USR_64KBPS_BUF_ID_WIDTH 28
#define	ESF_DZ_TX_USR_1MBPS_BUF_ID_LBN 20
#define	ESF_DZ_TX_USR_1MBPS_BUF_ID_WIDTH 24
#define	ESF_DZ_TX_USR_4MBPS_BUF_ID_LBN 22
#define	ESF_DZ_TX_USR_4MBPS_BUF_ID_WIDTH 22
#define	ESF_DZ_TX_USR_4MBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_TX_USR_4MBPS_BYTE_OFFSET_WIDTH 22
#define	ESF_DZ_TX_USR_1MBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_TX_USR_1MBPS_BYTE_OFFSET_WIDTH 20
#define	ESF_DZ_TX_USR_64KBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_TX_USR_64KBPS_BYTE_OFFSET_WIDTH 16
#define	ESF_DZ_TX_USR_4KBPS_BYTE_OFFSET_LBN 0
#define	ESF_DZ_TX_USR_4KBPS_BYTE_OFFSET_WIDTH 12


/* ES_TX_U_QSTATE_TBL0_ENTRY */
#define	ESF_DZ_TX_U_DC_FILL_LBN 112
#define	ESF_DZ_TX_U_DC_FILL_WIDTH 7
#define	ESF_DZ_TX_U_SOFT7_B1R3_LBN 112
#define	ESF_DZ_TX_U_SOFT7_B1R3_WIDTH 7
#define	ESF_DZ_TX_U_DSCR_HW_RPTR_LBN 96
#define	ESF_DZ_TX_U_DSCR_HW_RPTR_WIDTH 12
#define	ESF_DZ_TX_U_SOFT12_B1R2_LBN 96
#define	ESF_DZ_TX_U_SOFT12_B1R2_WIDTH 12
#define	ESF_DZ_TX_U_DC_RPTR_LBN 80
#define	ESF_DZ_TX_U_DC_RPTR_WIDTH 6
#define	ESF_DZ_TX_U_SOFT6_B1R1_LBN 80
#define	ESF_DZ_TX_U_SOFT6_B1R1_WIDTH 6
#define	ESF_DZ_TX_U_SOFT5_B1R0_LBN 64
#define	ESF_DZ_TX_U_SOFT5_B1R0_WIDTH 5
#define	ESF_DZ_TX_U_PREFETCH_ACTIVE_LBN 66
#define	ESF_DZ_TX_U_PREFETCH_ACTIVE_WIDTH 1
#define	ESF_DZ_TX_U_PREFETCH_PENDING_LBN 65
#define	ESF_DZ_TX_U_PREFETCH_PENDING_WIDTH 1
#define	ESF_DZ_TX_U_DOORBELL_ENABLED_LBN 64
#define	ESF_DZ_TX_U_DOORBELL_ENABLED_WIDTH 1
#define	ESF_DZ_TX_U_UPD_UDPTCP_CSUM_MODE_LBN 33
#define	ESF_DZ_TX_U_UPD_UDPTCP_CSUM_MODE_WIDTH 1
#define	ESF_DZ_TX_U_SOFT2_B0R2_LBN 32
#define	ESF_DZ_TX_U_SOFT2_B0R2_WIDTH 2
#define	ESF_DZ_TX_U_UPD_IP_CSUM_MODE_LBN 32
#define	ESF_DZ_TX_U_UPD_IP_CSUM_MODE_WIDTH 1
#define	ESF_DZ_TX_U_UPD_CRC_MODE_LBN 29
#define	ESF_DZ_TX_U_UPD_CRC_MODE_WIDTH 3
#define	ESE_DZ_C2RIP_FCOIP_MPA 5
#define	ESE_DZ_C2RIP_FCOIP_FCOE 4
#define	ESE_DZ_C2RIP_ISCSI_HDR_AND_PYLD 3
#define	ESE_DZ_C2RIP_ISCSI_HDR 2
#define	ESE_DZ_C2RIP_FCOE 1
#define	ESE_DZ_C2RIP_OFF 0
#define	ESF_DZ_TX_U_SOFT16_B0R1_LBN 16
#define	ESF_DZ_TX_U_SOFT16_B0R1_WIDTH 16
#define	ESF_DZ_TX_U_BIU_ARGS_LBN 16
#define	ESF_DZ_TX_U_BIU_ARGS_WIDTH 13
#define	ESF_DZ_TX_U_EV_QID_LBN 5
#define	ESF_DZ_TX_U_EV_QID_WIDTH 11
#define	ESF_DZ_TX_U_SOFT16_B0R0_LBN 0
#define	ESF_DZ_TX_U_SOFT16_B0R0_WIDTH 16
#define	ESF_DZ_TX_U_EV_QLABEL_LBN 0
#define	ESF_DZ_TX_U_EV_QLABEL_WIDTH 5


/* ES_TX_U_QSTATE_TBL1_ENTRY */
#define	ESF_DZ_TX_U_DSCR_BASE_PAGE_ID_LBN 64
#define	ESF_DZ_TX_U_DSCR_BASE_PAGE_ID_WIDTH 18
#define	ESF_DZ_TX_U_SOFT18_B1R0_LBN 64
#define	ESF_DZ_TX_U_SOFT18_B1R0_WIDTH 18
#define	ESF_DZ_TX_U_SOFT16_B0R3_LBN 48
#define	ESF_DZ_TX_U_SOFT16_B0R3_WIDTH 16
#define	ESF_DZ_TX_U_QUEUE_ENABLED_LBN 49
#define	ESF_DZ_TX_U_QUEUE_ENABLED_WIDTH 1
#define	ESF_DZ_TX_U_FLUSH_PENDING_LBN 48
#define	ESF_DZ_TX_U_FLUSH_PENDING_WIDTH 1
#define	ESF_DZ_TX_U_DSCR_HW_WPTR_LBN 32
#define	ESF_DZ_TX_U_DSCR_HW_WPTR_WIDTH 12
#define	ESF_DZ_TX_U_SOFT12_B0R2_LBN 32
#define	ESF_DZ_TX_U_SOFT12_B0R2_WIDTH 12
#define	ESF_DZ_TX_U_OWNER_ID_LBN 16
#define	ESF_DZ_TX_U_OWNER_ID_WIDTH 12
#define	ESF_DZ_TX_U_SOFT12_B0R1_LBN 16
#define	ESF_DZ_TX_U_SOFT12_B0R1_WIDTH 12
#define	ESF_DZ_TX_U_DSCR_SIZE_LBN 0
#define	ESF_DZ_TX_U_DSCR_SIZE_WIDTH 3
#define	ESF_DZ_TX_U_SOFT3_B0R0_LBN 0
#define	ESF_DZ_TX_U_SOFT3_B0R0_WIDTH 3


/* ES_TX_U_QSTATE_TBL2_ENTRY */
#define	ESF_DZ_TX_FINFO_WRD3_LBN 48
#define	ESF_DZ_TX_FINFO_WRD3_WIDTH 16
#define	ESF_DZ_TX_FINFO_WRD2_LBN 32
#define	ESF_DZ_TX_FINFO_WRD2_WIDTH 16
#define	ESF_DZ_TX_FINFO_WRD1_LBN 16
#define	ESF_DZ_TX_FINFO_WRD1_WIDTH 16
#define	ESF_DZ_TX_FINFO_SRCDST_LBN 0
#define	ESF_DZ_TX_FINFO_SRCDST_WIDTH 16


/* ES_b2t_cpl_rsp */
#define	ESF_DZ_B2T_CPL_RSP_CPL_ECC_LBN 268
#define	ESF_DZ_B2T_CPL_RSP_CPL_ECC_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW0_LBN 27
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW0_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW1_LBN 59
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW1_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW2_LBN 91
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW2_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW3_LBN 123
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW3_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW4_LBN 155
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW4_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW5_LBN 187
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW5_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW6_LBN 219
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW6_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW7_LBN 251
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_DW7_WIDTH 32
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_LBN 27
#define	ESF_DZ_B2T_CPL_RSP_CPL_DATA_WIDTH 256
#define	ESF_DZ_B2T_CPL_RSP_CPL_EOT_LBN 283
#define	ESF_DZ_B2T_CPL_RSP_CPL_EOT_WIDTH -15
#define	ESF_DZ_B2T_CPL_RSP_CPL_ERROR_LBN 26
#define	ESF_DZ_B2T_CPL_RSP_CPL_ERROR_WIDTH 1
#define	ESF_DZ_B2T_CPL_RSP_CPL_LAST_LBN 25
#define	ESF_DZ_B2T_CPL_RSP_CPL_LAST_WIDTH 1
#define	ESF_DZ_B2T_CPL_RSP_CPL_TAG_LBN 19
#define	ESF_DZ_B2T_CPL_RSP_CPL_TAG_WIDTH 6
#define	ESF_DZ_B2T_CPL_RSP_CPL_LEN_LBN 7
#define	ESF_DZ_B2T_CPL_RSP_CPL_LEN_WIDTH 12
#define	ESF_DZ_B2T_CPL_RSP_CPL_ADRS_LBN 0
#define	ESF_DZ_B2T_CPL_RSP_CPL_ADRS_WIDTH 7


#ifdef	__cplusplus
}
#endif

#endif /* _SYS_EFX_EF10_REGS_H */
