#ifndef __PREF_H__
#define __PREF_H__

#include <qobject.h>
#include <qdict.h>
#include <qstring.h>
#include <qstringlist.h>

class KConfig;
class desktopInfo;
class configDlg;

class kfishPref : public QObject
{
    Q_OBJECT
public:
    enum fishAnimations { None = 0, Mouse, Timer };

    static kfishPref *prefs();
    
    void load();
    void write();
    
    QString getName() const { return m_fishName; };
    QString getFile() const { return m_fishFile; };
    int getBubblesNumber() const { return m_numBubble; };
    int getWidth() const { return m_widthSpace; };
    int getTimeInAnimation() const { return m_animationTimer; };
    int getPanelHeight() const { return m_height; };
    int getPanelWidth() const { return m_width; };
    Orientation getOrientation() const { return m_panelOrientation; };
    fishAnimations getTypeOfAnimation() const { return m_animationFish; };
    const QDict<QString> *getFishList() const;
	
	void setName(QString name) { m_fishName = name; };
	void setFile(QString file) { m_fishFile = file; };
    void setBubbleNumber(int num) { m_numBubble = num; };
	void setWidth(int width ) { m_widthSpace = width; };
	void setTimeInAnimation(int t) { m_animationTimer = t; };
    void setPanelWidth( int w ) { m_width = w; };
    void setPanelHeight( int h ) { if (h > 1) m_height = h; };
    void setOrientation( Orientation type ) { m_panelOrientation = type; };
    void setTypeOfAnimation(fishAnimations fs) { m_animationFish = fs; };

    void emitChangePref();

signals:
    void changePref();
    
private:

    kfishPref();
    ~kfishPref();
	
	
	static kfishPref *s_prefs;
    
    // MAIN
    QString m_fishName;
	QDict<QString> *m_fishList;
    QString m_fishFile;
    int m_numBubble; 
    int m_widthSpace;
   // ANIMATION
    fishAnimations m_animationFish;
    int     m_animationTimer;
    // PANEL STUFF
    int m_width;
    int m_height;
    Orientation m_panelOrientation;

    KConfig *config;
};


#endif
