/*
 * kwin_skulpture.h
 *
 */

#ifndef KWIN_SKULPTURE_H
#define KWIN_SKULPTURE_H 1


/*-----------------------------------------------------------------------*/

#include <kcommondecoration.h>
class QStyleOptionButton;

class QtMdiDecorationButton : public KCommonDecorationButton
{
	Q_OBJECT

	public:
		QtMdiDecorationButton(ButtonType type, KCommonDecoration *parent);
		virtual ~QtMdiDecorationButton();
		virtual void reset(unsigned long changed);

	protected:
		virtual void paintEvent(QPaintEvent *event);

	protected:
		void initStyleOption(QStyleOptionButton &opt);

	private:
		void init();
};


/*-----------------------------------------------------------------------*/

class QStyleOption;

class QtMdiDecoration : public KCommonDecoration
{
	Q_OBJECT

	public:
		QtMdiDecoration(KDecorationBridge *bridge, KDecorationFactory *factory, QStyle *style = 0);
		virtual ~QtMdiDecoration();

	public:
		virtual QString visibleName() const;
		virtual bool decorationBehaviour(DecorationBehaviour behaviour) const;
		virtual int layoutMetric(LayoutMetric lm, bool respectWindowState = true, const KCommonDecorationButton *button = 0) const;
		virtual void updateWindowShape();

		virtual void init();
		virtual KCommonDecorationButton *createButton(ButtonType type);

		virtual void paintEvent(QPaintEvent *event);

                bool useIcon() const { return showIcon; }

	protected:
		void initStyleOption(QStyleOption &opt);

	private:
		/* cached style hints and pixel metrics */
		bool coloredFrame;
		bool contrastFrame;
		bool noBorder;
		bool autoRaise;
                bool showIcon;
		int titleHeight;
		int borderWidth;
                QStyle *style;
};


/*-----------------------------------------------------------------------*/

#include <kdecorationfactory.h>

class SkulptureDecorationFactory : public KDecorationFactory
{
	public:
		SkulptureDecorationFactory();
		virtual ~SkulptureDecorationFactory();

	public:
		virtual KDecoration *createDecoration(KDecorationBridge *bridge);
		virtual bool reset(unsigned long changed);
		virtual QList<BorderSize> borderSizes() const;
		virtual bool supports(Ability ability) const;

        private:
                QStyle *style;
};


/*-----------------------------------------------------------------------*/

#endif


