/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-session.h 3091 2007-03-29 05:15:06Z makeinu $
 */

#ifndef __KZ_SESSION_H__
#define __KZ_SESSION_H__

#include <glib-object.h>
#include "kz-bookmark-file.h"
#include "kz-profile.h"

G_BEGIN_DECLS

#define KZ_TYPE_SESSION		(kz_session_get_type ())
#define KZ_SESSION(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_SESSION, KzSession))
#define KZ_SESSION_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_SESSION, KzSessionClass))
#define KZ_IS_SESSION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_SESSION))
#define KZ_IS_SESSION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_SESSION))
#define KZ_SESSION_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_SESSION, KzSessionClass))

typedef struct _KzSession         KzSession;
typedef struct _KzSessionClass    KzSessionClass;


struct _KzSession
{
	KzBookmarkFile         parent;
};

struct _KzSessionClass
{
	KzBookmarkFileClass parent_class;
};

/* GType */
GType		kz_session_get_type	(void) G_GNUC_CONST;

KzBookmark     *kz_session_new	(const gchar *location, const gchar *title);

void		kz_session_set_auto_save (KzSession *session, gboolean auto_save);
void		kz_session_set_profile   (KzSession *session, KzProfile *profile);

void		kz_session_freeze	 (KzSession *session);
void		kz_session_thaw		 (KzSession *session);
gboolean        kz_session_is_frozen     (KzSession *session);

G_END_DECLS

#endif /* __KZ_SESSION_H__ */
