/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __KZ_BOOKMARK_SEPARATOR_H__
#define __KZ_BOOKMARK_SEPARATOR_H__

#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_SEPARATOR		(kz_bookmark_separator_get_type ())
#define KZ_BOOKMARK_SEPARATOR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_SEPARATOR, KzBookmarkSeparator))
#define KZ_BOOKMARK_SEPARATOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_SEPARATOR, KzBookmarkSeparatorClass))
#define KZ_IS_BOOKMARK_SEPARATOR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_SEPARATOR))
#define KZ_IS_BOOKMARK_SEPARATOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_SEPARATOR))
#define KZ_BOOKMARK_SEPARATOR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_SEPARATOR, KzBookmarkSeparatorClass))

typedef struct _KzBookmarkSeparator         KzBookmarkSeparator;
typedef struct _KzBookmarkSeparatorClass    KzBookmarkSeparatorClass;

struct _KzBookmarkSeparator
{
	KzBookmark parent;
};

struct _KzBookmarkSeparatorClass
{
	KzBookmarkClass parent_class;
};


GType		kz_bookmark_separator_get_type		(void) G_GNUC_CONST; 

KzBookmark     *kz_bookmark_separator_new		(void);

G_END_DECLS

#endif /* __KZ_BOOKMARK_SEPARATOR_H__ */
