/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include "kz-dbus-embed-agent.h"
#include "kz-embed.h"

static GtkWidget *notebook = NULL;
static GList *embeds_queue = NULL;

static void
cb_entry_activate (GtkEntry *entry, gpointer data)
{
    const gchar *uri;
    GtkWidget *current_page;

    uri = gtk_entry_get_text(entry);
    current_page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
                                             gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));

    kz_embed_load_uri(KZ_EMBED(current_page), uri);
}

static void
new_connection_func (DBusServer *dbus_server, DBusConnection *connection, gpointer user_data)
{
    DBusGConnection *g_connection;
    KzDBusEmbedAgent *embed;
    GList *last;

    dbus_connection_ref(connection);
    dbus_connection_setup_with_g_main(connection, NULL);

    g_connection = dbus_connection_get_g_connection(connection);
    last = g_list_last(embeds_queue);
    embed = last->data;
    embeds_queue = g_list_remove_link(embeds_queue, last);

    kz_dbus_embed_agent_set_connection(embed, g_connection);
    dbus_g_connection_register_g_object(g_connection,
                                        KZ_DBUS_EMBED_AGENT_PATH,
                                        G_OBJECT(embed));
}

static gchar *
setup_dbus (void)
{
    DBusError error;
    DBusServer *server;

    dbus_error_init(&error);
    server = dbus_server_listen("unix:tmpdir=/tmp/kazehakase/server", &error);
    if (!server) {
        g_print("%s\n", error.message);
        dbus_error_free(&error);
    }

    dbus_server_setup_with_g_main(server, NULL);
    dbus_server_set_new_connection_function(server, new_connection_func, NULL, NULL);
    return dbus_server_get_address(server);
}

static void
cb_destroy (GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

static void
add_embed (GtkWidget *notebook, const gchar *socket_address)
{
    GtkWidget *agent;

    agent = kz_dbus_embed_agent_new(socket_address);
    embeds_queue = g_list_append(embeds_queue, agent);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), agent, NULL);
    gtk_widget_show(agent);
}

int
main (int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *vbox, *entry;
    gchar *socket_address;

    if (!g_thread_supported()) g_thread_init(NULL);
    dbus_g_thread_init();

    socket_address = setup_dbus();

    gtk_init(&argc, &argv);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size(GTK_WINDOW(window), 640, 480);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(window), vbox);
    gtk_widget_show(vbox);

    entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(vbox), entry, FALSE, FALSE, 0);
    gtk_widget_show(entry);

    notebook = gtk_notebook_new();
    gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
    gtk_widget_show(notebook);

    add_embed(notebook, socket_address);
    add_embed(notebook, socket_address);
    add_embed(notebook, socket_address);

    g_signal_connect(entry, "activate", G_CALLBACK(cb_entry_activate), NULL);
    g_signal_connect (window, "destroy", G_CALLBACK(cb_destroy), NULL);

    gtk_widget_show(window);

    gtk_main();

    g_free(socket_address);

    exit(EXIT_SUCCESS);
}

/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
