class HandlerBase:
	def source(self, program, base, ext):
		pass

	def parse(self, amfile):
		pass
	
	def collect(self, amfile):
		pass

	def extensions(self):
		return []

	def handle(self, amfile):
		pass

	def shuffle_binaries(self, amfile):
		pass

ext_dict = {}
handlers = []

def register_handler(handler):
	for ext in handler.extensions():
		ext_dict[ext] = handler
	handlers.append(handler)
	
