/*
    romquerybuilder.h - Build a ROM SQL query.

    Copyright (c) 2005-2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUROMQUERYBUILDER_H
#define KAMEFUROMQUERYBUILDER_H

#include <qstring.h>

namespace Kamefu 
{

/**
 * @brief Build dynamic ROM SQL query.
 *
 * Class to build dynamic SQL queries that look up for ROMs based on certain filters.
 * This class assume that the table used to filter has fields like: "table_id" and "table_name".
 * Also it only work with the "rom" table, which is the central table of the database.
 *
 * Only one filter per table.
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class RomQueryBuilder
{
public:
	RomQueryBuilder();
	~RomQueryBuilder();

	/**
	 * @brief Add(or update) a filter on the dynamic query.
	 *
	 * A filter will be defined like this: "table_id = (SELECT table_id FROM table WHERE table_name LIKE ('Value%')"
	 * and the filter will be added to the WHERE clause of the query.
	 *
	 * @param filterTable Table to filter.
	 * @param filterValue Filter on this value.
	 */
	void addFilter(const QString &filterTable, const QString &filterValue);
	
	/**
	 * @brief Remove a filter on the dynamic query.
	 * 
	 * Remove the filter currently available for the given table.
	 * The method is ignored if the filter doesn't exist.
	 */
	void removeFilter(const QString &filterTable);

	/**
	 * Return the current state of the dynamic SQL query.
	 * @return a full SQL query in a QString.
	 */
	QString sqlQuery() const;

private:
	class Private;
	Private *d;
};

}

#endif
