/*
    kamefumainwindow.h - Kamefu Application Main Window

    Copyright (c) 2005-2006 by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef __KAMEFU_H__
#define __KAMEFU_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

/**
 * @short Application Main Window
 * @author Michaël Larouche <shock@shockdev.ca.tc>
 */
class KamefuMainWindow : public KMainWindow
{
    Q_OBJECT
public:
	/**
	 * Default Constructor
	 */
	KamefuMainWindow();

	/**
	 * Default Destructor
	 */
	virtual ~KamefuMainWindow();

private slots:
	/**
	 * This function is called at loading, checking if 
	 * it's the first time Kamefu is launched.
	 * Launch the first time wizard if needed.
	 */ 
	void checkFirstTime();
	/**
	 * Show the first time wizard.
	 */
	void showFirstTimeWizard();
	/**
	 * Called when wizard is accepted. Build the initial collection.
	 */
	void wizardAccepted();
	/**
	 * Fill the view with all the ROM in the collection.
	 */
	void fillRomList();
	/**
	 * Build the initial collection.
	 */
	void buildCollection();
	/**
	 * Menu command to looks for titlescreen from a directory.
	 * TODO: 0.2 Make this a plugin.
	 */
	void collectionTitlescreenLookup();
	/**
	 * Menu command to look for screenshots.
	 * TODO: 0.2 Make this a plugin
	 */
	void collectionScreenshotLookup();

	/**
	 * Error handler for database errors.
	 * @param errorMessage Error message to display.
	 */ 
	void displayError(const QString &errorMessage);
	/**
	 * Execute the required emulator from ROM url.
	 */
	void executeRom(const QString &romUrl);

	/**
	 * Open a ROM without adding it to the "play list" and the collection.
	 */
	void fileOpen();
	/**
	 * Show the preferences(configuration) dialog.
	 */ 
	void showPreferences();

	void buildBegin(int numberItems);
	void updateBuildProgress();
	void buildComplete();

	/**
	 * Read the size settings
	 */
	void readSettings();
	/**
	 * Save the size settings
	 */
	void saveSettings();

	/**
	 * Update the collection total item in statusbar.
	 */
	void updateCollectionTotal();
private:
	/**
	 * Create and setup all actions.
	 */
	void setupActions();

	/**
	 * Setup Qt signals/slots connections.
	 */
	void setupConnections();

	/**
	 * When exiting the application, do cleanup.
	 */	
	virtual bool queryExit();

private:
	class Private;
	Private *d;
	
};

#endif // _KEMUL_H_
